/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TemplateGenerator;
import java.util.Vector;
import org.apache.axiom.om.OMElement;

public class Reference {
    String uri;
    String id;
    String type;
    TemplateGenerator gen;
    OMElement objectElement;
    Vector transforms;
    String digester;

    protected Reference(TemplateGenerator tg, String uri, OMElement objectElement) {
        this.gen = tg;
        this.uri = uri;
        this.objectElement = objectElement;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addTransform(OMElement transform) {
        if (this.transforms == null) {
            this.transforms = new Vector();
        }
        this.transforms.addElement(transform);
    }

    public void addTransform(String algorithm) {
        OMElement transform = this.gen.createElementNS("Transform");
        transform.addAttribute("Algorithm", algorithm, null);
        this.addTransform(transform);
    }

    public void addXPathTransform(String expression) {
        OMElement transform = this.gen.createElementNS("Transform");
        transform.addAttribute("Algorithm", "http://www.w3.org/TR/1999/REC-xpath-19991116", null);
        OMElement xpath = this.gen.createElementNS("XPath");
        DOMUtil.appendText(xpath, expression);
        transform.addChild(xpath);
        this.addTransform(transform);
    }

    public void setDigestMethod(String digester) {
        this.digester = digester;
    }

    protected String getDigestMethod() {
        return this.digester;
    }

    public OMElement getReferenceElement() {
        return this.getReferenceElement(null);
    }

    public OMElement getReferenceElement(IndentConfig iconf) {
        OMElement or = this.gen.createElementNS("Reference");
        or.addAttribute("URI", this.uri, null);
        if (this.id != null) {
            or.addAttribute("Id", this.id, null);
        }
        if (this.type != null) {
            or.addAttribute("Type", this.type, null);
        }
        DOMUtil.addIndent(or, iconf, 3);
        if (this.transforms != null) {
            OMElement transformsElement = this.gen.createElementNS("Transforms");
            for (int i = 0; i < this.transforms.size(); ++i) {
                OMElement transformElement = (OMElement)this.transforms.elementAt(i);
                DOMUtil.addIndent(transformsElement, iconf, 4);
                transformsElement.addChild(transformElement);
            }
            DOMUtil.addIndent(transformsElement, iconf, 3);
            or.addChild(transformsElement);
            DOMUtil.addIndent(or, iconf, 3);
        }
        OMElement digestMethod = this.gen.createElementNS("DigestMethod");
        digestMethod.addAttribute("Algorithm", this.digester, null);
        or.addChild(digestMethod);
        DOMUtil.addIndent(or, iconf, 3);
        or.addChild(this.gen.createElementNS("DigestValue"));
        DOMUtil.addIndent(or, iconf, 2);
        return or;
    }

    protected OMElement getObjectElement() {
        return this.objectElement;
    }

    protected boolean isEnvelopedObject() {
        return this.objectElement != null;
    }
}

