/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.axiom.om.OMElement;

public class CertUtil {
    static final boolean DEBUG = false;
    public static final int CHAINS_ANY = 100;
    public static final int CHAINS_ALL = 101;

    public static Key verify(OMElement signature, int chainsFlag, PKIXParameters params) throws XSignatureException {
        return CertUtil.verifyAndGetCert(signature, chainsFlag, params).getPublicKey();
    }

    public static X509Certificate verifyAndGetCert(OMElement signature, int chainsFlag, PKIXParameters params) throws XSignatureException {
        Key publicKey;
        KeyInfo.X509Data[] x5data;
        X509Certificate cert = null;
        byte[] encodedKey = null;
        try {
            KeyInfo keyInfo = CertUtil.getKeyInfo(signature);
            x5data = keyInfo.getX509Data();
            if (x5data == null || x5data.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            publicKey = keyInfo.getKeyValue();
            if (publicKey != null) {
                encodedKey = publicKey.getEncoded();
            }
        }
        catch (SignatureStructureException sse) {
            throw new XSignatureException(sse);
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "IBMCertPath");
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            CertPathValidatorException exception = null;
            for (int i = 0; i < x5data.length; ++i) {
                List certList = CertUtil.orderCertificates(x5data[i].getCertificates());
                if (certList.size() == 0) {
                    if (chainsFlag == 100) continue;
                    throw new CertPathValidatorException("Incomplete certificate chain.");
                }
                cert = (X509Certificate)certList.get(0);
                PublicKey ckey = cert.getPublicKey();
                if (encodedKey == null) {
                    publicKey = ckey;
                    encodedKey = ckey.getEncoded();
                } else if (!MessageDigest.isEqual(encodedKey, ckey.getEncoded())) {
                    throw new CertPathValidatorException("A certificate has different key.");
                }
                CertPath certPath = factory.generateCertPath(certList);
                if (chainsFlag == 101) {
                    validator.validate(certPath, params);
                    continue;
                }
                try {
                    validator.validate(certPath, params);
                    return cert;
                }
                catch (CertPathValidatorException cpve) {
                    exception = cpve;
                }
            }
            if (chainsFlag == 101) {
                return cert;
            }
            if (exception == null) {
                throw new CertPathValidatorException("No valid certificate chain.");
            }
            throw new CertPathValidatorException("No valid certificate chain: Last exception: " + exception);
        }
        catch (GeneralSecurityException gse) {
            throw new XSignatureException(gse);
        }
    }

    public static X509DataUtil[] getX509Data(OMElement signature) throws XSignatureException {
        try {
            KeyInfo keyInfo = CertUtil.getKeyInfo(signature);
            KeyInfo.X509Data[] x5data = keyInfo.getX509Data();
            if (x5data == null || x5data.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            Key k = keyInfo.getKeyValue();
            X509DataUtil[] x5u = new X509DataUtil[x5data.length];
            for (int i = 0; i < x5data.length; ++i) {
                x5u[i] = new X509DataUtil(x5data[i], k);
            }
            return x5u;
        }
        catch (SignatureStructureException sse) {
            throw new XSignatureException(sse);
        }
    }

    public static List orderCertificates(X509Certificate[] certs) throws CertPathValidatorException {
        boolean found;
        LinkedList<X509Certificate> list = new LinkedList<X509Certificate>();
        if (certs == null || certs.length == 0) {
            return list;
        }
        if (certs.length == 1) {
            list.add(certs[0]);
            return list;
        }
        X509Certificate[] certs2 = new X509Certificate[certs.length];
        System.arraycopy(certs, 0, certs2, 0, certs.length);
        for (int i = 0; i < certs2.length; ++i) {
            Principal subject = certs2[i].getSubjectDN();
            found = false;
            for (int j = 0; j < certs.length; ++j) {
                Principal issuer;
                if (j == i || !((Object)subject).equals(issuer = certs2[j].getIssuerDN())) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(certs2[i]);
            certs2[i] = null;
            break;
        }
        if (list.size() == 0) {
            return list;
        }
        Principal issuer = ((X509Certificate)list.get(0)).getIssuerDN();
        int remains = certs2.length - 1;
        while (remains > 0) {
            found = false;
            for (int i = 0; i < certs2.length; ++i) {
                X509Certificate c = certs2[i];
                if (c == null || !((Object)c.getSubjectDN()).equals(issuer)) continue;
                found = true;
                list.add(c);
                certs2[i] = null;
                --remains;
                issuer = c.getIssuerDN();
                break;
            }
            if (found) continue;
            throw new CertPathValidatorException("The chain is incomplete: No certificate of an issuer `" + issuer + "'");
        }
        return list;
    }

    private static KeyInfo getKeyInfo(OMElement signature) throws SignatureStructureException, XSignatureException {
        OMElement keyInfoElement = KeyInfo.searchForKeyInfo(signature);
        if (keyInfoElement == null) {
            throw new SignatureStructureException("No KeyInfo element.");
        }
        return new KeyInfo(keyInfoElement);
    }

    public static class X509DataUtil {
        KeyInfo.X509Data x5data;
        CertStore docStore = null;
        Key publicKey;

        public X509DataUtil(KeyInfo.X509Data x5d, Key k) {
            this.x5data = x5d;
            this.publicKey = k;
        }

        private CertStore createCertStore() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            Vector<X509Certificate> certs = new Vector<X509Certificate>();
            X509Certificate[] srccerts = this.x5data.getCertificates();
            if (srccerts != null) {
                for (int j = 0; j < srccerts.length; ++j) {
                    certs.addElement(srccerts[j]);
                }
            }
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(certs));
        }

        public Key validate(PKIXBuilderParameters params) throws XSignatureException {
            return this.validateAndGetCert(params).getPublicKey();
        }

        public X509Certificate validateAndGetCert(PKIXBuilderParameters params) throws XSignatureException {
            CertPath path;
            List<CertStore> storeList = params.getCertStores();
            ArrayList<CertStore> newList = new ArrayList<CertStore>((storeList == null ? 0 : storeList.size()) + 1);
            for (int i = 0; i < storeList.size(); ++i) {
                newList.add(storeList.get(i));
            }
            try {
                newList.add(this.createCertStore());
                params.setCertStores(newList);
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
                CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                path = builder.build(params).getCertPath();
                validator.validate(path, params);
            }
            catch (InvalidAlgorithmParameterException iape) {
                params.setCertStores(storeList);
                throw new XSignatureException(iape);
            }
            catch (NoSuchAlgorithmException nsae) {
                params.setCertStores(storeList);
                throw new XSignatureException(nsae);
            }
            catch (CertPathBuilderException cpbe) {
                params.setCertStores(storeList);
                throw new XSignatureException(cpbe);
            }
            catch (CertPathValidatorException cpve) {
                params.setCertStores(storeList);
                throw new XSignatureException(cpve);
            }
            List<? extends Certificate> certs = path.getCertificates();
            return certs.isEmpty() ? null : (X509Certificate)certs.get(0);
        }

        public X509CertSelector createSelector() throws IOException {
            X509Certificate[] certs;
            String[] subjects;
            X509CertSelector selector = new X509CertSelector();
            String[] issuers = this.x5data.getIssuerNames();
            if (issuers != null && issuers.length > 0) {
                BigInteger[] serials = this.x5data.getSerialNumbers();
                selector.setIssuer(issuers[0]);
                selector.setSerialNumber(serials[0]);
            }
            if ((subjects = this.x5data.getSubjectNames()) != null && subjects.length > 0) {
                selector.setSubject(subjects[0]);
            } else {
                X509Certificate[] certs2 = this.x5data.getCertificates();
                if (certs2 != null && certs2.length > 0) {
                    selector.setSubject(certs2[0].getSubjectDN().getName());
                }
            }
            Object[] skis = this.x5data.getSKIs();
            if (skis != null && skis.length > 0) {
                selector.setSubjectKeyIdentifier((byte[])skis[0]);
            }
            if ((certs = this.x5data.getCertificates()) != null && certs.length == 1) {
                selector.setCertificate(certs[0]);
            }
            if (this.publicKey != null) {
                selector.setSubjectPublicKey(this.publicKey.getEncoded());
            }
            return selector;
        }
    }
}

