/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.util.io.BufferExportableByteArrayOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.util.io.WriterChainHolder;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceProxy;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class XPathCanonicalizer {
    static final boolean DEBUG = false;
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    public static ByteArrayHolder serializeAll(OMDocument doc, boolean withComments) {
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            OMElement node = doc.getOMDocumentElement();
            XPathCanonicalizer.serializeNode(null, node, null, withComments, false, wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            return bah;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static void serializeAll(OMDocument doc, boolean withComments, Writer wr) throws IOException {
        OMElement node = doc.getOMDocumentElement();
        XPathCanonicalizer.serializeNode(null, node, null, withComments, false, wr);
    }

    public static ByteArrayHolder serializeSubset(OMNode node, boolean withComments) {
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            XPathCanonicalizer.serializeNode(node, node, null, withComments, true, wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            return bah;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    public static void serializeSubset(OMNode node, boolean withComments, Writer wr) throws IOException {
        XPathCanonicalizer.serializeNode(node, node, null, withComments, true, wr);
    }

    public static ArrayList toNodeset(OMNode node, OMNode exceptedNode, boolean withComments) {
        ArrayList nodeList = new ArrayList();
        XPathCanonicalizer.toNodeset_addNode(nodeList, node, exceptedNode, withComments);
        return nodeList;
    }

    private static void toNodeset_addNode(ArrayList nodeList, OMNode node, OMNode exceptedNode, boolean withComments) {
        if (node == exceptedNode) {
            return;
        }
        switch (node.getType()) {
            case 1: {
                OMNamespace ns;
                nodeList.add(node);
                Hashtable namespaces = XPathCanonicalizer.collectNamespaceNodesInAncestors(node, true);
                Enumeration en = namespaces.elements();
                while (en.hasMoreElements()) {
                    ns = (OMNamespace)en.nextElement();
                    if (!(ns.getPrefix() != null && ns.getPrefix().length() != 0 || ns.getName() != null && ns.getName().length() != 0)) continue;
                    nodeList.add(new OMNamespaceWithOwner(node, ns));
                }
                Iterator nsIte = ((OMElement)node).getAllDeclaredNamespaces();
                while (nsIte.hasNext()) {
                    ns = (OMNamespace)nsIte.next();
                    nodeList.add(new OMNamespaceWithOwner(node, ns));
                }
                Iterator attrIte = ((OMElement)node).getAllAttributes();
                while (attrIte.hasNext()) {
                    OMAttribute a = (OMAttribute)attrIte.next();
                    nodeList.add(new OMAttributeWithOwner(node, a));
                }
                for (OMNode child = ((OMContainer)((Object)node)).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(nodeList, child, exceptedNode, withComments);
                }
                break;
            }
            case 9: {
                for (OMNode child = ((OMContainer)((Object)node)).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(nodeList, child, exceptedNode, withComments);
                }
                break;
            }
            case 5: {
                if (!withComments) break;
                nodeList.add(node);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 12: {
                nodeList.add(node);
                break;
            }
        }
    }

    public static ByteArrayHolder serializeSubset(Iterator iter, boolean withComments) {
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        while (iter.hasNext()) {
            OMNode n = (OMNode)iter.next();
            list.add(n);
        }
        return XPathCanonicalizer.serializeSubset(list, withComments);
    }

    public static void serializeSubset(Iterator iter, boolean withComments, Writer wr) throws IOException {
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        while (iter.hasNext()) {
            OMNode n = (OMNode)iter.next();
            list.add(n);
        }
        XPathCanonicalizer.serializeSubset(list, withComments, wr);
    }

    public static ByteArrayHolder serializeSubset(ArrayList nodeList, boolean withComments) {
        try {
            BufferExportableByteArrayOutputStream bebaos = new BufferExportableByteArrayOutputStream(0);
            WriterChainHolder wch = (WriterChainHolder)WriterChainHolder.getUtf8WriterChainHolderFactory().getObject();
            wch.getProxyOutputStream().setOutputStream(bebaos);
            BufferedWriter wr = wch.getBufferedWriter();
            XPathCanonicalizer.serializeSubset(nodeList, withComments, (Writer)wr);
            ((Writer)wr).flush();
            ByteArrayHolder bah = bebaos.getByteArrayHolder();
            WriterChainHolder.getUtf8WriterChainHolderFactory().releaseObject(wch);
            return bah;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal Error: " + ioe);
        }
    }

    private static boolean inNodeList(OMNode node, ArrayList list) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != node) continue;
            return true;
        }
        return false;
    }

    public static void serializeSubset(ArrayList nodeList, boolean withComments, Writer wr) throws IOException {
        Vector<Object> nodeVector = new Vector<Object>(nodeList.size());
        for (int i = 0; i < nodeList.size(); ++i) {
            Object obj2;
            OMElement owner;
            Hashtable attributes;
            Object obj = nodeList.get(i);
            if (obj instanceof OMNode) {
                Object attr;
                Object ns;
                OMNode node = (OMNode)obj;
                nodeVector.addElement(node);
                if (node.getType() != 1) continue;
                attributes = null;
                Hashtable namespaces = null;
                OMContainer cont = node.getParent();
                if (cont instanceof OMNode && !XPathCanonicalizer.inNodeList((OMNode)((Object)cont), nodeList)) {
                    attributes = XPathCanonicalizer.collectXMLPrefixAttributesInAncestors(node);
                }
                if (i + 1 < nodeList.size() && (ns = nodeList.get(i + 1)) instanceof OMNamespace && XPathCanonicalizer.isOwnerElement(node, (OMNamespace)ns)) {
                    Object obj22;
                    if (namespaces == null) {
                        namespaces = new Hashtable();
                    }
                    ++i;
                    while (i < nodeList.size() && (obj22 = nodeList.get(i)) instanceof OMNamespace && XPathCanonicalizer.isOwnerElement(node, (OMNamespace)obj22)) {
                        namespaces.put(((OMNamespace)obj22).getPrefix(), obj22);
                        ++i;
                    }
                    if (namespaces.containsKey("") && ((OMNamespace)namespaces.get("")).getName().length() == 0) {
                        namespaces.remove("");
                    }
                    --i;
                    nodeVector.addElement(new OMNamespaces(node, namespaces));
                } else if (namespaces != null) {
                    nodeVector.addElement(new OMNamespaces(node, namespaces));
                }
                if (i + 1 < nodeList.size() && (attr = nodeList.get(i + 1)) instanceof OMAttribute && XPathCanonicalizer.isOwnerElement(node, (OMAttribute)attr)) {
                    Object obj23;
                    if (attributes == null) {
                        attributes = new Hashtable();
                    }
                    ++i;
                    while (i < nodeList.size() && (obj23 = nodeList.get(i)) instanceof OMAttribute && XPathCanonicalizer.isOwnerElement(node, (OMAttribute)obj23)) {
                        attributes.put(((OMAttribute)obj23).getQName(), obj23);
                        ++i;
                    }
                    --i;
                    nodeVector.addElement(new OMAttributes(node, attributes));
                    continue;
                }
                if (attributes == null) continue;
                nodeVector.addElement(new OMAttributes(node, attributes));
                continue;
            }
            if (obj instanceof OMNamespaceWithOwner) {
                owner = ((OMNamespaceWithOwner)obj).getOwnerElement();
                Hashtable namespaces = new Hashtable();
                while (i < nodeList.size() && (obj2 = nodeList.get(i)) instanceof OMNamespace && owner == ((OMNamespaceWithOwner)obj2).getOwnerElement()) {
                    namespaces.put(((OMNamespace)obj2).getPrefix(), obj2);
                    ++i;
                }
                nodeVector.addElement(new OMNamespaces(owner, namespaces));
                --i;
                continue;
            }
            if (!(obj instanceof OMAttributeWithOwner)) continue;
            owner = ((OMAttributeWithOwner)obj).getOwnerElement();
            attributes = new Hashtable();
            while (i < nodeList.size() && (obj2 = nodeList.get(i)) instanceof OMAttribute && owner == ((OMAttributeWithOwner)obj2).getOwnerElement()) {
                attributes.put(((OMAttribute)obj2).getQName(), obj2);
                ++i;
            }
            nodeVector.addElement(new OMAttributes(owner, attributes));
            --i;
        }
        Stack nStack = new Stack();
        Stack aStack = new Stack();
        for (int i = 0; i < nodeVector.size(); ++i) {
            XPathCanonicalizer.serializeSubset(nStack, aStack, nodeVector, i, withComments, wr);
        }
    }

    private static void serializeSubset(Stack nStack, Stack aStack, Vector nodeVector, int i, boolean withComments, Writer wr) throws IOException {
        OMContainer parent;
        String prefix;
        Object obj = nodeVector.elementAt(i);
        if (obj == null) {
            return;
        }
        if (obj instanceof OMNamespaces) {
            OMNamespaces ancestorNss = nStack.empty() ? null : (OMNamespaces)nStack.peek();
            ((OMNamespaces)obj).serialize(ancestorNss, wr);
            nodeVector.setElementAt(null, i);
            return;
        }
        if (obj instanceof OMAttributes) {
            OMAttributes ancestorAttrs = aStack.empty() ? null : (OMAttributes)aStack.peek();
            ((OMAttributes)obj).serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, i);
            return;
        }
        OMNode node = (OMNode)obj;
        int type = node.getType();
        if (type != 1) {
            XPathCanonicalizer.serializeNode(null, node, null, withComments, true, wr);
            return;
        }
        wr.write("<");
        OMElement elem = (OMElement)node;
        String string = prefix = elem.getNamespace() == null ? null : elem.getNamespace().getPrefix();
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(elem.getLocalName());
        OMNamespaces ancestorNss = nStack.empty() ? null : (OMNamespaces)nStack.peek();
        OMNamespaces nss = null;
        int next = i + 1;
        if (next >= nodeVector.size() || nodeVector.elementAt(next) instanceof OMNode) {
            parent = node.getParent();
            if (!(parent instanceof OMDocument) && ancestorNss != null && ancestorNss.contains("")) {
                wr.write(" xmlns=\"\"");
            }
        } else if (nodeVector.elementAt(next) instanceof OMNamespaces) {
            nss = (OMNamespaces)nodeVector.elementAt(next);
            if (!nss.contains("") && !((parent = node.getParent()) instanceof OMDocument) && ancestorNss != null && ancestorNss.contains("")) {
                wr.write(" xmlns=\"\"");
            }
            nss.serialize(ancestorNss, wr);
            nodeVector.setElementAt(null, next);
            ++next;
        }
        OMAttributes ancestorAttrs = aStack.empty() ? null : (OMAttributes)aStack.peek();
        OMAttributes attrs = null;
        if (next < nodeVector.size() && nodeVector.elementAt(next) instanceof OMAttributes) {
            attrs = (OMAttributes)nodeVector.elementAt(next);
            attrs.serialize(ancestorAttrs, wr);
            nodeVector.setElementAt(null, next);
        }
        wr.write(">");
        nStack.push(nss);
        aStack.push(attrs);
        while (next < nodeVector.size()) {
            if (nodeVector.elementAt(next) == null) {
                ++next;
                continue;
            }
            if (!XPathCanonicalizer.isAncestor(nodeVector.elementAt(next), node)) break;
            XPathCanonicalizer.serializeSubset(nStack, aStack, nodeVector, next, withComments, wr);
            nodeVector.setElementAt(null, next++);
        }
        nStack.pop();
        aStack.pop();
        wr.write("</");
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(elem.getLocalName());
        wr.write(">");
    }

    static boolean isAncestor(Object me, OMNode anc) {
        OMNode parent = me instanceof OMAttributes ? ((OMAttributes)me).parent : (me instanceof OMNamespaces ? ((OMNamespaces)me).parent : (OMNode)me);
        while (parent != anc) {
            OMContainer cont = parent.getParent();
            if (cont instanceof OMDocument || cont == null) {
                return false;
            }
            parent = (OMNode)((Object)cont);
        }
        return true;
    }

    static boolean isOwnerElement(OMNode parent, OMAttribute child) {
        if (!(parent instanceof OMElement)) {
            return false;
        }
        if (child instanceof OMAttributeWithOwner && ((OMAttributeWithOwner)child).getOwnerElement() == parent) {
            return true;
        }
        OMElement elem = (OMElement)parent;
        Iterator ite = elem.getAllAttributes();
        while (ite.hasNext()) {
            if (!child.equals(ite.next())) continue;
            return true;
        }
        return false;
    }

    static boolean isOwnerElement(OMNode parent, OMNamespace child) {
        if (!(parent instanceof OMElement)) {
            return false;
        }
        if (child instanceof OMNamespaceWithOwner && ((OMNamespaceWithOwner)child).getOwnerElement() == parent) {
            return true;
        }
        OMElement elem = (OMElement)parent;
        Iterator ite = elem.getAllDeclaredNamespaces();
        while (ite.hasNext()) {
            if (!child.equals(ite.next())) continue;
            return true;
        }
        return false;
    }

    static void serializeNode(OMNode topNode, OMNode node, OMNode exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        XPathCanonicalizer.serializeNode(topNode, null, null, node, exceptedNode, withComments, xmlAttributes, wr);
    }

    private static void serializeNode(OMNode topNode, Stack nStack, Stack aStack, OMNode node, OMNode exceptedNode, boolean withComments, boolean xmlAttributes, Writer wr) throws IOException {
        if (exceptedNode == node) {
            return;
        }
        switch (node.getType()) {
            case 1: {
                String prefix;
                OMElement e = (OMElement)node;
                if (nStack == null) {
                    nStack = new Stack();
                }
                if (aStack == null) {
                    aStack = new Stack();
                }
                wr.write("<");
                String string = prefix = e.getNamespace() == null ? null : e.getNamespace().getPrefix();
                if (prefix != null && prefix.length() != 0) {
                    wr.write(prefix);
                    wr.write(":");
                }
                wr.write(e.getLocalName());
                XPathCanonicalizer.serializeNamespaces(topNode, nStack, e, wr);
                XPathCanonicalizer.serializeAttributes(topNode, aStack, e, xmlAttributes, wr);
                wr.write(">");
                for (OMNode child = e.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    XPathCanonicalizer.serializeNode(topNode, nStack, aStack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                nStack.pop();
                aStack.pop();
                wr.write("</");
                if (prefix != null && prefix.length() != 0) {
                    wr.write(prefix);
                    wr.write(":");
                }
                wr.write(e.getLocalName());
                wr.write(">");
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                C14nUtil.serializeText(((OMText)node).getText(), wr);
                break;
            }
            case 9: {
                for (OMNode child = ((OMContainer)((Object)node)).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    XPathCanonicalizer.serializeNode(topNode, nStack, aStack, child, exceptedNode, withComments, xmlAttributes, wr);
                }
                break;
            }
            case 3: {
                C14nUtil.serializePI(node, wr);
                break;
            }
            case 5: {
                if (!withComments) break;
                C14nUtil.serializeComment(node, wr);
                break;
            }
        }
    }

    private static boolean isTopElement(OMNode topNode, OMElement element) {
        if (topNode == element) {
            return true;
        }
        OMContainer parent = element.getParent();
        if (parent != null) {
            if (parent instanceof OMElement) {
                return false;
            }
            if (parent instanceof OMDocument) {
                return true;
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + ((OMNode)((Object)parent)).getType());
        }
        return true;
    }

    private static void serializeAttributes(OMNode topNode, Stack stack, OMElement element, boolean xmlAttributes, Writer wr) throws IOException {
        Hashtable xmlattrs;
        Hashtable<QName, OMAttribute> nsattrs = new Hashtable<QName, OMAttribute>();
        Iterator attrsIte = element.getAllAttributes();
        while (attrsIte.hasNext()) {
            OMAttribute a = (OMAttribute)attrsIte.next();
            nsattrs.put(a.getQName(), a);
        }
        if (xmlAttributes && (xmlattrs = XPathCanonicalizer.collectXMLPrefixAttributesInAncestors(element)) != null) {
            Enumeration en = xmlattrs.elements();
            while (en.hasMoreElements()) {
                OMAttribute attr = (OMAttribute)en.nextElement();
                nsattrs.put(attr.getQName(), attr);
            }
        }
        Hashtable parentAttrs = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        int atlen = nsattrs.size();
        String[] as = new String[atlen];
        int[] indexMap = new int[atlen];
        OMAttribute[] attrs = new OMAttribute[atlen];
        int i = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            OMAttribute attr = (OMAttribute)en.nextElement();
            indexMap[i] = i;
            attrs[i] = attr;
            as[i] = XPathCanonicalizer.createSortedString(attr);
            ++i;
        }
        C14nUtil.heapSort(indexMap, as, atlen);
        for (int j = 0; j < atlen; ++j) {
            OMAttribute xa;
            OMAttribute a = attrs[indexMap[j]];
            QName attrName = a.getQName();
            boolean checkURI = false;
            if (attrName.getPrefix() != null && attrName.getPrefix().equals("xml") && parentAttrs != null && (xa = (OMAttribute)parentAttrs.get(attrName)) != null && xa.getAttributeValue() != null && xa.getAttributeValue().equals(a.getAttributeValue())) continue;
            C14nUtil.serializeAttribute(a, wr, checkURI);
        }
    }

    private static void serializeNamespaces(OMNode topNode, Stack stack, OMElement element, Writer wr) throws IOException {
        Hashtable nsattrs = XPathCanonicalizer.collectNamespaceNodesInAncestors(element, false);
        Iterator nssIte = element.getAllDeclaredNamespaces();
        while (nssIte.hasNext()) {
            OMNamespace ns = (OMNamespace)nssIte.next();
            nsattrs.put(ns.getPrefix(), ns);
        }
        Hashtable parentNss = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(nsattrs);
        int nslen = nsattrs.size();
        String[] as = new String[nslen];
        int[] indexMap = new int[nslen];
        OMNamespace[] nss = new OMNamespace[nslen];
        int i = 0;
        Enumeration en = nsattrs.elements();
        while (en.hasMoreElements()) {
            OMNamespace ns = (OMNamespace)en.nextElement();
            indexMap[i] = i;
            nss[i] = ns;
            as[i] = XPathCanonicalizer.createSortedString(ns);
            ++i;
        }
        C14nUtil.heapSort(indexMap, as, nslen);
        for (int j = 0; j < nslen; ++j) {
            OMNamespace _ns;
            OMNamespace ns = nss[indexMap[j]];
            String prefix = ns.getPrefix();
            boolean checkURI = false;
            if (prefix.equals("xml")) continue;
            if (!(prefix != null && prefix.length() != 0 || ns.getName() != null && ns.getName().length() != 0)) {
                if (XPathCanonicalizer.isTopElement(topNode, element)) continue;
                boolean found = false;
                for (int depth = stack.size() - 1; depth >= 0; --depth) {
                    Hashtable nss2 = (Hashtable)stack.elementAt(depth);
                    OMNamespace ns2 = (OMNamespace)nss2.get("");
                    if (ns2 == null || ns2.getName() == null || ns2.getName().length() <= 0) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            checkURI = true;
            if (parentNss != null && (_ns = (OMNamespace)parentNss.get(prefix)) != null && _ns.getName() != null && _ns.getName().equals(ns.getName())) continue;
            C14nUtil.serializeNamespace(ns, wr, checkURI);
        }
    }

    public static Hashtable collectNamespaceNodesInAncestors(OMNode startNode, boolean useProxy) {
        OMNode node = startNode;
        Hashtable<String, OMNamespace> nsnodes = new Hashtable<String, OMNamespace>();
        OMFactory factory = startNode.getOMFactory();
        if (node.getType() == 1 && ((OMElement)node).findNamespaceURI("xml") == null) {
            if (useProxy) {
                nsnodes.put("xml", new OMNamespaceProxy(startNode, factory, XML_NAMESPACE, "xml"));
            } else {
                OMNamespace xa = factory.createOMNamespace(XML_NAMESPACE, "xml");
                nsnodes.put("xml", xa);
            }
        }
        if (node.getType() != 1) {
            OMContainer cont = node.getParent();
            node = cont instanceof OMDocument ? null : (OMElement)cont;
        }
        while (node != null) {
            OMContainer cont;
            Iterator nsList = ((OMElement)node).getAllDeclaredNamespaces();
            if (nsList != null) {
                while (nsList.hasNext()) {
                    OMNamespace newNs;
                    OMNamespace ns = (OMNamespace)nsList.next();
                    String prefix = ns.getPrefix();
                    if (nsnodes.containsKey(prefix)) continue;
                    if (node == startNode) {
                        nsnodes.put(prefix, ns);
                        continue;
                    }
                    if (useProxy) {
                        newNs = new OMNamespaceProxy(startNode, factory, ns.getName(), prefix);
                        nsnodes.put(prefix, newNs);
                        continue;
                    }
                    newNs = factory.createOMNamespace(ns.getName(), prefix);
                    nsnodes.put(prefix, newNs);
                }
            }
            if ((cont = node.getParent()) instanceof OMDocument) {
                node = null;
                continue;
            }
            node = (OMElement)cont;
        }
        return nsnodes;
    }

    public static void copyNamespaceNodesInAncestors(OMElement startNode) {
        OMElement node = startNode;
        OMContainer cont = node.getParent();
        while (cont instanceof OMElement) {
            node = (OMElement)cont;
            Iterator nsList = node.getAllDeclaredNamespaces();
            if (nsList == null) continue;
            while (nsList.hasNext()) {
                OMNamespace ns = (OMNamespace)nsList.next();
                startNode.declareNamespace(ns);
            }
        }
    }

    public static void copyNamespaceNodesInAncestorsRecursively(OMNode startNode) {
        if (startNode.getType() != 1) {
            return;
        }
        XPathCanonicalizer.copyNamespaceNodesInAncestors((OMElement)startNode);
        for (OMNode child = ((OMElement)startNode).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            switch (child.getType()) {
                case 1: 
                case 9: {
                    XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(child);
                }
            }
        }
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(OMNode startNode) {
        Iterator attributeList;
        Hashtable<QName, OMAttribute> attrs = null;
        OMContainer node = startNode.getParent();
        while (node instanceof OMElement) {
            Iterator attributeList2 = ((OMElement)node).getAllAttributes();
            if (attributeList2 != null) {
                while (attributeList2.hasNext()) {
                    OMAttribute attr = (OMAttribute)attributeList2.next();
                    QName qname = attr.getQName();
                    if (!"xml".equals(qname.getPrefix()) || attrs != null && attrs.containsKey(qname)) continue;
                    if (attrs == null) {
                        attrs = new Hashtable<QName, OMAttribute>();
                    }
                    attrs.put(qname, attr);
                }
            }
            node = ((OMElement)node).getParent();
        }
        if (attrs != null && (attributeList = ((OMElement)startNode).getAllAttributes()) != null) {
            while (attributeList.hasNext()) {
                OMAttribute attr = (OMAttribute)attributeList.next();
                QName qname = attr.getQName();
                if (!"xml".equals(qname.getPrefix()) || !attrs.containsKey(qname)) continue;
                attrs.remove(qname);
            }
        }
        return attrs;
    }

    private static String createSortedString(OMAttribute node) {
        String local = node.getLocalName();
        String uri = node.getNamespace() == null ? null : node.getNamespace().getName();
        String ret = uri == null || uri.length() == 0 ? "\u0001" + local : uri + "\u0001" + local;
        return ret;
    }

    private static String createSortedString(OMNamespace node) {
        String prefix = node.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            return "\u0000";
        }
        return "\u0000" + prefix;
    }

    static class OMNamespaces {
        OMNode parent;
        Hashtable namespaces;
        Hashtable rendered;

        OMNamespaces(OMNode node, Hashtable nss) {
            this.parent = node;
            this.namespaces = nss;
            if (this.namespaces == null) {
                this.namespaces = new Hashtable();
            }
            this.rendered = null;
        }

        boolean contains(String prefix) {
            return this.namespaces.containsKey(prefix);
        }

        private boolean rendered(String prefix) {
            if (this.rendered == null) {
                return false;
            }
            return this.rendered.containsKey(prefix);
        }

        private void setRendered(String prefix, OMNamespace a) {
            if (this.rendered == null) {
                this.rendered = new Hashtable();
            }
            this.rendered.put(prefix, a);
        }

        void serialize(OMNamespaces parent, Writer wr) throws IOException {
            OMNamespace ns;
            int j;
            int nsLength = this.namespaces.size();
            String[] as = new String[nsLength];
            int[] indexMap = new int[nsLength];
            OMNamespace[] nsArray = new OMNamespace[nsLength];
            Enumeration en = this.namespaces.elements();
            for (j = 0; j < nsLength; ++j) {
                ns = (OMNamespace)en.nextElement();
                indexMap[j] = j;
                nsArray[j] = ns;
                as[j] = XPathCanonicalizer.createSortedString(ns);
            }
            C14nUtil.heapSort(indexMap, as, nsLength);
            for (j = 0; j < nsLength; ++j) {
                ns = nsArray[indexMap[j]];
                String prefixName = ns.getPrefix();
                boolean checkURI = false;
                if (prefixName.equals("xml")) continue;
                checkURI = true;
                if (parent != null && parent.contains(prefixName) && parent.get(prefixName).getName().equals(ns.getName())) continue;
                C14nUtil.serializeNamespace(ns, wr, checkURI);
            }
        }

        Enumeration enumeration() {
            return this.namespaces.elements();
        }

        OMNamespace get(String prefix) {
            return (OMNamespace)this.namespaces.get(prefix);
        }

        private void remove(String prefix) {
            Object ns = this.namespaces.remove(prefix);
            if (ns == null) {
                // empty if block
            }
        }

        private boolean usePrefix(String prefix) {
            if (prefix.length() == 0) {
                return false;
            }
            Enumeration en = this.enumeration();
            while (en.hasMoreElements()) {
                OMNamespace ns = (OMNamespace)en.nextElement();
                String p = ns.getPrefix();
                if (p == null || !p.equals(prefix)) continue;
                return true;
            }
            return false;
        }

        private static boolean renderedInAncestors(Stack ancestors, String name, String ns) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                OMNamespaces nss = (OMNamespaces)ancestors.elementAt(i);
                if (!nss.rendered(name) || !nss.get(name).getName().equals(ns)) continue;
                return true;
            }
            return false;
        }

        private boolean utilizedInNearest(Stack ancestors, OMNamespace ns) {
            if (ancestors == null || ancestors.isEmpty()) {
                return false;
            }
            String prefix = ns.getPrefix();
            for (int i = ancestors.size() - 1; i >= 0; --i) {
                String eprefix;
                OMNamespaces nss = (OMNamespaces)ancestors.elementAt(i);
                if (nss.parent == null) continue;
                OMNamespace parentNS = ((OMElement)nss.parent).getNamespace();
                String string = eprefix = parentNS == null ? null : parentNS.getPrefix();
                if (eprefix == null) {
                    eprefix = "";
                }
                if (!prefix.equals(eprefix) && !nss.usePrefix(prefix)) continue;
                return nss.contains(ns.getPrefix()) && nss.get(ns.getPrefix()).getName().equals(ns.getName());
            }
            return false;
        }

        void serialize(Stack ancestors, Hashtable prefixList, String elprefix, Writer wr) throws IOException {
            OMNamespace ns;
            int j;
            int nsLength = this.namespaces.size();
            String[] as = new String[nsLength];
            int[] indexMap = new int[nsLength];
            OMNamespace[] nsArray = new OMNamespace[nsLength];
            Enumeration en = this.namespaces.elements();
            for (j = 0; j < nsLength; ++j) {
                ns = (OMNamespace)en.nextElement();
                indexMap[j] = j;
                nsArray[j] = ns;
                as[j] = XPathCanonicalizer.createSortedString(ns);
            }
            C14nUtil.heapSort(indexMap, as, nsLength);
            for (j = 0; j < nsLength; ++j) {
                ns = nsArray[indexMap[j]];
                String prefixName = ns.getPrefix();
                boolean checkURI = false;
                if (prefixName.equals("xml")) continue;
                checkURI = true;
                if (prefixList != null && prefixList.get(prefixName) != null) {
                    OMNamespaces par = null;
                    if (ancestors != null && !ancestors.isEmpty()) {
                        par = (OMNamespaces)ancestors.elementAt(ancestors.size() - 1);
                    }
                    if (par != null && par.contains(prefixName) && par.get(prefixName).getName().equals(ns.getName())) {
                        continue;
                    }
                } else if (elprefix == null || OMNamespaces.renderedInAncestors(ancestors, prefixName, ns.getName()) && this.utilizedInNearest(ancestors, ns) || elprefix != null && !elprefix.equals(prefixName) && !this.usePrefix(prefixName)) continue;
                this.setRendered(prefixName, ns);
                C14nUtil.serializeNamespace(ns, wr, checkURI);
            }
        }

        public String toString() {
            return "OMNamespaces[#=" + this.namespaces.size() + "]";
        }
    }

    static class OMAttributes {
        OMNode parent;
        Hashtable attributes;

        OMAttributes(OMNode node, Hashtable attrs) {
            this.parent = node;
            this.attributes = attrs;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
        }

        boolean contains(QName attrname) {
            return this.attributes.containsKey(attrname);
        }

        void serialize(OMAttributes parent, Writer wr) throws IOException {
            OMAttribute attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            OMAttribute[] attrArray = new OMAttribute[attrLength];
            Enumeration en = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (OMAttribute)en.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = XPathCanonicalizer.createSortedString(attr);
            }
            C14nUtil.heapSort(indexMap, as, attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                String prefix = attr.getNamespace() == null ? null : attr.getNamespace().getPrefix();
                boolean checkURI = false;
                if (prefix == null || prefix.equals("xml")) {
                    // empty if block
                }
                C14nUtil.serializeAttribute(attr, wr, checkURI);
            }
        }

        Enumeration enumeration() {
            return this.attributes.elements();
        }

        OMAttribute get(QName name) {
            return (OMAttribute)this.attributes.get(name);
        }

        private void remove(QName name) {
            Object attr = this.attributes.remove(name);
            if (attr == null) {
                // empty if block
            }
        }

        private boolean usePrefix(String prefix) {
            if (prefix.length() == 0) {
                return false;
            }
            Enumeration en = this.enumeration();
            while (en.hasMoreElements()) {
                OMAttribute attr = (OMAttribute)en.nextElement();
                String p = attr.getNamespace() == null ? null : attr.getNamespace().getPrefix();
                if (p == null || !p.equals(prefix)) continue;
                return true;
            }
            return false;
        }

        void serialize(Stack ancestors, Hashtable prefixList, String elprefix, Writer wr) throws IOException {
            OMAttribute attr;
            int j;
            int attrLength = this.attributes.size();
            String[] as = new String[attrLength];
            int[] indexMap = new int[attrLength];
            OMAttribute[] attrArray = new OMAttribute[attrLength];
            Enumeration en = this.attributes.elements();
            for (j = 0; j < attrLength; ++j) {
                attr = (OMAttribute)en.nextElement();
                indexMap[j] = j;
                attrArray[j] = attr;
                as[j] = XPathCanonicalizer.createSortedString(attr);
            }
            C14nUtil.heapSort(indexMap, as, attrLength);
            for (j = 0; j < attrLength; ++j) {
                attr = attrArray[indexMap[j]];
                boolean checkURI = false;
                C14nUtil.serializeAttribute(attr, wr, checkURI);
            }
        }

        public String toString() {
            return "OMAttributes[#=" + this.attributes.size() + "]";
        }
    }
}

