/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.Base64;

public class DOMUtil {
    public static final String S_XMLNS = "xmlns";
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    public static final String S_XMLNSATTRIBUTEURI = "http://www.w3.org/2000/xmlns/";
    private static final String[] INDENT_STRINGS = new String[]{"\n", "\n ", "\n  ", "\n   ", "\n    ", "\n     ", "\n      ", "\n       ", "\n        ", "\n         ", "\n          "};
    public static IndentConfig DEFAULT_INDENT = new IndentConfig(){

        public boolean doIndentation() {
            return false;
        }

        public int getUnit() {
            return 2;
        }
    };

    private DOMUtil() {
    }

    public static String getStringValue(OMNode node) {
        switch (node.getType()) {
            case 1: 
            case 9: {
                OMNode child = ((OMElement)node).getFirstOMChild();
                if (child == null) {
                    return "";
                }
                StringBuffer buf = new StringBuffer();
                DOMUtil.getStringValue0(node, buf);
                return new String(buf);
            }
            case 4: 
            case 6: 
            case 12: {
                return ((OMText)node).getText();
            }
            case 3: {
                return ((OMProcessingInstruction)node).getValue();
            }
            case 5: {
                return ((OMComment)node).getValue();
            }
        }
        throw new RuntimeException("Internal Error: Unexpected node type: " + node.getType());
    }

    private static void getStringValue0(OMNode n, StringBuffer buf) {
        switch (n.getType()) {
            case 1: {
                for (OMNode ch = ((OMElement)n).getFirstOMChild(); ch != null; ch = ch.getNextOMSibling()) {
                    DOMUtil.getStringValue0(ch, buf);
                }
                break;
            }
            case 4: 
            case 12: {
                DOMUtil.getStringValueFromText((OMText)n, buf);
                break;
            }
        }
    }

    private static void getStringValueFromText(OMText omText, StringBuffer buffer) {
        Object dh;
        if (omText.isOptimized() && (dh = omText.getDataHandler()) instanceof DataHandler) {
            try {
                InputStream is = ((DataHandler)dh).getInputStream();
                if (is != null) {
                    DOMUtil.toStringValueFromInputStream(is, buffer);
                    return;
                }
            }
            catch (IOException e) {
                RuntimeException rte = new RuntimeException("Internal Error: Unexpected IOException: " + e.getMessage());
                rte.initCause(e);
                throw rte;
            }
        }
        buffer.append(omText.getText());
    }

    private static void toStringValueFromInputStream(InputStream inStream, StringBuffer buffer) throws IOException {
        int avail = inStream.available();
        if (avail > 0) {
            buffer.ensureCapacity((int)((double)avail * 1.4) + buffer.length());
        }
        do {
            int len;
            byte[] data = new byte[1023];
            while ((len = inStream.read(data)) > 0) {
                Base64.encode(data, 0, len, buffer);
            }
        } while (inStream.available() > 0);
    }

    public static final OMElement createTextElementNS(OMFactory fac, OMElement parent, String localName, String value) {
        OMElement el = DOMUtils.createDsigOMElement(localName, fac, parent);
        el.addChild(fac.createOMText(value));
        return el;
    }

    public static final void appendText(OMElement el, String text) {
        el.addChild(el.getOMFactory().createOMText(text));
    }

    public static final void removeAllChildren(OMElement el) {
        Iterator children = el.getChildren();
        while (children.hasNext()) {
            OMNode child = (OMNode)children.next();
            child.detach();
        }
    }

    public static String getNamespaceForPrefix(String prefix, OMElement current) {
        if (prefix.equals("xml")) {
            return S_XMLNAMESPACEURI;
        }
        if (prefix.equals(S_XMLNS)) {
            return S_XMLNSATTRIBUTEURI;
        }
        OMNamespace ns = current.findNamespaceURI(prefix);
        if (ns != null) {
            return ns.getName();
        }
        return null;
    }

    public static String getNamespace(OMElement el) {
        OMNamespace ns = el.getNamespace();
        return ns.getName();
    }

    public static OMNode getPreviousSibling2(OMNode node) {
        OMNode ret = node.getPreviousOMSibling();
        if (ret == null) {
            OMContainer parent = node.getParent();
            if (parent instanceof OMDocument) {
                return null;
            }
            if (((OMNode)((Object)parent)).getType() == 9) {
                ret = DOMUtil.getPreviousSibling2((OMNode)((Object)parent));
            }
        } else {
            while (ret.getType() == 9) {
                Iterator i = ((OMContainer)((Object)ret)).getChildren();
                OMNode last = null;
                while (i.hasNext()) {
                    last = (OMNode)i.next();
                }
                if (last == null) {
                    ret = DOMUtil.getPreviousSibling2(ret);
                    break;
                }
                ret = last;
            }
        }
        return ret;
    }

    public static OMNode getNextSibling2(OMNode node) {
        OMNode ret = node.getNextOMSibling();
        if (ret == null) {
            OMContainer parent = node.getParent();
            if (parent instanceof OMDocument) {
                return null;
            }
            if (((OMNode)((Object)parent)).getType() == 9) {
                ret = DOMUtil.getNextSibling2((OMNode)((Object)parent));
            }
        } else {
            while (ret.getType() == 9) {
                OMNode first = ((OMContainer)((Object)ret)).getFirstOMChild();
                if (first == null) {
                    ret = DOMUtil.getNextSibling2(ret);
                    break;
                }
                ret = first;
            }
        }
        return ret;
    }

    public static OMNode getFirstChild2(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return null;
        }
        OMNode ret = ((OMContainer)((Object)node)).getFirstOMChild();
        while (ret != null && ret.getType() == 9) {
            OMNode first = ((OMContainer)((Object)ret)).getFirstOMChild();
            if (first == null) {
                ret = DOMUtil.getNextSibling2(ret);
                break;
            }
            ret = first;
        }
        return ret;
    }

    public static OMNode getLastChild2(OMNode node) {
        if (!(node instanceof OMContainer)) {
            return null;
        }
        Iterator i = ((OMContainer)((Object)node)).getChildren();
        OMNode ret = null;
        while (i.hasNext()) {
            ret = (OMNode)i.next();
        }
        while (ret != null && ret.getType() == 9) {
            Iterator i2 = ((OMContainer)((Object)ret)).getChildren();
            OMNode last = null;
            while (i2.hasNext()) {
                last = (OMNode)i2.next();
            }
            if (last == null) {
                ret = DOMUtil.getPreviousSibling2(ret);
                break;
            }
            ret = last;
        }
        return ret;
    }

    public static OMElement getNextElement(OMNode element) {
        OMNode next = element;
        while ((next = DOMUtil.getNextSibling2(next)) != null && next.getType() != 1) {
        }
        return (OMElement)next;
    }

    public static OMElement getFirstChildElement(OMNode parent) {
        OMNode child = DOMUtil.getFirstChild2(parent);
        while (child != null && child.getType() != 1) {
            child = DOMUtil.getNextSibling2(child);
        }
        return (OMElement)child;
    }

    public static OMElement getFirstChildElementNamed(OMNode parent, String local) {
        if (!(parent instanceof OMContainer)) {
            return null;
        }
        OMNode child = ((OMContainer)((Object)parent)).getFirstOMChild();
        while (!(child == null || child.getType() == 1 && ((OMElement)child).getLocalName().equals(local))) {
            child = DOMUtil.getNextSibling2(child);
        }
        return (OMElement)child;
    }

    public static OMElement getFirstChildElementNamed(OMNode parent, String ns, String local) {
        if (!(parent instanceof OMContainer)) {
            return null;
        }
        OMNode child = ((OMContainer)((Object)parent)).getFirstOMChild();
        while (child != null) {
            if (child.getType() == 1) {
                OMElement el = (OMElement)child;
                String elns = DOMUtil.getNamespace(el);
                if ((local.equals("*") || el.getLocalName().equals(local)) && (ns == null && elns == null || ns != null && ns.equals("*") || ns != null && ns.equals(elns))) break;
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return (OMElement)child;
    }

    public static boolean checkAllSpaces(String str) {
        for (int s = 0; s < str.length(); ++s) {
            char ch = str.charAt(s);
            if (ch <= ' ' && 0 <= " \t\r\n".indexOf(ch)) continue;
            return false;
        }
        return true;
    }

    public static void writeEscapedAttribute(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                writer.write("&lt;");
                continue;
            }
            if ('&' == ch) {
                writer.write("&amp;");
                continue;
            }
            if ('\t' == ch) {
                writer.write("&#x9;");
                continue;
            }
            if ('\n' == ch) {
                writer.write("&#xA;");
                continue;
            }
            if ('\r' == ch) {
                writer.write("&#xD;");
                continue;
            }
            if ('\"' == ch) {
                writer.write("&quot;");
                continue;
            }
            writer.write(ch);
        }
    }

    public static void writeEscapedCharData(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ('<' == ch) {
                writer.write("&lt;");
                continue;
            }
            if ('&' == ch) {
                writer.write("&amp;");
                continue;
            }
            if ('>' == ch) {
                writer.write("&gt;");
                continue;
            }
            if ('\r' == ch) {
                writer.write("&#xD;");
                continue;
            }
            writer.write(ch);
        }
    }

    public static String escapeAttribute(String string) {
        StringBuffer buffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ("<&\t\n\r\"".indexOf(ch) >= 0) {
                if (buffer == null) {
                    buffer = new StringBuffer(string.length() * 2);
                    buffer.append(string.substring(0, i));
                }
                if ('<' == ch) {
                    buffer.append("&lt;");
                    continue;
                }
                if ('&' == ch) {
                    buffer.append("&amp;");
                    continue;
                }
                if ('\t' == ch) {
                    buffer.append("&#x9;");
                    continue;
                }
                if ('\n' == ch) {
                    buffer.append("&#xA;");
                    continue;
                }
                if ('\r' == ch) {
                    buffer.append("&#xD;");
                    continue;
                }
                if ('\"' != ch) continue;
                buffer.append("&quot;");
                continue;
            }
            if (buffer == null) continue;
            buffer.append(ch);
        }
        return buffer == null ? string : new String(buffer);
    }

    public static String escapeCharData(String string) {
        StringBuffer buffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if ("<&>\r".indexOf(ch) >= 0) {
                if (buffer == null) {
                    buffer = new StringBuffer(string.length() * 2);
                    buffer.append(string.substring(0, i));
                }
                if ('<' == ch) {
                    buffer.append("&lt;");
                    continue;
                }
                if ('&' == ch) {
                    buffer.append("&amp;");
                    continue;
                }
                if ('>' == ch) {
                    buffer.append("&gt;");
                    continue;
                }
                if ('\r' != ch) continue;
                buffer.append("&#xD;");
                continue;
            }
            if (buffer == null) continue;
            buffer.append(ch);
        }
        return buffer == null ? string : new String(buffer);
    }

    public static void replacePrefix(OMElement el, String ns, String prefix) {
        if (ns == null && (el.getNamespace() == null ? null : el.getNamespace().getName()) == null || ns != null && ns.equals(el.getNamespace() == null ? null : el.getNamespace().getName())) {
            el.setNamespace(el.getOMFactory().createOMNamespace(ns, prefix));
        }
        OMNode child = DOMUtil.getFirstChild2(el);
        while (child != null) {
            if (child.getType() == 1) {
                DOMUtil.replacePrefix((OMElement)child, ns, prefix);
            }
            child = DOMUtil.getNextSibling2(child);
        }
    }

    private static String getIndentText(IndentConfig iconf, int level) {
        String text;
        if (!iconf.doIndentation()) {
            return null;
        }
        int sp = iconf.getUnit() * level;
        if (sp < INDENT_STRINGS.length) {
            text = INDENT_STRINGS[sp];
        } else {
            StringBuffer buffer = new StringBuffer(1 + sp);
            buffer.append(INDENT_STRINGS[INDENT_STRINGS.length - 1]);
            for (int i = INDENT_STRINGS.length - 1; i < sp; ++i) {
                buffer.append(' ');
            }
            text = new String(buffer);
        }
        return text;
    }

    public static String getSpaces(IndentConfig iconf, int level) {
        if (iconf == null) {
            iconf = DEFAULT_INDENT;
        }
        int sp = iconf.getUnit() * level;
        StringBuffer buffer = new StringBuffer(sp);
        for (int i = 0; i < sp; ++i) {
            buffer.append(' ');
        }
        return new String(buffer);
    }

    private static OMNode getIndentNode(OMFactory factory, IndentConfig iconf, int level) {
        return factory.createOMText(DOMUtil.getIndentText(iconf, level));
    }

    public static void addIndent(OMElement el, IndentConfig iconf, int level) {
        if (iconf == null) {
            iconf = DEFAULT_INDENT;
        }
        if (!iconf.doIndentation()) {
            return;
        }
        el.addChild(DOMUtil.getIndentNode(el.getOMFactory(), iconf, level));
    }

    public static void addIndentBefore(OMElement parent, OMNode next, IndentConfig iconf, int level) {
        if (iconf == null) {
            iconf = DEFAULT_INDENT;
        }
        if (!iconf.doIndentation()) {
            return;
        }
        OMNode indentNode = DOMUtil.getIndentNode(parent.getOMFactory(), iconf, level);
        if (next == null) {
            parent.addChild(indentNode);
        } else {
            next.insertSiblingBefore(indentNode);
        }
    }

    public static OMDocument getOwnerDocument(OMNode node) {
        while (true) {
            OMContainer parent;
            if ((parent = node.getParent()) == null) {
                OMFactory fac = node.getOMFactory();
                OMDocument doc = fac.createOMDocument();
                doc.addChild(node);
                return doc;
            }
            if (parent instanceof OMDocument) {
                return (OMDocument)parent;
            }
            node = (OMNode)((Object)parent);
        }
    }
}

