/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class DOMBuilder
implements ContentHandler,
LexicalHandler {
    public static final String XMLNS_NSURI = "http://www.w3.org/2000/xmlns/";
    private OMNode contextNode = null;
    private OMDocument document = null;
    private Stack contextStack = new Stack();
    private OMFactory factory;
    private boolean inCdata = false;
    private Vector prefixes = null;
    private StringBuffer buffer = null;
    static Stack s_parserPool = new Stack();
    static SAXParserFactory s_factory = null;

    public DOMBuilder(OMFactory factory) {
        this.reset(factory);
    }

    public void reset(OMFactory factory) {
        this.factory = factory;
        this.contextStack.setSize(0);
        this.contextNode = null;
        this.document = null;
        this.inCdata = false;
        this.prefixes = null;
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
    }

    public OMNode getNode() {
        this.flushText();
        return this.contextNode;
    }

    protected void output(OMNode node) {
        if (this.contextNode == null) {
            this.contextNode = node;
            this.document.addChild(node);
        } else {
            ((OMElement)this.contextNode).addChild(node);
        }
    }

    protected void pushContext(OMContainer newContext) {
        if (newContext instanceof OMNode) {
            this.contextStack.push(this.contextNode);
            this.contextNode = (OMNode)((Object)newContext);
        } else {
            this.document = (OMDocument)newContext;
        }
    }

    protected OMNode popContext() {
        OMNode ret = this.contextNode;
        this.contextNode = (OMNode)this.contextStack.pop();
        return ret;
    }

    protected void flushText() {
        if (this.buffer == null || this.buffer.length() == 0) {
            return;
        }
        String text = new String(this.buffer);
        OMText node = this.inCdata ? this.factory.createOMText(text) : this.factory.createOMText(text);
        this.output(node);
        this.buffer.setLength(0);
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this.characters(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        OMProcessingInstruction pi = null;
        this.flushText();
        pi = this.factory.createOMProcessingInstruction(null, target, data);
        this.output(pi);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushText();
        String data = new String(ch, start, length);
        OMComment node = this.factory.createOMComment(null, data);
        this.output(node);
    }

    public void startDocument() throws SAXException {
        this.pushContext(this.factory.createOMDocument());
    }

    public void endDocument() throws SAXException {
        this.output(this.popContext());
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.prefixes == null) {
            this.prefixes = new Vector();
        }
        OMNamespace attr = this.factory.createOMNamespace(uri, prefix);
        this.prefixes.addElement(attr);
    }

    public void startElement(String uri, String local, String qname, Attributes atts) throws SAXException {
        int i;
        this.flushText();
        String prefix = null;
        int colonIndex = qname.indexOf(58);
        if (colonIndex >= 0) {
            prefix = qname.substring(0, colonIndex);
        }
        OMElement elem = this.factory.createOMElement(local, uri, prefix);
        for (i = 0; i < atts.getLength(); ++i) {
            String ns = atts.getURI(i);
            String qn = atts.getQName(i);
            colonIndex = qn.indexOf(58);
            if (colonIndex >= 0) {
                if (qn.startsWith("xmlns:")) {
                    elem.declareNamespace(ns, qn.substring(colonIndex + 1));
                    continue;
                }
                elem.addAttribute(qn.substring(0, colonIndex), atts.getValue(i), this.factory.createOMNamespace(ns, qn.substring(colonIndex + 1)));
                continue;
            }
            if (qn.equals("xmlns")) {
                elem.declareNamespace(ns, "");
                continue;
            }
            elem.addAttribute(qn, atts.getValue(i), this.factory.createOMNamespace(ns, ""));
        }
        if (this.prefixes != null && this.prefixes.size() > 0) {
            for (i = 0; i < this.prefixes.size(); ++i) {
                OMNamespace attr = (OMNamespace)this.prefixes.elementAt(i);
                elem.declareNamespace(attr);
            }
            this.prefixes.removeAllElements();
        }
        this.pushContext(elem);
    }

    public void endElement(String uri, String local, String qname) throws SAXException {
        this.flushText();
        this.output(this.popContext());
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startDTD(String root, String p, String s) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        Stack stack = s_parserPool;
        synchronized (stack) {
            if (!s_parserPool.isEmpty()) {
                return (XMLReader)s_parserPool.pop();
            }
        }
        return s_factory.newSAXParser().getXMLReader();
    }

    public static void releaseXMLReader(XMLReader parser) {
        s_parserPool.push(parser);
    }

    public static OMDocument parse(InputStream is) throws XMLStreamException {
        StAXOMBuilder builder = new StAXOMBuilder(is);
        return builder.getDocument();
    }

    public static OMDocument parse(byte[] src) throws XMLStreamException {
        return DOMBuilder.parse(new ByteArrayInputStream(src));
    }

    static {
        try {
            Class<?> cl = Class.forName("jaxp.SAXParserFactoryImpl");
            s_factory = (SAXParserFactory)cl.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_factory == null) {
            s_factory = SAXParserFactory.newInstance();
        }
        s_factory.setNamespaceAware(true);
    }
}

