/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import java.io.IOException;
import java.io.Writer;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;

public final class C14nUtil {
    private static final int TEXT_TAB_SIZE = 64;
    private static final String[] textTab = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};
    private static final int[] fixTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, -2048, -2048, -2048, -2048};

    static final void serializeText(String text, Writer wr) throws IOException {
        int len = text.length();
        int start = -1;
        for (int i = 0; i < len; ++i) {
            String escaped;
            char ch = text.charAt(i);
            String string = escaped = ch < '@' ? textTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(text, start, i - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            wr.write(text, start, len - start);
        }
    }

    static final void serializePI(OMNode node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParent() instanceof OMDocument) {
            OMNode prev = node;
            while ((prev = prev.getPreviousOMSibling()) != null && prev.getType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        OMProcessingInstruction pi = (OMProcessingInstruction)node;
        if (greater) {
            wr.write("\n");
        }
        wr.write("<?");
        wr.write(pi.getTarget());
        if (pi.getValue() != null && pi.getValue().length() > 0) {
            wr.write(" ");
            String data = pi.getValue();
            int start = 0;
            for (int index = 0; index < data.length(); ++index) {
                if (data.charAt(index) != '\r') continue;
                if (index > start) {
                    wr.write(data, start, index - start);
                }
                wr.write("&#xD;");
                start = index + 1;
            }
            if (start < data.length()) {
                wr.write(data, start, data.length() - start);
            }
        }
        wr.write("?>");
        if (lesser) {
            wr.write("\n");
        }
    }

    static final void serializeComment(OMNode node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParent() instanceof OMDocument) {
            OMNode prev = node;
            while ((prev = prev.getPreviousOMSibling()) != null && prev.getType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        if (greater) {
            wr.write("\n");
        }
        wr.write("<!--");
        wr.write(((OMComment)node).getValue());
        wr.write("-->");
        if (lesser) {
            wr.write("\n");
        }
    }

    static final void serializeAttribute(OMAttribute attr, Writer wr, boolean checkURI) throws IOException {
        OMNamespace ns = attr.getNamespace();
        String prefix = ns == null ? null : ns.getPrefix();
        C14nUtil.serializeAttribute(prefix, attr.getLocalName(), attr.getAttributeValue(), wr, checkURI);
    }

    static final void serializeAttribute(String prefix, String local, String value, Writer wr, boolean checkURI) throws IOException {
        int len = value.length();
        int start = -1;
        boolean hasColon = false;
        wr.write(" ");
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(local);
        wr.write("=\"");
        for (int j = 0; j < len; ++j) {
            String escaped;
            char ch = value.charAt(j);
            String string = escaped = ch < '@' ? attrTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(value, start, j - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start >= 0) continue;
            start = j;
        }
        if (start >= 0) {
            wr.write(value, start, len - start);
        }
        wr.write("\"");
    }

    static final void serializeNamespace(OMNamespace ns, Writer wr, boolean checkURI) throws IOException {
        C14nUtil.serializeNamespace(ns.getPrefix(), ns.getName(), wr, checkURI);
    }

    static final void serializeNamespace(String prefix, String uri, Writer wr, boolean checkURI) throws IOException {
        int len = uri.length();
        int start = -1;
        boolean hasColon = false;
        wr.write(" xmlns");
        if (prefix != null && prefix.length() != 0) {
            wr.write(":");
            wr.write(prefix);
        }
        wr.write("=\"");
        for (int j = 0; j < len; ++j) {
            String escaped;
            char ch = uri.charAt(j);
            String string = escaped = ch < '@' ? attrTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(uri, start, j - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start < 0) {
                start = j;
            }
            if (!checkURI) continue;
            if (ch == ':') {
                hasColon = true;
                continue;
            }
            if (ch != '/' || hasColon) continue;
            throw new RuntimeException("Found a relative URI: xmlns:" + prefix + "='" + uri + "'");
        }
        if (start >= 0) {
            wr.write(uri, start, len - start);
        }
        if (uri.length() > 0 && checkURI && !hasColon) {
            throw new RuntimeException("Found a relative URI: xmlns:" + prefix + "='" + uri + "'");
        }
        wr.write("\"");
    }

    public static void heapSort(int[] indexMap, String[] pd, int length) {
        int i;
        for (i = length / 2; i >= 0; --i) {
            C14nUtil.fall(indexMap, pd, length, i);
        }
        for (i = length - 1; i > 0; --i) {
            int t = indexMap[0];
            indexMap[0] = indexMap[i];
            indexMap[i] = t;
            C14nUtil.fall(indexMap, pd, i, 0);
        }
    }

    private static void fall(int[] indexMap, String[] pd, int n, int i) {
        int j = 2 * i + 1;
        if (j < n) {
            if (j + 1 < n && 0 > pd[indexMap[j]].compareTo(pd[indexMap[j + 1]])) {
                j = 2 * i + 2;
            }
            if (0 > C14nUtil.compareInUCS(pd[indexMap[i]], pd[indexMap[j]])) {
                int t = indexMap[i];
                indexMap[i] = indexMap[j];
                indexMap[j] = t;
                C14nUtil.fall(indexMap, pd, n, j);
            }
        }
    }

    public static final int lengthInUCS(String str) {
        int length = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ('\ud800' <= ch && ch < '\udc00') {
                ++i;
            }
            ++length;
        }
        return length;
    }

    public static final int compareInUCS(String s1, String s2) {
        int len2;
        int len1 = s1.length();
        int minlen = len1 < (len2 = s2.length()) ? len1 : len2;
        int i1 = 0;
        int i2 = 0;
        while (minlen-- != 0) {
            int c1 = s1.charAt(i1++);
            c1 += fixTable[c1 >> 11];
            int c2 = s2.charAt(i2++);
            if (c1 == (c2 += fixTable[c2 >> 11])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }
}

