/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j;

import com.ibm.ws.wssecurity.core.EncryptionEngine;
import com.ibm.ws.wssecurity.core.EngineFactory;
import com.ibm.ws.wssecurity.core.KeyGenerationEngine;
import com.ibm.ws.wssecurity.core.SignatureEngine;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.DigestMethod;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.SignatureMethod;
import com.ibm.ws.wssecurity.wssobject.impl.xenc.EncryptionMethod;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Canonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureEngineDSA;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureEngineHMAC;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureEngineRSA;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.ExclusiveC11r;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.enc.DOMSerializationEngine;
import com.ibm.ws.wssecurity.xml.xss4j.enc.EncryptionEngineImpl;
import com.ibm.ws.wssecurity.xml.xss4j.enc.KeyGenerationEngineImpl;
import com.ibm.ws.wssecurity.xml.xss4j.enc.StructureException;
import com.ibm.ws.wssecurity.xml.xss4j.enc.type.OAEPParams;
import com.ibm.ws.wssecurity.xml.xss4j.enc.util.Util;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmFactory
implements EngineFactory {
    private static final TraceComponent tc = Tr.register(AlgorithmFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static boolean fipsEnabled = false;
    private static List<Provider> providers = new ArrayList<Provider>();
    private static AlgorithmFactory s_theInstance;
    protected static Stack<MessageDigest> sha1Pool;
    protected static Stack<MessageDigest> sha256Pool;
    protected static Stack<MessageDigest> sha512Pool;
    protected static Stack<SignatureEngine> rsaPool;
    protected static Stack<SignatureEngine> dsaPool;
    protected static Stack<SignatureEngine> hmacPool;
    protected static HashMap<String, Stack<EncryptionEngine>> eePoolMap;
    protected static Stack<KeyGenerationEngine> kge3desPool;
    protected static HashMap hwcSha1Map;
    protected static HashMap hwcSha256Map;
    protected static HashMap hwcSha512Map;
    protected static HashMap<String, SignatureEngine> hwcRsaMap;
    protected static HashMap<String, SignatureEngine> hwcDsaMap;
    protected static HashMap<String, SignatureEngine> hwcHmacMap;
    protected static HashMap<String, EncryptionEngine> hwcEERsaMap;
    protected static HashMap<String, EncryptionEngine> hwcEE3desMap;
    protected static HashMap<String, EncryptionEngine> hwcEEAes128Map;
    protected static HashMap<String, EncryptionEngine> hwcEEAes192Map;
    protected static HashMap<String, EncryptionEngine> hwcEEAes256Map;
    protected static HashMap<String, EncryptionEngine> hwcEERsaOaepMap;
    protected static HashMap<String, EncryptionEngine> hwcEEkw3desMap;
    protected static HashMap<String, EncryptionEngine> hwcEEkwAes128Map;
    protected static HashMap<String, EncryptionEngine> hwcEEkwAes192Map;
    protected static HashMap<String, EncryptionEngine> hwcEEkwAes256Map;
    protected static HashMap hwcKge3desMap;
    private boolean debug = false;
    protected static DocumentBuilderFactory documentBuilderFactory;
    protected static Stack<DocumentBuilder> documentBuilderPool;
    private final String MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5".intern();
    protected Provider provider;
    protected String providerName;
    protected HashMap<String, String> digestMethodTable;
    protected HashMap<String, String> transformTable;
    protected HashMap<String, String> canonicalizerTable;
    protected Set<String> supportedSignature;
    protected Set<String> supportedDigest;
    protected Set<String> supportedDataEncryption;
    protected Set<String> supportedKeyEncryption;
    protected final List<EngineFactory> childFactory;
    protected final Map<EngineFactory, Set<String>> childFactoryURIs;
    private ThreadLocal<Map<String, Object>> _providerMap = new ThreadLocal();
    private ThreadLocal<String> _allCryptoOffload = new ThreadLocal();

    public void setCryptoOffloadProperty(String allCryptoOffload) {
        this._allCryptoOffload.set(allCryptoOffload);
    }

    private Map<String, Object> getProviderMap() {
        Map<String, Object> map = this._providerMap.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            this._providerMap.set(map);
        }
        return map;
    }

    public void clearLocalProviderMap() {
        this.getProviderMap().clear();
    }

    public void setLocalProvider(String key, Object value) {
        this.getProviderMap().put(key, value);
    }

    public Object getLocalProvider(String key) {
        return this.getProviderMap().get(key);
    }

    public Map<String, Object> getProviderMaps() {
        return this.getProviderMap();
    }

    public static AlgorithmFactory getInstance() {
        return s_theInstance;
    }

    protected AlgorithmFactory(String provider) {
        if (!fipsEnabled) {
            providers.clear();
            providers.add(provider == null ? null : Security.getProvider(provider));
        }
        this.childFactory = new Vector<EngineFactory>();
        this.childFactoryURIs = new Hashtable<EngineFactory, Set<String>>();
        this.supportedDataEncryption = new HashSet<String>();
        this.supportedKeyEncryption = new HashSet<String>();
        this.supportedDataEncryption.add("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        this.supportedDataEncryption.add("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.supportedDataEncryption.add("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        this.supportedDataEncryption.add("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#kw-aes128");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#kw-aes192");
        this.supportedKeyEncryption.add("http://www.w3.org/2001/04/xmlenc#kw-aes256");
        this.supportedSignature = new HashSet<String>();
        this.supportedSignature.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        this.supportedSignature.add("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        this.supportedSignature.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        this.digestMethodTable = new HashMap();
        this.digestMethodTable.put("http://www.w3.org/2000/09/xmldsig#sha1", "SHA");
        this.digestMethodTable.put(this.MD5, "md5");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#sha256", "SHA256");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#sha512", "SHA512");
        this.digestMethodTable.put("http://www.w3.org/2001/04/xmlenc#ripemd160", "RIPEMD160");
        this.supportedDigest = new HashSet<String>();
        this.supportedDigest.add("http://www.w3.org/2000/09/xmldsig#sha1");
        this.supportedDigest.add(this.MD5);
        this.supportedDigest.add("http://www.w3.org/2001/04/xmlenc#sha256");
        this.supportedDigest.add("http://www.w3.org/2001/04/xmlenc#sha512");
        this.supportedDigest.add("http://www.w3.org/2001/04/xmlenc#ripemd160");
        this.transformTable = new HashMap();
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.transformTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.ExclusiveC11r");
        this.transformTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.ExclusiveC11rWC");
        this.transformTable.put("http://www.w3.org/2000/09/xmldsig#base64", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.Base64Transformer");
        this.transformTable.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.Enveloped");
        this.transformTable.put("http://www.w3.org/TR/1999/REC-xslt-19991116", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XSLTTransformer");
        this.transformTable.put("http://www.w3.org/TR/1999/REC-xpath-19991116", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XPathTransformer");
        this.transformTable.put("http://www.w3.org/2002/06/xmldsig-filter2", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XPath2Transformer");
        this.transformTable.put("http://www.w3.org/2001/04/decrypt#", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XMLDecryptionTransformer");
        this.transformTable.put("http://www.w3.org/2002/07/decrypt#XML", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.XMLDecryptionTransformer2");
        this.transformTable.put("http://www.w3.org/2002/07/decrypt#Binary", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.BinaryDecryptionTransformer");
        this.canonicalizerTable = new HashMap();
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000601", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20000613", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-c14n#", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/WD-xml-c14n-20001011#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/TR/2000/CR-xml-c14n-20001026#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2WC");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-c14n#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.W3CCanonicalizer2");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-exc-c14n#", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.ExclusiveC11r");
        this.canonicalizerTable.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "com.ibm.ws.wssecurity.xml.xss4j.dsig.transform.ExclusiveC11rWC");
    }

    public String getProvider() {
        return null;
    }

    @Override
    public Set getSignatureAlgorithms() {
        return this.supportedSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignatureEngine getSignatureEngine(String uri) throws NoSuchAlgorithmException {
        Stack<SignatureEngine> e3;
        SignatureEngine eng;
        SignatureEngine eng2;
        if (uri == null) {
            throw new NullPointerException("No SignatureMethod for null.");
        }
        boolean pcnt = false;
        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
        if (p1 != null && ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(uri) ? (eng2 = hwcRsaMap.get(p1.getName())) != null : ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(uri) ? (eng2 = hwcDsaMap.get(p1.getName())) != null : "http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri) && (eng2 = hwcHmacMap.get(p1.getName())) != null))) {
            return eng2;
        }
        Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
        if (p2 != null && ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(uri) ? (eng = hwcRsaMap.get(p2.getName())) != null : ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(uri) ? (eng = hwcDsaMap.get(p2.getName())) != null : "http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri) && (eng = hwcHmacMap.get(p2.getName())) != null))) {
            return eng;
        }
        if (p1 != null) {
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getSignatureEngine, hw provider name: " + p1.getName() + "and uri is: " + uri);
                }
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                    return new SignatureEngineHMAC(uri, p1);
                }
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    return new SignatureEngineRSA(uri, p1);
                }
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    return new SignatureEngineDSA(uri, p1);
                }
            }
            catch (NoSuchAlgorithmException e2) {
                System.out.println("HARDWARE CRYPTO, In AlgFactory, caught Exception" + e2.getMessage());
                e2.printStackTrace();
            }
        }
        if (p2 != null) {
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getSignatureEngine, hw provider name: " + p2.getName() + "and uri is: " + uri);
                }
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                    return new SignatureEngineHMAC(uri, p2);
                }
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    return new SignatureEngineRSA(uri, p2);
                }
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    return new SignatureEngineDSA(uri, p2);
                }
            }
            catch (NoSuchAlgorithmException e3) {
                System.out.println("HARDWARE CRYPTO, In AlgFactory, caught Exception" + e3.getMessage());
                e3.printStackTrace();
            }
        }
        if ((p1 != null || p2 != null) && this.debug) {
            System.out.println("HARDWARE CRYPTO: getSignatureEngine fails with hardware crypto provider. Continue to use JCE provider");
        }
        if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(uri)) {
            e3 = rsaPool;
            synchronized (e3) {
                if (!rsaPool.empty()) {
                    if (this.debug) {
                        System.out.println("HARDWARE CRYPTO: Alg Factory. getting it from pool");
                    }
                    return rsaPool.pop();
                }
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(uri)) {
            e3 = dsaPool;
            synchronized (e3) {
                if (!dsaPool.empty()) {
                    return dsaPool.pop();
                }
            }
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri)) {
            e3 = hmacPool;
            synchronized (e3) {
                if (!hmacPool.empty()) {
                    return hmacPool.pop();
                }
            }
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            for (EngineFactory factory : this.childFactory) {
                SignatureEngine engine2;
                Set<String> uris = this.childFactoryURIs.get(factory);
                if (uris == null || !(uris instanceof Set) || !uris.contains(uri) || !factory.getSignatureAlgorithms().contains(uri) || (engine2 = factory.getSignatureEngine(uri)) == null) continue;
                return engine2;
            }
        }
        int i = 0;
        while (true) {
            if (i >= providers.size()) break;
            try {
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                    return new SignatureEngineHMAC(uri, providers.get(i));
                }
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    if (this.debug) {
                        System.out.println("HARDWARE CRYPTO:Alg Factory getting it using software provider" + providers.get(i));
                    }
                    return new SignatureEngineRSA(uri, providers.get(i));
                }
                if (uri.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    return new SignatureEngineDSA(uri, providers.get(i));
                }
            }
            catch (NoSuchAlgorithmException e4) {
                // empty catch block
            }
            ++i;
        }
        throw new NoSuchAlgorithmException("No SignatureEngine for " + uri);
    }

    @Override
    public boolean releaseSignatureEngine(SignatureEngine eng) {
        if (this.getProviderMaps().isEmpty()) {
            if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(eng.getURI())) {
                rsaPool.push(eng);
                return true;
            }
            if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(eng.getURI())) {
                dsaPool.push(eng);
                return true;
            }
            if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(eng.getURI())) {
                hmacPool.push(eng);
                return true;
            }
            if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
                for (EngineFactory factory : this.childFactory) {
                    if (!factory.releaseSignatureEngine(eng)) continue;
                    return true;
                }
            }
        } else {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, releaseSignatureEngine hw provider is in use");
            }
            if ("http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(eng.getURI())) {
                Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                if (p1 != null) {
                    hwcRsaMap.put(p1.getName(), eng);
                } else {
                    Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                    if (p2 != null) {
                        hwcRsaMap.put(p2.getName(), eng);
                    }
                }
                return true;
            }
            if ("http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(eng.getURI())) {
                Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                if (p1 != null) {
                    hwcDsaMap.put(p1.getName(), eng);
                } else {
                    Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                    if (p2 != null) {
                        hwcDsaMap.put(p2.getName(), eng);
                    }
                }
                return true;
            }
            if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(eng.getURI())) {
                Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                if (p1 != null) {
                    hwcHmacMap.put(p1.getName(), eng);
                } else {
                    Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                    if (p2 != null) {
                        hwcHmacMap.put(p2.getName(), eng);
                    }
                }
                return true;
            }
        }
        return this.supportedSignature.contains(eng.getURI());
    }

    @Override
    public Set getDigestAlgorithms() {
        return this.supportedDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageDigest getMessageDigest(String uri, AlgorithmParameterSpec spec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Stack<MessageDigest> stack;
        if (uri == null) {
            throw new NullPointerException("Algorithm identifier is null.");
        }
        if (spec != null) {
            throw new InvalidAlgorithmParameterException("The algorithm " + uri + " does not support AlgorihmParameterSpec.");
        }
        String algName = this.digestMethodTable.get(uri);
        if (algName == null) {
            throw new NoSuchAlgorithmException("No DigestMethod for " + uri);
        }
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            stack = sha1Pool;
            synchronized (stack) {
                if (!sha1Pool.empty()) {
                    MessageDigest digest = sha1Pool.pop();
                    digest.reset();
                    return digest;
                }
            }
        } else if (uri.equals("http://www.w3.org/2001/04/xmlenc#sha256")) {
            stack = sha256Pool;
            synchronized (stack) {
                if (!sha256Pool.empty()) {
                    MessageDigest digest = sha256Pool.pop();
                    digest.reset();
                    return digest;
                }
            }
        } else if (uri.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            stack = sha512Pool;
            synchronized (stack) {
                if (!sha512Pool.empty()) {
                    MessageDigest digest = sha512Pool.pop();
                    digest.reset();
                    return digest;
                }
            }
        } else if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            for (EngineFactory factory : this.childFactory) {
                MessageDigest digest;
                Set<String> uris = this.childFactoryURIs.get(factory);
                if (uris == null || !(uris instanceof Set) || !uris.contains(uri) || !factory.getDigestAlgorithms().contains(uri) || (digest = factory.getMessageDigest(uri, spec)) == null) continue;
                return digest;
            }
        }
        int i = 0;
        while (true) {
            if (i >= providers.size()) break;
            Provider provider = providers.get(i);
            try {
                MessageDigest md = provider == null ? MessageDigest.getInstance(algName) : MessageDigest.getInstance(algName, provider);
                return md;
            }
            catch (NoSuchAlgorithmException e) {
                ++i;
                continue;
            }
            break;
        }
        throw new NoSuchAlgorithmException("No MessageDigest for " + algName);
    }

    @Override
    public boolean releaseMessageDigest(String uri, MessageDigest d) {
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(uri)) {
            sha1Pool.push(d);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(uri)) {
            sha256Pool.push(d);
            return true;
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(uri)) {
            sha512Pool.push(d);
            return true;
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            for (EngineFactory factory : this.childFactory) {
                if (!factory.releaseMessageDigest(uri, d)) continue;
                return true;
            }
        }
        return this.supportedDigest.contains(uri);
    }

    public Set getTransformAlgorithms() {
        return this.transformTable.keySet();
    }

    public Transform getTransform(String uri) throws NoSuchAlgorithmException {
        ExclusiveC11r obj;
        if (uri == null) {
            throw new NoSuchAlgorithmException("null parameter.");
        }
        if (uri.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            obj = new ExclusiveC11r();
        } else {
            String className = this.transformTable.get(uri);
            if (className == null) {
                throw new NoSuchAlgorithmException("Unknown algorithm URI: " + uri);
            }
            try {
                obj = Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae.getMessage());
            }
        }
        return obj;
    }

    public Set getCanonicalizationAlgorithms() {
        return this.canonicalizerTable.keySet();
    }

    public Canonicalizer getCanonicalizer(String uri) {
        ExclusiveC11r obj;
        if (uri == null) {
            return null;
        }
        if (uri.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            obj = new ExclusiveC11r();
        } else {
            String className = this.canonicalizerTable.get(uri);
            if (className == null) {
                return null;
            }
            try {
                obj = Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException iae) {
                return null;
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        Object object = documentBuilderPool;
        synchronized (object) {
            if (!documentBuilderPool.empty()) {
                return documentBuilderPool.pop();
            }
        }
        object = documentBuilderFactory;
        synchronized (object) {
            return documentBuilderFactory.newDocumentBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDocumentBuilder(DocumentBuilder builder) {
        Stack<DocumentBuilder> stack = documentBuilderPool;
        synchronized (stack) {
            documentBuilderPool.push(builder);
        }
    }

    @Override
    public Set getDataEncryptionAlgorithms() {
        return this.supportedDataEncryption;
    }

    @Override
    public Set getKeyEncryptionAlgorithms() {
        return this.supportedKeyEncryption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EncryptionEngine getEncryptionEngine(String uri) throws NoSuchAlgorithmException {
        Stack<EncryptionEngine> pool;
        EncryptionEngine eng;
        if (uri == null) {
            throw new NullPointerException("URI not specified");
        }
        boolean defaultUri = true;
        boolean pcnt = false;
        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
        if (p1 != null && ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(uri) ? (eng = hwcEERsaMap.get(p1.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(uri) ? (eng = hwcEE3desMap.get(p1.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(uri) ? (eng = hwcEEAes128Map.get(p1.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(uri) ? (eng = hwcEEAes192Map.get(p1.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(uri) ? (eng = hwcEEAes256Map.get(p1.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri) ? (eng = hwcEERsaOaepMap.get(p1.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(uri) ? (eng = hwcEEkw3desMap.get(p1.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(uri) ? (eng = hwcEEkwAes128Map.get(p1.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(uri) ? (eng = hwcEEkwAes192Map.get(p1.getName())) != null : "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(uri) && (eng = hwcEEkwAes256Map.get(p1.getName())) != null)))))))))) {
            return eng;
        }
        Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
        if (p2 != null) {
            EncryptionEngine eng2;
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, getEncryptionEngine, uri and provider:" + uri + ":" + ((Provider)this.getLocalProvider("HWCONFIG")).getName());
            }
            if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(uri) ? (eng2 = hwcEERsaMap.get(p2.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(uri) ? (eng2 = hwcEE3desMap.get(p2.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(uri) ? (eng2 = hwcEEAes128Map.get(p2.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(uri) ? (eng2 = hwcEEAes192Map.get(p2.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(uri) ? (eng2 = hwcEEAes256Map.get(p2.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri) ? (eng2 = hwcEERsaOaepMap.get(p2.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(uri) ? (eng2 = hwcEEkw3desMap.get(p2.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(uri) ? (eng2 = hwcEEkwAes128Map.get(p2.getName())) != null : ("http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(uri) ? (eng2 = hwcEEkwAes192Map.get(p2.getName())) != null : "http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(uri) && (eng2 = hwcEEkwAes256Map.get(p2.getName())) != null))))))))) {
                return eng2;
            }
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, getEncryptionEngine, did not get any thing from the pool");
            }
        }
        if (p1 != null) {
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getEncryptionEngine, provider and uri: " + p1.getName() + ":" + uri);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new EncryptionEngineImpl.TripleDESCBC(p1);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new EncryptionEngineImpl.AES128CBC(p1);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new EncryptionEngineImpl.AES192CBC(p1);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new EncryptionEngineImpl.AES256CBC(p1);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                    return new EncryptionEngineImpl.RSA15(p1, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                    return new EncryptionEngineImpl.RSAOAEP(p1, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new EncryptionEngineImpl.HWC_KWTripleDES(p1, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new EncryptionEngineImpl.HWC_KWAES128(p1, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new EncryptionEngineImpl.HWC_KWAES192(p1, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new EncryptionEngineImpl.HWC_KWAES256(p1, this);
                }
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("HARDWARE, Alg Factory, getEncryption Engine, caught Exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (p2 != null) {
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getEncryptionEngine, provider and uri: " + p2.getName() + ":" + uri);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new EncryptionEngineImpl.TripleDESCBC(p2);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new EncryptionEngineImpl.AES128CBC(p2);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new EncryptionEngineImpl.AES192CBC(p2);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new EncryptionEngineImpl.AES256CBC(p2);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                    return new EncryptionEngineImpl.RSA15(p2, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                    return new EncryptionEngineImpl.RSAOAEP(p2, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new EncryptionEngineImpl.HWC_KWTripleDES(p2, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new EncryptionEngineImpl.HWC_KWAES128(p2, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new EncryptionEngineImpl.HWC_KWAES192(p2, this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new EncryptionEngineImpl.HWC_KWAES256(p2, this);
                }
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("HARDWARE, Alg Factory, getEncryption Engine, caught Exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if ((p1 != null || p2 != null) && this.debug) {
            System.out.println("HARDWARE CRYPTO: getEncryptionEngine fails with hardware crypto provider. Continue to use JCE provider");
        }
        if ((pool = eePoolMap.get(uri)) != null) {
            Stack<EncryptionEngine> stack = pool;
            synchronized (stack) {
                if (!pool.isEmpty()) {
                    return pool.pop();
                }
            }
        }
        int i = 0;
        while (true) {
            if (i >= providers.size()) break;
            try {
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new EncryptionEngineImpl.TripleDESCBC(providers.get(i));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new EncryptionEngineImpl.AES128CBC(providers.get(i));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new EncryptionEngineImpl.AES192CBC(providers.get(i));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new EncryptionEngineImpl.AES256CBC(providers.get(i));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                    return new EncryptionEngineImpl.RSA15(providers.get(i), this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
                    return new EncryptionEngineImpl.RSAOAEP(providers.get(i), this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new EncryptionEngineImpl.KWTripleDES(providers.get(i), this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new EncryptionEngineImpl.KWAES128(providers.get(i), this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new EncryptionEngineImpl.KWAES192(providers.get(i), this);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new EncryptionEngineImpl.KWAES256(providers.get(i), this);
                }
                defaultUri = false;
            }
            catch (NoSuchAlgorithmException e) {
                ++i;
                continue;
            }
            break;
        }
        if (defaultUri) {
            throw new NoSuchAlgorithmException("No EncryptionEngine for " + uri);
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            for (EngineFactory factory : this.childFactory) {
                EncryptionEngine engine2;
                Set<String> uris = this.childFactoryURIs.get(factory);
                if (uris == null || !(uris instanceof Set) || !uris.contains(uri) || !factory.getDataEncryptionAlgorithms().contains(uri) && !factory.getKeyEncryptionAlgorithms().contains(uri) || (engine2 = factory.getEncryptionEngine(uri)) == null) continue;
                return engine2;
            }
        }
        throw new NoSuchAlgorithmException("Unknown algorithm: " + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseEncryptionEngine(EncryptionEngine eng) {
        String uri = eng.getURI();
        if (this.getProviderMaps().isEmpty()) {
            if (this.supportedDataEncryption.contains(uri) || this.supportedKeyEncryption.contains(uri)) {
                Stack<EncryptionEngine> pool = eePoolMap.get(uri);
                pool.push(eng);
                return true;
            }
            if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
                for (EngineFactory factory : this.childFactory) {
                    if (!factory.releaseEncryptionEngine(eng)) continue;
                    return true;
                }
            }
        } else {
            if (this.debug) {
                System.out.println("HWC: AlgorithmFactory, releaseEncryptionEngine, uri and provider:" + uri + ":" + ((Provider)this.getLocalProvider("HWCONFIG")).getName());
            }
            if (this.supportedDataEncryption.contains(uri) || this.supportedKeyEncryption.contains(uri)) {
                if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(uri)) {
                    Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                    if (p1 != null) {
                        hwcEERsaMap.put(p1.getName(), eng);
                    } else {
                        Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                        if (p2 != null) {
                            HashMap<String, EncryptionEngine> hashMap = hwcEERsaMap;
                            synchronized (hashMap) {
                                hwcEERsaMap.put(p2.getName(), eng);
                            }
                        }
                    }
                    return true;
                }
                if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(uri)) {
                    Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                    if (p1 != null) {
                        hwcEE3desMap.put(p1.getName(), eng);
                        return true;
                    }
                    Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                    if (p2 != null) {
                        hwcEE3desMap.put(p2.getName(), eng);
                        return true;
                    }
                } else {
                    if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(uri)) {
                        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (p1 != null) {
                            hwcEEAes128Map.put(p1.getName(), eng);
                        } else {
                            Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (p2 != null) {
                                HashMap<String, EncryptionEngine> hashMap = hwcEEAes128Map;
                                synchronized (hashMap) {
                                    hwcEEAes128Map.put(p2.getName(), eng);
                                }
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(uri)) {
                        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (p1 != null) {
                            hwcEEAes192Map.put(p1.getName(), eng);
                        } else {
                            Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (p2 != null) {
                                HashMap<String, EncryptionEngine> hashMap = hwcEEAes192Map;
                                synchronized (hashMap) {
                                    hwcEEAes192Map.put(p2.getName(), eng);
                                }
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(uri)) {
                        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (p1 != null) {
                            hwcEEAes256Map.put(p1.getName(), eng);
                        } else {
                            Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (p2 != null) {
                                HashMap<String, EncryptionEngine> hashMap = hwcEEAes256Map;
                                synchronized (hashMap) {
                                    hwcEEAes256Map.put(p2.getName(), eng);
                                }
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri)) {
                        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (p1 != null) {
                            hwcEERsaOaepMap.put(p1.getName(), eng);
                        } else {
                            Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (p2 != null) {
                                HashMap<String, EncryptionEngine> hashMap = hwcEERsaOaepMap;
                                synchronized (hashMap) {
                                    hwcEERsaOaepMap.put(p2.getName(), eng);
                                }
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(uri)) {
                        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (p1 != null) {
                            hwcEEkw3desMap.put(p1.getName(), eng);
                        } else {
                            Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (p2 != null) {
                                HashMap<String, EncryptionEngine> hashMap = hwcEEkw3desMap;
                                synchronized (hashMap) {
                                    hwcEEkw3desMap.put(p2.getName(), eng);
                                }
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#kw-aes128".equals(uri)) {
                        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (p1 != null) {
                            hwcEEkwAes128Map.put(p1.getName(), eng);
                        } else {
                            Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (p2 != null) {
                                HashMap<String, EncryptionEngine> hashMap = hwcEEkwAes128Map;
                                synchronized (hashMap) {
                                    hwcEEkwAes128Map.put(p2.getName(), eng);
                                }
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#kw-aes192".equals(uri)) {
                        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (p1 != null) {
                            hwcEEkwAes192Map.put(p1.getName(), eng);
                        } else {
                            Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (p2 != null) {
                                HashMap<String, EncryptionEngine> hashMap = hwcEEkwAes192Map;
                                synchronized (hashMap) {
                                    hwcEEkwAes192Map.put(p2.getName(), eng);
                                }
                            }
                        }
                        return true;
                    }
                    if ("http://www.w3.org/2001/04/xmlenc#kw-aes256".equals(uri)) {
                        Provider p1 = (Provider)this.getLocalProvider("com.ibm.ws.wssecurity.config.keystore.keyStoreRef");
                        if (p1 != null) {
                            hwcEEkwAes256Map.put(p1.getName(), eng);
                        } else {
                            Provider p2 = (Provider)this.getLocalProvider("HWCONFIG");
                            if (p2 != null) {
                                HashMap<String, EncryptionEngine> hashMap = hwcEEkwAes256Map;
                                synchronized (hashMap) {
                                    hwcEEkwAes256Map.put(p2.getName(), eng);
                                }
                            }
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyGenerationEngine getKeyGenerationEngine(String uri, String type) throws NoSuchAlgorithmException {
        int i2;
        if (uri == null) {
            throw new NullPointerException("URI not specified");
        }
        boolean defaultUri = true;
        boolean pcnt = false;
        ArrayList plist = new ArrayList(2);
        for (i2 = 0; i2 < plist.size(); ++i2) {
            Provider provider = (Provider)plist.get(i2);
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getKeyGenerationEngine, provider and uri is: " + provider.getName() + ":" + uri);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new KeyGenerationEngineImpl.HWC_TripleDESCBC(provider);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new KeyGenerationEngineImpl.AES128CBC(provider);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new KeyGenerationEngineImpl.AES192CBC(provider);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new KeyGenerationEngineImpl.AES256CBC(provider);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new KeyGenerationEngineImpl.HWC_KWTripleDES(provider);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new KeyGenerationEngineImpl.KWAES128(provider);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new KeyGenerationEngineImpl.KWAES192(provider);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new KeyGenerationEngineImpl.KWAES256(provider);
                }
                break;
            }
            catch (Exception e) {
                System.out.println("HARDWARE: Alg Factory, getKeyGenerationEngine, exception: " + e.getMessage());
                e.printStackTrace();
                continue;
            }
        }
        if (plist.size() != 0 && this.debug) {
            System.out.println("HARDWARE CRYPTO: getKeyGenerationEngine fails with hardware crypto provider. Continue to use JCE provider");
        }
        if (uri.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            Stack<KeyGenerationEngine> i2 = kge3desPool;
            synchronized (i2) {
                if (!kge3desPool.isEmpty()) {
                    return kge3desPool.pop();
                }
            }
        }
        i2 = 0;
        while (true) {
            if (i2 >= providers.size()) break;
            try {
                if (this.debug) {
                    System.out.println("HWC: AlgorithmFactory, getKeyGenerationEngine, uri is: " + uri);
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    return new KeyGenerationEngineImpl.TripleDESCBC(providers.get(i2));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    return new KeyGenerationEngineImpl.AES128CBC(providers.get(i2));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    return new KeyGenerationEngineImpl.AES192CBC(providers.get(i2));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    return new KeyGenerationEngineImpl.AES256CBC(providers.get(i2));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
                    return new KeyGenerationEngineImpl.KWTripleDES(providers.get(i2));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
                    return new KeyGenerationEngineImpl.KWAES128(providers.get(i2));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
                    return new KeyGenerationEngineImpl.KWAES192(providers.get(i2));
                }
                if (uri.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
                    return new KeyGenerationEngineImpl.KWAES256(providers.get(i2));
                }
                defaultUri = false;
            }
            catch (NoSuchAlgorithmException e) {
                ++i2;
                continue;
            }
            break;
        }
        if (defaultUri) {
            throw new NoSuchAlgorithmException("No EncryptionEngine for " + uri);
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            for (EngineFactory factory : this.childFactory) {
                KeyGenerationEngine engine2;
                Set<String> uris = this.childFactoryURIs.get(factory);
                if (uris == null || !(uris instanceof Set) || !uris.contains(uri) || !factory.getDataEncryptionAlgorithms().contains(uri) && !factory.getKeyEncryptionAlgorithms().contains(uri) || (engine2 = factory.getKeyGenerationEngine(uri, type)) == null) continue;
                return engine2;
            }
        }
        throw new NoSuchAlgorithmException("Unknown algorithm: " + uri);
    }

    @Override
    public boolean releaseKeyGenerationEngine(KeyGenerationEngine eng) {
        if (this.debug) {
            System.out.println("HWC: AlgorithmFactory, releaseKeyGenerationEngine, no hwprovider?");
        }
        if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(eng.getURI())) {
            kge3desPool.push(eng);
            return true;
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            for (EngineFactory factory : this.childFactory) {
                if (!factory.releaseKeyGenerationEngine(eng)) continue;
                return true;
            }
        }
        return this.supportedDataEncryption.contains(eng.getURI()) || this.supportedKeyEncryption.contains(eng.getURI());
    }

    public DOMSerializationEngine getDOMSerializationEngine(String type) throws NoSuchAlgorithmException {
        DOMSerializationEngine.XMLContent engine2 = null;
        if (type == null) {
            throw new NullPointerException("Type not specified");
        }
        if (type.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            engine2 = new DOMSerializationEngine.XMLElement();
        } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            engine2 = new DOMSerializationEngine.XMLContent();
        } else {
            throw new NoSuchAlgorithmException("Unknown type: " + type);
        }
        return engine2;
    }

    @Override
    public AlgorithmParameterSpec unmarshalParameter(String uri, OMElement el) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec = null;
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri)) {
            OMElement olel = DOMUtil.getFirstChildElementNamed(el, "http://www.w3.org/2000/09/xmldsig#", "HMACOutputLength");
            if (olel != null) {
                int ol = Integer.parseInt(DOMUtil.getStringValue(olel));
                spec = new SignatureEngineHMAC.HMACParameterSpec(ol);
            }
            return spec;
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri)) {
            OAEPParams params;
            String dmAlgo = null;
            OMElement dmel = DOMUtil.getFirstChildElementNamed(el, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
            if (dmel != null) {
                dmAlgo = dmel.getAttributeValue(new QName("", "Algorithm"));
            }
            byte[] paramBytes = null;
            OMElement pel = DOMUtil.getFirstChildElementNamed(el, "OAEPparams");
            if (pel != null && (params = new OAEPParams(pel)) != null) {
                paramBytes = params.getParameters();
            }
            spec = this.getOAEPParameterSpec(dmAlgo, paramBytes);
            return spec;
        }
        if (this.supportedSignature.contains(uri) || this.supportedDigest.contains(uri) || this.supportedDataEncryption.contains(uri) || this.supportedKeyEncryption.contains(uri)) {
            return spec;
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            for (EngineFactory factory : this.childFactory) {
                Set<String> uris = this.childFactoryURIs.get(factory);
                if (uris == null || !(uris instanceof Set) || !uris.contains(uri)) continue;
                spec = factory.unmarshalParameter(uri, el);
                return spec;
            }
        }
        throw new NoSuchAlgorithmException(uri);
    }

    public AlgorithmParameterSpec unmarshalParameter(String uri, WSSObjectElement el) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec = null;
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri)) {
            SignatureMethod signatureMethod = (SignatureMethod)el;
            VariablePartTextValue vPartText = signatureMethod.getHMACOutputLength();
            if (vPartText != null) {
                int ol = Integer.parseInt(vPartText.toString());
                spec = new SignatureEngineHMAC.HMACParameterSpec(ol);
            }
            return spec;
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri)) {
            EncryptionMethod encMeth = (EncryptionMethod)el;
            DigestMethod digMeth = (DigestMethod)WSSObjectUtils.getChild(el, Utf8ByteConstantsQNames.DSIG.QN_DIGEST_METHOD);
            VariablePartAttributeValue vPartAttr = digMeth.getAlgorithm();
            String algo = null;
            if (vPartAttr != null) {
                algo = vPartAttr.toString();
            }
            byte[] paramBytes = null;
            VariablePartTextValue vPartText = encMeth.getOAEPparams();
            if (vPartText != null) {
                int type = vPartText.getValueType();
                Object obj = vPartText.getValueObj();
                if (type == 2) {
                    paramBytes = (byte[])obj;
                } else if (type == 6) {
                    ByteArrayHolder bah = (ByteArrayHolder)obj;
                    paramBytes = bah.toByteArray();
                } else if (type == 3) {
                    try {
                        paramBytes = ((String)obj).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException(e.getMessage());
                        iape.initCause(e);
                        throw iape;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OAEP unmarshalling parameter bytes. Params type = " + type);
                    Tr.debug(tc, "OAEP unmarshalling parameter bytes (raw): " + paramBytes);
                    Tr.debug(tc, "OAEP unmarshalling parameter bytes (base64): " + Base64.encode(paramBytes));
                }
            }
            spec = this.getOAEPParameterSpec(algo, paramBytes);
            return spec;
        }
        if (this.supportedSignature.contains(uri) || this.supportedDigest.contains(uri) || this.supportedDataEncryption.contains(uri) || this.supportedKeyEncryption.contains(uri)) {
            return spec;
        }
        throw new NoSuchAlgorithmException(uri);
    }

    @Override
    public void marshalParameter(String uri, AlgorithmParameterSpec spec, OMElement el) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (spec == null) {
            return;
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri)) {
            OMFactory factory = el.getOMFactory();
            OMElement olel = DOMUtils.createDsigOMElement("HMACOutputLength", factory, el);
            el.addChild(olel);
            int ol = ((SignatureEngineHMAC.HMACParameterSpec)spec).getOutputLength();
            olel.addChild(factory.createOMText(Integer.toString(ol)));
            return;
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri)) {
            String digestMethodURI = this.getOaepDigestMethodURI(spec);
            OMFactory factory = el.getOMFactory();
            OMElement dmel = DOMUtils.createDsigOMElement("DigestMethod", factory, el);
            dmel.addAttribute("Algorithm", Util.normalize(digestMethodURI), null);
            el.addChild(dmel);
            byte[] params = this.getOaepParams(spec);
            if (params != null && params.length > 0) {
                OAEPParams oaepParams = new OAEPParams();
                oaepParams.setParameters(params);
                OMElement oaepel = null;
                try {
                    oaepel = oaepParams.createElement(factory, el);
                }
                catch (StructureException e) {
                    InvalidAlgorithmParameterException exc = new InvalidAlgorithmParameterException("Unable to create OAEPparams element");
                    exc.initCause(e);
                    throw exc;
                }
                if (oaepel != null) {
                    el.addChild(oaepel);
                }
            }
            return;
        }
        if (this.supportedSignature.contains(uri) || this.supportedDigest.contains(uri) || this.supportedDataEncryption.contains(uri) || this.supportedKeyEncryption.contains(uri)) {
            throw new InvalidAlgorithmParameterException("The algorithm " + uri + " does not support any AlgorithmParameterSpec.");
        }
        if (!fipsEnabled && this.childFactory != null && !this.childFactory.isEmpty()) {
            for (EngineFactory factory : this.childFactory) {
                Set<String> uris = this.childFactoryURIs.get(factory);
                if (uris == null || !(uris instanceof Set) || !uris.contains(uri)) continue;
                factory.marshalParameter(uri, spec, el);
            }
        }
        throw new NoSuchAlgorithmException(uri);
    }

    public void marshalParameter(String uri, AlgorithmParameterSpec spec, WSSObjectElement el) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (spec == null) {
            return;
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(uri)) {
            SignatureMethod sigMeth = (SignatureMethod)el;
            int ol = ((SignatureEngineHMAC.HMACParameterSpec)spec).getOutputLength();
            sigMeth.setHMACOutputLength(VariablePartFactory.getInstance().createTextValueWithString(Integer.toString(ol)));
            return;
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri)) {
            EncryptionMethod encMeth = (EncryptionMethod)el;
            String digestMethodURI = this.getOaepDigestMethodURI(spec);
            DigestMethod digMeth = new DigestMethod(encMeth.getWSSObjectDocument());
            digMeth.setAlgorithm(VariablePartFactory.getInstance().createAttrValueWithString(Util.normalize(digestMethodURI)));
            encMeth.addChild(digMeth);
            byte[] params = this.getOaepParams(spec);
            if (params != null && params.length > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OAEP marshalled parameter bytes (base64): " + Base64.encode(params));
                }
                encMeth.setOAEPparams(VariablePartFactory.getInstance().createTextValueWithByteToBeBase64Encoded(params));
            }
            return;
        }
        if (this.supportedSignature.contains(uri) || this.supportedDigest.contains(uri) || this.supportedDataEncryption.contains(uri) || this.supportedKeyEncryption.contains(uri)) {
            throw new InvalidAlgorithmParameterException("The algorithm " + uri + " does not support any AlgorithmParameterSpec.");
        }
        throw new NoSuchAlgorithmException(uri);
    }

    @Override
    public AlgorithmParameterSpec convertParameter(String uri, Map properties) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec = null;
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri)) {
            String digestMethodURI = (String)properties.get(Constants.WSSECURITY_RSAOAEP_DIGEST_METHOD);
            String encodedParams = (String)properties.get(Constants.WSSECURITY_RSAOAEP_PARAMS);
            byte[] paramBytes = null;
            if (encodedParams != null && encodedParams.length() > 0) {
                paramBytes = Base64.decode(encodedParams);
            }
            spec = this.getOAEPParameterSpec(digestMethodURI, paramBytes);
            return spec;
        }
        if (!(this.supportedSignature.contains(uri) || this.supportedDigest.contains(uri) || this.supportedDataEncryption.contains(uri) || this.supportedKeyEncryption.contains(uri) || fipsEnabled || this.childFactory == null || this.childFactory.isEmpty())) {
            for (EngineFactory factory : this.childFactory) {
                Set<String> uris = this.childFactoryURIs.get(factory);
                if (uris == null || !(uris instanceof Set) || !uris.contains(uri)) continue;
                spec = factory.convertParameter(uri, properties);
                return spec;
            }
        }
        return null;
    }

    public AlgorithmParameterSpec getOAEPParameterSpec(String digestURI, byte[] paramBytes) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec = null;
        AlgorithmParameterSpec mgfSpec = null;
        String mdName = null;
        if (digestURI == null || digestURI.length() <= 0 || "http://www.w3.org/2000/09/xmldsig#sha1".equals(digestURI)) {
            mdName = "SHA-1";
            mgfSpec = OAEPHelper.sha1MgfSpec;
        } else if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(digestURI)) {
            mdName = "SHA-256";
            mgfSpec = OAEPHelper.sha256MgfSpec;
        } else if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(digestURI)) {
            mdName = "SHA-512";
            mgfSpec = OAEPHelper.sha512MgfSpec;
        } else {
            throw new InvalidAlgorithmParameterException("Message digest algorithm " + digestURI + " is not supported for use with the RSA-OAEP encryption algorithm.");
        }
        try {
            String mgfName = "MGF1";
            Object pSrc = null;
            if (paramBytes == null || paramBytes.length <= 0) {
                pSrc = OAEPHelper.defaultPSource;
            } else {
                Constructor c = OAEPHelper.pSourceConstructor;
                if (c != null) {
                    pSrc = c.newInstance(new Object[]{paramBytes});
                }
            }
            Constructor constructor = OAEPHelper.oaepParamSpecConstructor;
            if (mgfSpec == null || pSrc == null || constructor == null) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Unable to construct OAEPParameterSpec");
                iape.initCause(OAEPHelper.exc);
                throw iape;
            }
            spec = (AlgorithmParameterSpec)constructor.newInstance(mdName, mgfName, mgfSpec, pSrc);
        }
        catch (IllegalAccessException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
        return spec;
    }

    private String getOaepDigestMethodURI(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        String uri;
        block6: {
            uri = "http://www.w3.org/2000/09/xmldsig#sha1";
            if (spec == null) {
                return uri;
            }
            try {
                Method m = OAEPHelper.getDigestAlgorithm;
                if (m == null) break block6;
                Object obj = m.invoke((Object)spec, new Object[0]);
                String digestMethod = null;
                if (obj == null || !(obj instanceof String)) break block6;
                digestMethod = (String)obj;
                if ("SHA-1".equals(digestMethod) || "SHA1".equals(digestMethod)) {
                    uri = "http://www.w3.org/2000/09/xmldsig#sha1";
                    break block6;
                }
                if ("SHA-256".equals(digestMethod) || "SHA256".equals(digestMethod)) {
                    uri = "http://www.w3.org/2001/04/xmlenc#sha256";
                    break block6;
                }
                if ("SHA-512".equals(digestMethod) || "SHA512".equals(digestMethod)) {
                    uri = "http://www.w3.org/2001/04/xmlenc#sha512";
                    break block6;
                }
                throw new InvalidAlgorithmParameterException("Message digest algorithm " + digestMethod + " is not supported for use with the RSA-OAEP encryption algorithm.");
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException(e.getMessage());
            }
        }
        return uri;
    }

    private byte[] getOaepParams(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        byte[] params = null;
        if (spec == null) {
            return params;
        }
        try {
            Object value;
            Object pSource;
            Method m = OAEPHelper.getPSource;
            if (m != null && (pSource = m.invoke((Object)spec, new Object[0])) != null && (m = OAEPHelper.getValue) != null && (value = m.invoke(pSource, new Object[0])) instanceof byte[]) {
                params = (byte[])value;
            }
        }
        catch (Exception e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
        return params;
    }

    static {
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        documentBuilderPool = new Stack();
        sha1Pool = new Stack();
        sha256Pool = new Stack();
        sha512Pool = new Stack();
        rsaPool = new Stack();
        dsaPool = new Stack();
        hmacPool = new Stack();
        eePoolMap = new HashMap();
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#rsa-1_5", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#kw-tripledes", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#kw-aes128", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#kw-aes192", new Stack());
        eePoolMap.put("http://www.w3.org/2001/04/xmlenc#kw-aes256", new Stack());
        kge3desPool = new Stack();
        hwcRsaMap = new HashMap();
        hwcDsaMap = new HashMap();
        hwcHmacMap = new HashMap();
        hwcEERsaMap = new HashMap();
        hwcEE3desMap = new HashMap();
        hwcEEAes128Map = new HashMap();
        hwcEEAes192Map = new HashMap();
        hwcEEAes256Map = new HashMap();
        hwcEERsaOaepMap = new HashMap();
        hwcEEkw3desMap = new HashMap();
        hwcEEkwAes128Map = new HashMap();
        hwcEEkwAes192Map = new HashMap();
        hwcEEAes256Map = new HashMap();
        hwcKge3desMap = new HashMap();
        if ("true".equalsIgnoreCase(Security.getProperty("com.ibm.websphere.security.fips.enabled"))) {
            fipsEnabled = true;
            StringTokenizer tokenizer = new StringTokenizer(Security.getProperty("com.ibm.websphere.security.fips.jceProviders"), "|");
            while (tokenizer.hasMoreTokens()) {
                providers.add(Security.getProvider(tokenizer.nextToken()));
            }
        }
        s_theInstance = new AlgorithmFactory(null);
    }

    private static class OAEPHelper {
        static Object defaultPSource = null;
        static AlgorithmParameterSpec sha1MgfSpec = null;
        static AlgorithmParameterSpec sha256MgfSpec = null;
        static AlgorithmParameterSpec sha512MgfSpec = null;
        static Constructor oaepParamSpecConstructor = null;
        static Constructor pSourceConstructor = null;
        static Method getDigestAlgorithm = null;
        static Method getPSource = null;
        static Method getValue = null;
        static Throwable exc = null;

        private OAEPHelper() {
        }

        static {
            try {
                Class<?> mgf1PSClass = Class.forName("java.security.spec.MGF1ParameterSpec");
                Object obj = mgf1PSClass.getField("SHA1").get(null);
                sha1MgfSpec = (AlgorithmParameterSpec)obj;
                obj = mgf1PSClass.getField("SHA256").get(null);
                sha256MgfSpec = (AlgorithmParameterSpec)obj;
                obj = mgf1PSClass.getField("SHA512").get(null);
                sha512MgfSpec = (AlgorithmParameterSpec)obj;
                Class<?> pSpecifiedClass = Class.forName("javax.crypto.spec.PSource$PSpecified");
                defaultPSource = obj = pSpecifiedClass.getField("DEFAULT").get(null);
                pSourceConstructor = pSpecifiedClass.getConstructor(byte[].class);
                Class<?> pSourceClass = Class.forName("javax.crypto.spec.PSource");
                Class<?> OAEPParameterSpec = Class.forName("javax.crypto.spec.OAEPParameterSpec");
                oaepParamSpecConstructor = OAEPParameterSpec.getConstructor(String.class, String.class, AlgorithmParameterSpec.class, pSourceClass);
                getDigestAlgorithm = OAEPParameterSpec.getMethod("getDigestAlgorithm", new Class[0]);
                getPSource = OAEPParameterSpec.getMethod("getPSource", new Class[0]);
                getValue = pSpecifiedClass.getMethod("getValue", new Class[0]);
            }
            catch (IllegalAccessException e) {
                exc = e;
            }
            catch (NoSuchFieldException e) {
                exc = e;
            }
            catch (NoSuchMethodException e) {
                exc = e;
            }
            catch (ClassNotFoundException e) {
                exc = e;
            }
            catch (Throwable e) {
                exc = e;
            }
        }
    }
}

