/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.util;

import com.ibm.ws.wssecurity.util.io.Base64EncodeOutputStream;
import com.ibm.ws.wssecurity.util.io.ByteArrayHolder;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPairSortedSet;
import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePart;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartNsDeclUri;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import java.io.IOException;
import java.io.OutputStream;

public abstract class WSSObjectWriter {
    public static final boolean DEBUG = false;
    public static int INIT_CAPACITY = 512;
    public static final int C14N_WRITER = 1;
    public static final int NORMAL_WRITER = 2;
    protected OutputStream os;
    protected byte[][] textTab;
    protected byte[][] attrTab;
    protected byte[] out;
    protected int pos;
    private int type;
    private Base64EncodeOutputStream b64eos = null;
    public int NPPSS_MAX = 2;
    protected int nppssSize = 0;
    protected NamespacePrefixPairSortedSet[] pooledNPPSS = new NamespacePrefixPairSortedSet[this.NPPSS_MAX];

    public WSSObjectWriter(int capacity) {
        if (capacity < 16) {
            capacity = INIT_CAPACITY;
        }
        this.out = new byte[capacity];
        this.pos = 0;
        this.textTab = this.getTextTab();
        this.attrTab = this.getAttrTab();
    }

    public WSSObjectWriter(OutputStream os, int type) {
        this(INIT_CAPACITY);
        this.os = os;
        this.type = type;
    }

    public abstract byte[][] getTextTab();

    public abstract byte[][] getAttrTab();

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void reset() {
        this.os = null;
        this.pos = 0;
    }

    public void flush() throws IOException {
        this.internalFlush();
        this.os.flush();
    }

    public void setINIT_CAPACITY(int capacity) {
        this.out = new byte[INIT_CAPACITY];
    }

    private final void writeWithCharEsc(String str, int length, byte[][] characterTab) throws IOException {
        for (int i = 0; i < length; ++i) {
            char c;
            if (this.pos >= this.out.length) {
                this.internalFlush();
            }
            if ((c = str.charAt(i)) < characterTab.length) {
                byte[] b = characterTab[c];
                if (b == null) {
                    this.out[this.pos++] = (byte)c;
                    continue;
                }
                int requiredSize = this.pos + b.length;
                if (requiredSize >= this.out.length) {
                    this.internalFlush();
                }
                System.arraycopy(b, 0, this.out, this.pos, b.length);
                this.pos += b.length;
                continue;
            }
            this.writeUTF8WithCharEsc(str, i, characterTab);
            break;
        }
        this.internalFlush();
    }

    private final void writeUTF8WithCharEsc(String str, int start, byte[][] characterTab) throws IOException {
        byte[] utf8bytes = str.substring(start).getBytes("UTF8");
        for (int i = 0; i < utf8bytes.length; ++i) {
            if (this.pos >= this.out.length) {
                this.internalFlush();
            }
            if (utf8bytes[i] > 0 && utf8bytes[i] < characterTab.length) {
                byte[] b = characterTab[utf8bytes[i]];
                if (b == null) {
                    this.out[this.pos++] = utf8bytes[i];
                    continue;
                }
                int requiredSize = this.pos + b.length;
                if (requiredSize >= this.out.length) {
                    this.internalFlush();
                }
                System.arraycopy(b, 0, this.out, this.pos, b.length);
                this.pos += b.length;
                continue;
            }
            this.out[this.pos++] = utf8bytes[i];
        }
    }

    private final void internalFlush() throws IOException {
        if (this.pos > 0) {
            this.os.write(this.out, 0, this.pos);
            this.pos = 0;
        }
    }

    private final boolean writeFromCache(VariablePart variablePart) throws IOException {
        if (this.type == 2) {
            this.writeUTF8CharwithoutCharRef(variablePart.utf8S11N);
            return true;
        }
        if (this.type == 1) {
            this.writeUTF8CharwithoutCharRef(variablePart.utf8C14N);
            return true;
        }
        return false;
    }

    public final void writeUTF8CharwithoutCharRef(byte b) throws IOException {
        this.os.write(b);
    }

    public final void writeUTF8CharwithoutCharRef(byte[] bytes) throws IOException {
        this.os.write(bytes, 0, bytes.length);
    }

    public final void writeUTF8CharwithoutCharRef(byte[] bytes, int offset, int length) throws IOException {
        this.os.write(bytes, offset, length);
    }

    public final void writeBase64Binary(byte[] bytes) throws IOException {
        this.writeBase64Binary(bytes, 0, bytes.length);
    }

    public final void writeBase64Binary(byte[] bytes, int offset, int length) throws IOException {
        if (this.b64eos == null) {
            this.b64eos = new Base64EncodeOutputStream(this.os);
        } else {
            this.b64eos.reset(this.os);
        }
        this.b64eos.write(bytes, offset, length);
        this.b64eos.forceFlush();
    }

    public final void write(VariablePart variablePart) throws IOException {
        boolean success;
        if (variablePart.hasCache && (success = this.writeFromCache(variablePart))) {
            return;
        }
        switch (variablePart.getValueType()) {
            case 2: {
                byte[] bytes = (byte[])variablePart.getValueObj();
                this.writeUTF8CharwithoutCharRef(bytes);
                break;
            }
            case 6: {
                ByteArrayHolder bah = (ByteArrayHolder)variablePart.getValueObj();
                this.writeUTF8CharwithoutCharRef(bah.getValue(), bah.getOffset(), bah.getLength());
                break;
            }
            case 4: {
                byte[] bytes = (byte[])variablePart.getValueObj();
                this.writeBase64Binary(bytes);
                break;
            }
            case 7: {
                ByteArrayHolder bah = (ByteArrayHolder)variablePart.getValueObj();
                this.writeBase64Binary(bah.getValue(), bah.getOffset(), bah.getLength());
                break;
            }
            case 5: {
                QName qname = (QName)variablePart.getValueObj();
                this.writeUTF8CharwithoutCharRef(qname.getUtf8Representation());
                break;
            }
            case 3: {
                String str = (String)variablePart.getValueObj();
                int valueLength = str.length();
                if (variablePart instanceof VariablePartTextValue) {
                    this.writeWithCharEsc(str, valueLength, this.textTab);
                    break;
                }
                if (variablePart instanceof VariablePartAttributeValue || variablePart instanceof VariablePartNsDeclUri) {
                    this.writeWithCharEsc(str, valueLength, this.attrTab);
                    break;
                }
                throw new IOException("not implemented yet");
            }
            default: {
                throw new IOException("not implemented yet");
            }
        }
    }

    public NamespacePrefixPairSortedSet getPooledNamespacePrefixPairSortedSet() {
        if (this.nppssSize == 0) {
            return new NamespacePrefixPairSortedSet();
        }
        --this.nppssSize;
        return this.pooledNPPSS[this.nppssSize];
    }

    public void poolNamespacePrefixPairSortedSet(NamespacePrefixPairSortedSet nppss) {
        if (this.nppssSize >= this.NPPSS_MAX) {
            return;
        }
        nppss.reset();
        this.pooledNPPSS[this.nppssSize] = nppss;
        ++this.nppssSize;
    }
}

