/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.util;

import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QName
implements Comparable<QName> {
    protected NamespacePrefixPair namespacePrefixPair;
    protected String localName;
    protected byte[] utf8Representation;
    protected byte[] openStartTagUtf8Representation;
    protected byte[] startTagUtf8Representation;
    protected byte[] endTagUtf8Representation;
    protected byte[] openAttrUtf8Representation;
    protected int ascendingNumber = 0;

    public QName(NamespacePrefixPair namespacePrefixPair, String localName) {
        if (namespacePrefixPair == null) {
            throw new RuntimeException("namespace prefix pair must not be null");
        }
        if (localName == null) {
            throw new RuntimeException("localName pair must not be null");
        }
        this.namespacePrefixPair = namespacePrefixPair;
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public NamespacePrefixPair getNamespacePrefixPair() {
        return this.namespacePrefixPair;
    }

    public byte[] getUtf8Representation() {
        if (this.utf8Representation == null) {
            String qname = null;
            String prefix = this.namespacePrefixPair.getPrefix();
            qname = prefix == null || "".equals(prefix) ? this.localName : prefix + ":" + this.localName;
            try {
                this.utf8Representation = qname.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.utf8Representation;
    }

    public byte[] getOpenStartTagUtf8Representation() {
        if (this.openStartTagUtf8Representation == null) {
            byte[] qname = this.getUtf8Representation();
            this.openStartTagUtf8Representation = new byte[qname.length + 1];
            this.openStartTagUtf8Representation[0] = 60;
            System.arraycopy(qname, 0, this.openStartTagUtf8Representation, 1, qname.length);
        }
        return this.openStartTagUtf8Representation;
    }

    public byte[] getStartTagUtf8Representation() {
        if (this.startTagUtf8Representation == null) {
            byte[] qname = this.getUtf8Representation();
            this.startTagUtf8Representation = new byte[qname.length + 2];
            this.startTagUtf8Representation[0] = 60;
            System.arraycopy(qname, 0, this.startTagUtf8Representation, 1, qname.length);
            this.startTagUtf8Representation[qname.length + 1] = 62;
        }
        return this.startTagUtf8Representation;
    }

    public byte[] getEndTagUtf8Representation() {
        if (this.endTagUtf8Representation == null) {
            byte[] qname = this.getUtf8Representation();
            this.endTagUtf8Representation = new byte[qname.length + 3];
            this.endTagUtf8Representation[0] = 60;
            this.endTagUtf8Representation[1] = 47;
            System.arraycopy(qname, 0, this.endTagUtf8Representation, 2, qname.length);
            this.endTagUtf8Representation[qname.length + 2] = 62;
        }
        return this.endTagUtf8Representation;
    }

    public byte[] getOpenAttrUtf8Representation() {
        if (this.openAttrUtf8Representation == null) {
            byte[] qname = this.getUtf8Representation();
            this.openAttrUtf8Representation = new byte[qname.length + 3];
            this.openAttrUtf8Representation[0] = 32;
            System.arraycopy(qname, 0, this.openAttrUtf8Representation, 1, qname.length);
            this.openAttrUtf8Representation[qname.length + 1] = 61;
            this.openAttrUtf8Representation[qname.length + 2] = 34;
        }
        return this.openAttrUtf8Representation;
    }

    public void setAscendingNumber(int ascendingNumber) {
        this.ascendingNumber = ascendingNumber;
    }

    @Override
    public int compareTo(QName o) {
        if (this.ascendingNumber > 0 && o.ascendingNumber > 0) {
            return this.ascendingNumber - o.ascendingNumber;
        }
        int comp = 0;
        comp = this.namespacePrefixPair.uri.compareTo(o.namespacePrefixPair.uri);
        if (comp != 0) {
            return comp;
        }
        comp = this.localName.compareTo(o.localName);
        return comp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QName)) {
            return false;
        }
        QName qname = (QName)o;
        if (!this.localName.equals(qname.localName)) {
            return false;
        }
        return this.namespacePrefixPair.equals(qname.namespacePrefixPair);
    }

    public String toString() {
        return new String(this.getUtf8Representation());
    }
}

