/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.util;

import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;

public final class NamespacePrefixPairSortedSet {
    public static final int DEFAULT_CAPACITY = 8;
    protected NamespacePrefixPair[] nsPrefixPairs;
    protected int size;

    public NamespacePrefixPairSortedSet() {
        this(8);
    }

    public NamespacePrefixPairSortedSet(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 8;
        }
        this.nsPrefixPairs = new NamespacePrefixPair[initialCapacity];
        this.size = 0;
    }

    private final void ensureCapacity() {
        int nextCapacity = this.nsPrefixPairs.length * 2;
        NamespacePrefixPair[] nsPrefixPairsTemp = new NamespacePrefixPair[nextCapacity];
        System.arraycopy(this.nsPrefixPairs, 0, nsPrefixPairsTemp, 0, this.size);
        this.nsPrefixPairs = nsPrefixPairsTemp;
    }

    public int add(NamespacePrefixPair namespacePrefixPair) {
        int comp;
        int i;
        if (this.size >= this.nsPrefixPairs.length) {
            this.ensureCapacity();
        }
        for (i = 0; i < this.size && (comp = this.nsPrefixPairs[i].compareTo(namespacePrefixPair)) <= 0; ++i) {
            if (comp != 0) continue;
            return -1;
        }
        int numMoved = this.size - i;
        if (numMoved > 0) {
            System.arraycopy(this.nsPrefixPairs, i, this.nsPrefixPairs, i + 1, numMoved);
        }
        this.nsPrefixPairs[i] = namespacePrefixPair;
        ++this.size;
        return i;
    }

    public void remove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.nsPrefixPairs, index + 1, this.nsPrefixPairs, index, numMoved);
        }
        --this.size;
        this.nsPrefixPairs[this.size] = null;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.nsPrefixPairs[i] = null;
        }
        this.size = 0;
    }

    public void reset() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public NamespacePrefixPair getNamespacePrefixPair(int index) {
        if (index >= this.size) {
            return null;
        }
        return this.nsPrefixPairs[index];
    }

    public NamespacePrefixPair getNamespacePrefixPair(String prefix) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.nsPrefixPairs[i].getPrefix().equals(prefix)) continue;
            return this.nsPrefixPairs[i];
        }
        return null;
    }
}

