/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssobject.impl;

import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectTextElementImpl;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectTextNodeImpl;
import com.ibm.ws.wssecurity.wssobject.interfaces.BelongsToNamespace;
import com.ibm.ws.wssecurity.wssobject.interfaces.Child;
import com.ibm.ws.wssecurity.wssobject.interfaces.HasNamspaceDeclarations;
import com.ibm.ws.wssecurity.wssobject.interfaces.Parent;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectTextElement;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectTextNode;
import com.ibm.ws.wssecurity.wssobject.util.AttributeSortedSet;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPairSortedSet;
import com.ibm.ws.wssecurity.wssobject.util.NamespacePrefixPairStack;
import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectC14NWriter;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectNormalWriter;
import com.ibm.ws.wssecurity.wssobject.util.WSSObjectWriter;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstants;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsNSPrefixPair;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSSObjectElementImpl
implements WSSObjectElement {
    public static final int RESERVED_CHILDREN_SIZE = 0;
    protected WSSObjectDocumentImpl wssObjectDocumentImpl;
    protected QName qname;
    protected NamespacePrefixPair namespacePrefixPair;
    protected NamespacePrefixPairSortedSet namespaceDeclarations;
    protected AttributeSortedSet attrSortedSet;
    protected Parent parent;
    protected ArrayList<WSSObject> children;
    protected VariablePartAttributeValue wsuId;

    public WSSObjectElementImpl(WSSObjectDocumentImpl wssObjectDocumentImpl, QName qname) {
        if (wssObjectDocumentImpl == null) {
            throw new NullPointerException("WSSObjectElementImpl: wssObjectDocumentImpl must not be null");
        }
        this.wssObjectDocumentImpl = wssObjectDocumentImpl;
        this.qname = qname;
        this.namespacePrefixPair = qname.getNamespacePrefixPair();
    }

    @Override
    public final void setWSSObjectDocument(WSSObjectDocumentImpl wssObjectDocumentImpl) {
        this.wssObjectDocumentImpl = wssObjectDocumentImpl;
    }

    @Override
    public final WSSObjectDocumentImpl getWSSObjectDocument() {
        return this.wssObjectDocumentImpl;
    }

    @Override
    public final void propagateWSSObjectDocument(WSSObjectDocumentImpl wssObjectDocumentImpl) {
        this.setWSSObjectDocument(wssObjectDocumentImpl);
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                WSSObject wssObject = this.children.get(i);
                if (wssObject == null) continue;
                wssObject.propagateWSSObjectDocument(wssObjectDocumentImpl);
            }
        }
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public final NamespacePrefixPair getNamespace() {
        return this.namespacePrefixPair;
    }

    @Override
    public final void gatherUtilizedNamespaces(NamespacePrefixPairSortedSet utilizedNamespaces) {
        utilizedNamespaces.add(this.namespacePrefixPair);
        if (this.attrSortedSet != null) {
            int size = this.attrSortedSet.size();
            for (int i = 0; i < size; ++i) {
                NamespacePrefixPair attrNamespacePrefixPair = this.attrSortedSet.getQName(i).getNamespacePrefixPair();
                if (Utf8ByteConstantsNSPrefixPair.NSPP_DEFAULT_ATTR.equals(attrNamespacePrefixPair)) continue;
                utilizedNamespaces.add(attrNamespacePrefixPair);
            }
        }
    }

    @Override
    public final void gatherAllUtilizedNamespaces(NamespacePrefixPairSortedSet utilizedNamespaces) {
        this.gatherUtilizedNamespaces(utilizedNamespaces);
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                WSSObject wssObject = this.children.get(i);
                if (!(wssObject instanceof BelongsToNamespace)) continue;
                BelongsToNamespace belongsToNamespace = (BelongsToNamespace)((Object)wssObject);
                belongsToNamespace.gatherAllUtilizedNamespaces(utilizedNamespaces);
            }
        }
    }

    @Override
    public final void setParent(Parent parent) {
        this.parent = parent;
    }

    @Override
    public final Parent getParent() {
        return this.parent;
    }

    @Override
    public int getReservedChildrenSize() {
        return 0;
    }

    public int getInitialChildrenSize() {
        return 5;
    }

    @Override
    public int getChildrenSize() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public final ArrayList<WSSObject> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(WSSObject wssObject) {
        if (this.children == null) {
            this.ensureChildrenCapacity();
        }
        this.children.add(wssObject);
        if (wssObject != null) {
            wssObject.setParent(this);
        }
        if (wssObject instanceof BelongsToNamespace) {
            BelongsToNamespace belongsToNamespace = (BelongsToNamespace)((Object)wssObject);
            this.wssObjectDocumentImpl.declareNamespace(belongsToNamespace.getNamespace());
        }
    }

    @Override
    public void setChild(int index, WSSObject wssObject) {
        if (this.children == null) {
            this.ensureChildrenCapacity();
        }
        this.ensureChildrenCapacity(index);
        WSSObject removed = this.children.set(index, wssObject);
        if (removed != null) {
            removed.setParent(null);
        }
        if (wssObject != null) {
            wssObject.setParent(this);
        }
        if (wssObject instanceof BelongsToNamespace) {
            BelongsToNamespace belongsToNamespace = (BelongsToNamespace)((Object)wssObject);
            this.wssObjectDocumentImpl.declareNamespace(belongsToNamespace.getNamespace());
        }
    }

    @Override
    public void insertChildBefore(int index, WSSObject wssObject) {
        if (this.children == null) {
            this.ensureChildrenCapacity();
        }
        this.ensureChildrenCapacity(index);
        this.children.add(index, wssObject);
        if (wssObject != null) {
            wssObject.setParent(this);
        }
        if (wssObject instanceof BelongsToNamespace) {
            BelongsToNamespace belongsToNamespace = (BelongsToNamespace)((Object)wssObject);
            this.wssObjectDocumentImpl.declareNamespace(belongsToNamespace.getNamespace());
        }
    }

    @Override
    public WSSObject getChild(int index) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(index);
    }

    @Override
    public WSSObject removeChild(int index) {
        if (this.children == null) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (index >= this.children.size()) {
            return null;
        }
        WSSObject ret = this.children.get(index);
        if (ret != null) {
            ret.setParent(null);
        }
        if (index < this.getReservedChildrenSize()) {
            this.children.set(index, null);
        } else {
            this.children.remove(index);
        }
        return ret;
    }

    protected void ensureChildrenCapacity() {
        int reservedSize = this.getReservedChildrenSize();
        int initialSize = reservedSize + this.getInitialChildrenSize();
        this.children = new ArrayList(initialSize);
    }

    protected void ensureChildrenCapacity(int index) {
        int pos = this.children.size();
        if (index >= pos) {
            while (pos <= index) {
                this.children.add(null);
                ++pos;
            }
        }
    }

    @Override
    public void declareNamespace(NamespacePrefixPair namespacePrefixPair) {
        int index;
        if (this.wssObjectDocumentImpl.getNSDeclsMode() == 1) {
            throw new IllegalArgumentException("explicit namespace declaration is restricted in CENTRALIZED mode (outbound)");
        }
        if (this.namespaceDeclarations == null) {
            this.namespaceDeclarations = new NamespacePrefixPairSortedSet();
        }
        if ((index = this.namespaceDeclarations.add(namespacePrefixPair)) < 0) {
            throw new IllegalArgumentException("namespace overwriting by same prefix is restricted in CENTRALIZED mode (outbound)");
        }
    }

    @Override
    public NamespacePrefixPairSortedSet getDeclaredNamespaces() {
        return this.namespaceDeclarations;
    }

    @Override
    public final void setAttributeToSortedSet(QName qname, VariablePartAttributeValue variablePart) {
        if (this.attrSortedSet == null) {
            this.attrSortedSet = new AttributeSortedSet();
        }
        if (variablePart == null) {
            this.attrSortedSet.remove(qname);
        } else {
            this.attrSortedSet.add(qname, variablePart);
            if (qname.getNamespacePrefixPair() != Utf8ByteConstantsNSPrefixPair.NSPP_DEFAULT_ATTR) {
                this.wssObjectDocumentImpl.declareNamespace(qname.getNamespacePrefixPair());
            }
        }
    }

    @Override
    public final AttributeSortedSet getAttributeSortedSet() {
        return this.attrSortedSet;
    }

    public final void registerThis2IdMap(VariablePartAttributeValue variablePart) {
        String id = variablePart.toString();
        if (id == null) {
            throw new NullPointerException("WSSObjectElementImpl.registerThis2IdMap(VariablePartAttributeValue): Id value must not be null");
        }
        WSSObject ret = this.wssObjectDocumentImpl.getIdMap().put(id, this);
        if (ret != null) {
            throw new IllegalArgumentException("WSSObjectElementImpl.registerThis2IdMap(VariablePartAttributeValue): The Id=" + variablePart.toString() + " is already used in this WSSObject tree");
        }
    }

    public final void setWsuId(VariablePartAttributeValue variablePart) {
        this.wsuId = variablePart;
        this.setAttributeToSortedSet(Utf8ByteConstantsQNames.WSU.QN_ID, variablePart);
        this.registerThis2IdMap(variablePart);
    }

    public WSSObjectTextElement createWSSObjectTextElement(QName qname, VariablePartTextValue variablePart) {
        if (variablePart == null) {
            return null;
        }
        return new WSSObjectTextElementImpl(this.wssObjectDocumentImpl, qname, variablePart);
    }

    public final void setChildAsSimpleTextElement(int reservedIndex, QName qname, VariablePartTextValue variablePart) {
        WSSObjectTextElement wssobjectTextElement = this.createWSSObjectTextElement(qname, variablePart);
        this.setChild(reservedIndex, wssobjectTextElement);
    }

    public final void addChildAsSimpleTextElement(QName qname, VariablePartTextValue variablePart) {
        WSSObjectTextElement wssobjectTextElement = this.createWSSObjectTextElement(qname, variablePart);
        this.addChild(wssobjectTextElement);
    }

    public WSSObjectTextNode createWSSObjectTextNode(VariablePartTextValue variablePartText) {
        if (variablePartText == null) {
            return null;
        }
        return new WSSObjectTextNodeImpl(this.wssObjectDocumentImpl, variablePartText);
    }

    public final void setChildAsTextNode(int reservedIndex, VariablePartTextValue variablePart) {
        WSSObjectTextNode wssObjectTextNode = this.createWSSObjectTextNode(variablePart);
        this.setChild(reservedIndex, wssObjectTextNode);
    }

    public final void addChildAsTextNode(VariablePartTextValue variablePart) {
        WSSObjectTextNode wssObjectTextNode = this.createWSSObjectTextNode(variablePart);
        this.addChild(wssObjectTextNode);
    }

    @Override
    public final void canonicalize(WSSObjectC14NWriter wssObjectC14NWriter, NamespacePrefixPairStack nsRendered, HashSet<String> inclusiveNamespacesPrefixList, boolean asRoot) throws IOException {
        if (asRoot && inclusiveNamespacesPrefixList != null && inclusiveNamespacesPrefixList.size() == 0) {
            inclusiveNamespacesPrefixList = null;
        }
        nsRendered.pushContext();
        this.canonicalizeStartPart(wssObjectC14NWriter, nsRendered, inclusiveNamespacesPrefixList, asRoot);
        wssObjectC14NWriter.writeUTF8CharwithoutCharRef((byte)62);
        this.canonicalizeMiddlePart(wssObjectC14NWriter, nsRendered, inclusiveNamespacesPrefixList, asRoot);
        wssObjectC14NWriter.writeUTF8CharwithoutCharRef(this.qname.getEndTagUtf8Representation());
        nsRendered.popContext();
    }

    protected void canonicalizeStartPart(WSSObjectC14NWriter wssObjectC14NWriter, NamespacePrefixPairStack nsRendered, HashSet<String> inclusiveNamespacesPrefixList, boolean asRoot) throws IOException {
        NamespacePrefixPair namespacePrefixPair;
        int i;
        int size;
        NamespacePrefixPairSortedSet toBeRenderedNamespaces;
        NamespacePrefixPairSortedSet utilizedNamespaces;
        block21: {
            wssObjectC14NWriter.writeUTF8CharwithoutCharRef(this.qname.getOpenStartTagUtf8Representation());
            utilizedNamespaces = wssObjectC14NWriter.getPooledNamespacePrefixPairSortedSet();
            this.gatherUtilizedNamespaces(utilizedNamespaces);
            toBeRenderedNamespaces = wssObjectC14NWriter.getPooledNamespacePrefixPairSortedSet();
            size = utilizedNamespaces.size();
            for (i = 0; i < size; ++i) {
                namespacePrefixPair = utilizedNamespaces.getNamespacePrefixPair(i);
                String prefix = namespacePrefixPair.getPrefix();
                NamespacePrefixPair renderedNS = nsRendered.getNamespacePrefixPair(prefix);
                if (renderedNS != null || inclusiveNamespacesPrefixList != null && inclusiveNamespacesPrefixList.contains(prefix)) continue;
                toBeRenderedNamespaces.add(namespacePrefixPair);
            }
            if (inclusiveNamespacesPrefixList != null && inclusiveNamespacesPrefixList.size() > 0) {
                int num = 0;
                for (String prefix : inclusiveNamespacesPrefixList) {
                    if (toBeRenderedNamespaces.getNamespacePrefixPair(prefix) == null) continue;
                    ++num;
                }
                if (num != inclusiveNamespacesPrefixList.size()) {
                    if (this.namespaceDeclarations != null) {
                        size = this.namespaceDeclarations.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            NamespacePrefixPair namespacePrefixPair2 = this.namespaceDeclarations.getNamespacePrefixPair(i2);
                            if (!inclusiveNamespacesPrefixList.contains(namespacePrefixPair2.getPrefix())) continue;
                            toBeRenderedNamespaces.add(namespacePrefixPair2);
                            if (num++ != inclusiveNamespacesPrefixList.size()) {
                                continue;
                            }
                            break block21;
                        }
                    }
                    if (this.parent instanceof WSSObjectDocumentImpl) {
                        NamespacePrefixPairSortedSet nsdecls = this.wssObjectDocumentImpl.getDeclaredNamespaces();
                        size = nsdecls.size();
                        for (int i3 = 0; i3 < size; ++i3) {
                            NamespacePrefixPair namespacePrefixPair3 = nsdecls.getNamespacePrefixPair(i3);
                            if (!inclusiveNamespacesPrefixList.contains(namespacePrefixPair3.getPrefix())) continue;
                            toBeRenderedNamespaces.add(namespacePrefixPair3);
                            if (num++ != inclusiveNamespacesPrefixList.size()) {
                                continue;
                            }
                            break block21;
                        }
                    }
                    if (asRoot) {
                        Parent tempParent = this.parent;
                        while (tempParent instanceof Child) {
                            if (!(tempParent instanceof HasNamspaceDeclarations)) continue;
                            HasNamspaceDeclarations parentWithNSDecls = (HasNamspaceDeclarations)((Object)tempParent);
                            NamespacePrefixPairSortedSet nsdecls = parentWithNSDecls.getDeclaredNamespaces();
                            if (nsdecls != null) {
                                size = nsdecls.size();
                                for (int i4 = 0; i4 < size; ++i4) {
                                    NamespacePrefixPair pair = nsdecls.getNamespacePrefixPair(i4);
                                    if (!inclusiveNamespacesPrefixList.contains(pair.getPrefix())) continue;
                                    toBeRenderedNamespaces.add(this.namespacePrefixPair);
                                    if (num++ != inclusiveNamespacesPrefixList.size()) {
                                        continue;
                                    }
                                    break block21;
                                }
                            }
                            Child childOfGrandParent = (Child)((Object)tempParent);
                            tempParent = childOfGrandParent.getParent();
                        }
                        NamespacePrefixPairSortedSet nsdecls = this.wssObjectDocumentImpl.getDeclaredNamespaces();
                        size = nsdecls.size();
                        for (int i5 = 0; i5 < size; ++i5) {
                            NamespacePrefixPair namespacePrefixPair4 = nsdecls.getNamespacePrefixPair(i5);
                            if (!inclusiveNamespacesPrefixList.contains(namespacePrefixPair4.getPrefix())) continue;
                            toBeRenderedNamespaces.add(namespacePrefixPair4);
                            if (num++ != inclusiveNamespacesPrefixList.size()) {
                                continue;
                            }
                            break block21;
                        }
                        for (String prefix : inclusiveNamespacesPrefixList) {
                            NamespacePrefixPair pair = this.wssObjectDocumentImpl.getNamespacesInAncestor().findNamespacePrefixesPairFromOMNamespaces(prefix);
                            if (pair == null) continue;
                            toBeRenderedNamespaces.add(pair);
                            if (num++ != inclusiveNamespacesPrefixList.size()) continue;
                            break;
                        }
                    }
                }
            }
        }
        size = toBeRenderedNamespaces.size();
        for (i = 0; i < size; ++i) {
            namespacePrefixPair = toBeRenderedNamespaces.getNamespacePrefixPair(i);
            nsRendered.declarePrefix(namespacePrefixPair);
            wssObjectC14NWriter.writeUTF8CharwithoutCharRef(namespacePrefixPair.getSerializationExpression());
        }
        if (this.attrSortedSet != null) {
            int attrSize = this.attrSortedSet.size();
            for (int i6 = 0; i6 < attrSize; ++i6) {
                wssObjectC14NWriter.writeUTF8CharwithoutCharRef(this.attrSortedSet.getQName(i6).getOpenAttrUtf8Representation());
                wssObjectC14NWriter.write(this.attrSortedSet.getVariableParts(i6));
                wssObjectC14NWriter.writeUTF8CharwithoutCharRef((byte)34);
            }
        }
        wssObjectC14NWriter.poolNamespacePrefixPairSortedSet(utilizedNamespaces);
        wssObjectC14NWriter.poolNamespacePrefixPairSortedSet(toBeRenderedNamespaces);
    }

    protected void canonicalizeMiddlePart(WSSObjectC14NWriter wssObjectC14NWriter, NamespacePrefixPairStack nsRendered, HashSet<String> inclusiveNamespacesPrefixList, boolean asRoot) throws IOException {
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                WSSObject wssObject = this.children.get(i);
                if (wssObject == null) continue;
                wssObject.canonicalize(wssObjectC14NWriter, nsRendered, inclusiveNamespacesPrefixList, false);
            }
        }
    }

    @Override
    public final void serialize(WSSObjectWriter wSSObjectWriter, boolean asRoot) throws IOException {
        this.serializeStartPart(wSSObjectWriter, asRoot);
        if (this.children == null || this.children.size() == 0) {
            wSSObjectWriter.writeUTF8CharwithoutCharRef(Utf8ByteConstants.SLASH_GT);
        } else {
            wSSObjectWriter.writeUTF8CharwithoutCharRef((byte)62);
            this.serializeMiddlePart(wSSObjectWriter);
            wSSObjectWriter.writeUTF8CharwithoutCharRef(this.qname.getEndTagUtf8Representation());
        }
    }

    protected void serializeStartPart(WSSObjectWriter wSSObjectWriter, boolean asRoot) throws IOException {
        wSSObjectWriter.writeUTF8CharwithoutCharRef(this.qname.getOpenStartTagUtf8Representation());
        if (this.parent instanceof WSSObjectDocumentImpl) {
            WSSObjectDocumentImpl wssObjectDocumentImpl = (WSSObjectDocumentImpl)this.parent;
            NamespacePrefixPairSortedSet registeredNamespaces = wssObjectDocumentImpl.getDeclaredNamespaces();
            int size = registeredNamespaces.size();
            for (int i = 0; i < size; ++i) {
                NamespacePrefixPair namespacePrefixPair = registeredNamespaces.getNamespacePrefixPair(i);
                wSSObjectWriter.writeUTF8CharwithoutCharRef(namespacePrefixPair.getSerializationExpression());
            }
        }
        if (this.namespaceDeclarations != null) {
            int size = this.namespaceDeclarations.size();
            for (int i = 0; i < size; ++i) {
                NamespacePrefixPair namespacePrefixPair = this.namespaceDeclarations.getNamespacePrefixPair(i);
                wSSObjectWriter.writeUTF8CharwithoutCharRef(namespacePrefixPair.getSerializationExpression());
            }
        }
        if (this.attrSortedSet != null) {
            int size = this.attrSortedSet.size();
            for (int i = 0; i < size; ++i) {
                wSSObjectWriter.writeUTF8CharwithoutCharRef(this.attrSortedSet.getQName(i).getOpenAttrUtf8Representation());
                wSSObjectWriter.write(this.attrSortedSet.getVariableParts(i));
                wSSObjectWriter.writeUTF8CharwithoutCharRef((byte)34);
            }
        }
    }

    protected void serializeMiddlePart(WSSObjectWriter wSSObjectWriter) throws IOException {
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                WSSObject wssObject = this.children.get(i);
                if (wssObject == null) continue;
                wssObject.serialize(wSSObjectWriter, false);
            }
        }
    }

    public final String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        WSSObjectNormalWriter variablePartWriter = new WSSObjectNormalWriter(baos);
        try {
            this.serialize(variablePartWriter, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] bytes = baos.toByteArray();
        return new String(bytes);
    }
}

