/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.verify.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerifyPart;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptionImpl;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSVerifyPartImpl
implements WSSVerifyPart {
    private static final TraceComponent tc = Tr.register(WSSDecryptionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSVerifyPartImpl.class.getName();
    private static final long serialVersionUID = 3678122071571862249L;
    private static final Map<Integer, String> partMap = new HashMap<Integer, String>();
    private List<String> digestMethods = new ArrayList<String>();
    private List<AlgorithmParameterData> transforms = new ArrayList<AlgorithmParameterData>();
    private String dialect = Constants.DIALECT_WAS;
    private String keyword;
    private String headerNamespace;
    private String headerName;

    @Override
    public void addAllowedDigestMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getDigestAlgorithms().contains(method)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s11";
            WSSException e = WSSException.format(msg, method);
            Tr.processException((Throwable)e, clsName + ".addAllowedDigestMethod", "97", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        this.digestMethods.add(method);
    }

    @Override
    public void addAllowedTransform(String algorithm) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getTransformAlgorithms().contains(algorithm)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s12";
            WSSException e = WSSException.format(msg, algorithm);
            Tr.processException((Throwable)e, clsName + ".addAllowedTransform", "111", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        AlgorithmParameterData paramData = new AlgorithmParameterData(algorithm);
        this.transforms.add(paramData);
    }

    @Override
    public void setRequiredVerifyPart(int part) throws WSSException {
        this.keyword = this.getKeyword(part);
    }

    @Override
    public void setRequiredVerifyHeader(QName header) {
        this.dialect = Constants.DIALECT_HEADER;
        this.headerNamespace = header.getNamespaceURI();
        this.headerName = header.getLocalPart();
    }

    @Override
    public void setRequiredVerifyPartByXPath(String xpath) {
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = xpath;
    }

    public List<String> getDigestMethods() {
        return this.digestMethods;
    }

    public List<AlgorithmParameterData> getTransforms() {
        return this.transforms;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getHeaderNamespace() {
        return this.headerNamespace;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getKeyword(int part) throws WSSException {
        String keyword;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyword (" + part + ")");
        }
        if ((keyword = partMap.get(part)) == null) {
            String msg = "security.wssecurity.WSEC7010E";
            WSSException e = WSSException.format(msg);
            Tr.processException((Throwable)e, clsName + ".getKeyword", "180", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyword (" + part + ")");
        }
        return keyword;
    }

    static {
        partMap.put(41, IntegralDialectElementSelector.WASDIALECTS[0]);
        partMap.put(42, IntegralDialectElementSelector.WASDIALECTS[13]);
        partMap.put(43, IntegralDialectElementSelector.WASDIALECTS[1]);
    }
}

