/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.verify.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerifyPart;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerifyPartImpl;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSVerificationImpl
implements WSSVerification,
Consumable {
    private static final TraceComponent tc = Tr.register(WSSVerificationImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSVerificationImpl.class.getName();
    private static final long serialVersionUID = 5487399524209531395L;
    private SecurityToken token;
    private List<WSSVerifyPart> verifyParts = new ArrayList<WSSVerifyPart>();
    private List<String> canonicalizationMethods = new ArrayList<String>();
    private List<String> signatureMethods = new ArrayList<String>();
    private boolean signatureConfirmation;
    private boolean requriredSignatureConfirmation;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSVerificationImpl(SecurityTokenManagerImpl securityTokenManager) {
        this.securityTokenManager = securityTokenManager;
    }

    public WSSVerificationImpl(Class tokenClass, CallbackHandler callbackHandler, String loginModuleName, SecurityTokenManagerImpl securityTokenManager) throws WSSException {
        this.securityTokenManager = securityTokenManager;
        this.addToken(tokenClass, callbackHandler, loginModuleName);
    }

    @Override
    public void addRequiredVerifyPart(int part) throws WSSException {
        WSSVerifyPartImpl verifyPart = new WSSVerifyPartImpl();
        verifyPart.setRequiredVerifyPart(part);
        this.verifyParts.add(verifyPart);
    }

    @Override
    public void addRequiredVerifyPartByXPath(String xpath) {
        WSSVerifyPartImpl verifyPart = new WSSVerifyPartImpl();
        verifyPart.setRequiredVerifyPartByXPath(xpath);
        this.verifyParts.add(verifyPart);
    }

    @Override
    public void addRequiredVerifyPart(WSSVerifyPart part) {
        this.verifyParts.add(part);
    }

    @Override
    public void addAllowedCanonicalizationMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getCanonicalizationAlgorithms().contains(method)) {
            WSSException wSSException = WSSException.format("security.wssecurity.PrivateConsumerConfig.s08", method);
        }
        this.canonicalizationMethods.add(method);
    }

    @Override
    public void addAllowedSignatureMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getSignatureAlgorithms().contains(method)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s09";
            WSSException e = WSSException.format(msg, method);
            Tr.processException((Throwable)e, clsName + ".addAllowedSignatureMethod", "153", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        this.signatureMethods.add(method);
    }

    @Override
    public void addRequiredVerifyHeader(QName header) {
        WSSVerifyPartImpl verifyPart = new WSSVerifyPartImpl();
        verifyPart.setRequiredVerifyHeader(header);
        this.verifyParts.add(verifyPart);
    }

    public List<WSSVerifyPart> getVerifyParts() {
        return this.verifyParts;
    }

    public List<String> getCanonicalizationMethods() {
        return this.canonicalizationMethods;
    }

    public List<String> getSignatureMethods() {
        return this.signatureMethods;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    @Override
    public void addToken(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName )");
        }
        this.token = WSSUtil.newSecurityTokenForConsumer(tokenClass, callbackHandler, loginConfigName, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(Qname valueType, CallbackHandler callbackHandler, String loginConfigName )");
        }
    }

    @Override
    public void addToken(Class tokenClass, CallbackHandler callbackHandler) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler )");
        }
        this.token = WSSUtil.newSecurityTokenForConsumer(tokenClass, callbackHandler, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler )");
        }
    }

    @Override
    public void requireSignatureConfirmation() {
        this.signatureConfirmation = true;
    }

    public boolean isRequriredSignatureConfirmation() {
        return this.requriredSignatureConfirmation;
    }

    public boolean isSignatureConfirmation() {
        return this.signatureConfirmation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WSSVerificationImpl:");
        buffer.append(" canonicalizationMethods: ");
        buffer.append(this.canonicalizationMethods);
        buffer.append(", signatureMethods: ");
        buffer.append(this.signatureMethods);
        buffer.append(", verifyParts: ");
        buffer.append(this.verifyParts);
        buffer.append(", token: ");
        buffer.append(this.token);
        buffer.append(", signatureConfirmation: ");
        buffer.append(this.signatureConfirmation);
        buffer.append(", requriredSignatureConfirmation: ");
        buffer.append(this.requriredSignatureConfirmation);
        buffer.append("]");
        return buffer.toString();
    }
}

