/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.BinarySecurityTokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecurityPermission;
import java.security.cert.X509Certificate;
import org.apache.axis2.util.ObjectStateUtils;

public class X509TokenImpl
extends BinarySecurityTokenImpl
implements X509Token {
    private static final TraceComponent tc = Tr.register(X509TokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 3166835820878605529L;
    private static final String VERSION_NUMBER = "1.0";
    private static final SecurityPermission SETCERT_PERM = new SecurityPermission("wssapi.X509Token.setCertificate");
    private X509Certificate certificate;
    private String issuerName;
    private String issuerSerial;
    protected int hashcode = 0;

    public X509TokenImpl() {
        this.keyIdentifierValueType = Constants.X509_SKI_OLD;
        this.keyIdentifierEncodingType = Constants.BASE64_BINARY;
        this.valueType = X509Token.ValueType;
        this.tokenQName = X509Token.TokenQname;
        this.hashcode = SecurityUIDGenerator.createUID().hashCode();
    }

    public void setTokenToErrata10() {
        if (!this.readOnly) {
            this.keyIdentifierValueType = Constants.X509_SKI;
            this.valueType = Constants.X509V3;
        }
    }

    public String getId() {
        if (this.id == null || this.id.length() == 0) {
            int value = 0;
            value = SecurityUIDGenerator.createUID().hashCode();
            this.id = "x509_" + String.valueOf(value);
        }
        return this.id;
    }

    public X509Certificate getCertificate() {
        X509Certificate certificate = this.certificate;
        if (this.readOnly && this.certificate != null) {
            try {
                certificate = CertificateUtil.generateX509Certificate(this.certificate.getEncoded(), null);
            }
            catch (Exception e) {
                certificate = null;
            }
        }
        return certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETCERT_PERM.toString());
            }
            sm.checkPermission(SETCERT_PERM);
        }
        if (!this.readOnly) {
            this.certificate = certificate;
            if (certificate == null) {
                this.principal = null;
            } else {
                this.principal = certificate.getSubjectDN().getName();
                String encoded = KeyInfo.X509Data.encodeDName(this.principal);
                if (encoded != null && encoded.length() > 0) {
                    this.principal = encoded;
                }
            }
        }
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        if (!this.readOnly) {
            this.issuerName = issuerName;
        }
    }

    public String getIssuerSerial() {
        return this.issuerSerial;
    }

    public void setIssuerSerial(String issuerSerial) {
        if (!this.readOnly) {
            this.issuerSerial = issuerSerial;
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X509TokenImpl)) {
            return false;
        }
        return ((X509TokenImpl)o).hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            StringBuffer hashString = new StringBuffer();
            if (this.getId() != null) {
                hashString.append(this.getId());
            }
            if (this.getCertificate() != null) {
                hashString.append(this.getCertificate().getSerialNumber());
            }
            this.hashcode = hashString.length() > 0 ? hashString.hashCode() : SecurityUIDGenerator.createUID().hashCode();
        }
        return this.hashcode;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        String version = ObjectStateUtils.readString(in, "X509Token.version");
        if (VERSION_NUMBER.equals(version)) {
            Object tmp = ObjectStateUtils.readObject(in, "X509Token.certificate");
            if (tmp != null) {
                this.certificate = (X509Certificate)tmp;
            }
            this.issuerName = ObjectStateUtils.readString(in, "X509Token.issuerName");
            this.issuerSerial = ObjectStateUtils.readString(in, "X509Token.issuerSerial");
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ObjectStateUtils.writeString(out, VERSION_NUMBER, "UsernameToken.version");
        ObjectStateUtils.writeObject(out, this.certificate, "X509Token.certificate");
        ObjectStateUtils.writeString(out, this.issuerName, "X509Token.issuerName");
        ObjectStateUtils.writeString(out, this.issuerSerial, "X509Token.issuerSerial");
    }
}

