/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.X509ConsumeCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509TokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509ConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(X509ConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509ConsumeLoginModule.class.getName();
    private static final String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.X509Token");
    private static final TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean isKeyName;
        boolean isKeyId;
        boolean isStrref;
        boolean isEmb;
        boolean isX509;
        boolean isThumbprint;
        boolean isNone;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        X509ConsumeCallback x509Callback = new X509ConsumeCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{x509Callback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "143", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig config2 = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        boolean isForwardable = true;
        String forwardable = (String)config2.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (forwardable != null && forwardable.equalsIgnoreCase("false")) {
            isForwardable = false;
        }
        X509TokenImpl x509Token = (X509TokenImpl)_tokenFactory.getToken(isForwardable);
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, x509Token);
        QName vtype = config2.getType();
        if (!(com.ibm.ws.wssecurity.common.Constants.X509V3.equals(vtype) || com.ibm.ws.wssecurity.common.Constants.X509V3_OLD.equals(vtype) || com.ibm.ws.wssecurity.common.Constants.X509V3_11_V3.equals(vtype))) {
            String errorMes = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{vtype.toString(), com.ibm.ws.wssecurity.common.Constants.X509V3.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.X509V3_OLD.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.X509V3_11_V3.toString()});
            throw new LoginException(errorMes);
        }
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        CertCacheManager cmanager = (CertCacheManager)this._context.get(CertCacheManager.class);
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        OMElement target = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (keyInfoType == null) {
            isNone = true;
            isThumbprint = false;
            isX509 = false;
            isEmb = false;
            isStrref = false;
            isKeyId = false;
            isKeyName = false;
        } else {
            isNone = false;
            isKeyName = ConfigUtil.isKeyInfoKeyname(keyInfoType);
            isKeyId = ConfigUtil.isKeyInfoKeyid(keyInfoType);
            isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb(keyInfoType);
            isX509 = ConfigUtil.isKeyInfoX509issuer(keyInfoType);
            isThumbprint = ConfigUtil.isKeyInfoThumbprint(keyInfoType);
        }
        this._token = isNone || isEmb ? X509ConsumeLoginModule.processElement(x509Token, x509Callback, target, config2, cmanager, messageContext, isNone, isEmb, this._context) : X509ConsumeLoginModule.resolveKeyInfo(x509Token, x509Callback, config2, cmanager, messageContext, keyInfoType, isKeyName, isKeyId, isStrref, isX509, isThumbprint, this._securityTokenManager, this._context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The token hash value = " + this._token.hashCode());
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final SecurityToken resolveKeyInfo(X509TokenImpl x509Token, X509ConsumeCallback x509Callback, TokenConsumerConfig config2, CertCacheManager cmanager, MessageContext messageContext, String keyInfoType, boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isX509, boolean isThumbprint, SecurityTokenManager securityTokenManager, Map<Object, Object> context) throws LoginException {
        String tokenId;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveKeyInfo(");
            buf.append("X509TokenImpl x509Token, X509ConsumeCallback x509Callback, ");
            buf.append("TokenConsumerConfig config, CertCacheManager cmanager, ");
            buf.append("SOAPMessageContext messageContext, ");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("boolean isKeyName[").append(isKeyName).append("], ");
            buf.append("boolean isKeyId[").append(isKeyId).append("], ");
            buf.append("boolean isStrref[").append(isStrref).append("], ");
            buf.append("boolean isX509[").append(isX509).append("], ");
            buf.append("boolean isThumbprint[").append(isThumbprint).append("], ");
            buf.append("SecurityTokenManager securityTokenManager, Map context)");
            Tr.entry(tc, buf.toString());
        }
        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean isAuthnEventsRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, context) || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context);
        SecurityToken token = null;
        if (isStrref) {
            SecurityToken existToken;
            tokenId = (String)context.get(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token identifier is [" + tokenId + "]");
            }
            if ((existToken = securityTokenManager.getToken(config2, tokenId)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: SecurityToken whose identifier is \"" + tokenId + "\" was not found in the Subject.");
                }
                token = x509Token;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is the token [" + tokenId + "] stored in the Subject.");
                }
                token = existToken;
            }
        } else {
            tokenId = null;
            String tokenIssuerName = null;
            String tokenIssuerSerial = null;
            if (isKeyId) {
                tokenId = (String)context.get(Constants.WSSECURITY_KEY_ID);
            } else if (isThumbprint) {
                tokenId = (String)context.get(Constants.WSSECURITY_KEY_THUMBPRINT_REFERENCE);
            } else if (isKeyName) {
                tokenId = (String)context.get(Constants.WSSECURITY_KEY_NAME);
            } else if (isX509) {
                tokenIssuerName = (String)context.get(Constants.WSSECURITY_KEY_ISSUERNAME);
                tokenIssuerSerial = (String)context.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
                if (tokenIssuerName != null && tokenIssuerSerial != null) {
                    tokenId = tokenIssuerName + ":" + tokenIssuerSerial;
                }
            }
            SecurityToken existToken = securityTokenManager.getToken(config2, tokenId);
            if (existToken == null) {
                KeyStoreManager.KeyInformation keyInformation;
                X509Certificate x509;
                block81: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no token [" + tokenId + "] stored in the Subject.");
                    }
                    x509Token.setId(tokenId);
                    if (!x509Callback.existKeyStore()) {
                        String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6810E", new String[]{tokenId});
                        throw new LoginException(errorMes);
                    }
                    x509 = null;
                    if (cmanager != null) {
                        Certificate cert;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the cached X509Certificate object with the key[" + tokenId + "].");
                        }
                        try {
                            cert = cmanager.getCachedCert(tokenId);
                        }
                        catch (SoapSecurityException e) {
                            Tr.processException(e, clsName + ".resolveKeyInfo", "410");
                            throw new LoginException(e.toString());
                        }
                        if (cert == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "There is no cached certificiate.");
                            }
                        } else if (cert instanceof X509Certificate) {
                            x509 = (X509Certificate)cert;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The X509Certificate [" + x509.getSubjectDN().getName() + "] was found.");
                            }
                        } else if (tc.isDebugEnabled()) {
                            StringBuffer buf = new StringBuffer("The certificate [");
                            buf.append(cert.getClass().getName());
                            buf.append("] was found, but it's not the X509Certificate object.");
                            Tr.debug(tc, buf.toString());
                        }
                    }
                    keyInformation = null;
                    try {
                        KeyStoreManager ksManager = KeyStoreManager.getInstance();
                        keyInformation = ksManager.getKeyInformation(x509Callback.getKeyStorePath(), x509Callback.getKeyStoreType(), x509Callback.getKeyStorePassword(), x509Callback.getKeyStoreReference(), x509Callback.getAlias(), x509Callback.getKeyPassword(), x509Callback.getKeyName());
                    }
                    catch (SoapSecurityException e) {
                        Tr.processException(e, clsName + ".resolveKeyInfo", "443");
                        throw new LoginException(e.toString());
                    }
                    if (x509 == null) {
                        try {
                            QName vtype;
                            if (isKeyId) {
                                vtype = (QName)context.get(Constants.WSSECURITY_KEY_VALUETYPE);
                                if (vtype == null) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier02");
                                    throw new LoginException(errorMes);
                                }
                                if (!com.ibm.ws.wssecurity.common.Constants.X509_SKI.equals(vtype) && !com.ibm.ws.wssecurity.common.Constants.X509_SKI_OLD.equals(vtype)) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier03", new String[]{com.ibm.ws.wssecurity.common.Constants.X509_SKI.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.X509_SKI_OLD.toString(), vtype.toString()});
                                    throw new LoginException(errorMes);
                                }
                                QName idtype = (QName)context.get(Constants.WSSECURITY_KEY_IDTYPE);
                                QName etype = (QName)context.get(Constants.WSSECURITY_KEY_ENCODING);
                                String keyId = null;
                                if (etype == null || NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
                                    if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                                        keyId = keyInformation.getB64KeyId();
                                    } else {
                                        if (!NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                                            String errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01");
                                            errorMes = errorMes + ": " + idtype;
                                            throw new LoginException(errorMes);
                                        }
                                        keyId = keyInformation.getB64KeyId60();
                                    }
                                } else {
                                    if (!NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
                                        String errorMes = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{etype.toString()});
                                        throw new LoginException(errorMes);
                                    }
                                    if (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                                        keyId = keyInformation.getHexKeyId();
                                    } else {
                                        if (!NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                                            String errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01");
                                            errorMes = errorMes + ": " + idtype;
                                            throw new LoginException(errorMes);
                                        }
                                        keyId = keyInformation.getHexKeyId60();
                                    }
                                }
                                if (!tokenId.equals(keyId)) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6811E", new String[]{tokenId, keyId, x509Callback.getKeyStorePath()});
                                    throw new LoginException(errorMes);
                                }
                            } else if (isThumbprint) {
                                vtype = (QName)context.get(Constants.WSSECURITY_KEY_VALUETYPE);
                                if (vtype == null) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier02");
                                    throw new LoginException(errorMes);
                                }
                                if (!com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1.equals(vtype)) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier03", new String[]{com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1.toString(), vtype.toString()});
                                    throw new LoginException(errorMes);
                                }
                                QName etype = (QName)context.get(Constants.WSSECURITY_KEY_ENCODING);
                                String thumbprint = null;
                                if (etype == null || NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
                                    thumbprint = keyInformation.getB64Thumbprint();
                                } else {
                                    if (!NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
                                        String errorMes = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{etype.toString()});
                                        throw new LoginException(errorMes);
                                    }
                                    thumbprint = keyInformation.getHexThumbprint();
                                }
                                if (!tokenId.equals(thumbprint)) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6811E", new String[]{tokenId, thumbprint, x509Callback.getKeyStorePath()});
                                    throw new LoginException(errorMes);
                                }
                            } else if (isKeyName) {
                                String keyName;
                                String encTokenId = KeyInfo.X509Data.encodeDName(tokenId);
                                if (encTokenId == null) {
                                    encTokenId = tokenId;
                                }
                                if (!encTokenId.equals(keyName = keyInformation.getSubjectDN())) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6812E", new String[]{encTokenId, keyName, x509Callback.getKeyStorePath()});
                                    throw new LoginException(errorMes);
                                }
                            } else if (isX509) {
                                String issuerName;
                                String encIssuerName = KeyInfo.X509Data.encodeDName(tokenIssuerName);
                                if (encIssuerName == null) {
                                    encIssuerName = tokenIssuerName;
                                }
                                if (!encIssuerName.equals(issuerName = keyInformation.getIssuerDN())) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6813E", new String[]{encIssuerName, issuerName, x509Callback.getKeyStorePath()});
                                    throw new LoginException(errorMes);
                                }
                                String issuerSerial = keyInformation.getIssuerSerial();
                                if (!tokenIssuerSerial.equals(issuerSerial)) {
                                    String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6813E", new String[]{tokenIssuerSerial, issuerSerial, x509Callback.getKeyStorePath()});
                                    throw new LoginException(errorMes);
                                }
                            }
                            x509 = (X509Certificate)keyInformation.getCertificate();
                            if (!x509Callback.isTrustAnyCertificate()) {
                                X509ConsumeLoginModule.validateX509(x509, x509Callback);
                            }
                            if (cmanager == null) break block81;
                            try {
                                cmanager.cacheCert(tokenId, x509);
                            }
                            catch (SoapSecurityException e) {
                                Tr.processException(e, clsName + ".resolveKeyInfo", "615");
                                throw new LoginException(e.toString());
                            }
                        }
                        catch (SoapSecurityException e) {
                            Tr.processException(e, clsName + ".resolveKeyInfo", "620");
                            throw new LoginException(e.toString());
                        }
                    }
                }
                if (isAuthnEventsRequired) {
                    Map<String, Object> auditContext = wssAuditEventGenerator.setExtendedAuditData(context, "TrustAny", new Boolean(x509Callback.isTrustAnyCertificate()).toString());
                    wssAuditEventGenerator.addExtendedAuditData(auditContext, "CertDN", x509.getSubjectDN().getName());
                    wssAuditEventGenerator.addExtendedAuditData(auditContext, "CertIssuer", x509.getIssuerDN().getName());
                    wssAuditEventGenerator.addExtendedAuditData(auditContext, "KeyStore", keyInformation.toString());
                    if (wssAuditService.isVerbose()) {
                        String base64Cert = null;
                        try {
                            base64Cert = Base64.encode(x509.getEncoded());
                            wssAuditEventGenerator.addExtendedAuditData(auditContext, "X509Cert", base64Cert);
                        }
                        catch (CertificateEncodingException e) {
                            Tr.processException(e, clsName + ".validateX509", "916");
                        }
                    }
                }
                try {
                    final X509TokenImpl tempToken = x509Token;
                    final X509Certificate tempx509 = x509;
                    final byte[] tempbinary = keyInformation.getBinary();
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            tempToken.setCertificate(tempx509);
                            tempToken.setBinary(tempbinary);
                            return null;
                        }
                    });
                    x509Token.setKey(63, keyInformation.getPublicOrSecretKey());
                    x509Token.setKey(64, keyInformation.getPrivateOrSecretKey());
                }
                catch (SoapSecurityException e) {
                    Tr.processException(e, clsName + ".resolveKeyInfo", "636");
                    throw new LoginException(e.toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resolveKeyInfo, The X509Token hash value = " + x509Token.hashCode());
                }
                token = x509Token;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is the token [" + tokenId + "] stored in the Subject.");
                }
                token = existToken;
            }
        }
        if (isAuthnEventsRequired && token != null) {
            wssAuditEventGenerator.setExtendedAuditData(context, "TokenId", token.getId());
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveKeyInfo(");
            buf.append("X509TokenImpl, X509ConsumeCallback, TokenConsumerConfig, ");
            buf.append("CertCacheManager, SOAPMessageContext, String, boolean, boolean, ");
            buf.append("boolean, boolean, Map)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    private static final SecurityToken processElement(X509TokenImpl x509Token, X509ConsumeCallback x509Callback, OMElement target, TokenConsumerConfig config, CertCacheManager cmanager, MessageContext messageContext, boolean isNone, boolean isEmb, Map<Object, Object> context) throws LoginException {
        if (X509ConsumeLoginModule.tc.isEntryEnabled()) {
            buf = new StringBuffer("processElement(");
            buf.append("X509TokenImpl x509Token, X509ConsumeCallback x509Callback, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("TokenConsumerConfig config, CertCacheManager cmanager, ");
            buf.append("SOAPMessageContext messageContext, ");
            buf.append("boolean isNone[").append(isNone).append("], ");
            buf.append("boolean isEmb[").append(isEmb).append("], ");
            buf.append("Map context)");
            Tr.entry(X509ConsumeLoginModule.tc, buf.toString());
        }
        x509Token.setXML(new OMStructure(target));
        tokenId = null;
        if (isNone) {
            idattr = IdUtils.getInstance().getIdAttributeName(target);
            if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                Tr.debug(X509ConsumeLoginModule.tc, "The identifier attribute of the target element is [" + idattr + "].");
            }
            if (idattr != null) {
                tokenId = target.getAttributeValue(idattr);
            }
        } else if (isEmb) {
            tokenId = (String)context.get(Constants.WSSECURITY_KEY_EMBID);
        }
        if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
            Tr.debug(X509ConsumeLoginModule.tc, "The identifier of the token is [" + tokenId + "]");
        }
        x509Token.setId(tokenId);
        encoded = DOMUtils.getStringValue(target);
        x509 = null;
        x509binary = null;
        configHashStr = null;
        if (config != null) {
            configHashStr = Integer.valueOf(config.hashCode()).toString();
            if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                Tr.debug(X509ConsumeLoginModule.tc, "Hash code of the token config object = " + configHashStr);
            }
        }
        if (cmanager != null) {
            if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                Tr.debug(X509ConsumeLoginModule.tc, "Checking the cached X509Certificate object with the key[" + encoded + "].");
            }
            try {
                cert = cmanager.getCachedCert(encoded + configHashStr);
            }
            catch (SoapSecurityException e) {
                Tr.processException(e, X509ConsumeLoginModule.clsName + ".processElement", "723");
                throw new LoginException(e.toString());
            }
            if (cert == null) {
                if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(X509ConsumeLoginModule.tc, "There is no cached certificiate.");
                }
            } else if (cert instanceof X509Certificate) {
                x509 = (X509Certificate)cert;
                if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(X509ConsumeLoginModule.tc, "The X509Certificate [" + x509.getSubjectDN().getName() + "] was found.");
                }
                try {
                    x509binary = x509.getEncoded();
                }
                catch (CertificateEncodingException e) {
                    Tr.processException(e, X509ConsumeLoginModule.clsName + ".processElement", "738");
                    Tr.error(X509ConsumeLoginModule.tc, "security.wssecurity.WSEC0155E", e);
                    errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{e.toString()});
                    throw new LoginException(errorMes);
                }
            } else if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                buf = new StringBuffer("The certificate [");
                buf.append(cert.getClass().getName());
                buf.append("] was found, but it's not the X509Certificate object.");
                Tr.debug(X509ConsumeLoginModule.tc, buf.toString());
            }
        }
        if (x509 == null) {
            if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                Tr.debug(X509ConsumeLoginModule.tc, "Getting the X509Certificate object through the LoginModule.");
            }
            if (encoded != null) {
                x509binary = Base64.decode(encoded);
            }
            if (x509binary == null) {
                errorMes = ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s02");
                throw new LoginException(errorMes);
            }
            try {
                x509 = CertificateUtil.generateX509Certificate(x509binary, null);
            }
            catch (Exception e) {
                Tr.processException(e, X509ConsumeLoginModule.clsName + ".processElement", "772");
                Tr.error(X509ConsumeLoginModule.tc, "security.wssecurity.X509LoginModule.s01", e);
                errorMes = ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s01", new String[]{e.toString()});
                throw new LoginException(errorMes);
            }
            if (!x509Callback.isTrustAnyCertificate()) {
                X509ConsumeLoginModule.validateX509(x509, x509Callback);
            }
            if (cmanager != null) {
                try {
                    cmanager.cacheCert(encoded + configHashStr, x509);
                }
                catch (SoapSecurityException e) {
                    Tr.processException(e, X509ConsumeLoginModule.clsName + ".processElement", "787");
                    throw new LoginException(e.toString());
                }
            }
        }
        tempToken = x509Token;
        tempx509 = x509;
        tempbinary = x509binary;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                tempToken.setCertificate(tempx509);
                tempToken.setBinary(tempbinary);
                return null;
            }
        });
        wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        v0 = isAuthnEventsRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, context) != false || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context) != false;
        if (isAuthnEventsRequired) {
            auditContext = wssAuditEventGenerator.setExtendedAuditData(context, "TrustAny", new Boolean(x509Callback.isTrustAnyCertificate()).toString());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "CertDN", x509.getSubjectDN().getName());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "CertIssuer", x509.getIssuerDN().getName());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "TokenId", tokenId);
            if (wssAuditService.isVerbose()) {
                base64Cert = null;
                try {
                    base64Cert = Base64.encode(x509.getEncoded());
                    wssAuditEventGenerator.addExtendedAuditData(auditContext, "X509Cert", base64Cert);
                }
                catch (CertificateEncodingException e) {
                    Tr.processException(e, X509ConsumeLoginModule.clsName + ".validateX509", "916");
                }
            }
        }
        if (x509Callback.existKeyStore()) {
            if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                Tr.debug(X509ConsumeLoginModule.tc, "There is a keystore in the configuration.");
            }
            try {
                ksManager = KeyStoreManager.getInstance();
                keyInformation = ksManager.getKeyInformation(x509Callback.getKeyStorePath(), x509Callback.getKeyStoreType(), x509Callback.getKeyStorePassword(), x509Callback.getKeyStoreReference(), x509Callback.getAlias(), x509Callback.getKeyPassword(), x509Callback.getKeyName());
                x509_2 = (X509Certificate)keyInformation.getCertificate();
                if (!x509.equals(x509_2)) {
                    owner1 = x509 == null ? null : x509.getSubjectDN().getName();
                    owner2 = x509_2 == null ? null : x509_2.getSubjectDN().getName();
                    errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6809E", new String[]{owner1, owner2, x509Callback.getKeyStorePath()});
                    throw new LoginException(errorMes);
                }
                x509Token.setKey(63, keyInformation.getPublicOrSecretKey());
                x509Token.setKey(64, keyInformation.getPrivateOrSecretKey());
                if (!isAuthnEventsRequired) ** GOTO lbl142
                wssAuditEventGenerator.setExtendedAuditData(context, "KeyStore", keyInformation.toString());
            }
            catch (SoapSecurityException e) {
                Tr.processException(e, X509ConsumeLoginModule.clsName + ".processElement", "826");
                throw new LoginException(e.toString());
            }
        } else {
            if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
                Tr.debug(X509ConsumeLoginModule.tc, "There is NO keystore in the configuration.");
            }
            x509Token.setKey(63, x509.getPublicKey());
        }
lbl142:
        // 3 sources

        token = x509Token;
        if (X509ConsumeLoginModule.tc.isDebugEnabled()) {
            Tr.debug(X509ConsumeLoginModule.tc, "The X509Token hash value = " + x509Token.hashCode());
        }
        if (X509ConsumeLoginModule.tc.isEntryEnabled()) {
            buf = new StringBuffer("processElement(");
            buf.append("X509TokenImpl, OMElement, TokenConsumerConfig, CertCacheManager, ");
            buf.append("SOAPMessageContext, boolean, boolean, SecurityTokenManager, Map)");
            buf.append(" returns X509TokenImpl[").append(token).append("]");
            Tr.exit(X509ConsumeLoginModule.tc, buf.toString());
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void validateX509(X509Certificate x509, X509ConsumeCallback x509Callback) throws LoginException {
        Object ksManager;
        PKIXBuilderParameters pkixBuilderParams;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("validateX509(");
            buf.append("X509Certificate x509[");
            buf.append(x509 == null ? null : x509.getSubjectDN().getName()).append("], ");
            buf.append("X509ConsumeCallback x509Callback)");
            Tr.entry(tc, buf.toString());
        }
        if ((pkixBuilderParams = x509Callback.getCertPathParameter()) == null) {
            ksManager = KeyStoreManager.getInstance();
            KeyStore trustAnchor = null;
            try {
                trustAnchor = ((KeyStoreManager)ksManager).getKeyStore(x509Callback.getTrustAnchorPath(), x509Callback.getTrustAnchorType(), x509Callback.getTrustAnchorPassword(), null);
            }
            catch (SoapSecurityException e) {
                Tr.processException(e, clsName + ".validateX509", "873");
                Tr.error(tc, "security.wssecurity.X509ConsumeLoginModule.s01", new String[]{e.getMessage()});
                String errorMes = ConfigUtil.getMessage("security.wssecurity.X509ConsumeLoginModule.s01", new String[]{e.getMessage()});
                throw new LoginException(errorMes);
            }
            try {
                X509CertSelector selector = new X509CertSelector();
                pkixBuilderParams = new PKIXBuilderParameters(trustAnchor, (CertSelector)selector);
                pkixBuilderParams.setDate(null);
            }
            catch (InvalidAlgorithmParameterException e) {
                Tr.processException(e, clsName + ".validateX509", "881");
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s12", new String[]{e.getMessage()});
                String errorMes = ConfigUtil.getMessage("security.wssecurity.CommonReceiverConfig.s12", new String[]{e.getMessage()});
                throw new LoginException(errorMes);
            }
            catch (KeyStoreException e) {
                Tr.processException(e, clsName + ".validateX509", "889");
                Tr.error(tc, ".CommonReceiverConfig.s12", new String[]{e.getMessage()});
                String errorMes = ConfigUtil.getMessage("security.wssecurity.CommonReceiverConfig.s12", new String[]{e.getMessage()});
                throw new LoginException(errorMes);
            }
            List certStores = x509Callback.getCertStores();
            if (certStores != null) {
                for (CertStore certStore : certStores) {
                    pkixBuilderParams.addCertStore(certStore);
                }
            }
        } else {
            ksManager = pkixBuilderParams;
            synchronized (ksManager) {
                pkixBuilderParams = (PKIXBuilderParameters)pkixBuilderParams.clone();
            }
        }
        Provider provider = x509Callback.getProvider();
        try {
            CertificateUtil.validateX509Certificate(x509, provider, pkixBuilderParams);
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".validateX509", "916");
            throw new LoginException(e.toString());
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("validateX509(");
            buf.append("X509Certificate, X509ConsumeCallback)");
            Tr.exit(tc, buf.toString());
        }
    }
}

