/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.UNTConsumeCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSRealmFactory;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.token.WSSUserRegistryProcessor;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.UsernameTokenImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.util.Date;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class UNTConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(UNTConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UNTConsumeLoginModule.class.getName();
    private static final QName TYPE_Q = new QName("", "Type");
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.UsernameToken");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        UNTConsumeCallback untCallback = new UNTConsumeCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{untCallback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "136", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig config2 = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        boolean isForwardable = true;
        String forwardable = (String)config2.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (forwardable != null && forwardable.equalsIgnoreCase("false")) {
            isForwardable = false;
        }
        UsernameTokenImpl unToken = (UsernameTokenImpl)_tokenFactory.getToken(isForwardable);
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, unToken);
        QName vtype = config2.getType();
        if (!com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(vtype) && !com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(vtype)) {
            String errorMes = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{vtype.toString(), com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString()});
            throw new LoginException(errorMes);
        }
        unToken.setValueType(vtype);
        OMElement target = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        String tokenId = null;
        QName idattr = IdUtils.getInstance().getIdAttributeName(target);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier attribute of the target element is [" + idattr + "].");
        }
        if (idattr != null) {
            tokenId = target.getAttributeValue(idattr);
        }
        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean isAuthnEventsRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, this._context) || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, this._context);
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        SecurityToken token = null;
        boolean ret = true;
        SecurityToken existToken = this._securityTokenManager.getToken(config2, tokenId);
        if (existToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no token [" + tokenId + "] stored in the Subject.");
            }
            unToken.setId(tokenId);
            unToken.setXML(new OMStructure(target));
            int wssVersion = 0;
            Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (obj != null && obj instanceof Integer) {
                wssVersion = (Integer)obj;
            }
            String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
            String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
            String username = null;
            try {
                OMElement elem = DOMUtils.getOneElement(target, nsWsse, "Username");
                username = DOMUtils.getStringValue(elem);
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "225", this);
                throw new LoginException(e.toString());
            }
            char[] password = null;
            try {
                OMElement elem = DOMUtils.getZeroOrOneElement(target, nsWsse, "Password");
                if (elem != null) {
                    QName passwordType;
                    String passwordTypeStr = elem.getAttributeValue(TYPE_Q);
                    if (ConfigUtil.hasValue(passwordTypeStr) && !com.ibm.ws.wssecurity.common.Constants.PASSWORD_TEXT.equals(passwordType = DOMUtils.getQName(elem, passwordTypeStr, wssVersion))) {
                        String errorMes = passwordType + " was supplied, but only " + com.ibm.ws.wssecurity.common.Constants.PASSWORD_TEXT + " is supported.";
                        throw new LoginException(errorMes);
                    }
                    String passwordStr = DOMUtils.getStringValue(elem);
                    if (passwordStr != null) {
                        password = passwordStr.toCharArray();
                    }
                }
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "252", this);
                throw new LoginException(e.toString());
            }
            if (isAuthnEventsRequired) {
                Map<String, Object> auditContext = wssAuditEventGenerator.setExtendedAuditData(this._context, "Username", username);
                if (password != null) {
                    wssAuditEventGenerator.addExtendedAuditData(auditContext, "Password", "NON-NULL");
                } else {
                    wssAuditEventGenerator.addExtendedAuditData(auditContext, "Password", "NULL");
                }
            }
            boolean requiredNonce = untCallback.isNonce();
            boolean requiredCreatedTimestamp = untCallback.isCreatedTimestamp();
            Date created = null;
            try {
                NonceManager nmanager = (NonceManager)this._context.get(NonceManager.class);
                created = this.checkNonce(target, config2, nsWsse, nsWsu, requiredNonce, requiredCreatedTimestamp, nmanager);
            }
            catch (SoapSecurityException e1) {
                if (isAuthnEventsRequired) {
                    wssAuditEventGenerator.setAuditOutcomeReasonCode(this._context, WSSAuditService.WSSAuditReason.TOKEN_EXPIRED);
                }
                throw new LoginException(e1.getMessage());
            }
            unToken.setCreatedTime(created);
            if (username != null && username.length() > 0) {
                if (password != null && password.length > 0) {
                    boolean checkRegistry = WSSUserRegistryProcessor.checkRegistry(username, password);
                    if (!checkRegistry) {
                        String errorMes = ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s01", new String[]{username, "WSSUserRegistryProcessor.checkRegistry()=" + checkRegistry});
                        throw new LoginException(errorMes);
                    }
                } else {
                    if (!untCallback.isUsingIdentityAssertion()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No password, not UNT Identity Assertion Consumer");
                        }
                        String errorMes = ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s01", new String[]{username, "password is null"});
                        throw new LoginException(errorMes);
                    }
                    if (!untCallback.isUsingTrustedRealm()) {
                        boolean checkUsername = WSSUserRegistryProcessor.checkUsername(username);
                        if (!checkUsername) {
                            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s02", new String[]{username, "WSSUserRegistryProcessor.checkUsername()=" + checkUsername}));
                        }
                    } else {
                        try {
                            if (!WSSRealmFactory.getInstance().isUserFromTrustedRealm(username)) {
                                String errorMsg = ConfigUtil.getMessage("security.wssecurity.WSWSSLoginModule.s02", new String[]{username});
                                throw new LoginException(errorMsg);
                            }
                        }
                        catch (SoapSecurityException se) {
                            throw new LoginException(se.getMessage());
                        }
                    }
                }
                unToken.setUsername(username);
                unToken.setPassword(password);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no username...");
                }
                ret = false;
            }
            token = unToken;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is the token [" + tokenId + "] stored in the Subject.");
            }
            token = existToken;
        }
        if (isAuthnEventsRequired) {
            wssAuditEventGenerator.setExtendedAuditData(this._context, "TokenId", token.getId());
        }
        this._token = token;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return ret;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private Date checkNonce(OMElement target, TokenConsumerConfig config2, String nsWsse, String nsWsu, boolean requiredNonce, boolean requiredCreatedTimestamp, NonceManager nmanager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkNonce(");
            buf.append("Element target[").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("TokenConsumerConfig config, ");
            buf.append("String nsWsse[").append(nsWsse).append("], ");
            buf.append("String nsWsu[").append(nsWsu).append("], ");
            buf.append("boolean requiredNonce[").append(requiredNonce).append("], ");
            buf.append("boolean requiredCreatedTimestamp[").append(requiredCreatedTimestamp).append("], ");
            buf.append("NonceManager nmanager)");
            Tr.entry(tc, buf.toString());
        }
        Map<Object, Object> p = config2.getProperties();
        int nonceMaxAge = -1;
        Object obj = p.get(Constants.WSSECURITY_NONCE_MAX_AGE);
        if (obj != null && obj instanceof Integer) {
            nonceMaxAge = (Integer)obj;
        }
        int nonceClockSkew = -1;
        obj = p.get(Constants.WSSECURITY_NONCE_CLOCK_SKEW);
        if (obj != null && obj instanceof Long) {
            nonceClockSkew = (Integer)obj;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nonceMaxAge is [" + nonceMaxAge + "].");
            Tr.debug(tc, "nonceClockSkew is [" + nonceClockSkew + "].");
        }
        Date created = null;
        if (requiredCreatedTimestamp) {
            OMElement createdElem = DOMUtils.getChildElement(target, nsWsu, "Created");
            created = NonceUtil.checkNonceTimestamp(createdElem, nsWsu, nonceMaxAge, nonceClockSkew);
        }
        if (requiredNonce) {
            OMElement nonce = DOMUtils.getChildElement(target, nsWsse, "Nonce");
            NonceUtil.checkNonce(nonce, nsWsse, nmanager);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkNonce(");
            buf.append("Element, TokenConsumerConfig, String, String, ");
            buf.append("boolean, boolean, NonceManager nmanager)");
            buf.append(" returns Date [").append(created).append("]");
            Tr.exit(tc, buf.toString());
        }
        return created;
    }
}

