/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class TokenFactoryFactory {
    private static final TraceComponent tc = Tr.register(TokenFactoryFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

    public static TokenFactory getTokenFactory(String className) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TokenFactory = " + className);
        }
        TokenFactory _tokenFactory = null;
        final String classname = className;
        try {
            _tokenFactory = (TokenFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl != null) {
                        return cl.loadClass(classname).newInstance();
                    }
                    return Class.forName(classname).newInstance();
                }
            });
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new RuntimeException(e.getMessage());
        }
        return _tokenFactory;
    }
}

