/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.io.ObjectOutputInputUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;

public class TGTAuthToken
implements CacheableToken {
    private static final long serialVersionUID = 1L;
    private static final String VERSION_NUMBER = "1.0";
    protected String identifier = null;
    protected KerberosTicket tgt = null;
    public static final String TGT_PREFIX = "krbtgt";

    public TGTAuthToken() {
    }

    public TGTAuthToken(HashMap map, String client) {
        Subject kerberosSubject = (Subject)map.get("contextSubject");
        this.tgt = TGTAuthToken.extractTgt(map, client);
    }

    public KerberosTicket getTGT() {
        return this.tgt;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String version = ObjectOutputInputUtil.readUTF(in, "TGTToken.version");
        if (VERSION_NUMBER.equals(version)) {
            this.identifier = ObjectOutputInputUtil.readUTF(in, "TGTToken.identifier");
            Object tmp = ObjectOutputInputUtil.readObject(in, "TGTToken.tgt");
            if (tmp != null) {
                this.tgt = (KerberosTicket)tmp;
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        ObjectOutputInputUtil.writeUTF(out, VERSION_NUMBER, "TGTToken.version");
        ObjectOutputInputUtil.writeUTF(out, this.identifier, "TGTToken.identifier");
        ObjectOutputInputUtil.writeObject(out, this.tgt, "TGTToken.tgt");
    }

    private static KerberosTicket extractTgt(HashMap map, String clientName) {
        final Subject subj = (Subject)map.get("contextSubject");
        KerberosTicket krbCred = null;
        if (subj != null) {
            krbCred = (KerberosTicket)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (KerberosTicket entry : subj.getPrivateCredentials(KerberosTicket.class)) {
                        KerberosTicket krb = entry;
                        String svrName = krb.getServer().getName();
                        if (!svrName.startsWith(TGTAuthToken.TGT_PREFIX)) continue;
                        return krb;
                    }
                    return null;
                }
            });
        }
        return krbCred;
    }
}

