/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.KRB5TokenCacheUtil;
import com.ibm.ws.wssecurity.util.KRB5Util;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ObjectOutputInputUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Date;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.xml.namespace.QName;

public class TGSAuthToken
extends SecurityTokenImpl
implements CacheableToken,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final String VERSION_NUMBER = "1.0";
    private static final TraceComponent tc = Tr.register(TGSAuthToken.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected String identifier = null;
    protected KerberosTicket tgs = null;
    protected KerberosTicket tgt = null;
    protected String spn = null;
    protected String apreqSha1 = null;
    protected byte[] secreteBytes = null;
    protected String client = null;
    protected String realm = null;
    protected Date tgsExpirationTime = null;
    protected Date tgtExpirationTime = null;
    protected byte[] tokenBytes = null;
    protected HashMap credTable = new HashMap();
    private static final SecurityPermission ACCESS_KRB5TKT_PERM = new SecurityPermission("wsspi.KRB5Token.accessTKT");
    private static final SecurityPermission ACCESS_SESSIONKEY_PERM = new SecurityPermission("wsspi.KRB5Token.accessSessionKey");
    public static final String TGSAuthToken_version = "TGSAuthToken.version";
    public static final String TGSAuthToken_identifier = "TGSAuthToken.identifier";
    public static final String TGSAuthToken_spn = "TGSAuthToken.spn";
    public static final String TGSAuthToken_tgs = "TGSAuthToken.tgs";
    public static final String TGSAuthToken_tgt = "TGSAuthToken.tgt";
    public static final String TGSAuthToken_valueType = "TGSAuthToken.valueType";
    public static final String TGSAuthToken_secreteBytes = "TGSAuthToken.secreteBytes";
    public static final String TGSAuthToken_apreqSha1 = "TGSAuthToken.apreqSha1";
    public static final String TGSAuthToken_client = "TGSAuthToken.client";
    public static final String TGSAuthToken_tgtExpirationTime = "TGSAuthToken.tgtExpirationTime";
    public static final String TGSAuthToken_tgsExpirationTime = "TGSAuthToken.tgsExpirationTime";
    public static final String TGT_PREFIX = "krbtgt";
    private HashMap _table = new HashMap();

    public TGSAuthToken() {
    }

    public TGSAuthToken(byte[] inTokenBytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TGSAuthToken(TokenBytes)");
        }
        this.tokenBytes = inTokenBytes;
        if (this.tokenBytes != null) {
            try {
                ByteArrayInputStream bayin = new ByteArrayInputStream(this.tokenBytes);
                ObjectInputStream in = new ObjectInputStream(bayin);
                this.readExternal(in);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        this.credTable = this.copy2Table();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TGSAuthToken(TokenBytes)");
        }
    }

    public TGSAuthToken(HashMap map, String client, String spn, QName vType, String sha1) {
        this.spn = spn;
        this.valueType = vType;
        this.secreteBytes = TGSAuthToken.extractSecretBytes(map);
        this.client = client;
        if (this.client == null) {
            this.client = (String)map.get("clientName");
        }
        this.realm = (String)map.get("clientRealmName");
        this.apreqSha1 = sha1;
        this.tgsExpirationTime = new Date(System.currentTimeMillis() + 0x6DDD00L);
        this.tgtExpirationTime = new Date(System.currentTimeMillis() + 28800000L);
        this.tgt = TGSAuthToken.extractTgt(map, client);
        if (this.tgt == null) {
            this.tgt = (KerberosTicket)map.get("contextDelegatedKerberosTicket");
        }
        if (this.tgt != null) {
            this.identifier = KRB5TokenCacheUtil.getClientIdentifierForServiceTicket(this.tgt.getClient().getName(), this.tgt.getClient().getRealm(), spn);
            this.client = this.tgt.getClient().getName();
            this.realm = this.tgt.getClient().getRealm();
            this.tgtExpirationTime = this.tgt.getEndTime();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server principal =" + this.tgt.getServer().getName());
            }
        }
        this.tgs = (KerberosTicket)map.get("contextServiceTicket");
        if (this.tgs != null) {
            this.tgsExpirationTime = this.tgs.getEndTime();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server principal =" + this.tgs.getServer().getName());
            }
        } else {
            this.tgsExpirationTime = new Date((Long)map.get("tgsExpiryTime"));
        }
        if (this.client != null) {
            this.client = KRB5Util.stripOutPrincipalName(this.client);
        }
        this.principal = this.client;
        this.credTable = this.copy2Table();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TGT Ticket expiration time=" + this.tgtExpirationTime);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Service Ticket expiration time=" + this.tgsExpirationTime);
        }
    }

    public TGSAuthToken modifyTGSAuthToken(byte[] apReqKeyBytes, String apReqSha1) {
        TGSAuthToken newToken = (TGSAuthToken)this.clone();
        newToken.apreqSha1 = apReqSha1;
        newToken.secreteBytes = apReqKeyBytes;
        newToken.copy2Table();
        return newToken;
    }

    public Object clone() {
        return new TGSAuthToken(this.getTokenBytes());
    }

    private HashMap copy2Table() {
        this._table.put(TGSAuthToken_identifier, this.identifier);
        this._table.put(TGSAuthToken_spn, this.spn);
        this._table.put(TGSAuthToken_tgs, this.tgs);
        this._table.put(TGSAuthToken_tgt, this.tgt);
        this._table.put(TGSAuthToken_valueType, this.valueType);
        this._table.put(TGSAuthToken_secreteBytes, this.secreteBytes);
        this._table.put(TGSAuthToken_apreqSha1, this.apreqSha1);
        this._table.put(TGSAuthToken_client, this.client);
        this._table.put(TGSAuthToken_tgtExpirationTime, this.tgtExpirationTime);
        this._table.put(TGSAuthToken_tgsExpirationTime, this.tgsExpirationTime);
        this._table.put(KRBAuthnTokenFactory.PRINCIPAL_NAME, this.principal);
        this._table.put(KRBAuthnTokenFactory.KERBEROS_TICKET, this.tgt);
        this._table.put(KRBAuthnTokenFactory.REALM_NAME, this.realm);
        long l = this.tgtExpirationTime.getTime();
        this._table.put(KRBAuthnTokenFactory.EXPIRATION_TIME, new Long(l));
        return this._table;
    }

    public byte[] getTokenBytes() {
        try {
            ByteArrayOutputStream bayout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bayout);
            this.writeExternal(out);
            out.flush();
            out.close();
            this.tokenBytes = bayout.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.tokenBytes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Date getServiceTicketExpirationTime() {
        return this.tgsExpirationTime;
    }

    public Date getTGTExpirationTime() {
        return this.tgtExpirationTime;
    }

    public String getSHA1ofAPREQ() {
        return this.apreqSha1;
    }

    public byte[] getSecretKeyByte() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting: " + ACCESS_SESSIONKEY_PERM.toString());
            }
            sm.checkPermission(ACCESS_SESSIONKEY_PERM);
        }
        return this.secreteBytes;
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public KerberosTicket getTGS() {
        return this.tgs;
    }

    public KerberosTicket getTGT() {
        return this.tgt;
    }

    public HashMap getTGSAuthTokenAsMap() {
        return this.credTable;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        String version = ObjectOutputInputUtil.readUTF(in, TGSAuthToken_version);
        if (VERSION_NUMBER.equals(version)) {
            this.identifier = ObjectOutputInputUtil.readUTF(in, TGSAuthToken_identifier);
            this.spn = ObjectOutputInputUtil.readUTF(in, TGSAuthToken_spn);
            Object tmp = ObjectOutputInputUtil.readObject(in, TGSAuthToken_tgs);
            if (tmp != null) {
                this.tgs = (KerberosTicket)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, TGSAuthToken_tgt)) != null) {
                this.tgt = (KerberosTicket)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, TGSAuthToken_valueType)) != null) {
                this.valueType = (QName)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, TGSAuthToken_secreteBytes)) != null) {
                this.secreteBytes = (byte[])tmp;
            }
            this.apreqSha1 = ObjectOutputInputUtil.readUTF(in, TGSAuthToken_apreqSha1);
            this.client = ObjectOutputInputUtil.readUTF(in, TGSAuthToken_client);
            tmp = ObjectOutputInputUtil.readObject(in, TGSAuthToken_tgsExpirationTime);
            if (tmp != null) {
                this.tgsExpirationTime = (Date)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, TGSAuthToken_tgtExpirationTime)) != null) {
                this.tgtExpirationTime = (Date)tmp;
            }
            this.credTable = this.copy2Table();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ObjectOutputInputUtil.writeUTF(out, VERSION_NUMBER, TGSAuthToken_version);
        ObjectOutputInputUtil.writeUTF(out, this.identifier, TGSAuthToken_identifier);
        ObjectOutputInputUtil.writeUTF(out, this.spn, TGSAuthToken_spn);
        ObjectOutputInputUtil.writeObject(out, this.tgs, TGSAuthToken_tgs);
        ObjectOutputInputUtil.writeObject(out, this.tgt, TGSAuthToken_tgt);
        ObjectOutputInputUtil.writeObject(out, this.valueType, TGSAuthToken_valueType);
        ObjectOutputInputUtil.writeObject(out, this.secreteBytes, TGSAuthToken_secreteBytes);
        ObjectOutputInputUtil.writeUTF(out, this.apreqSha1, TGSAuthToken_apreqSha1);
        ObjectOutputInputUtil.writeUTF(out, this.client, TGSAuthToken_client);
        ObjectOutputInputUtil.writeObject(out, this.tgsExpirationTime, TGSAuthToken_tgsExpirationTime);
        ObjectOutputInputUtil.writeObject(out, this.tgtExpirationTime, TGSAuthToken_tgtExpirationTime);
    }

    private static byte[] extractSecretBytes(HashMap map) {
        byte[] keyfromToken = (byte[])map.get("contextSubKeyBytes");
        if (keyfromToken == null) {
            keyfromToken = (byte[])map.get("contextSessionKeyBytes");
            if (keyfromToken != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found session key of type: " + map.get("contextSessionKeyBytesType") + " from kerberos token.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found sub key of type: " + map.get("contextSubKeyBytesType") + " from kerberos token.");
        }
        return keyfromToken;
    }

    private static KerberosTicket extractTgt(HashMap map, String clientName) {
        final Subject subj = (Subject)map.get("contextSubject");
        KerberosTicket krbCred = null;
        if (subj != null) {
            krbCred = (KerberosTicket)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (KerberosTicket entry : subj.getPrivateCredentials(KerberosTicket.class)) {
                        KerberosTicket krb = entry;
                        String svrName = krb.getServer().getName();
                        if (!svrName.startsWith(TGSAuthToken.TGT_PREFIX)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Ticket name=" + svrName);
                            Tr.debug(tc, "Expiration time=" + krb.getEndTime());
                        }
                        return krb;
                    }
                    return null;
                }
            });
        }
        if (krbCred == null) {
            krbCred = (KerberosTicket)map.get("contextDelegatedKerberosTicket");
        }
        return krbCred;
    }
}

