/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTokenManagerImpl
implements SecurityTokenManager {
    private static final TraceComponent tc = Tr.register(SecurityTokenManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SecurityTokenManagerImpl.class.getName();
    private final Map<Object, Object> _context;
    private final Map<SecurityToken, SecurityTokenWrapper> _tokenMapping;

    public SecurityTokenManagerImpl(Map<Object, Object> context) {
        this._context = context;
        this._tokenMapping = new HashMap<SecurityToken, SecurityTokenWrapper>();
        this.initializeSubject();
    }

    public Map<Object, Object> getContext() {
        return this._context;
    }

    private final void initializeSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSubject()");
        }
        this._context.put("com.ibm.wsspi.wssecurity.core.securityTokenManager", this);
        Object obj = this._context.get("com.ibm.wsspi.wssecurity.core.subject");
        if (obj == null || !(obj instanceof Subject)) {
            Subject subject = new Subject();
            this._context.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSubject()");
        }
    }

    public final void integrateSubject() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integrateSubject()");
        }
        if (this._context != null) {
            MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            Subject wssSubject = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
            boolean isServer = Axis2Util.isServiceProvider(messageContext);
            if (isServer) {
                String str;
                WSSContext secContext = WSSContextFactory.getInstance();
                Subject caller = null;
                try {
                    caller = secContext.getCallerSubject(messageContext);
                }
                catch (Exception e) {
                    throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject02", e);
                }
                if (caller == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The caller subject is null.");
                    }
                } else {
                    messageContext.setProperty("com.ibm.ws.wssecurity.constants.callerSubject", caller);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stored the caller subject.");
                    }
                }
                Subject invocation = null;
                try {
                    invocation = secContext.getRunAsSubject(messageContext);
                }
                catch (Exception e) {
                    Tr.processException(e, clsName + ".finalizeSubject", "153");
                    throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject03", e);
                }
                if (invocation == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The invocation subject is null.");
                    }
                } else {
                    messageContext.setProperty("com.ibm.ws.wssecurity.constants.invocationSubject", invocation);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stored the invocation subject.");
                    }
                }
                try {
                    secContext.setCallerSubject(wssSubject, messageContext);
                }
                catch (Exception e) {
                    throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject04", e);
                }
                if (tc.isDebugEnabled()) {
                    str = wssSubject == null ? "null" : "not null";
                    Tr.debug(tc, "Replaced the caller subject [" + str + "]");
                }
                try {
                    secContext.setRunAsSubject(wssSubject, messageContext);
                }
                catch (Exception e) {
                    throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject05", e);
                }
                if (tc.isDebugEnabled()) {
                    str = wssSubject == null ? "null" : "not null";
                    Tr.debug(tc, "Replaced the invocation subject [" + str + "]");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "integrateSubject()");
        }
    }

    public final void finalizeSubject() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finalizeSubject()");
        }
        if (this._context != null) {
            this._context.remove("com.ibm.wsspi.wssecurity.core.subject");
            this._context.remove("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        }
        this._tokenMapping.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finalizeSubject()");
        }
    }

    @Override
    public final void addToken(SecurityToken token) {
        SecurityToken t;
        Collection<SecurityToken> tokens;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("addToken(");
            buf.append("SecurityToken token[").append(token).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (token != null && !(tokens = this.getTokens()).contains(t = token)) {
            final Subject subject = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subject.getPrivateCredentials().add(t);
                    return null;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(SecurityToken)");
        }
    }

    @Override
    public final SecurityToken getToken(TokenConsumerConfig tconfig, String id) {
        SecurityToken token;
        block6: {
            block5: {
                if (tc.isEntryEnabled()) {
                    StringBuffer buf = new StringBuffer("getToken(");
                    buf.append("TokenConsumerConfig tconfig, ");
                    buf.append("String id[").append(id).append("])");
                    Tr.entry(tc, buf.toString());
                }
                token = null;
                if (tconfig != null) break block5;
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Since TokenConsumerConfig is null, the runtime can't identify a token.");
                break block6;
            }
            Collection<SecurityToken> tokens = this.getTokens();
            for (SecurityToken t : tokens) {
                String tid = t.getId();
                if (tid == null || !tid.equals(id)) continue;
                SecurityTokenWrapper tw = this._tokenMapping.get(t);
                if (tw == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "One candidate (tokenId=\"" + tid + "\" found.");
                        Tr.debug(tc, "But since there is no TokenConsumerConfig corresponding to the token. the runtime just returns the token.");
                    }
                    token = t;
                    break;
                }
                if (tconfig.hashCode() != tw.getUsedTokenConsumerHash()) continue;
                token = t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenConsumerConfig, String)");
            buf.append(" returns SecurityToken [").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    @Override
    public final SecurityToken getToken(String id) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("String id[").append(id).append("])");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = null;
        Collection<SecurityToken> tokens = this.getTokens();
        for (SecurityToken t : tokens) {
            String tid = t.getId();
            if (tid == null || !tid.equals(id)) continue;
            token = t;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(String)");
            buf.append(" returns SecurityToken [").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    @Override
    public final void addTokens(Collection<SecurityToken> tokens) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("addTokens(");
            buf.append("Collection tokens[").append(tokens).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (tokens != null) {
            final Collection<SecurityToken> tws = tokens;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                    } else {
                        subject.getPrivateCredentials().addAll(tws);
                    }
                    return null;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTokens(Collection)");
        }
    }

    @Override
    public final Collection<SecurityToken> getTokens() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokens()");
        }
        Collection<SecurityToken> tokens = null;
        final Subject subject = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
        if (subject == null) {
            Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
        } else {
            tokens = AccessController.doPrivileged(new PrivilegedAction<Collection<SecurityToken>>(){

                @Override
                public Collection<SecurityToken> run() {
                    Set<SecurityToken> tokens = subject.getPrivateCredentials(SecurityToken.class);
                    return tokens;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens()");
            buf.append(" returns Collection [").append(tokens).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokens;
    }

    @Override
    public Collection<SecurityToken> getTokens(TokenGeneratorConfig tconfig) {
        Collection<SecurityTokenWrapper> tokenWrappers;
        Iterator<SecurityTokenWrapper> it;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens(");
            buf.append("TokenGeneratorConfig tconfig[").append(tconfig).append("])");
            Tr.entry(tc, buf.toString());
        }
        HashSet<SecurityToken> ts = null;
        if (tconfig != null && (it = (tokenWrappers = this.getTokenWrappers()).iterator()).hasNext()) {
            ts = new HashSet<SecurityToken>();
            while (it.hasNext()) {
                SecurityTokenWrapper tokenWrapper = it.next();
                if (tokenWrapper.getUsedTokenGeneratorHash() != tconfig.hashCode()) continue;
                ts.add(tokenWrapper.getSecurityToken());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens(TokenGeneratorConfig)");
            buf.append(" returns Collection [").append(ts).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ts;
    }

    @Override
    public Collection<SecurityToken> getTokens(TokenGeneratorConfig tconfig, String keyInfoType) {
        Collection<SecurityTokenWrapper> tokenWrappers;
        Iterator<SecurityTokenWrapper> it;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens(");
            buf.append("TokenGeneratorConfig tconfig[").append(tconfig).append("], ");
            buf.append("String keyInfoType[").append(keyInfoType).append("])");
            Tr.entry(tc, buf.toString());
        }
        HashSet<SecurityToken> ts = null;
        if (tconfig != null && (it = (tokenWrappers = this.getTokenWrappers()).iterator()).hasNext()) {
            ts = new HashSet<SecurityToken>();
            while (it.hasNext()) {
                SecurityTokenWrapper tokenWrapper = it.next();
                if (tokenWrapper.getUsedTokenGeneratorHash() != tconfig.hashCode() || !tokenWrapper.getKeyInfoType().equals(keyInfoType)) continue;
                ts.add(tokenWrapper.getSecurityToken());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens(TokenGeneratorConfig, String)");
            buf.append(" returns Collection [").append(ts).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ts;
    }

    @Override
    public Collection<SecurityToken> getTokens(TokenConsumerConfig tconfig) {
        Collection<SecurityTokenWrapper> tokenWrappers;
        Iterator<SecurityTokenWrapper> it;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens(");
            buf.append("TokenConsumerConfig tconfig[").append(tconfig).append("])");
            Tr.entry(tc, buf.toString());
        }
        HashSet<SecurityToken> ts = null;
        if (tconfig != null && (it = (tokenWrappers = this.getTokenWrappers()).iterator()).hasNext()) {
            ts = new HashSet<SecurityToken>();
            while (it.hasNext()) {
                SecurityTokenWrapper tokenWrapper = it.next();
                if (tokenWrapper.getUsedTokenConsumerHash() != tconfig.hashCode()) continue;
                ts.add(tokenWrapper.getSecurityToken());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens(TokenConsumerConfig)");
            buf.append(" returns Collection [").append(ts).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ts;
    }

    @Override
    public final Collection<SecurityToken> getTokens(String id) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens(");
            buf.append("String id[").append(id).append("])");
            Tr.entry(tc, buf.toString());
        }
        HashSet<SecurityToken> ts = null;
        Collection<SecurityToken> tokens = this.getTokens();
        Iterator<SecurityToken> it = tokens.iterator();
        if (it.hasNext()) {
            ts = new HashSet<SecurityToken>();
            while (it.hasNext()) {
                SecurityToken token = it.next();
                String tid = token.getId();
                if (tid == null || !tid.equals(id)) continue;
                ts.add(token);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokens(String)");
            buf.append(" returns Collection [").append(ts).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ts;
    }

    @Override
    public final void removeToken(SecurityToken token) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("removeToken(");
            buf.append("SecurityToken token[").append(token).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (token != null) {
            final SecurityToken t = token;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                    } else {
                        subject.getPrivateCredentials().remove(t);
                    }
                    return null;
                }
            });
            this._tokenMapping.remove(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeToken(SecurityToken)");
        }
    }

    @Override
    public final void removeTokens(Collection<SecurityToken> tokens) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("removeTokens(");
            buf.append("Set tokens[").append(tokens).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (tokens != null) {
            final Collection<SecurityToken> ts = tokens;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                    } else {
                        subject.getPrivateCredentials().removeAll(ts);
                    }
                    return null;
                }
            });
            Iterator<SecurityToken> it = ts.iterator();
            while (it.hasNext()) {
                this._tokenMapping.remove(it.next());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTokens(Collection)");
        }
    }

    @Override
    public final void removeAllTokens() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllTokens()");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    Set<SecurityToken> tokens = subject.getPrivateCredentials(SecurityToken.class);
                    subject.getPrivateCredentials().removeAll(tokens);
                }
                return null;
            }
        });
        this._tokenMapping.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllTokens()");
        }
    }

    public final void addTokenWrapper(SecurityTokenWrapper tokenWrapper) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("addTokenWrapper(");
            buf.append("SecurityTokenWrapper tokenWrapper[").append(tokenWrapper).append("])");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = tokenWrapper.getSecurityToken();
        this._tokenMapping.put(token, tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTokenWrapper(SecurityTokenWrapper)");
        }
    }

    public final SecurityTokenWrapper getTokenWrapper(SecurityToken token) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokenWrapper(");
            buf.append("SecurityToken token[").append(token).append("])");
            Tr.entry(tc, buf.toString());
        }
        SecurityTokenWrapper tokenWrapper = this._tokenMapping.get(token);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokenWrapper(");
            buf.append("SecurityToken)");
            buf.append(" returns SecurityTokenWrapper [").append(tokenWrapper).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenWrapper;
    }

    public final SecurityTokenWrapper getUnprocessedTokenWrapper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnprocessedTokenWrapper()");
        }
        SecurityTokenWrapper tokenWrapper = null;
        Collection<SecurityTokenWrapper> tokenWrappers = this._tokenMapping.values();
        for (SecurityTokenWrapper tw : tokenWrappers) {
            if (tw.isProcessed()) continue;
            tokenWrapper = tw;
            break;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getUnprocessedTokenWrapper()");
            buf.append(" returns SecurityTokenWrapper [").append(tokenWrapper).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenWrapper;
    }

    public final Collection<SecurityTokenWrapper> getTokenWrappers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenWrappers()");
        }
        Collection<SecurityTokenWrapper> tokenWrappers = this._tokenMapping.values();
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokenWrappers()");
            buf.append(" returns Collection[").append(tokenWrappers).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenWrappers;
    }

    public final Collection<SecurityTokenWrapper> getTokenWrappers(Collection<SecurityToken> tokens) {
        Iterator<SecurityToken> it;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokenWrappers(");
            buf.append("Collection tokens[").append(tokens).append("])");
            Tr.entry(tc, buf.toString());
        }
        HashSet<SecurityTokenWrapper> ts = null;
        if (tokens != null && (it = tokens.iterator()).hasNext()) {
            ts = new HashSet<SecurityTokenWrapper>();
            while (it.hasNext()) {
                SecurityToken token = it.next();
                SecurityTokenWrapper tokenWrapper = this._tokenMapping.get(token);
                if (tokenWrapper == null) continue;
                ts.add(tokenWrapper);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokenWrappers(Collection)");
            buf.append(" returns Collection [").append(ts).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ts;
    }

    public final void addTokenWrappers(Collection<SecurityTokenWrapper> tokenWrappers) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("addTokenWrappers(");
            buf.append("Collection tokenWrappers[").append(tokenWrappers).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (tokenWrappers != null) {
            final Collection<SecurityTokenWrapper> tws = tokenWrappers;
            final Map<SecurityToken, SecurityTokenWrapper> tms = this._tokenMapping;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                    } else {
                        Set<Object> set = subject.getPrivateCredentials();
                        for (SecurityTokenWrapper tokenWrapper : tws) {
                            SecurityToken token = tokenWrapper.getSecurityToken();
                            set.add(token);
                            tms.put(token, tokenWrapper);
                        }
                    }
                    return null;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTokenWrappers(Collection)");
        }
    }

    public static final String getRunAsIdentity(final MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getRunAsIdentity(");
            buf.append("MessageContext messageContext[").append(messageContext.getMessageID()).append("])");
            Tr.entry(tc, buf.toString());
        }
        String identity = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Iterator<Principal> i;
                Set<Principal> set;
                Subject subject = null;
                String ret = null;
                try {
                    WSSContext secContext = WSSContextFactory.getInstance();
                    subject = secContext.getRunAsSubject(messageContext);
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.finalizeSubject03");
                    }
                }
                catch (Exception e) {
                    Tr.processException(e, clsName + ".getRunAsIdentity", "919");
                    Tr.error(tc, "security.wssecurity.TokenManager.finalizeSubject03");
                }
                if (subject != null && (set = subject.getPrincipals()) != null && (i = set.iterator()).hasNext()) {
                    Principal principal = i.next();
                    ret = principal.getName();
                }
                return ret;
            }
        });
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getRunAsIdentity(boolean)");
            buf.append(" returns String[").append(identity).append("]");
            Tr.exit(tc, buf.toString());
        }
        return identity;
    }

    public final void addToSubject(final Subject loginSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSubject(Subject)");
        }
        final Subject subject = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Object publicObject : loginSubject.getPublicCredentials()) {
                    if (publicObject == null) continue;
                    if (!subject.getPublicCredentials().contains(publicObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding public object to Subject: " + publicObject);
                        }
                        subject.getPublicCredentials().add(publicObject);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Public object already in Subject: " + publicObject);
                }
                for (Object privateObject : loginSubject.getPrivateCredentials()) {
                    if (privateObject == null) continue;
                    if (!subject.getPrivateCredentials().contains(privateObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding private object to Subject: " + privateObject);
                        }
                        subject.getPrivateCredentials().add(privateObject);
                        continue;
                    }
                    if (privateObject instanceof SecurityToken) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "ws-sec Token private object already in Subject: " + privateObject);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Private object already in Subject: " + privateObject);
                }
                for (Principal principalObject : loginSubject.getPrincipals()) {
                    if (principalObject == null) continue;
                    if (!subject.getPrincipals().contains(principalObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding principal object to Subject: " + principalObject);
                        }
                        subject.getPrincipals().add(principalObject);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Principal object already in Subject: " + principalObject);
                }
                return null;
            }
        });
        this._context.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSubject(Subject)");
        }
    }

    @Override
    public final Collection<SecurityToken> getTokensByKeyInfo(String keyInfoName) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokenByKeyInfo(");
            buf.append("String id[").append(keyInfoName).append("])");
            Tr.entry(tc, buf.toString());
        }
        if (keyInfoName == null) {
            return null;
        }
        HashSet<SecurityToken> ts = null;
        Collection<SecurityTokenWrapper> tokenWrappers = this.getTokenWrappers();
        Iterator<SecurityTokenWrapper> it = tokenWrappers.iterator();
        if (it != null && it.hasNext()) {
            ts = new HashSet<SecurityToken>();
            while (it.hasNext()) {
                SecurityTokenWrapper tokenWrapper = it.next();
                if (!keyInfoName.equals(tokenWrapper.getKeyInfoUniqueID())) continue;
                ts.add(tokenWrapper.getSecurityToken());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getTokenByKeyInfo(String)");
            buf.append(" returns SecurityToken [").append(ts).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ts;
    }
}

