/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallbackHandler;
import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.SCAndTrustConstants;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.sc.SecureConversationImpl;
import com.ibm.ws.wssecurity.trust.client.ITrustClient;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.client.impl.TrustClientFactory;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSNonceGenerator;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT13;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.spi.BindingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTWrapper
extends SCT {
    private static final TraceComponent tc = Tr.register(SCTWrapper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = SCTWrapper.class.getName();
    private static final long serialVersionUID = -3367052060192133610L;
    private SCT sctReference = null;
    private String currentInstance = null;
    private BindingProvider bindingProvider = null;
    private static final String comp = "security.wssecurity";
    private SecurityTokenManagerImpl securityTokenManager = null;

    public SCTWrapper() {
    }

    public SCTWrapper(String uuid, SCT.KeyHistoryEntry[] entries, String id, String instance) {
        super(uuid, entries);
        this.id = id;
        this.currentInstance = instance;
    }

    public SCT getSCT() {
        return this.sctReference;
    }

    public void setSCT(SCT sct) {
        if (!this.readOnly) {
            this.sctReference = sct;
            this.valueType = sct.getValueType();
        }
    }

    public String getCurrentInstance() {
        return this.currentInstance;
    }

    public void setCurrentInstance(String curInstance) {
        if (!this.readOnly) {
            this.currentInstance = curInstance;
        }
    }

    @Override
    public void renew() throws WSSException {
        this.renew(this.getSCT().getWssGenerationContext(), this.getSCT().getWssConsumingContext());
    }

    @Override
    public void renew(WSSGenerationContext gencont, WSSConsumingContext concont) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renew in SCTWrapper (WSSGenerateionContext gencont, WSSConsumingContext concont)");
        }
        SCT sct = this.getSCT();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT config map = " + sct.getMap());
            Tr.debug(tc, "Current SCT information, SCT UUID = " + sct.getUUID());
            Tr.debug(tc, "SCTWrapper, Current Instance = " + this.currentInstance);
            Tr.debug(tc, "SCT ID = " + this.id);
            Tr.debug(tc, "SCT element = " + DOMUtils.toString(((OMStructure)this.xml).getNode()));
            String[] list = this.getInstances();
            for (int i = 0; i < list.length; ++i) {
                Tr.debug(tc, "SCT Instance [" + i + "]" + " = " + list[i]);
            }
        }
        if (!sct.isValid(this.currentInstance, 0L) && !sct.isRenewableAfterExpiration()) {
            throw WSSException.format("security.wssecurity.WSEC7072E");
        }
        sct.setWssGenerationContext(gencont);
        sct.setWssConsumingContext(concont);
        Map map = sct.getMap();
        Map CachedCfg = (Map)map.get("STSCONFIGURATION");
        ITrustRequestSecurityTokenTemplate cachedTemp = (ITrustRequestSecurityTokenTemplate)map.get("RSTTEMPLATE");
        ConfigurationContext configurationContext = (ConfigurationContext)map.get("CONFIG_CONTEXT");
        String tolerateWSFPTrustRequest = (String)CachedCfg.get("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages");
        String trustLevel = (String)CachedCfg.get("TRUST_LEVEL");
        String tokenType = (String)CachedCfg.get("TokenType");
        String keySizeStr = (String)CachedCfg.get("KeySize");
        String wsa_ns = (String)CachedCfg.get("ADDRESSING_LEVEL");
        int keylength = new Integer(keySizeStr);
        String serviceEndpointAddress = (String)CachedCfg.get("MESSAGE_TO");
        String reqType = null;
        String msgAction = null;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[1][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[1][1];
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[5][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[5][1];
        }
        ITrustClient client10 = null;
        try {
            client10 = TrustClientFactory.getTrustClient(trustLevel);
        }
        catch (TrustException e) {
            Tr.processException((Throwable)e, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", e);
        }
        ITrustRequestSecurityTokenTemplate rstt = client10.getSTSRequestSecurityTokenTemplate();
        rstt.setWSANamespace(wsa_ns);
        rstt.addTokenType(tokenType);
        rstt.addRequestType(reqType);
        rstt.addKeySize(keySizeStr);
        byte[] clientSecret = WSSNonceGenerator.generateBytes(keylength * 8);
        rstt.addEntropyNonce(Base64.encode(clientSecret));
        rstt.setTo(serviceEndpointAddress);
        rstt.setAction(msgAction);
        String mid = SecurityUIDGenerator.createUID();
        rstt.setMessageID(mid);
        rstt.addRenewTarget(((OMStructure)this.xml).getNode());
        HashMap<String, String> stsConfig = new HashMap<String, String>();
        stsConfig.putAll(CachedCfg);
        stsConfig.put("MESSAGE_ID", mid);
        stsConfig.put("MESSAGE_ACTION", msgAction);
        ServiceClient client = null;
        try {
            HashMap<String, Object> parms = new HashMap<String, Object>();
            parms.put("STSCONFIGURATION", stsConfig);
            parms.put("RSTTEMPLATE", rstt);
            HashMap<String, Object> innerMap = new HashMap<String, Object>();
            if (tolerateWSFPTrustRequest != null) {
                stsConfig.put("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPTrustRequest);
            }
            innerMap.put("com.ibm.ws.wssecurity.constants.wssapi.key.generator", gencont);
            innerMap.put("com.ibm.ws.wssecurity.constants.wssapi.key.consumer", concont);
            parms.put("AXIS2_MESSAGECONTEXT_PROPERTYMAP", innerMap);
            configurationContext = this.getConfigurationContext(serviceEndpointAddress);
            parms.put("CONFIG_CONTEXT", configurationContext);
            HashMap<String, Object> cachedMap = new HashMap<String, Object>();
            cachedMap.putAll(parms);
            ITrustRequestSecurityToken rst = client10.createRequestSecurityToken(rstt, parms);
            AxisService axService = rst.getAxisService();
            if (axService != null) {
                axService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            client = rst.getServiceClient();
            gencont.process(client);
            concont.process(client);
            byte[] serverSecret = null;
            String uuid = null;
            String instance = null;
            Object created = null;
            Object expires = null;
            Date createdDate = null;
            Date expiresDate = null;
            String renewable = "true";
            String renewableAfterExpiration = "false";
            ITrustRequestSecurityTokenResponseCollection rstrc = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Renew request.");
            }
            rstrc = client10.renew(rst);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client Renew is successful.");
            }
            OMElement securityContextTokenElement = null;
            Iterator<ITrustRequestSecurityTokenResponse> iter = rstrc.getRSTRCollection();
            if (iter.hasNext()) {
                ITrustRequestSecurityTokenResponse rstr = iter.next();
                securityContextTokenElement = rstr.getSecurityContextTokenElement();
                uuid = rstr.getUUID();
                instance = rstr.getInstance();
                serverSecret = rstr.getServerSecretBytes();
                createdDate = rstr.getCreatedDate();
                expiresDate = rstr.getExpiresDate();
                Integer size = rstr.getKeySize();
                if (size != null) {
                    keylength = size;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + keylength);
                    }
                }
                renewable = rstr.getRenewable();
                renewableAfterExpiration = rstr.getRenewableAfterExpiration();
            }
            SCT.KeyHistoryEntry token = new SCT.KeyHistoryEntry(instance, clientSecret, serverSecret, createdDate, expiresDate, SCT.SCTState.RENEWED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + uuid + ", id = " + this.id + ", created = " + createdDate.toString() + ", expires = " + expiresDate.toString() + ", and instance = " + instance + ", serverSecret = " + Base64.encode(serverSecret) + ", clientEntropy = " + Base64.encode(clientSecret));
            }
            if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
                SCT13 sctoken13 = new SCT13(uuid);
                sct = sctoken13;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Value Type = " + sct.getValueType().getLocalPart());
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
                sct = new SCT(uuid);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Value Type = " + sct.getValueType().getLocalPart());
                }
            }
            sct.setUUID(uuid);
            sct.setId(this.id);
            if (this.getSCT() != null) {
                String[] list = this.getSCT().getInstances();
                for (int i = 0; i < list.length; ++i) {
                    sct.setKeyHistoryEntry(this.getSCT().getKeyHistoryEntry(list[i]));
                }
            }
            sct.setKeyHistoryEntry(token);
            sct.setTokenID(this.id);
            sct.setReferenceURI("#" + this.id);
            sct.setClientID(uuid);
            sct.setMap(map);
            sct.setUsedForSigAndEnc(true);
            sct.setWssConsumingContext(concont);
            sct.setWssGenerationContext(gencont);
            sct.setKeySize(keylength);
            sct.setXML(new OMStructure(securityContextTokenElement));
            sct.setRenewable(Boolean.valueOf(renewable));
            sct.setRenewableAfterExpiration(Boolean.valueOf(renewableAfterExpiration));
            this.setUUID(uuid);
            this.setKeyHistoryEntry(token);
            this.xml = new OMStructure(securityContextTokenElement);
            this.currentInstance = instance;
            this.setSCT(sct);
            this.setWssGenerationContext(gencont);
            this.setWssConsumingContext(concont);
            this.setMap(map);
            SecureConversationCacheHelper.setSecurityContextTokenToCache(uuid, null, sct, null);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", e);
        }
        catch (Throwable e) {
            Tr.processException(e, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, renew(WSSGenerateionContext gencont, WSSConsumingContext concont) return");
        }
    }

    public DerivedKeyToken getDerivedKeyToken() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getDerivedKeyToken()");
        }
        SCT sct = this.getSCT();
        Map<String, Object> signatureAlgoMap = this.getKeyAlgorithm(DefaultValueManager.getInstance().getDefaultSignatureAlgorithm());
        Map<String, Object> encryptionAlgoMap = this.getKeyAlgorithm(DefaultValueManager.getInstance().getDefaultEncryptionAlgorithm());
        SCTGenerateCallbackHandler cb = new SCTGenerateCallbackHandler(this, sct.getWssGenerationContext(), sct.getWssConsumingContext(), (String)signatureAlgoMap.get("algorithm"), (Integer)signatureAlgoMap.get("keyLength"), (String)encryptionAlgoMap.get("algorithm"), (Integer)encryptionAlgoMap.get("keyLength"), "Default", "Default");
        DKToken dktoken = new DKToken();
        dktoken.setrefTokenId(this.id);
        dktoken.setDerivableSecurityToken(this);
        SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper((SecurityToken)dktoken, (CallbackHandler)cb, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getDerivedKeyToken() return");
        }
        return dktoken;
    }

    public DerivedKeyToken getDerivedKeyToken(String algorithm) throws WSSException {
        return this.getDerivedKeyToken(algorithm, "Default", "Default");
    }

    @Override
    public DerivedKeyToken getDerivedKeyToken(String algorithm, String clientLabel, String serviceLabel) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getDerivedKeyToken( " + algorithm + ", " + clientLabel + ", " + serviceLabel + ")");
        }
        if (clientLabel == null) {
            clientLabel = "Default";
        }
        if (serviceLabel == null) {
            serviceLabel = "Default";
        }
        SCT sct = this.getSCT();
        Map<String, Object> algoMap = this.getKeyAlgorithm(algorithm);
        SCTGenerateCallbackHandler cb = null;
        cb = (Boolean)algoMap.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, sct.getWssGenerationContext(), sct.getWssConsumingContext(), (String)algoMap.get("algorithm"), (Integer)algoMap.get("keyLength"), null, 0, clientLabel, serviceLabel) : new SCTGenerateCallbackHandler(this, sct.getWssGenerationContext(), sct.getWssConsumingContext(), null, 0, (String)algoMap.get("algorithm"), (Integer)algoMap.get("keyLength"), clientLabel, serviceLabel);
        DKToken dktoken = new DKToken();
        dktoken.setrefTokenId(this.id);
        dktoken.setDerivableSecurityToken(this);
        SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper((SecurityToken)dktoken, (CallbackHandler)cb, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getDerivedKeyToken(String, String )");
        }
        return dktoken;
    }

    public DerivedKeyToken getDerivedKeyToken(String algorithm, int keylen) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getDerivedKeyToken( " + algorithm + ", " + keylen + ")");
        }
        Map<String, Object> algoMap = this.getKeyAlgorithm(algorithm);
        SCTGenerateCallbackHandler cb = null;
        SCT sct = this.getSCT();
        cb = (Boolean)algoMap.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, sct.getWssGenerationContext(), sct.getWssConsumingContext(), (String)algoMap.get("algorithm"), keylen, null, 0, "Default", "Defalut") : new SCTGenerateCallbackHandler(this, sct.getWssGenerationContext(), sct.getWssConsumingContext(), null, 0, (String)algoMap.get("algorithm"), keylen, "Default", "Defalut");
        DKToken dktoken = new DKToken();
        dktoken.setrefTokenId(this.id);
        dktoken.setDerivableSecurityToken(this);
        SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper((SecurityToken)dktoken, (CallbackHandler)cb, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getDerivedKeyToken(String, int)");
        }
        return dktoken;
    }

    @Override
    public DerivedKeyToken getDerivedKeyToken(String algorithm, int keylen, String clientLabel, String serviceLabel) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getDerivedKeyToken( " + algorithm + ", " + keylen + " , " + clientLabel + " , " + serviceLabel + ")");
        }
        if (clientLabel == null) {
            clientLabel = "Default";
        }
        if (serviceLabel == null) {
            serviceLabel = "Default";
        }
        SCT sct = this.getSCT();
        Map<String, Object> algoMap = this.getKeyAlgorithm(algorithm);
        SCTGenerateCallbackHandler cb = null;
        cb = (Boolean)algoMap.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, sct.getWssGenerationContext(), sct.getWssConsumingContext(), (String)algoMap.get("algorithm"), keylen, null, 0, clientLabel, serviceLabel) : new SCTGenerateCallbackHandler(this, sct.getWssGenerationContext(), sct.getWssConsumingContext(), null, 0, (String)algoMap.get("algorithm"), keylen, clientLabel, serviceLabel);
        DKToken dktoken = new DKToken();
        dktoken.setrefTokenId(this.id);
        dktoken.setDerivableSecurityToken(this);
        SecurityTokenWrapper tokenWrapper = new SecurityTokenWrapper((SecurityToken)dktoken, (CallbackHandler)cb, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getDerivedKeyToken(String, int, String)");
        }
        return dktoken;
    }

    private Map<String, Object> getKeyAlgorithm(String algName) {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getKeyAlgorithm(String algName): algName=" + algName);
        }
        if ((map = DefaultValueManager.getInstance().getSignatureAlgorithmMap().get(algName)) != null) {
            map.put("isSignature", Boolean.TRUE);
        }
        if (map == null && (map = DefaultValueManager.getInstance().getEncryptionAlgorithmMap().get(algName)) != null) {
            map.put("isSignature", Boolean.FALSE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getKeyAlgorithm(String algName, int keyBytesLength) returns map" + map);
        }
        return map;
    }

    @Override
    public void cancel() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, cancel()");
        }
        final SCT sct = this.getSCT();
        final BindingProvider bp = this.getBindingProvider();
        if (bp != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws WSSException {
                        SCTWrapper.this.cancel(bp);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (WSSException)e.getException();
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSException {
                    sct.cancel();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (WSSException)e.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, cancel()");
        }
    }

    @Override
    public void cancel(WSSGenerationContext gencont, WSSConsumingContext concont) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont)");
        }
        SCT sct = this.getSCT();
        final WSSGenerationContext g = gencont;
        final WSSConsumingContext c = concont;
        final BindingProvider bp = this.getBindingProvider();
        if (bp != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws WSSException {
                        SCTWrapper.this.cancel(bp);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (WSSException)e.getException();
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSException {
                    SCTWrapper.this.cancelSCT(g, c);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (WSSException)e.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont) return");
        }
    }

    private void cancel(BindingProvider bp) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancel(BindingProvider bp)");
        }
        EndpointDescription endpointDesc = bp.getEndpointDescription();
        AxisService aService = null;
        if (endpointDesc != null) {
            aService = endpointDesc.getAxisService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AxisService from the binding provider = " + aService);
            }
        }
        try {
            this.cancel(aService);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT cancel is done");
            }
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".cancel", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7067E", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel(BindingProvider bp)");
        }
    }

    private void cancel(AxisService aService) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelSCT(AxisService aService)");
        }
        SCT sctoken = null;
        Parameter par = aService.getParameter(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
        if (par != null) {
            String clientId = (String)par.getValue();
            sctoken = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(clientId);
        }
        if (sctoken.isCancelled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SecurityContextToken is already cancelled.");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cancel SCT using Policy Set");
        }
        try {
            SecureConversationImpl.cancelSCT(aService);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".cancel", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7067E", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelSCT(AxisService aService)");
        }
    }

    public void cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont)");
        }
        SCT sct = this.getSCT();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT config map = " + sct.getMap());
            Tr.debug(tc, "Current SCT information, SCT UUID = " + sct.getUUID());
            Tr.debug(tc, "SCTWrapper, Current Instance = " + this.currentInstance);
            Tr.debug(tc, "SCT ID = " + this.id);
            Tr.debug(tc, "SCT element = " + DOMUtils.toString(((OMStructure)this.xml).getNode()));
            String[] list = this.getInstances();
            for (int i = 0; i < list.length; ++i) {
                Tr.debug(tc, "SCT Instance [" + i + "]" + " = " + list[i]);
            }
        }
        if (!sct.isValid(this.currentInstance, 0L) && !sct.isRenewableAfterExpiration()) {
            throw WSSException.format("security.wssecurity.WSEC7072E");
        }
        sct.setWssGenerationContext(gencont);
        sct.setWssConsumingContext(concont);
        String uuid = sct.getIdentifier();
        Map map = sct.getMap();
        Map CachedCfg = (Map)map.get("STSCONFIGURATION");
        ITrustRequestSecurityTokenTemplate cachedTemp = (ITrustRequestSecurityTokenTemplate)map.get("RSTTEMPLATE");
        String trustLevel = (String)CachedCfg.get("TRUST_LEVEL");
        String tokenType = (String)CachedCfg.get("TokenType");
        String serviceEndpointAddress = (String)CachedCfg.get("MESSAGE_TO");
        String wsa_ns = (String)CachedCfg.get("ADDRESSING_LEVEL");
        String tolerateWSFPTrustRequest = (String)CachedCfg.get("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages");
        String reqType = null;
        String msgAction = null;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[2][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[2][1];
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[6][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[6][1];
        }
        ITrustClient client10 = null;
        try {
            client10 = TrustClientFactory.getTrustClient(trustLevel);
        }
        catch (TrustException e) {
            Tr.processException((Throwable)e, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", e);
        }
        ITrustRequestSecurityTokenTemplate rstt = client10.getSTSRequestSecurityTokenTemplate();
        rstt.setWSANamespace(wsa_ns);
        rstt.addTokenType(tokenType);
        rstt.addRequestType(reqType);
        rstt.setTo(serviceEndpointAddress);
        rstt.setAction(msgAction);
        String mid = SecurityUIDGenerator.createUID();
        rstt.setMessageID(mid);
        rstt.addCancelTarget(((OMStructure)this.xml).getNode());
        HashMap<String, String> stsConfig = new HashMap<String, String>();
        stsConfig.putAll(CachedCfg);
        stsConfig.put("MESSAGE_ID", mid);
        stsConfig.put("MESSAGE_ACTION", msgAction);
        if (tolerateWSFPTrustRequest != null) {
            stsConfig.put("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPTrustRequest);
        }
        ServiceClient client = null;
        try {
            HashMap<String, Object> parms = new HashMap<String, Object>();
            parms.put("STSCONFIGURATION", stsConfig);
            parms.put("RSTTEMPLATE", rstt);
            HashMap<String, Object> innerMap = new HashMap<String, Object>();
            innerMap.put("com.ibm.ws.wssecurity.sc.SCT.Cancel", new Boolean(true));
            innerMap.put("com.ibm.ws.wssecurity.constants.wssapi.key.generator", gencont);
            innerMap.put("com.ibm.ws.wssecurity.constants.wssapi.key.consumer", concont);
            parms.put("AXIS2_MESSAGECONTEXT_PROPERTYMAP", innerMap);
            ConfigurationContext configurationContext = this.getConfigurationContext(serviceEndpointAddress);
            parms.put("CONFIG_CONTEXT", configurationContext);
            HashMap<String, Object> cachedMap = new HashMap<String, Object>();
            cachedMap.putAll(parms);
            ITrustRequestSecurityToken rst = client10.createRequestSecurityToken(rstt, parms);
            AxisService axService = rst.getAxisService();
            if (axService != null) {
                axService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            client = rst.getServiceClient();
            gencont.process(client);
            concont.process(client);
            ITrustRequestSecurityTokenResponseCollection rstrc = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Cancel request.");
            }
            rstrc = client10.cancel(rst);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client Cancel is successful.");
            }
            Iterator<ITrustRequestSecurityTokenResponse> iterCancel = rstrc.getRSTRCollection();
            while (iterCancel.hasNext()) {
                Boolean isCancel;
                ITrustRequestSecurityTokenResponse rstr = iterCancel.next();
                OMElement elem = rstr.getRequestedTokenCancelledElement();
                if (elem != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cancel Element:" + ((Object)elem).toString());
                }
                if ((isCancel = rstr.isTokenCancelled()) == null || !isCancel.booleanValue()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Successfully Cancelled");
                }
                SecureConversationCacheHelper.invalidateCache(sct.getIdentifier());
                sct.setCancelState();
            }
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".cancelSCT", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7068E", e);
        }
        catch (Throwable e) {
            Tr.processException(e, clsName + ".cancelSCT", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7068E", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont) return");
        }
    }

    @Override
    public boolean validate() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
            Tr.exit(tc, "validate()");
        }
        return this.validate(this.getSCT().getWssGenerationContext(), this.getSCT().getWssConsumingContext());
    }

    @Override
    public boolean validate(WSSGenerationContext gencont, WSSConsumingContext concont) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate(WSSGenerateionContext gencont, WSSConsumingContext concont)");
        }
        SCT sct = this.getSCT();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT config map = " + sct.getMap());
            Tr.debug(tc, "Current SCT information, SCT UUID = " + sct.getUUID());
            Tr.debug(tc, "SCTWrapper, Current Instance = " + this.currentInstance);
            Tr.debug(tc, "SCT ID = " + this.id);
            Tr.debug(tc, "SCT element = " + DOMUtils.toString(((OMStructure)this.xml).getNode()));
            String[] list = this.getInstances();
            for (int i = 0; i < list.length; ++i) {
                Tr.debug(tc, "SCT Instance [" + i + "]" + " = " + list[i]);
            }
        }
        if (!sct.isValid(this.currentInstance, 0L) && !sct.isRenewableAfterExpiration()) {
            throw WSSException.format("security.wssecurity.WSEC7072E");
        }
        sct.setWssGenerationContext(gencont);
        sct.setWssConsumingContext(concont);
        Map map = sct.getMap();
        Map CachedCfg = (Map)map.get("STSCONFIGURATION");
        ITrustRequestSecurityTokenTemplate cachedTemp = (ITrustRequestSecurityTokenTemplate)map.get("RSTTEMPLATE");
        String trustLevel = (String)CachedCfg.get("TRUST_LEVEL");
        String tokenType = (String)CachedCfg.get("TokenType");
        String serviceEndpointAddress = (String)CachedCfg.get("MESSAGE_TO");
        String wsa_ns = (String)CachedCfg.get("ADDRESSING_LEVEL");
        String tolerateWSFPTrustRequest = (String)CachedCfg.get("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages");
        String reqType = null;
        String msgAction = null;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[3][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[3][1];
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[7][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[7][1];
        }
        ITrustClient client10 = null;
        try {
            client10 = TrustClientFactory.getTrustClient(trustLevel);
        }
        catch (TrustException e) {
            Tr.processException((Throwable)e, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", e);
        }
        ITrustRequestSecurityTokenTemplate rstt = client10.getSTSRequestSecurityTokenTemplate();
        rstt.setWSANamespace(wsa_ns);
        rstt.addTokenType(tokenType);
        rstt.addRequestType(reqType);
        rstt.setTo(serviceEndpointAddress);
        rstt.setAction(msgAction);
        String mid = SecurityUIDGenerator.createUID();
        rstt.setMessageID(mid);
        rstt.addValidateTarget(((OMStructure)this.xml).getNode());
        HashMap<String, String> stsConfig = new HashMap<String, String>();
        stsConfig.putAll(CachedCfg);
        stsConfig.put("MESSAGE_ID", mid);
        stsConfig.put("MESSAGE_ACTION", msgAction);
        if (tolerateWSFPTrustRequest != null) {
            stsConfig.put("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPTrustRequest);
        }
        ServiceClient client = null;
        try {
            Iterator<ITrustRequestSecurityTokenResponse> iterValidate;
            HashMap<String, Object> parms = new HashMap<String, Object>();
            parms.put("STSCONFIGURATION", stsConfig);
            parms.put("RSTTEMPLATE", rstt);
            HashMap<String, Object> innerMap = new HashMap<String, Object>();
            innerMap.put("com.ibm.ws.wssecurity.constants.wssapi.key.generator", gencont);
            innerMap.put("com.ibm.ws.wssecurity.constants.wssapi.key.consumer", concont);
            parms.put("AXIS2_MESSAGECONTEXT_PROPERTYMAP", innerMap);
            ConfigurationContext configurationContext = this.getConfigurationContext(serviceEndpointAddress);
            parms.put("CONFIG_CONTEXT", configurationContext);
            HashMap<String, Object> cachedMap = new HashMap<String, Object>();
            cachedMap.putAll(parms);
            ITrustRequestSecurityToken rst = client10.createRequestSecurityToken(rstt, parms);
            AxisService axService = rst.getAxisService();
            if (axService != null) {
                axService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            client = rst.getServiceClient();
            gencont.process(client);
            concont.process(client);
            ITrustRequestSecurityTokenResponseCollection rstrc = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Validate request.");
            }
            rstrc = client10.validate(rst);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client validate is successful.");
            }
            if ((iterValidate = rstrc.getRSTRCollection()).hasNext()) {
                ITrustRequestSecurityTokenResponse rstr = iterValidate.next();
                String code = rstr.getStatusCode();
                String reason = rstr.getStatusReason();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status Code=" + code);
                    Tr.debug(tc, "Status Reason=" + reason);
                }
                if (code.equals(trustLevel + "/status/invalid")) {
                    SecureConversationCacheHelper.invalidateCache(this.id);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This sct is removed from cache.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validate(WSSGenerateionContext gencont, WSSConsumingContext concont) return false.");
                    }
                    return false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validate(WSSGenerateionContext gencont, WSSConsumingContext concont) return true.");
                }
                return true;
            }
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".validate", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7071E", e);
        }
        catch (Throwable e) {
            Tr.processException(e, clsName + ".validate", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7071E", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate(WSSGenerateionContext gencont, WSSConsumingContext concont) return");
        }
        return false;
    }

    public ConfigurationContext getConfigurationContext(String serviceEndpointAddress) throws Exception {
        ConfigurationContext configurationContext = null;
        ClientConfigurationFactory clientConfigurationFactory = ClientConfigurationFactory.newInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ClientConfigurationFactory.newInstance(): " + clientConfigurationFactory);
        }
        if (clientConfigurationFactory == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
        }
        configurationContext = clientConfigurationFactory.getClientConfigurationContext();
        if (configurationContext == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
        }
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        if (axisConfiguration == null) {
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
            throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
        }
        AxisService aService = axisConfiguration.getService(serviceEndpointAddress);
        if (aService == null) {
            AxisService axisService = new AxisService(serviceEndpointAddress);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AxisService: " + axisService);
            }
            if (axisService == null) {
                Tr.warning(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisService", new Object[]{serviceEndpointAddress});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating an empty AxisService.");
                }
                if ((axisService = new AxisService()) == null) {
                    Tr.error(tc, "UNABLE TO CREATE EMPTY AxisService");
                }
            }
            axisConfiguration.addService(axisService);
            clientConfigurationFactory.completeAxis2Configuration(axisService);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ccf.completeAxis2Configuration(): " + clientConfigurationFactory);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found Target axisService from AxisConfiguration.");
        }
        return configurationContext;
    }

    public void setBindingProvider(BindingProvider bp) {
        this.bindingProvider = bp;
    }

    public BindingProvider getBindingProvider() {
        return this.bindingProvider;
    }

    @Override
    public void setSecurityTokenManagerImpl(SecurityTokenManagerImpl tokenMgr) {
        this.securityTokenManager = tokenMgr;
    }
}

