/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.SCAndTrustConstants;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.impl.auth.callback.SCTCallback;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.sc.SecureConversationImpl;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.client.ITrustClient;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityToken;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponse;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenResponseCollection;
import com.ibm.ws.wssecurity.trust.client.ITrustRequestSecurityTokenTemplate;
import com.ibm.ws.wssecurity.trust.client.impl.TrustClientFactory;
import com.ibm.ws.wssecurity.trust.client.impl.TrustException;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdAttributeValue;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSNonceGenerator;
import com.ibm.ws.wssecurity.util.WSSObjectUtils;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.WSSObjectStructureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyAlgorithm;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT13;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectElementImpl;
import com.ibm.ws.wssecurity.wssobject.impl.wsc.SecurityContextToken;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObject;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartTextValue;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.ws.BindingProvider;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;

public class SCTGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(SCTGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SCTGenerateLoginModule.class.getName();
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XMLENC_NS = "http://www.w3.org/2001/04/xmlenc#";
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String HMAC = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String KW_TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String KWAES128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String KWAES192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String KWAES256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private static final javax.xml.namespace.QName wsuQname = new javax.xml.namespace.QName(com.ibm.ws.wssecurity.common.Constants.NS_WSU, "Id");
    static final KeyAlgorithm KA_HMAC = new KeyAlgorithm("HmacSHA1", 20);
    static final KeyAlgorithm KA_RSA = new KeyAlgorithm("SHA1withRSA", 20);
    static final KeyAlgorithm KA_DSA = new KeyAlgorithm("SHA1withDSA", 20);
    static final KeyAlgorithm KA_TRIPLEDES_CBC = new KeyAlgorithm("DESede", 24);
    static final KeyAlgorithm KA_AES128_CBC = new KeyAlgorithm("AES", 16);
    static final KeyAlgorithm KA_AES192_CBC = new KeyAlgorithm("AES", 24);
    static final KeyAlgorithm KA_AES256_CBC = new KeyAlgorithm("AES", 32);
    static final KeyAlgorithm KA_RSA_1_5 = new KeyAlgorithm("RSA", 16);
    static final KeyAlgorithm KA_KWAES128 = new KeyAlgorithm("DESede/CBC/NoPadding", 16);
    static final KeyAlgorithm KA_KWAES192 = new KeyAlgorithm("DESede/CBC/NoPadding", 24);
    static final KeyAlgorithm KA_KWAES256 = new KeyAlgorithm("DESede/CBC/NoPadding", 32);
    private CallbackHandler _handler;
    private Map _sharedState;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private Object _referencedTokenElement;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;
    private boolean isWSSAPI = false;
    private javax.xml.namespace.QName _soapFault = null;
    private boolean _isOM = false;
    private boolean _isWSSObject = false;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._sharedState = sharedState;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        PropertyCallback propertyCallback = new PropertyCallback(null);
        SCTCallback sctCallback = new SCTCallback();
        SCTGenerateCallback sctGenerateCallback = new SCTGenerateCallback();
        Callback[] callbacks = new Callback[]{sctCallback, sctGenerateCallback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                if (e.getMessage() != null) {
                    // empty if block
                }
                throw new LoginException(e.getMessage());
            }
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        boolean bl = this.isWSSAPI = !sctCallback.isExist();
        if (this.isWSSAPI) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSAPI for WS-SC enables.");
            }
            this.loginForWSSAPI(sctGenerateCallback, this._securityTokenManager);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The policy set for WS-SC enables.");
            }
            this.loginForPolicyset(sctCallback, this._securityTokenManager);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login() returns.");
        }
        return true;
    }

    private final void loginForWSSAPI(SCTGenerateCallback sctGenerateCallback, SecurityTokenManager securityTokenManager) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("loginForWSSAPI(");
            buf.append("SCTGenerateCallback sctGenerateCallback, ");
            buf.append("SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        SCTWrapper sctWrapper = null;
        Object dktoken = null;
        boolean requireExternalURIReference = false;
        boolean b = SCTGenerateLoginModule.isExistedBootstrapPolicy(sctGenerateCallback.getBindingProvider());
        if (b) {
            if (tc.isEntryEnabled()) {
                StringBuffer buf = new StringBuffer("loginForWSSAPI(");
                buf.append("SCTCallback, SCTGenerateCallback)");
                Tr.exit(tc, buf.toString());
            }
            return;
        }
        SCT sctoken = (SCT)sctGenerateCallback.getToken();
        if (sctoken == null) {
            WSSGenerationContext gctx = sctGenerateCallback.getWSSGenerationContext();
            WSSConsumingContext cctx = sctGenerateCallback.getWSSConsumingContext();
            String serviceEndpointAddress = sctGenerateCallback.getServiceEndpointAddress();
            sctWrapper = this.requestSCTusingWSSAPI(gctx, cctx, serviceEndpointAddress, sctGenerateCallback);
            sctGenerateCallback.setToken(sctWrapper);
            this._processedTokens.add(sctWrapper);
            if (tc.isEntryEnabled()) {
                StringBuffer buf = new StringBuffer("loginForWSSAPI(");
                buf.append("SCTCallback, SCTGenerateCallback)");
                Tr.exit(tc, buf.toString());
            }
            return;
        }
        String instanceInUse = null;
        if (sctoken instanceof SCTWrapper) {
            sctWrapper = (SCTWrapper)sctoken;
            sctoken = sctWrapper.getSCT();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT Generate callback getToken returns SCTWrapper");
                Tr.debug(tc, "SCT configuration map = " + sctWrapper.getSCT().getMap().toString());
                Tr.debug(tc, "Instance=" + sctoken.getInstances());
            }
        } else if (sctoken instanceof SCT) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT Generate callback getToken returns SCT");
                Tr.debug(tc, "SCT configuration map = " + sctoken.getMap().toString());
            }
            String[] inst = null;
            inst = sctoken.getInstances();
            if (inst != null && inst.length > 0) {
                instanceInUse = inst[inst.length - 1];
            }
            sctWrapper = SCTGenerateLoginModule.createSCTWrapper(sctoken, instanceInUse);
            sctWrapper.setSCT(sctoken);
        }
        String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        tokenType = sctoken.getValueType().getLocalPart();
        javax.xml.namespace.QName tokenVType = sctoken.getValueType();
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
        }
        instanceInUse = sctWrapper.getCurrentInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT uuid = " + sctoken.getUUID() + " and SCT instance = " + instanceInUse);
        }
        if (sctoken != null && !sctoken.isCancelled() && sctoken.isValid(instanceInUse, 0L)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security context token is a valid token");
            }
        } else {
            this._soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT", tokenType);
            this._context.put("com.ibm.ws.wssecurity.sc.FaultCode", this._soapFault);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.invalidSCT"));
        }
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (keyInfoType == null) {
            boolean isStrref = false;
        } else {
            boolean isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
        }
        int wssVersion = 0;
        Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        boolean alreadyExist = false;
        try {
            alreadyExist = SCTGenerateLoginModule.checkToken(config2, keyInfoType, sctWrapper, this._securityTokenManager);
        }
        catch (SoapSecurityException e) {
            Tr.processException(e, clsName + ".login", "384");
            throw new LoginException(e.toString());
        }
        Object parent = this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (parent instanceof WSSObjectElement) {
            this._isWSSObject = true;
        } else {
            this._isOM = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Looking for the SCT element in the message.. ");
        }
        boolean isSCTElemInMessage = false;
        String SCTTokenId = null;
        Object sctelem = this.getSCTChild(parent, nsWsc);
        if (sctelem != null) {
            String tuuid = this.getIdentifier(sctelem, nsWsc);
            if (tuuid.equals(sctoken.getUUID())) {
                isSCTElemInMessage = true;
                this._referencedTokenElement = sctelem;
                isSCTElemInMessage = true;
            }
            SCTTokenId = this.getSCTId(sctelem);
        } else {
            this._processedTokens.add(sctWrapper);
            this._insertedTokens.add(sctWrapper);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT element exists in the message: " + isSCTElemInMessage);
        }
        if (!alreadyExist) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT doesn't exist in the subject. ");
            }
            Object elem = null;
            if (!isSCTElemInMessage) {
                String instanceToAdd = null;
                if (sctoken.getInstances() != null && sctoken.getInstances().length > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SCT has more than one instance,instance should be included in the message. ");
                    }
                    instanceToAdd = sctWrapper.getCurrentInstance();
                }
                SCTTokenId = IdUtils.getInstance().makeUniqueId(this._context, "sct_");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using SCT id = " + SCTTokenId + ", to create SCT token.");
                }
                elem = this.createTokenObject(parent, tokenVType, SCTTokenId, sctoken.getIdentifier(), instanceToAdd, wssVersion);
                if (this._isWSSObject) {
                    sctWrapper.setXML(new WSSObjectStructureImpl((WSSObjectElement)elem));
                } else if (this._isOM) {
                    sctWrapper.setXML(new OMStructure((OMElement)elem));
                }
                sctWrapper.setId(SCTTokenId);
            }
            if (tc.isDebugEnabled()) {
                if (this._isWSSObject) {
                    Tr.debug(tc, "security context token WSSObjectElement looks like = " + elem);
                } else if (this._isOM) {
                    Tr.debug(tc, "security context token OMElement looks like = " + DOMUtils.toString((OMElement)elem));
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found SCT in the subject. ");
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.externalTokenReference", sctoken.getUUID());
        int iKeys = sctoken.getInstances().length;
        if (iKeys > 1) {
            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenInstance", sctWrapper.getCurrentInstance());
        }
        if (!requireExternalURIReference) {
            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.internalTokenReference", sctWrapper.getId());
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenValueType", sctoken.getValueType());
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenClientSecret", sctoken.getClientSecret(sctWrapper.getCurrentInstance()));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenServerSecret", sctoken.getServerSecret(sctWrapper.getCurrentInstance()));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", sctoken.getSecret(sctWrapper.getCurrentInstance()));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken", Constants.WSSECURITY_KEY_REFERENCE);
        this._sharedState.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._sharedState.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("loginForWSSAPI(");
            buf.append("SCTGenerateCallback, SecurityTokenManager)");
            Tr.exit(tc, buf.toString());
        }
    }

    private final void loginForPolicyset(SCTCallback sctCallback, SecurityTokenManager securityTokenManager) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("loginForPolicyset(");
            buf.append("SCTCallback sctCallback, ");
            buf.append("SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        SCT sctoken = sctCallback.getToken();
        SCTWrapper sctWrapper = sctCallback.getWrapperToken();
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        boolean isServer = false;
        try {
            isServer = Axis2Util.isServiceProvider(messageContext);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (keyInfoType == null) {
            boolean isStrref = false;
        } else {
            boolean isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
        }
        int wssVersion = 0;
        Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        if (messageContext.getProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE) != null) {
            tokenType = (String)messageContext.getProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
            messageContext.setProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, null);
        }
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT Token Value Type = " + tokenType);
        }
        boolean alreadyExist = false;
        try {
            alreadyExist = SCTGenerateLoginModule.checkToken(config2, keyInfoType, sctWrapper, securityTokenManager);
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".login", "717", this);
            throw new LoginException(e.toString());
        }
        Object parent = this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (parent instanceof WSSObjectElement) {
            this._isWSSObject = true;
        } else {
            this._isOM = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Looking for the SCT element in the message.. ");
        }
        boolean pre70Bindings = false;
        boolean pre70Behavior = false;
        if (((PolicyOutboundConfig)gconfig).isTargetBindingsUsing10NS() || ((PolicyOutboundConfig)gconfig).isDefaultBindingsUsing10NS()) {
            pre70Bindings = true;
        } else {
            String preV7Format = null;
            preV7Format = (String)config2.getProperties().get(Constants.PRE_V7_FORMAT_OF_INCLUDING_SCT_IN_MESSAGE);
            if (preV7Format != null && preV7Format.equals("true")) {
                pre70Behavior = true;
            }
        }
        boolean requireExternalURIReference = false;
        if (pre70Bindings || pre70Behavior) {
            String inclideSCT;
            if (!isServer) {
                inclideSCT = (String)config2.getProperties().get(Constants.INCLUDE_SCT_IN_REQUEST);
                if (inclideSCT != null && inclideSCT.equalsIgnoreCase("false")) {
                    requireExternalURIReference = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Do not include SCT in request message.");
                    }
                }
            } else {
                inclideSCT = (String)config2.getProperties().get(Constants.INCLUDE_SCT_IN_RESPONSE);
                if (inclideSCT == null || "false".equalsIgnoreCase(inclideSCT)) {
                    requireExternalURIReference = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Do not include SCT in response message.");
                    }
                }
            }
        } else if (config2.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.externalURIReference") != null && ((Boolean)config2.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.externalURIReference")).booleanValue()) {
            requireExternalURIReference = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "External URI reference = true ");
            }
        }
        boolean isSCTElemInMessage = false;
        boolean IncludingSCTMessage = false;
        String SCTTokenId = null;
        Object sctelem = this.getSCTChild(parent, nsWsc);
        if (sctelem != null) {
            String tuuid = this.getIdentifier(sctelem, nsWsc);
            if (tuuid.equals(sctoken.getUUID())) {
                isSCTElemInMessage = true;
                this._referencedTokenElement = sctelem;
                IncludingSCTMessage = true;
            }
            SCTTokenId = this.getSCTId(sctelem);
        } else {
            this._processedTokens.add(sctWrapper);
            if (!requireExternalURIReference) {
                this._insertedTokens.add(sctWrapper);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Include SCT in the message.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT element exists in the message: " + isSCTElemInMessage);
        }
        if (!alreadyExist) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT doesn't exist in the subject. ");
            }
            Object elem = null;
            if (!isSCTElemInMessage) {
                String instanceToAdd = null;
                if (sctoken.getInstances() != null && sctoken.getInstances().length > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SCT has more than one instance,instance should be included in the message. ");
                    }
                    instanceToAdd = sctWrapper.getCurrentInstance();
                }
                IdAttributeValue idAttrVal = IdUtils.getInstance().makeUniqueId(this._context);
                SCTTokenId = "sct_" + idAttrVal.getStringValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using SCT id = " + SCTTokenId + ", to create SCT token.");
                }
                elem = this.createTokenObject(parent, sctoken.getValueType(), SCTTokenId, sctoken.getIdentifier(), instanceToAdd, wssVersion);
                if (this._isWSSObject) {
                    sctWrapper.setXML(new WSSObjectStructureImpl((WSSObjectElement)elem));
                } else if (this._isOM) {
                    sctWrapper.setXML(new OMStructure((OMElement)elem));
                }
                sctWrapper.setId(SCTTokenId);
            }
            if (tc.isDebugEnabled()) {
                if (this._isWSSObject) {
                    Tr.debug(tc, "security context token WSSObjectElement looks like = " + elem);
                } else if (this._isOM) {
                    Tr.debug(tc, "security context token OMElement looks like = " + DOMUtils.toString((OMElement)elem));
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found SCT in the subject. ");
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.externalTokenReference", sctoken.getUUID());
        int iKeys = sctoken.getInstances().length;
        if (iKeys > 1) {
            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenInstance", sctWrapper.getCurrentInstance());
        }
        if (!requireExternalURIReference) {
            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.internalTokenReference", sctWrapper.getId());
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenValueType", sctoken.getValueType());
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenClientSecret", sctoken.getClientSecret(sctWrapper.getCurrentInstance()));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenServerSecret", sctoken.getServerSecret(sctWrapper.getCurrentInstance()));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", sctoken.getSecret(sctWrapper.getCurrentInstance()));
        this._sharedState.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._sharedState.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken", Constants.WSSECURITY_KEY_REFERENCE);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("loginForPolicyset(");
            buf.append("SCTCallback, SCTGenerateCallback, SecurirityTokenManager)");
            Tr.exit(tc, buf.toString());
        }
    }

    private final SCTWrapper requestSCTusingWSSAPI(WSSGenerationContext gencont, WSSConsumingContext concont, String serviceEndpointAddress, SCTGenerateCallback sctGenerateCallback) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("requestSCTusingWSSAPI(");
            buf.append("WSSGenerationContext gencont, WSSConsumingContext concont, ");
            buf.append("String serviceEndpointAddress[").append(serviceEndpointAddress).append("], ");
            buf.append("SCTGenerateCallback sctGenerateCallback)");
            Tr.entry(tc, buf.toString());
        }
        String trustLevel = "http://schemas.xmlsoap.org/ws/2005/02/trust";
        SCT sctoken = null;
        SCTWrapper sctWrapper = null;
        String soapLevel = com.ibm.ws.wssecurity.common.Constants.NS_SOAP;
        String replyToAddress = "http://www.w3.org/2005/08/addressing/anonymous";
        String tokenType = null;
        String string = tokenType = (javax.xml.namespace.QName)this._context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE) != null ? ((javax.xml.namespace.QName)this._context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE)).getLocalPart() : com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token Value Type = " + tokenType);
        }
        String tolerateWSFPTrustRequest = (String)this._context.get(Constants.TOLERATE_WSFP_TRUST_REQUEST);
        String reqType = null;
        String msgAction = null;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
            trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[0][2];
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[0][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[0][1];
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            trustLevel = SCAndTrustConstants.SC_TRUST_NAMESPACES[1][2];
            reqType = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[4][0];
            msgAction = SCAndTrustConstants.SC_TRUST_ACTION_NAMESPACES[4][1];
        }
        int keylength = 32;
        String encAlg = null;
        encAlg = sctGenerateCallback.getEncyptionAlgorithm();
        if (encAlg != null) {
            KeyAlgorithm ka = SCTGenerateLoginModule.getKeyAlgorithm(encAlg, false, false, false, true);
            encAlg = ka.algorithm;
            keylength = ka.keyLength;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption algorithm (JCE mapping) and key length are = " + encAlg + ", " + keylength);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using WSSAPI, key length to use = " + keylength);
        }
        String keySizeStr = Integer.toString(keylength * 8);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using WSSAPI, key size in bits = " + keySizeStr);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using Trust Level = " + trustLevel);
        }
        ITrustClient client10 = null;
        try {
            client10 = TrustClientFactory.getTrustClient(trustLevel);
        }
        catch (TrustException e) {
            Tr.processException((Throwable)e, clsName, ".requestSCTusingWSSAPI", "%C");
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.issueSCT", new String[]{e.toString()}));
        }
        ITrustRequestSecurityTokenTemplate rstt = client10.getSTSRequestSecurityTokenTemplate();
        String wsa_ns = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
        rstt.setWSANamespace(wsa_ns);
        rstt.addTokenType(tokenType);
        rstt.addRequestType(reqType);
        rstt.addKeySize(keySizeStr);
        byte[] clientSecret = WSSNonceGenerator.generateBytes(keylength);
        rstt.addEntropyNonce(Base64.encode(clientSecret));
        rstt.setTo(serviceEndpointAddress);
        rstt.setAction(msgAction);
        String mid = SecurityUIDGenerator.createUID();
        rstt.setMessageID(mid);
        HashMap<String, String> stsConfig = new HashMap<String, String>();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting final WS-Addressing level in the trust service request." + wsa_ns);
        }
        try {
            stsConfig.put("MESSAGE_ID", mid);
            stsConfig.put("MESSAGE_TO", serviceEndpointAddress);
            stsConfig.put("MESSAGE_ACTION", msgAction);
            stsConfig.put("SOAP_LEVEL", soapLevel);
            stsConfig.put("ADDRESSING_LEVEL", wsa_ns);
            stsConfig.put("TRUST_LEVEL", trustLevel);
            stsConfig.put("KeySize", keySizeStr);
            stsConfig.put("TokenType", tokenType);
            stsConfig.put("CONTEXT_URI", "http://www.ibm.com/login/");
            stsConfig.put("STS_NAME", "SSI");
            if (tolerateWSFPTrustRequest != null) {
                stsConfig.put("com.ibm.ws.wsspi.wssecurity.trust.tolerateFeaturePackMessages", tolerateWSFPTrustRequest);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serviceEndpointAddress: " + serviceEndpointAddress);
            }
            ConfigurationContext configurationContext = null;
            ClientConfigurationFactory clientConfigurationFactory = ClientConfigurationFactory.newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ClientConfigurationFactory.newInstance(): " + clientConfigurationFactory);
            }
            if (clientConfigurationFactory == null) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
            }
            configurationContext = clientConfigurationFactory.getClientConfigurationContext();
            if (configurationContext == null) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
            }
            AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
            if (axisConfiguration == null) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
            }
            AxisService aService = axisConfiguration.getService(serviceEndpointAddress);
            if (aService == null) {
                AxisService axisService = new AxisService(serviceEndpointAddress);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AxisService: " + axisService);
                }
                if (axisService == null) {
                    Tr.warning(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisService", new Object[]{serviceEndpointAddress});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "creating an empty AxisService.");
                    }
                    if ((axisService = new AxisService()) == null) {
                        Tr.error(tc, "UNABLE TO CREATE EMPTY AxisService");
                    }
                }
                axisConfiguration.addService(axisService);
                clientConfigurationFactory.completeAxis2Configuration(axisService);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ccf.completeAxis2Configuration(): " + clientConfigurationFactory);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Target axisService from AxisConfiguration.");
            }
            HashMap<String, Object> parms = new HashMap<String, Object>();
            parms.put("STSCONFIGURATION", stsConfig);
            parms.put("RSTTEMPLATE", rstt);
            parms.put("CONFIG_CONTEXT", configurationContext);
            HashMap<String, Object> innerMap = new HashMap<String, Object>();
            innerMap.put("com.ibm.ws.wssecurity.constants.wssapi.key.generator", gencont);
            innerMap.put("com.ibm.ws.wssecurity.constants.wssapi.key.consumer", concont);
            parms.put("AXIS2_MESSAGECONTEXT_PROPERTYMAP", innerMap);
            HashMap<String, Object> cachedMap = new HashMap<String, Object>();
            cachedMap.putAll(parms);
            ITrustRequestSecurityToken rst = client10.createRequestSecurityToken(rstt, parms);
            AxisService axService = rst.getAxisService();
            if (axService != null) {
                axService.addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            ServiceClient client = rst.getServiceClient();
            gencont.process(client);
            concont.process(client);
            byte[] serverSecret = null;
            String uuid = null;
            String instance = null;
            Object created = null;
            Object expires = null;
            Date createdDate = null;
            Date expiresDate = null;
            String renewable = "true";
            String renewableAfterExpiration = "false";
            ITrustRequestSecurityTokenResponseCollection rstrc = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Issue request.");
            }
            rstrc = client10.issue(rst);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client Issue is successful.");
            }
            OMElement securityContextTokenElement = null;
            Iterator<ITrustRequestSecurityTokenResponse> iter = rstrc.getRSTRCollection();
            if (iter.hasNext()) {
                ITrustRequestSecurityTokenResponse rstr = iter.next();
                securityContextTokenElement = rstr.getSecurityContextTokenElement();
                uuid = rstr.getUUID();
                instance = rstr.getInstance();
                serverSecret = rstr.getServerSecretBytes();
                createdDate = rstr.getCreatedDate();
                expiresDate = rstr.getExpiresDate();
                Integer size = rstr.getKeySize();
                if (size != null) {
                    keylength = size;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + keylength);
                    }
                }
                renewable = rstr.getRenewable();
                renewableAfterExpiration = rstr.getRenewableAfterExpiration();
            }
            SCT.KeyHistoryEntry token = new SCT.KeyHistoryEntry(instance, clientSecret, serverSecret, createdDate, expiresDate, SCT.SCTState.ISSUED);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + uuid + ", created = " + createdDate.toString() + ", expires = " + expiresDate.toString() + ", and instance = " + instance + ", serverSecret = " + Base64.encode(serverSecret) + ", clientEntropy = " + Base64.encode(clientSecret));
            }
            if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
                SCT13 sctoken13 = new SCT13(uuid);
                sctoken = sctoken13;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Value Type = " + sctoken.getValueType().getLocalPart());
                }
            } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
                sctoken = new SCT(uuid);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Value Type = " + sctoken.getValueType().getLocalPart());
                }
            }
            sctoken.setKeyHistoryEntry(token);
            sctoken.setClientID(uuid);
            sctoken.setXML(new OMStructure(securityContextTokenElement));
            sctoken.setMap(cachedMap);
            sctoken.setWssConsumingContext(concont);
            sctoken.setWssGenerationContext(gencont);
            sctoken.setUsedForSigAndEnc(true);
            sctoken.setKeySize(keylength);
            sctoken.setRenewable(Boolean.valueOf(renewable));
            sctoken.setRenewableAfterExpiration(Boolean.valueOf(renewableAfterExpiration));
            sctWrapper = SCTGenerateLoginModule.createSCTWrapper(sctoken, instance);
            sctWrapper.setSCT(sctoken);
            sctWrapper.setXML(new OMStructure(securityContextTokenElement));
            sctWrapper.setWssGenerationContext(gencont);
            sctWrapper.setWssConsumingContext(concont);
            sctWrapper.setMap(cachedMap);
            SecureConversationCacheHelper.setSecurityContextTokenToCache(uuid, null, sctoken, null);
            client.cleanup();
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName, ".requestSCTusingWSSAPI", "%C");
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.issueSCT", new String[]{e.toString()}));
        }
        catch (Throwable e) {
            Tr.processException(e, clsName, ".requestSCTusingWSSAPI", "%C");
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{e});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.issueSCT", new String[]{e.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSCTusingWSSAPI(WSSGenerationContext gencont, WSSConsumingContext concont, String serviceEndpointAddress)");
        }
        return sctWrapper;
    }

    public static final Date parseDateTime(String s) {
        if (s == null) {
            return null;
        }
        try {
            Date d = UTC.parse(s);
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int il = this._processedTokens.size();
        for (int i = 0; i < il; ++i) {
            SecurityToken token = this._processedTokens.get(i);
            this._securityTokenManager.addToken(token);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        this._context.put(Constants.WSSECURITY_TOKENELEMENT_REFERENCED, this._referencedTokenElement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final boolean checkToken(TokenGeneratorConfig config2, String keyInfoType, SecurityToken token, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        Collection<SecurityToken> tokens;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkToken(");
            buf.append("TokenGenratorConfig config, ");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("SecurityToken token, SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        boolean ret = false;
        String uniqueId = null;
        String instance = null;
        if (token instanceof SCTWrapper) {
            uniqueId = ((SCTWrapper)token).getSCT().getUUID();
            instance = ((SCTWrapper)token).getCurrentInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uuid = " + uniqueId + ", instance = " + instance);
            }
        } else {
            uniqueId = ((SCT)token).getUUID();
        }
        if ((tokens = securityTokenManager.getTokens(config2, keyInfoType)) != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                String uuid;
                SCT sct;
                if (t instanceof SCTWrapper) {
                    sct = (SCTWrapper)t;
                    uuid = sct.getUUID();
                    String currentInstance = ((SCTWrapper)sct).getCurrentInstance();
                    if (!uuid.equals(uniqueId) || !currentInstance.equals(instance)) continue;
                    ret = true;
                    break;
                }
                if (!(t instanceof SCT) || !(uuid = (sct = (SCT)t).getUUID()).equals(uniqueId)) continue;
                ret = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("checkToken(");
            buf.append("TokenGenratorConfig, String, SecurityToken, SecurityTokenManager)");
            buf.append(" return boolean[").append(ret).append("]");
            Tr.exit(tc, buf.toString());
        }
        return ret;
    }

    private final Object createTokenObject(Object parent, javax.xml.namespace.QName valueType, String refId, String uuid, String curInstance, int wssVersion) {
        Object token = null;
        if (this._isWSSObject) {
            token = this.createTokenWSSObject(parent, valueType, refId, uuid, curInstance, wssVersion);
        } else if (this._isOM) {
            token = SCTGenerateLoginModule.createTokenElement(((OMElement)parent).getOMFactory(), (OMElement)parent, valueType, refId, uuid, curInstance, wssVersion);
        }
        return token;
    }

    private final WSSObjectElement createTokenWSSObject(Object parent, javax.xml.namespace.QName valueType, String refId, String uuid, String curInstance, int wssVersion) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenWSSObject(");
            buf.append("Object parent[").append(parent).append("], ");
            buf.append("QName valueType[").append(valueType).append("], ");
            buf.append("String refId[").append(refId).append("], ");
            buf.append("String uuid[").append(uuid).append("], ");
            buf.append("String curInstance[").append(curInstance).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("])");
            Tr.entry(tc, buf.toString());
        }
        WSSObjectElementImpl parentWSSObject = (WSSObjectElementImpl)parent;
        String tokenType = null;
        tokenType = valueType.getLocalPart();
        if (tokenType != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT NS =  [" + tokenType + "].");
        }
        QName qn = null;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
            qn = Utf8ByteConstantsQNames.WSC_13.QN_SECURITY_CONTEXT_TOKEN;
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            qn = Utf8ByteConstantsQNames.WSC.QN_SECURITY_CONTEXT_TOKEN;
        }
        SecurityContextToken securityContextToken = new SecurityContextToken(parentWSSObject.getWSSObjectDocument(), qn);
        VariablePartAttributeValue vPart = IdUtils.getInstance().getVariablePart(refId);
        securityContextToken.setWsuId(vPart);
        securityContextToken.setIdentifier(VariablePartFactory.getInstance().createTextValueWithString(uuid));
        if (curInstance != null && !curInstance.isEmpty()) {
            securityContextToken.setInstance(VariablePartFactory.getInstance().createTextValueWithString(curInstance));
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenWSSObject(");
            buf.append("Object, QName, String, String, String, int)");
            buf.append(" returns WSSObjectElement [").append(securityContextToken).append("]");
            Tr.exit(tc, buf.toString());
        }
        return securityContextToken;
    }

    public static final OMElement createTokenElement(OMFactory factory, OMElement parent, javax.xml.namespace.QName valueType, String refId, String uuid, String curInstance, int wssVersion) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenElement(");
            buf.append("OMFactory factory, ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("QName valueType[").append(valueType).append("], ");
            buf.append("String refId[").append(refId).append("], ");
            buf.append("String uuid[").append(uuid).append("], ");
            buf.append("String curInstance[").append(curInstance).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("])");
            Tr.entry(tc, buf.toString());
        }
        String tokenType = null;
        tokenType = valueType.getLocalPart();
        if (tokenType != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT NS =  [" + tokenType + "].");
        }
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        } else if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
        }
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsc = null;
        if (parent != null) {
            pWsc = DOMUtils.getNamespacePrefix(parent, nsWsc);
        }
        if (pWsc == null) {
            isDecl = true;
            pWsc = "wsc";
        }
        OMElement tokenElem = factory.createOMElement("SecurityContextToken", nsWsc, pWsc);
        if (isDecl) {
            tokenElem.declareNamespace(nsWsc, "wsc");
        }
        isDecl = false;
        String pWsu = null;
        if (parent != null) {
            pWsu = DOMUtils.getNamespacePrefix(parent, nsWsu);
        }
        if (pWsu == null) {
            isDecl = true;
            pWsu = "wsu";
        }
        if (isDecl) {
            tokenElem.declareNamespace(nsWsu, "wsu");
        }
        tokenElem.addAttribute("Id", refId, tokenElem.getOMFactory().createOMNamespace(nsWsu, pWsu));
        OMElement id = factory.createOMElement("Identifier", nsWsc, pWsc);
        id.addChild(factory.createOMText(uuid));
        tokenElem.addChild(id);
        if (curInstance != null) {
            OMElement instance = factory.createOMElement("Instance", nsWsc, pWsc);
            instance.addChild(factory.createOMText(curInstance));
            tokenElem.addChild(instance);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding instance = " + curInstance);
                Tr.debug(tc, "After adding instance, = " + DOMUtils.toString(tokenElem));
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenElement(");
            buf.append("OMFactory, OMElement, QName, String, String, String, int)");
            buf.append(" returns OMElement [").append(tokenElem).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenElem;
    }

    private static final int getKeyLength(boolean sig, WSSGeneratorConfig config2, TokenGeneratorConfig tconfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "(boolean sig, String algorithmSuite, TokenGeneratorConfig config)");
        }
        String algorithmSuite = ((PolicyOutboundConfig)config2).getAlgorithmSuite();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Algorithm Suite = " + algorithmSuite);
        }
        String keyLengthInBinding = (String)tconfig.getProperties().get(Constants.DERIVED_KEY_LENGTH);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The specified Dervived Key Length is " + keyLengthInBinding);
        }
        return SCTGenerateLoginModule.getKeyLength(sig, algorithmSuite, keyLengthInBinding);
    }

    public static final int getKeyLength(boolean sig, String algorithmSuite, String keyLengthInBinding) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyLength(boolean sig [");
            buf.append(sig).append("], String algorithmSuite [").append(algorithmSuite).append("], String keyLengthInBinding [");
            buf.append(keyLengthInBinding).append("])");
            Tr.entry(tc, buf.toString());
        }
        String minLeng = PolicyConfigUtil.getMinimumSymmetricKeyLength(algorithmSuite);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Minimum Dervived Key Length for " + algorithmSuite + " is " + minLeng);
        }
        int iMinLeng = Integer.parseInt(minLeng) / 8;
        int iMaxLeng = 32;
        int iKeyLeng = iMinLeng;
        if (keyLengthInBinding != null && keyLengthInBinding.length() > 0) {
            iKeyLeng = Integer.parseInt(keyLengthInBinding);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified Dervived Key Length is " + iKeyLeng);
            }
            if (iKeyLeng < iMinLeng) {
                iKeyLeng = iMinLeng;
            }
            if (iKeyLeng > iMaxLeng) {
                iKeyLeng = iMaxLeng;
            }
        } else if (iKeyLeng == 16 && sig) {
            iKeyLeng = 20;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "The resulted Dervived Key Length is " + iKeyLeng);
        }
        return iKeyLeng;
    }

    public static final KeyAlgorithm getKeyAlgorithm(String algName, boolean isV, boolean isD, boolean isS, boolean isE) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKeyAlgorithm(");
            buf.append("String algName[").append(algName).append("], ");
            buf.append("boolean isV[").append(isV).append("], ");
            buf.append("boolean isD[").append(isD).append("], ");
            buf.append("boolean isS[").append(isS).append("], ");
            buf.append("boolean isE[").append(isE).append("])");
            Tr.entry(tc, buf.toString());
        }
        Object algorithm = null;
        boolean keylength = false;
        if (isV || isS) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isV: " + isV + ", " + "isS: " + isS + ".");
            }
            if (HMAC.equals(algName)) {
                return KA_HMAC;
            }
            if (RSA.equals(algName)) {
                return KA_RSA;
            }
            if (DSA.equals(algName)) {
                return KA_DSA;
            }
        } else if (isD || isE) {
            if (TRIPLEDES_CBC.equals(algName)) {
                return KA_TRIPLEDES_CBC;
            }
            if (AES128_CBC.equals(algName)) {
                return KA_AES128_CBC;
            }
            if (AES192_CBC.equals(algName)) {
                return KA_AES192_CBC;
            }
            if (AES256_CBC.equals(algName)) {
                return KA_AES256_CBC;
            }
            if (RSA_1_5.equalsIgnoreCase(algName)) {
                return KA_RSA_1_5;
            }
            if (KWAES128.equalsIgnoreCase(algName)) {
                return KA_KWAES128;
            }
            if (KWAES192.equalsIgnoreCase(algName)) {
                return KA_KWAES192;
            }
            if (KWAES256.equalsIgnoreCase(algName)) {
                return KA_KWAES256;
            }
        }
        return null;
    }

    private static final boolean isExistedBootstrapPolicy(BindingProvider bp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExistedBootstrapPolicy(BindingProvider bp)");
        }
        if (bp == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bp is null. The bootstrap policy does not exist.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isExistedBootstrapPolicy(BindingPolicy) returns false");
            }
            return false;
        }
        EndpointDescription endpointDesc = null;
        if (bp instanceof org.apache.axis2.jaxws.spi.BindingProvider) {
            endpointDesc = ((org.apache.axis2.jaxws.spi.BindingProvider)bp).getEndpointDescription();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingProvider not an instance of org.apache.axis2.jaxws.spi.BindingProvider, is instance of " + bp.getClass().getName());
        }
        AxisService aService = null;
        if (endpointDesc != null) {
            aService = endpointDesc.getAxisService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AxisService from the binding provider = " + aService);
            }
        }
        PrivateGeneratorConfig gCfg = SecureConversationImpl.getGeneratorConfigFromService(aService);
        PrivateConsumerConfig cCfg = SecureConversationImpl.getConsumerConfigFromService(aService);
        if (gCfg != null && cCfg != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "bootstrap policy exists.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isExistedBootstrapPolicy(BindingPolicy) returns true");
        }
        return true;
    }

    public static final SCTWrapper createSCTWrapper(SCT sctoken, String instance) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createSCTWrapper(");
            buf.append("SCT sctoken, String instance)");
            Tr.entry(tc, buf.toString());
        }
        String[] list = sctoken.getInstances();
        SCT.KeyHistoryEntry[] entries = new SCT.KeyHistoryEntry[list.length];
        SCTWrapper sctWrapper = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Instances in the list = " + list.length);
        }
        for (int i = 0; i < list.length; ++i) {
            entries[i] = sctoken.getKeyHistoryEntry(list[i]);
        }
        sctWrapper = new SCTWrapper(sctoken.getUUID(), entries, sctoken.getId(), instance);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createSCTWrapper(SCT, String)");
            buf.append(" returns SCTWrapper [");
            buf.append(sctWrapper == null ? null : sctWrapper.getCurrentInstance());
            buf.append("]");
            Tr.exit(tc, buf.toString());
        }
        return sctWrapper;
    }

    private Object getSCTChild(Object parent, String nsWsc) {
        Object child = null;
        if (this._isWSSObject) {
            WSSObjectElement wsso = (WSSObjectElement)parent;
            ArrayList<WSSObject> children = wsso.getChildren();
            if (children.size() > 0) {
                for (WSSObject obj : children) {
                    if (!(obj instanceof SecurityContextToken)) continue;
                    child = obj;
                    break;
                }
            }
        } else if (this._isOM) {
            child = DOMUtils.getChildElement((OMElement)parent, nsWsc, "SecurityContextToken");
        }
        return child;
    }

    private String getIdentifier(Object parent, String nsWsc) {
        OMElement elem;
        String uuid = null;
        if (this._isWSSObject) {
            VariablePartTextValue identifier = ((SecurityContextToken)parent).getIdentifier();
            uuid = identifier.toString();
        } else if (this._isOM && (elem = DOMUtils.getChildElement((OMElement)parent, nsWsc, "Identifier")) != null) {
            uuid = DOMUtils.getStringValue(elem);
        }
        return uuid;
    }

    private String getSCTId(Object sctelem) {
        String id = null;
        if (this._isWSSObject) {
            WSSObjectElement wssObj = (WSSObjectElement)sctelem;
            VariablePartAttributeValue vPartAttr = WSSObjectUtils.getAttribute(wssObj, wsuQname);
            if (vPartAttr != null) {
                id = vPartAttr.toString();
            }
        } else if (this._isOM) {
            javax.xml.namespace.QName idattr = IdUtils.getInstance().getIdAttributeName((OMElement)sctelem);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute QName of the target element is [" + idattr + "].");
            }
            if (idattr != null) {
                id = ((OMElement)sctelem).getAttributeValue(idattr);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Id attribute of the target element is [" + id + "].");
        }
        return id;
    }

    public static javax.xml.namespace.QName generateSoapFault(String str, String tokenType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateFault(String, String) " + str + ": " + tokenType);
        }
        javax.xml.namespace.QName fault = null;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
        }
        if ("invalidSCT".equals(str)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expired SCT. " + str);
            }
            fault = new javax.xml.namespace.QName(nsWsc, "RenewNeeded", "wsc");
            return fault;
        }
        if ("invalidSCT02".equals(str) || "invalidSCT03".equals(str)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot get valid SCT from trust service/client cache..Login Exception = " + str);
            }
            fault = new javax.xml.namespace.QName(nsWsc, "BadContextToken", "wsc");
            return fault;
        }
        if ("invalidSCT04".equals(str)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot support this SCT. " + str);
            }
            fault = new javax.xml.namespace.QName(nsWsc, "UnsupportedContextToken", "wsc");
            return fault;
        }
        if ("expiredSCT02".equals(str)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to renew. " + str);
            }
            fault = new javax.xml.namespace.QName(nsWsc, "UnableToRenew", "wsc");
            return fault;
        }
        if (str.compareTo(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02")) == 0 || str.compareTo(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03")) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot get valid SCT from trust service/client cache..Login Exception = " + str);
            }
            fault = new javax.xml.namespace.QName(nsWsc, "BadContextToken", "wsc");
        } else if (str.compareTo(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.invalidSCT")) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expired SCT. " + str);
            }
            fault = new javax.xml.namespace.QName(nsWsc, "RenewNeeded", "wsc");
        } else if (str.compareTo(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT04")) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot support this SCT. " + str);
            }
            fault = new javax.xml.namespace.QName(nsWsc, "UnsupportedContextToken", "wsc");
        } else if (str.compareTo(ConfigUtil.getMessage("security.wssecurity.WSTrustCallbackHandler.expiredSCT02")) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to renew. " + str);
            }
            fault = new javax.xml.namespace.QName(nsWsc, "UnableToRenew", "wsc");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateFault(String, String)");
        }
        return fault;
    }
}

