/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SCTConsumeCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.LocalNameConstants;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.impl.auth.callback.SCTCallback;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSTokenUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.CacheConfigFactory;
import com.ibm.ws.wssecurity.util.CommonLogUtils;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyAlgorithm;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT13;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(SCTConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SCTConsumeLoginModule.class.getName();
    private CallbackHandler _handler;
    private Map _sharedState;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;
    private static boolean jdbcEnabled = CacheConfigFactory.getInstance().isJDBCCache();

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._sharedState = sharedState;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean isStrref;
        boolean isEmb;
        boolean isNone;
        boolean isWSSAPI;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        PropertyCallback propertyCallback = new PropertyCallback(null);
        SCTCallback sctCallback = new SCTCallback();
        SCTConsumeCallback sctConsumeCallback = new SCTConsumeCallback();
        Callback[] callbacks = new Callback[]{sctCallback, sctConsumeCallback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "160", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig config2 = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        DKToken dkToken = new DKToken();
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, dkToken);
        this._token = null;
        boolean bl = isWSSAPI = !sctCallback.isExist();
        if (tc.isDebugEnabled()) {
            if (isWSSAPI) {
                Tr.debug(tc, "WSSAPI in SCTConsumeLoginModule.");
            } else {
                Tr.debug(tc, "PolicySet in SCTConsumeLoginModule");
            }
        }
        String algorithm = null;
        if (isWSSAPI) {
            algorithm = sctConsumeCallback.getEncryptionAlgorithm();
        }
        this._securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        OMElement target = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (keyInfoType == null) {
            isNone = true;
            isEmb = false;
            isStrref = false;
        } else {
            isNone = false;
            isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb(keyInfoType);
        }
        boolean isImpliedDerivedKey = false;
        if (isStrref) {
            DerivedKeyInfoConfig dkic = null;
            KeyInfoContentConsumerConfig keyInfoContent = (KeyInfoContentConsumerConfig)this._context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey");
            if (keyInfoContent != null) {
                dkic = keyInfoContent.getDerivedKeyInfoConfig();
            }
            if (dkic != null && dkic.isRequireImpliedDerivedKeys()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Implied Derived Keys are configured.");
                }
                isImpliedDerivedKey = true;
            }
        }
        if (isNone || isEmb) {
            this._token = this.processElement(dkToken, target, config2, isWSSAPI, isNone, isEmb, this._securityTokenManager, this._context, algorithm);
        } else if (isStrref && isImpliedDerivedKey) {
            this._token = this.processImpliedDerivedKey(this._securityTokenManager, this._context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private final SecurityToken processImpliedDerivedKey(SecurityTokenManager securityTokenManager, Map<Object, Object> context) throws LoginException {
        boolean isAuthnEventsRequired;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processImpliedDerivedKey(");
            buf.append("SecurityTokenManager, Map)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = null;
        String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String tokenId = (String)this._context.get(Constants.WSSECURITY_KEY_REFERENCE);
        boolean isExternalUriReference = false;
        if (this._context.get("com.ibm.ws.wssecurity.sc.dkt.externalURIReference") != null) {
            isExternalUriReference = (Boolean)this._context.get("com.ibm.ws.wssecurity.sc.dkt.externalURIReference");
        }
        if ((token = (SecurityToken)this._context.get("com.ibm.ws.wssecurity.sc.dkt.baseToken")) == null && isExternalUriReference) {
            String refTokenUUID = tokenId;
            String instance = (String)this._context.get("ImpliedDerivedKeyInstance");
            if (this._context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE) != null) {
                tokenType = (String)this._context.get(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
            }
            token = SCTConsumeLoginModule.resolveSCT(refTokenUUID, instance, messageContext, tokenType, context);
        }
        SCT sctoken = ((SCTWrapper)token).getSCT();
        String keyInstance = ((SCTWrapper)token).getCurrentInstance();
        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean bl = isAuthnEventsRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, context) || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context);
        if (isAuthnEventsRequired) {
            Map<String, Object> auditContext = wssAuditEventGenerator.setExtendedAuditData(this._context, "TokenId", token.getId());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "UUID", sctoken.getUUID());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "InstanceUUID", keyInstance);
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenClientSecret", sctoken.getClientSecret(keyInstance));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenServerSecret", sctoken.getServerSecret(keyInstance));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", sctoken.getSecret(keyInstance));
        this._context.put("com.ibm.ws.wssecurity.sc.dkt.baseToken", token);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processImpliedDerivedKey(");
            buf.append("SecurityTokenManager, Map)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    private final SecurityToken processElement(DKToken dkToken, OMElement targetElem, TokenConsumerConfig config2, boolean isWSSAPI, boolean isNone, boolean isEmb, SecurityTokenManager securityTokenManager, Map<Object, Object> context, String encAlg) throws LoginException {
        boolean isAuthnEventsRequired;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processElement(");
            buf.append("DKToken dkToken, ");
            buf.append("OMElement target[").append(DOMUtils.getDisplayName(targetElem)).append("], ");
            buf.append("TokenConsumerConfig config, ");
            buf.append("boolean isWSSAPI[").append(isWSSAPI).append("], ");
            buf.append("boolean isNone[").append(isNone).append("], ");
            buf.append("boolean isEmb[").append(isEmb).append("], ");
            buf.append("SecurityTokenManager securityTokenManager, Map context, String encAlg)");
            Tr.entry(tc, buf.toString());
        }
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        SecurityToken token = null;
        String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        String dktokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT_13;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Target Element namespace URI = " + targetElem.getNamespace().getNamespaceURI());
        }
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC.equals(targetElem.getNamespace().getNamespaceURI())) {
            tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT;
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
            dktokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT;
        }
        messageContext.setProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, tokenType);
        if (targetElem.getNamespace().getNamespaceURI().equals(nsWsc) && targetElem.getLocalName().equals("SecurityContextToken")) {
            OMElement elem = DOMUtils.getChildElement(targetElem, nsWsc, "Identifier");
            String uuid = DOMUtils.getStringValue(elem);
            QName s = IdUtils.getInstance().getIdAttributeName(targetElem);
            String refid = targetElem.getAttributeValue(s);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT id = " + refid + ", and token Value Type = " + tokenType);
            }
            OMElement instanceElem = DOMUtils.getChildElement(targetElem, nsWsc, "Instance");
            String instance = null;
            if (instanceElem != null) {
                instance = DOMUtils.getStringValue(instanceElem);
                if (instance == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "instance is null " + DOMUtils.toString(instanceElem));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "instance is = " + instance);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "instance element is null");
            }
            SCT sctoken = null;
            if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13.equals(tokenType)) {
                sctoken = new SCT13(uuid);
            }
            if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
                sctoken = new SCT(uuid);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT version =  [" + sctoken.getValueType().getLocalPart() + "].");
            }
            ((SCT)sctoken).setXML(new OMStructure(targetElem));
            if (refid != null) {
                sctoken.setId(refid);
                sctoken.setReferenceURI("#" + refid);
            }
            String algorithmSuite = null;
            String keySizeStr = "256";
            int keySize = 256;
            if (!isWSSAPI) {
                WSSConsumerConfig cconfig = (WSSConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                algorithmSuite = ((PolicyInboundConfig)cconfig).getAlgorithmSuite();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Algorithm Suite = " + algorithmSuite);
                }
                keySizeStr = PolicyConfigUtil.getMinimumSymmetricKeyLength(algorithmSuite);
                keySize = Integer.parseInt(keySizeStr);
            } else if (encAlg != null) {
                KeyAlgorithm ka = SCTGenerateLoginModule.getKeyAlgorithm(encAlg, false, true, false, false);
                keySize = ka.keyLength;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Key Size (in bits) based on the algorihthm Suite = " + keySize);
            }
            sctoken.setKeySize(keySize);
            SCTWrapper cachedToken = SCTConsumeLoginModule.verifySCT(sctoken, instance, isWSSAPI, messageContext, this._context);
            if (cachedToken != null) {
                String tid;
                SecurityToken existToken;
                cachedToken.setXML(new OMStructure(targetElem));
                if (refid != null) {
                    cachedToken.setId(refid);
                    cachedToken.setReferenceURI("#" + refid);
                }
                token = (existToken = securityTokenManager.getToken(config2, tid = cachedToken.getId())) == null ? cachedToken : existToken;
            }
        } else {
            messageContext.setProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE, tokenType);
            token = this.resolveReferencedToken(targetElem, messageContext, context);
        }
        SCT sctoken = ((SCTWrapper)token).getSCT();
        String keyInstance = ((SCTWrapper)token).getCurrentInstance();
        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean bl = isAuthnEventsRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, context) || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, context);
        if (isAuthnEventsRequired) {
            Map<String, Object> auditContext = wssAuditEventGenerator.setExtendedAuditData(this._context, "TokenId", token.getId());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "UUID", sctoken.getUUID());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "InstanceUUID", keyInstance);
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenClientSecret", sctoken.getClientSecret(keyInstance));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenServerSecret", sctoken.getServerSecret(keyInstance));
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", sctoken.getSecret(keyInstance));
        this._context.put("com.ibm.ws.wssecurity.sc.dkt.baseToken", token);
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("processElement(");
            buf.append("DKToken, OMElement, TokenConsumerConfig, ");
            buf.append("boolean, boolean, boolean, securityTokenManager, Map)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final SCTWrapper verifySCT(SCT sct, String keyInstance, boolean isWSSAPI, MessageContext messageContext, Map context) throws LoginException {
        SCTWrapper sctWrapper;
        block33: {
            SCT newsct;
            String tokenType;
            block32: {
                block31: {
                    if (tc.isEntryEnabled()) {
                        StringBuffer buf = new StringBuffer("verifySCT(SCT sct, ");
                        buf.append("String keyInstance(").append(keyInstance).append("], ");
                        buf.append("boolean isWSSAPI(").append(isWSSAPI).append("], ");
                        buf.append("MessageContext messageContext, ");
                        buf.append("HashMap context)");
                        Tr.entry(tc, buf.toString());
                    }
                    boolean isServer = false;
                    try {
                        isServer = Axis2Util.isServiceProvider(messageContext);
                    }
                    catch (Exception e) {
                        throw new LoginException(e.getMessage());
                    }
                    tokenType = sct.getValueType().getLocalPart();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SCT version =  [" + tokenType + "].");
                    }
                    sctWrapper = null;
                    String cacheKey = null;
                    cacheKey = keyInstance != null ? sct.getUUID() + keyInstance : sct.getUUID();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SCT cache key =  [" + cacheKey + "].");
                    }
                    if (!isServer) break block32;
                    newsct = null;
                    if (SCTHelper.getCache() != null) {
                        newsct = (SCT)SCTHelper.getCache().getToken(cacheKey);
                    }
                    if (newsct == null) {
                        try {
                            newsct = (SCT)STSTokenUtil.getToken(cacheKey, tokenType);
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block31;
                            Tr.debug(tc, "Exception while getting SCT from trust service:" + e.getMessage());
                        }
                    }
                }
                if (newsct == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Can not find SCT from trust server cache.");
                    }
                    QName soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT02", tokenType);
                    context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
                }
                if (keyInstance == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No instance information in the message");
                    }
                    keyInstance = SCTConsumeLoginModule.searchFirstInstance(newsct);
                }
                if ((newsct = SCTConsumeLoginModule.checkKeyInstance(newsct, keyInstance, tokenType)) != null && keyInstance != null && newsct.isValid(keyInstance, 0L)) {
                    try {
                        String endpointAddress = messageContext.getTo().getAddress();
                        boolean isValid = newsct.validateAppliesToURI(endpointAddress);
                        if (!isValid) {
                            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT05", new String[]{endpointAddress, newsct.getAppliesTo(0)}));
                        }
                        newsct.setKeySize(sct.getKeySize());
                        newsct.valueType = new QName("", tokenType);
                    }
                    catch (Exception ex) {
                        throw new LoginException(ex.getMessage());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server side, saving the token in message context context using the WSSECURITY_SECURECONVERSATION_IDENTIFIER as key and uuid = " + newsct.getUUID());
                        Tr.debug(tc, "Server side, saving the token in message context using INBOUND_SCTOKEN as key, token uuid = " + newsct.getUUID());
                        Tr.debug(tc, "Saving the instance in message context = " + keyInstance);
                    }
                    HashMap<String, String> wssMap = null;
                    wssMap = (HashMap<String, String>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (wssMap == null) {
                        wssMap = new HashMap<String, String>();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Save the uuid and instance in the wss-ramp propertymap");
                        }
                    }
                    wssMap.put(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, newsct.getUUID());
                    wssMap.put("com.ibm.ws.wssecurity.sc.InstanceFromMessage", keyInstance);
                    wssMap.put("tokenVTypeFromInboundMessage", tokenType);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", wssMap);
                    messageContext.setProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, newsct.getUUID());
                    messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", keyInstance);
                    messageContext.setProperty("tokenVTypeFromInboundMessage", tokenType);
                    TokenHolder.setInboundTokenToContext(newsct, messageContext);
                    sctWrapper = SCTGenerateLoginModule.createSCTWrapper(newsct, keyInstance);
                    sctWrapper.setXML(sct.getXML());
                    sctWrapper.setSCT(newsct);
                    break block33;
                } else {
                    if (newsct == null) {
                        QName soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT02", tokenType);
                        context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                        throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
                    }
                    QName soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT", tokenType);
                    context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.invalidSCT"));
                }
            }
            newsct = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(sct.getUUID());
            if (keyInstance == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No instance information in the message");
                }
                if (newsct.getInstances() != null) {
                    keyInstance = SCTConsumeLoginModule.searchFirstInstance(newsct);
                }
            }
            if (newsct != null && keyInstance != null && newsct.isValid(keyInstance, 0L)) {
                sctWrapper = SCTGenerateLoginModule.createSCTWrapper(newsct, keyInstance);
                sctWrapper.setXML(sct.getXML());
                sctWrapper.setKeySize(sct.getKeySize());
                sctWrapper.setSCT(newsct);
                messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", keyInstance);
            } else {
                QName soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT03", tokenType);
                context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                if (newsct == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Null SCT");
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid SCT");
                }
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("verifySCT(SCT, String, ");
            buf.append("boolean, MessageContext)");
            buf.append(" returns SCTWrapper[").append(sctWrapper).append("]");
            Tr.exit(tc, buf.toString());
        }
        return sctWrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final SCTWrapper resolveSCT(String uuid, String keyInstance, MessageContext messageContext, String tokenType, Map context) throws LoginException {
        SCTWrapper sctWrapper;
        block32: {
            SCT newsct;
            block31: {
                block30: {
                    if (tc.isEntryEnabled()) {
                        StringBuffer buf = new StringBuffer("resolveSCT(String uuid, ");
                        buf.append("String keyInstance [").append(keyInstance).append("], ");
                        buf.append("MessageContext messageContext, ");
                        buf.append("String tokenType [").append(tokenType).append("], ");
                        buf.append("Map context )");
                        Tr.entry(tc, buf.toString());
                    }
                    boolean isServer = false;
                    try {
                        isServer = Axis2Util.isServiceProvider(messageContext);
                    }
                    catch (Exception e) {
                        throw new LoginException(e.getMessage());
                    }
                    sctWrapper = null;
                    String cacheKey = null;
                    cacheKey = keyInstance != null ? uuid + keyInstance : uuid;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SCT cache key =  [" + cacheKey + "].");
                    }
                    if (!isServer) break block31;
                    newsct = null;
                    if (SCTHelper.getCache() != null) {
                        newsct = (SCT)SCTHelper.getCache().getToken(cacheKey);
                    }
                    if (newsct == null) {
                        try {
                            newsct = (SCT)STSTokenUtil.getToken(cacheKey, tokenType);
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block30;
                            Tr.debug(tc, "Exception while getting SCT from trust service:" + e.getMessage());
                        }
                    }
                }
                if (newsct == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Can not find SCT from trust server cache.");
                    }
                    QName soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT02", tokenType);
                    context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
                }
                if (keyInstance == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No instance information in the message");
                    }
                    keyInstance = SCTConsumeLoginModule.searchFirstInstance(newsct);
                }
                if ((newsct = SCTConsumeLoginModule.checkKeyInstance(newsct, keyInstance, tokenType)) != null && keyInstance != null && newsct.isValid(keyInstance, 0L)) {
                    try {
                        String endpointAddress = messageContext.getTo().getAddress();
                        boolean isValid = newsct.validateAppliesToURI(endpointAddress);
                        if (!isValid) {
                            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT05", new String[]{endpointAddress, newsct.getAppliesTo(0)}));
                        }
                    }
                    catch (Exception ex) {
                        throw new LoginException(ex.getMessage());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server side, saving the token in message context context using the WSSECURITY_SECURECONVERSATION_IDENTIFIER as key and uuid = " + newsct.getUUID());
                        Tr.debug(tc, "Server side, saving the token in message context using INBOUND_SCTOKEN as key, token uuid = " + newsct.getUUID());
                        Tr.debug(tc, "Saving the instance in message context = " + keyInstance);
                    }
                    newsct.valueType = new QName("", tokenType);
                    HashMap<String, String> wssMap = null;
                    wssMap = (HashMap<String, String>)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (wssMap == null) {
                        wssMap = new HashMap<String, String>();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Save the uuid and instance in the wss-ramp propertymap");
                        }
                    }
                    wssMap.put(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, newsct.getUUID());
                    wssMap.put("com.ibm.ws.wssecurity.sc.InstanceFromMessage", keyInstance);
                    wssMap.put("tokenVTypeFromInboundMessage", tokenType);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", wssMap);
                    messageContext.setProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, newsct.getUUID());
                    messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", keyInstance);
                    messageContext.setProperty("tokenVTypeFromInboundMessage", tokenType);
                    TokenHolder.setInboundTokenToContext(newsct, messageContext);
                    sctWrapper = SCTGenerateLoginModule.createSCTWrapper(newsct, keyInstance);
                    sctWrapper.setXML(newsct.getXML());
                    sctWrapper.setSCT(newsct);
                    break block32;
                } else {
                    if (newsct == null) {
                        QName soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT02", tokenType);
                        context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                        throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
                    }
                    QName soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT", tokenType);
                    context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.invalidSCT"));
                }
            }
            newsct = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(uuid);
            if (keyInstance == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No instance information in the message");
                }
                if (newsct.getInstances() != null) {
                    keyInstance = SCTConsumeLoginModule.searchFirstInstance(newsct);
                }
            }
            if (newsct != null && keyInstance != null && newsct.isValid(keyInstance, 0L)) {
                newsct.valueType = new QName("", tokenType);
                sctWrapper = SCTGenerateLoginModule.createSCTWrapper(newsct, keyInstance);
                sctWrapper.setXML(newsct.getXML());
                sctWrapper.setKeySize(newsct.getKeySize());
                sctWrapper.setSCT(newsct);
                messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", keyInstance);
            } else {
                QName soapFault = SCTGenerateLoginModule.generateSoapFault("invalidSCT03", tokenType);
                context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                if (newsct == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Null SCT");
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid SCT");
                }
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveSCT(String, String, ");
            buf.append("boolean, MessageContext)");
            buf.append(" returns SCTWrapper[").append(sctWrapper).append("]");
            Tr.exit(tc, buf.toString());
        }
        return sctWrapper;
    }

    private static SCT checkKeyInstance(SCT oldSCT, String keyInstance, String tokenType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyInstance");
        }
        String[] allInstance = oldSCT.getInstances();
        for (int i = 0; i < allInstance.length; ++i) {
            if (!allInstance[i].equalsIgnoreCase(keyInstance)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching key instance in SCT.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkKeyInstance");
            }
            return oldSCT;
        }
        long timeout = oldSCT.getExpiration(allInstance[0]).getTime() - oldSCT.getCreation(allInstance[0]).getTime();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not Found matching key instance in SCT in the cluster server??. Retry from primary cache.");
        }
        SCT newSCT = null;
        int loop = 0;
        boolean Found = false;
        String cacheKey = oldSCT.getUUID() + keyInstance;
        while (!Found && loop < 10) {
            block18: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Found matching key instance in SCT. Retry from cache " + loop + 1 + " times.");
                }
                try {
                    if (jdbcEnabled) {
                        if (SCTHelper.getCache() != null) {
                            newSCT = (SCT)SCTHelper.getCache().getTokenFromDatabase(cacheKey, timeout);
                        }
                        loop += 5;
                    } else {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        newSCT = (SCT)STSTokenUtil.getToken(cacheKey, tokenType);
                        ++loop;
                    }
                    allInstance = newSCT.getInstances();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug(tc, "Exception while getting SCT from trust service:" + e.getMessage());
                }
            }
            for (int i = 0; i < allInstance.length; ++i) {
                if (!allInstance[i].equalsIgnoreCase(keyInstance)) continue;
                Found = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found matching key instance in SCT during " + loop + 1 + " retry.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkKeyInstance");
                }
                return newSCT;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyInstance Fails.");
        }
        return oldSCT;
    }

    private SecurityToken resolveReferencedToken(OMElement target, MessageContext messageContext, Map<Object, Object> context) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveReferencedToken(");
            buf.append("OMElement target(").append(DOMUtils.getDisplayName(target)).append("], ");
            buf.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken referencedToken = null;
        String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT_13;
        String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
        tokenType = (String)messageContext.getProperty(com.ibm.ws.wssecurity.common.Constants.SCT_TOKEN_VALUE_TYPE);
        if (com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT.equals(tokenType)) {
            nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
        }
        if (target != null && target.getNamespace().getNamespaceURI().equals(nsWsc) && target.getLocalName().equals("DerivedKeyToken")) {
            Object refTokenId = null;
            String refTokenUUID = null;
            String ttype = null;
            String instance = null;
            OMElement elem = DOMUtils.getChildElement(target, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "SecurityTokenReference");
            if (elem != null) {
                elem = DOMUtils.getChildElement(elem, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "Reference");
                String refTokenUri = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.URI_Q);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reference Token URI in DerivedKeyToken element: " + refTokenUri);
                }
                if (refTokenUri.startsWith("#")) {
                    referencedToken = (SecurityToken)this._context.get("com.ibm.ws.wssecurity.sc.dkt.baseToken");
                } else {
                    refTokenUUID = refTokenUri;
                    QName INSTANCE_Q = new QName(nsWsc, "Instance");
                    instance = elem.getAttributeValue(INSTANCE_Q);
                    referencedToken = SCTConsumeLoginModule.resolveSCT(refTokenUUID, instance, messageContext, tokenType, context);
                }
                ttype = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("resolveReferencedToken(");
            buf.append("OMElement, MessageContext, Map)");
            Tr.exit(tc, buf.toString());
        }
        return referencedToken;
    }

    public static final String getUUIDByRef(String ref, MessageContext messageContext, Map<Object, Object> context, String nsWsc) {
        IDResolver idResolver;
        OMElement elem;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getUUIDByRef(");
            buf.append("String ref(").append(ref).append("], ");
            buf.append("MessageContext messageContext, Map context, ");
            buf.append("String nsWsc[").append(nsWsc).append("])");
            Tr.entry(tc, buf.toString());
        }
        String uuid = null;
        SOAPEnvelope soapEnv = messageContext.getEnvelope();
        SOAPHeader soapHead = soapEnv.getHeader();
        OMDocument doc = DOMUtil.getOwnerDocument(soapHead);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The original RM message to be processed : ");
            CommonLogUtils.logDebug(doc.getOMDocumentElement(), tc);
        }
        if ((elem = (idResolver = (IDResolver)context.get("com.ibm.ws.wssecurity.util.selector.IDResolver")).resolveID(doc, ref)) != null) {
            OMElement elem2;
            if (LocalNameConstants.LocalNamesWSC.LN_SECURITY_CONTEXT_TOKEN.equals(elem.getLocalName()) && nsWsc.equals(elem.getNamespace().getNamespaceURI()) && (elem2 = DOMUtils.getChildElement(elem, nsWsc, "Identifier")) != null) {
                uuid = DOMUtils.getStringValue(elem2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found the matching SCT(Attached reference) for wsu:Id = " + ref + ", the uuid Identifier = " + uuid);
                }
            }
            if (uuid == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "No SecurityContextToken element with the wsu:Id = " + ref + " Found.");
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getUUIDByRef(String, ");
            buf.append("MessageContext, Map) returns String[").append(uuid).append("]");
            Tr.exit(tc, buf.toString());
        }
        return uuid;
    }

    public static String searchFirstInstance(SCT sctoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchFirstInstance(SCT sctoken): No instance in Message, Use first issued instance.");
        }
        if (sctoken == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchFirstInstanceList(SCT sctoken): no SCT.");
            }
            return null;
        }
        String instance = null;
        Date now = new Date();
        String[] list = sctoken.getInstances();
        if (list == null || list.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchFirstInstance(SCT sctoken): no key instance.");
            }
            return null;
        }
        instance = list[0];
        if (tc.isDebugEnabled()) {
            if (sctoken.getExpiration(instance).after(now)) {
                Tr.debug(tc, "First Instance:" + instance);
            } else {
                Tr.debug(tc, "First Instance expired:" + instance);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchFirstInstanceList(SCT sctoken)");
        }
        return instance;
    }
}

