/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.X509GenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509PKCS7Token;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509GenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509PKCS7TokenImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.apache.axis2.context.MessageContext;

public class PKCS7GenerateLoginModule
extends X509GenerateLoginModule {
    private static final TraceComponent tc = Tr.register(PKCS7GenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PKCS7GenerateLoginModule.class.getName();

    public boolean login() throws LoginException {
        boolean isKeyName;
        boolean isKeyId;
        boolean isStrref;
        boolean isEmb;
        boolean isX509;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        X509GenerateCallback x509Callback = new X509GenerateCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbacks = new Callback[]{x509Callback, propertyCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, clsName + ".login", "71", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", e);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
        }
        this._context = propertyCallback.getProperties();
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        KeyStoreManager ksManager = KeyStoreManager.getInstance();
        KeyStoreManager.KeyInformation keyInformation = null;
        if (x509Callback.isUsedRequestorCertificate()) {
            Object obj = messageContext.getProperty("com.ibm.xml.soapsec.RequestCert");
            if (obj == null || !(obj instanceof X509Certificate)) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6808E");
                throw new LoginException(errorMes);
            }
            X509Certificate x509 = (X509Certificate)obj;
            try {
                keyInformation = ksManager.getKeyInformation(x509);
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "104", this);
                throw new LoginException(e.toString());
            }
        }
        try {
            keyInformation = ksManager.getKeyInformationInPKCS7(x509Callback.getKeyStorePath(), x509Callback.getKeyStoreType(), x509Callback.getKeyStorePassword(), x509Callback.getKeyStoreReference(), x509Callback.getAlias(), x509Callback.getKeyPassword(), x509Callback.getKeyName(), x509Callback.getCertStores());
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".login", "117", this);
            throw new LoginException(e.toString());
        }
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        SecurityToken existToken = null;
        String tokenId = null;
        try {
            Certificate cert = keyInformation.getCertificate();
            tokenId = keyInformation.getSubjectDN();
            existToken = PKCS7GenerateLoginModule.getToken(config2, keyInfoType, cert, this._securityTokenManager);
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".login", "134", this);
            throw new LoginException(e.toString());
        }
        boolean isStandAlone = config2.isStandAlone();
        if (keyInfoType == null) {
            isX509 = false;
            isEmb = false;
            isStrref = false;
            isKeyId = false;
            isKeyName = false;
        } else {
            isKeyName = ConfigUtil.isKeyInfoKeyname(keyInfoType);
            isKeyId = ConfigUtil.isKeyInfoKeyid(keyInfoType);
            isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb(keyInfoType);
            isX509 = ConfigUtil.isKeyInfoX509issuer(keyInfoType);
        }
        if (existToken == null) {
            Object parent = this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            X509PKCS7TokenImpl pkcs7Token = new X509PKCS7TokenImpl();
            try {
                tokenId = null;
                if (isStandAlone) {
                    tokenId = IdUtils.getInstance().makeUniqueId(this._context, "x509bst_");
                    pkcs7Token.setId(tokenId);
                    PKCS7GenerateLoginModule.createTokenElement(parent, config2.getType(), keyInformation, pkcs7Token, true, this._context);
                    this._processedTokens.add(pkcs7Token);
                    this._insertedTokens.add(pkcs7Token);
                } else if (isStrref) {
                    tokenId = IdUtils.getInstance().makeUniqueId(this._context, "x509bst_");
                    pkcs7Token.setId(tokenId);
                    pkcs7Token.setReferenceURI("#" + tokenId);
                    PKCS7GenerateLoginModule.createTokenElement(parent, config2.getType(), keyInformation, pkcs7Token, true, this._context);
                    this._processedTokens.add(pkcs7Token);
                    this._insertedTokens.add(pkcs7Token);
                } else if (isEmb) {
                    tokenId = IdUtils.getInstance().makeUniqueId(this._context, "x509bst_");
                    pkcs7Token.setId(tokenId);
                    PKCS7GenerateLoginModule.createTokenElement(parent, config2.getType(), keyInformation, pkcs7Token, false, this._context);
                    this._processedTokens.add(pkcs7Token);
                    this._insertedTokens.add(pkcs7Token);
                } else if (isKeyId) {
                    QName etype = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
                    QName idtype = (QName)this._context.get(Constants.WSSECURITY_KEY_IDTYPE);
                    tokenId = PKCS7GenerateLoginModule.getKeyIdentifier(keyInformation, etype, idtype);
                    pkcs7Token.setId(tokenId);
                    pkcs7Token.setKeyIdentifier(tokenId);
                    this._processedTokens.add(pkcs7Token);
                } else if (isKeyName) {
                    tokenId = keyInformation.getSubjectDN();
                    pkcs7Token.setId(tokenId);
                    pkcs7Token.setKeyName(tokenId);
                    this._processedTokens.add(pkcs7Token);
                } else if (isX509) {
                    String issuerName = keyInformation.getIssuerDN();
                    String issuerSerial = keyInformation.getIssuerSerial();
                    tokenId = issuerName + ":" + issuerSerial;
                    pkcs7Token.setId(tokenId);
                    pkcs7Token.setIssuerName(issuerName);
                    pkcs7Token.setIssuerSerial(issuerSerial);
                    this._processedTokens.add(pkcs7Token);
                }
                pkcs7Token.setId(tokenId);
                final X509PKCS7TokenImpl temppkcs7Token = pkcs7Token;
                final X509Certificate tempx509 = (X509Certificate)keyInformation.getCertificate();
                final byte[] tempbinary = keyInformation.getBinary();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        temppkcs7Token.setCertificate(tempx509);
                        temppkcs7Token.setBinary(tempbinary);
                        return null;
                    }
                });
                pkcs7Token.setKey(62, keyInformation.getPublicOrSecretKey());
                pkcs7Token.setKey(61, keyInformation.getPrivateOrSecretKey());
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "231", this);
                throw new LoginException(e.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There is the token [" + existToken.getId() + "] stored in the Subject.");
        }
        if (isStandAlone) {
            this._processedTokens.add(existToken);
        } else if (isStrref) {
            this._processedTokens.add(existToken);
        } else if (isEmb) {
            X509PKCS7TokenImpl pkcs7Token = new X509PKCS7TokenImpl();
            try {
                pkcs7Token.setId(IdUtils.getInstance().makeUniqueId(this._context, "x509bst_"));
                final X509PKCS7TokenImpl temppkcs7Token = pkcs7Token;
                final X509Certificate tempx509 = (X509Certificate)keyInformation.getCertificate();
                final byte[] tempbinary = keyInformation.getBinary();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        temppkcs7Token.setCertificate(tempx509);
                        temppkcs7Token.setBinary(tempbinary);
                        return null;
                    }
                });
                pkcs7Token.setKey(62, keyInformation.getPublicOrSecretKey());
                pkcs7Token.setKey(61, keyInformation.getPrivateOrSecretKey());
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, clsName + ".login", "262", this);
                throw new LoginException(e.toString());
            }
            this._processedTokens.add(pkcs7Token);
            this._insertedTokens.add(pkcs7Token);
        } else if (isKeyId) {
            this._processedTokens.add(existToken);
        } else if (isKeyName) {
            this._processedTokens.add(existToken);
        } else if (isX509) {
            this._processedTokens.add(existToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig config2, String keyInfoType, Certificate cert, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("Certificate cert, SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        SecurityToken token = null;
        Collection<SecurityToken> tokens = securityTokenManager.getTokens(config2, keyInfoType);
        if (tokens != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                if (!(t instanceof X509PKCS7Token) || !((X509PKCS7Token)t).getCertificate().equals(cert)) continue;
                token = t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig, String, Certificate, SecurityTokenManager)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }
}

