/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.BinarySecurityTokenImpl;
import com.ibm.wsspi.security.token.AuthenticationToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Enumeration;

public class LTPATokenImpl
extends BinarySecurityTokenImpl
implements LTPAToken,
AuthenticationToken {
    private static final TraceComponent tc = Tr.register(LTPATokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = -1474812800604914136L;
    private static final SecurityPermission SETBYTES_PERM = new SecurityPermission("wssapi.LTPATokenImpl.setBytes");
    private static final SecurityPermission GETBYTES_PERM = new SecurityPermission("wssapi.LTPATokenImpl.getBytes");
    private boolean isForwardable = true;
    private int hashCode = 0;
    private byte[] serializationBytes = null;
    public static final String authenticationTokenName = "security.wssecurity_http://www.ibm.com/websphere/appserver/tokentype/5.0.2#LTPA";

    public LTPATokenImpl() {
        this.valueType = LTPAToken.ValueType;
        this.tokenQName = LTPAToken.TokenQname;
    }

    public void initialize(byte[] encodedToken) {
        block2: {
            this.serializationBytes = encodedToken;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(encodedToken);
            try {
                ObjectInputStream inObjStream = new ObjectInputStream(byteStream);
                this.readExternal(inObjStream);
                inObjStream.close();
                byteStream.close();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to deserialize Token. ", e.getStackTrace());
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isForwardable = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isForwardable);
    }

    public boolean isForwardable() {
        return this.isForwardable;
    }

    public void setIsForwardable(boolean forward) {
        if (!this.readOnly) {
            this.isForwardable = forward;
        }
    }

    public String getUniqueID() {
        String uid = null;
        final LTPATokenImpl lt = this;
        byte[] tokenBinary = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return lt.getBinary();
            }
        });
        uid = new String(tokenBinary);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUniqueID() = " + uid);
        }
        return uid;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            LTPATokenImpl lt;
            byte[] tokenBinary;
            int hash = 0;
            if (this.getId() != null) {
                hash = this.getId().hashCode();
            }
            if ((tokenBinary = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(lt = this){
                final /* synthetic */ LTPATokenImpl val$lt;
                {
                    this.val$lt = lTPATokenImpl2;
                }

                @Override
                public Object run() {
                    return this.val$lt.getBinary();
                }
            })) != null) {
                hash += new String(tokenBinary).hashCode();
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LTPAToken)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public byte[] getBytes() {
        block7: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GETBYTES_PERM.toString());
                }
                sm.checkPermission(GETBYTES_PERM);
            }
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream outObjStream = new ObjectOutputStream(byteStream);
                this.writeExternal(outObjStream);
                outObjStream.close();
                byteStream.close();
                this.serializationBytes = byteStream.toByteArray();
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Fail to serialize Token. ", e.getStackTrace());
            }
        }
        if (tc.isDebugEnabled()) {
            if (this.serializationBytes == null) {
                Tr.debug(tc, "The string value of ltpaToken.getBytes is NULL");
            } else {
                Tr.debug(tc, "The string value of ltpaToken.getBytes :: " + new String(this.serializationBytes));
            }
        }
        return this.serializationBytes;
    }

    public void setBytes(byte[] sBytes) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETBYTES_PERM.toString());
            }
            sm.checkPermission(SETBYTES_PERM);
        }
        if (!this.readOnly) {
            this.serializationBytes = sBytes;
        }
    }

    public String getName() {
        return authenticationTokenName;
    }

    public short getVersion() {
        return 1;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String[] getAttributes(String key) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String[] addAttribute(String key, String value) {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public long getExpiration() {
        return -1L;
    }

    public Object clone() {
        return null;
    }
}

