/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.SubjectCache;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.TokenPropagationCallbackHandler;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAPropagationTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class LTPAPropagationConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAPropagationConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPAPropagationConsumeLoginModule.class.getName();
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManagerImpl _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        boolean isAuthnEventsRequired;
        SubjectCache cache;
        WSCredentialTokenMapperInterface wsCredTokenMapper;
        ArrayList tokenList;
        String cacheKeyString;
        Object[] returned_objects;
        Subject subject;
        String tokenId;
        LTPAPropagationTokenImpl ltpaToken;
        block50: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            PropertyCallback propertyCallback = new PropertyCallback(null);
            Callback[] callbacks = new Callback[]{propertyCallback};
            try {
                this._handler.handle(callbacks);
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, clsName + ".login", "134", this);
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{e.toString()}));
            }
            this._context = propertyCallback.getProperties();
            TokenConsumerConfig config2 = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
            ltpaToken = new LTPAPropagationTokenImpl();
            this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, ltpaToken);
            QName vtype = config2.getType();
            if (!com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN_PROPAGATION.equals(vtype)) {
                String errorMes = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{vtype.toString(), com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN_PROPAGATION.toString()});
                throw new LoginException(errorMes);
            }
            OMElement target = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            ltpaToken.setXML(new OMStructure(target));
            tokenId = null;
            QName idattr = IdUtils.getInstance().getIdAttributeName(target);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute of the target element is [" + idattr + "].");
            }
            if (idattr != null) {
                tokenId = target.getAttributeValue(idattr);
            }
            ltpaToken.setId(tokenId);
            String encoded = DOMUtils.getStringValue(target);
            byte[] binary = Base64.decode(encoded);
            subject = null;
            returned_objects = null;
            cacheKeyString = null;
            tokenList = null;
            wsCredTokenMapper = null;
            wsCredTokenMapper = _wsCredToken._wsCredTokenMapper;
            WSSContextManager manager = WSSContextManagerFactory.getInstance();
            cache = null;
            if (manager == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSSContextManager object missing");
                }
            } else {
                cache = manager.getSubjectCache();
            }
            try {
                tokenList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(binary);
                returned_objects = this.getSubjectFromTokenHolderCacheKey(null, tokenList, cache);
            }
            catch (WSSecurityException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught WSSecurityException trying to get cached Subject: " + e);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block50;
                Tr.debug(tc, "Caught Exception trying to get cached Subject: " + e);
            }
        }
        if (returned_objects != null) {
            subject = (Subject)returned_objects[0];
            cacheKeyString = (String)returned_objects[1];
        }
        WSCredential credential = null;
        WSPrincipal principal = null;
        if (subject != null) {
            credential = SubjectHelper.getWSCredentialFromSubject(subject);
            principal = SubjectHelper.getPrincipalFromSubject(subject);
            if (credential != null) {
                boolean is_destroyed = credential.isDestroyed();
                boolean is_forwardable = false;
                try {
                    is_forwardable = credential.isForwardable();
                }
                catch (Exception e) {
                    is_destroyed = true;
                }
                boolean isSubjectValid = false;
                if (cache != null && wsCredTokenMapper != null) {
                    isSubjectValid = wsCredTokenMapper.checkCushionValidityOfAllTokens(subject, cache.getCushion());
                }
                if (tc.isDebugEnabled()) {
                    if (is_forwardable) {
                        Tr.debug(tc, "credential is forwardable, subject valid = " + isSubjectValid);
                    } else {
                        Tr.debug(tc, "non-forwardable Subject");
                    }
                }
                if (is_destroyed || is_forwardable && !isSubjectValid) {
                    subject = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached subject is valid.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSCredential in Subject, logging in again.");
                }
                subject = null;
            }
        }
        if (subject == null) {
            credential = null;
            principal = null;
            String jaasConfig = "system.WSS_INBOUND";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using JAAS config: " + jaasConfig);
            }
            int tokenListSize = 0;
            if (tokenList != null) {
                tokenListSize = tokenList.size();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenList size = " + tokenListSize);
            }
            byte[] credBytes = null;
            for (int i = 0; i < tokenListSize; ++i) {
                Object objx = tokenList.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tokenList object [" + i + "] = " + objx.getClass().getName());
                }
                if (!(objx instanceof TokenHolder)) continue;
                TokenHolder th = (TokenHolder)objx;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "th[" + i + "].name = " + th.getName());
                    Tr.debug(tc, "th[" + i + "].version = " + th.getVersion());
                }
                if (!"com.ibm.ws.security.token.AuthorizationTokenImpl".equals(th.getName())) continue;
                credBytes = th.getBytes();
                if (!tc.isDebugEnabled()) continue;
                if (credBytes != null && credBytes.length > 0) {
                    Tr.debug(tc, "Got cred bytes from authz TokenHolder");
                    continue;
                }
                Tr.debug(tc, "Cred bytes from authz TokenHolder was null or zero-length");
            }
            LoginContext lc = null;
            try {
                TokenPropagationCallbackHandler cbh = new TokenPropagationCallbackHandler(this._context, tokenList, credBytes);
                lc = new LoginContext(jaasConfig, cbh);
                lc.login();
            }
            catch (LoginException e) {
                Tr.processException((Throwable)e, clsName + ".login()", "313", this);
                throw new LoginException("Error logging in: " + e.getClass().getName() + ": " + e.getMessage());
            }
            subject = lc.getSubject();
            if (cacheKeyString == null || cacheKeyString.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No cache key string found in token list; will not cache new subject.");
                }
            } else if (cache != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caching new subject with cache key string: " + cacheKeyString);
                }
                cache.insert(subject, new Object[]{cacheKeyString});
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not caching new subject because Securitycache instance is null.");
            }
            credential = SubjectHelper.getWSCredentialFromSubject(subject);
            principal = SubjectHelper.getPrincipalFromSubject(subject);
        }
        this._securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        if (subject != null) {
            this._securityTokenManager.addToSubject(subject);
        }
        ltpaToken.setWSCredential(credential);
        ltpaToken.setWSPrincipal(principal);
        try {
            ltpaToken.setBinary(credential.getCredentialToken());
        }
        catch (CredentialDestroyedException e) {
            throw new LoginException(e.getMessage());
        }
        ltpaToken.setPrincipal(principal.getName());
        WSSAuditService wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        WSSAuditEventGenerator wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean bl = isAuthnEventsRequired = wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, this._context) || wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, this._context);
        if (isAuthnEventsRequired) {
            Map<String, Object> auditContext = wssAuditEventGenerator.setExtendedAuditData(this._context, "TokenId", tokenId);
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "Username", ltpaToken.getPrincipal());
            wssAuditEventGenerator.addExtendedAuditData(auditContext, "Expiration", new Long(ltpaToken.getExpiration()).toString());
        }
        this._token = ltpaToken;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] token, List tokenHolderList, SubjectCache cache) throws Exception {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getSubjectFromTokenHolderCacheKey(");
            buf.append("byte[] token[");
            buf.append(token == null ? "null" : "not null").append("], ");
            buf.append("List tokenHolderList)");
            Tr.entry(tc, buf.toString());
        }
        Subject subject = null;
        String cacheKeyString = null;
        if (tokenHolderList != null) {
            for (int i = 0; i < tokenHolderList.size(); ++i) {
                boolean tokenMatches;
                TokenHolder th = (TokenHolder)tokenHolderList.get(i);
                if (!th.getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] cacheKeyBytes = th.getBytes();
                if (cacheKeyBytes != null) {
                    cacheKeyString = StringBytesConversion.getConvertedString((byte[])cacheKeyBytes);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cache key from token holder list: " + cacheKeyString);
                    }
                    subject = cache.getSubject(cacheKeyString);
                }
                if (subject == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Subject using cacheKey from prop token.");
                }
                if (token == null) continue;
                WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken ssoToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                boolean bl = tokenMatches = wsCred != null && Arrays.equals(token, wsCred.getCredentialToken()) || ssoToken != null && Arrays.equals(token, ssoToken.getBytes());
                if (tokenMatches) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject found from cacheKey does not have matching LTPA token.");
                }
                subject = null;
            }
        }
        Object[] return_objects = null;
        if (subject != null || cacheKeyString != null) {
            return_objects = new Object[]{subject, cacheKeyString};
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getSubjectFromTokenHolderCacheKey(");
            buf.append("byte[], List) returns Object[][");
            buf.append(return_objects == null ? "null" : "not null").append("]");
            Tr.exit(tc, buf.toString());
        }
        return return_objects;
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> wrapperClass = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object wrapperObj = wrapperClass.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)wrapperObj;
            }
            catch (Exception ex) {
                Tr.processException(ex, clsName + "init", "657");
            }
        }
    }
}

