/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.crypto.provider.AESKeySpec;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.wss.KerberosTokenGenerator;
import com.ibm.websphere.wssecurity.callbackhandler.KRBTokenGenerateCallback;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.handler.token.SimpleTargetURLCache;
import com.ibm.ws.wssecurity.platform.auth.WSSContext;
import com.ibm.ws.wssecurity.platform.auth.WSSContextFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.KRB5TokenCacheUtil;
import com.ibm.ws.wssecurity.util.KRB5Util;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.SimpleTargetURL;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.KRB5TokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.TGSAuthToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.TGTAuthToken;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactoryFactory;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRBGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(KRBGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KRBGenerateLoginModule.class.getName();
    private static final String newline = "\n";
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XMLENC_NS = "http://www.w3.org/2001/04/xmlenc#";
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String HMAC = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private static final HexDumpEncoder hexDumper = new HexDumpEncoder();
    private static final String endptAddress_JAXWS = "javax.xml.ws.service.endpoint.address";
    private boolean loginSucceeded = false;
    private boolean derivedkeyInfoConfigured = false;
    private boolean useDerivedKey = false;
    private boolean usingWSSAPI = false;
    private boolean isServer = false;
    private boolean isRequest = true;
    private boolean isStandAlone = false;
    private MessageContext messageContext = null;
    private OMNode _referencedTokenElement = null;
    private Subject _subject;
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map _options;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;
    private static KRBAuthnTokenFactory _tokenFactory = KRBAuthnTokenFactoryFactory.getFactory();

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int il = this._processedTokens.size();
        for (int i = 0; i < il; ++i) {
            SecurityToken token = this._processedTokens.get(i);
            this._securityTokenManager.addToken(token);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        boolean isKeyIdentifier = ConfigUtil.isKeyInfoKeyid(keyInfoType);
        if (!isKeyIdentifier) {
            this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KEYID is " + isKeyIdentifier + "...Not inserting token.");
        }
        this._context.put(Constants.WSSECURITY_TOKENELEMENT_REFERENCED, this._referencedTokenElement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._subject = subject;
        this._handler = handler;
        this._sharedState = sharedState;
        this._options = options;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean login() throws LoginException {
        if (KRBGenerateLoginModule.tc.isEntryEnabled()) {
            Tr.entry(KRBGenerateLoginModule.tc, "login()");
        }
        this.loginSucceeded = false;
        if (this._handler == null) {
            throw new LoginException("No CallbackHandler received.");
        }
        usernameCallback = new NameCallback("username: ");
        passwordCallback = new PasswordCallback("passowrd: ", false);
        propertyCallback = new PropertyCallback(null);
        krbtokenCallback = new KRBTokenGenerateCallback();
        callbacks = new Callback[]{usernameCallback, passwordCallback, propertyCallback, krbtokenCallback};
        try {
            if (KRBGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(KRBGenerateLoginModule.tc, "Invoking callbacks");
            }
            this._handler.handle(callbacks);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.wssecurity.wssapi.token.impl.KRBGenerateLoginModule", "%C", this);
            Tr.processException(t, KRBGenerateLoginModule.clsName + ".login", "%C", this);
            Tr.error(KRBGenerateLoginModule.tc, "security.wssecurity.BSTokenLoginModule.s01", t);
            throw new LoginException("\n" + ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{KRB5Util.stackToString(t)}));
        }
        if (KRBGenerateLoginModule.tc.isDebugEnabled()) {
            ktokenCB = krbtokenCallback;
            pwdValue = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return ktokenCB.getClientPassword();
                }
            });
            Tr.debug(KRBGenerateLoginModule.tc, "From KRBTokenGenerateCallback: " + krbtokenCallback.getClientName() + ", " + (pwdValue == null || pwdValue.length == 0 ? "" : "******") + ", " + krbtokenCallback.getClientKerberosRealm() + ", " + krbtokenCallback.getTargetServiceName() + ", " + krbtokenCallback.getTargetServiceHostName() + ", " + krbtokenCallback.getTargetServiceKerberosRealm() + ", " + krbtokenCallback.getValueType().toString());
        }
        this._context = propertyCallback.getProperties();
        tconfig = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        gconfig = (WSSGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        this.messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        try {
            this.isServer = Axis2Util.isServiceProvider(this.messageContext);
            this.isRequest = gconfig.isRequest();
            this.isStandAlone = tconfig.isStandAlone();
        }
        catch (Exception e) {
            throw new LoginException("\n" + ConfigUtil.getMessage("security.wssecurity.KRBGenerateLoginModule.s02", new String[]{KRB5Util.stackToString(e)}));
        }
        tokenValueType = null;
        tokenValueType = krbtokenCallback.getValueType() != null ? krbtokenCallback.getValueType() : tconfig.getType();
        if (!(tokenValueType.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ_TOKEN) || tokenValueType.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ1510_TOKEN) || tokenValueType.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ4120_TOKEN) || tokenValueType.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ_TOKEN) || tokenValueType.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ1510_TOKEN) || tokenValueType.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ4120_TOKEN))) {
            errorMes = "\n" + ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{tokenValueType.toString(), com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ1510_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ4120_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ1510_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ4120_TOKEN.toString() + "\n"});
            throw new LoginException(errorMes);
        }
        keyInfoContent = (KeyInfoContentGeneratorConfig)this._context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey");
        dkic = null;
        if (keyInfoContent != null) {
            dkic = keyInfoContent.getDerivedKeyInfoConfig();
        }
        if (dkic != null) {
            this.derivedkeyInfoConfigured = dkic.isRequireDerivedKeys();
        }
        requireAPREQToken = (String)tconfig.getProperties().get(Constants.ATTACH_KERBEROS_AP_REQUIRED);
        requireSHA1SupportToken = (String)tconfig.getProperties().get(Constants.ATTACH_HASHKEY_SUPPORT_KRB_TOKEN_REQUIRED);
        if (KRBGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(KRBGenerateLoginModule.tc, Constants.ATTACH_KERBEROS_AP_REQUIRED + ": " + requireAPREQToken);
            Tr.debug(KRBGenerateLoginModule.tc, Constants.ATTACH_HASHKEY_SUPPORT_KRB_TOKEN_REQUIRED + ": " + requireSHA1SupportToken);
        }
        requireAPREQ = false;
        if (KRBGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(KRBGenerateLoginModule.tc, "Support token? " + tconfig.isStandAlone());
            Tr.debug(KRBGenerateLoginModule.tc, "Is request? " + (this.isServer == false));
        }
        if (tconfig.isStandAlone() && !this.isServer) {
            if (requireSHA1SupportToken == null || !requireSHA1SupportToken.equalsIgnoreCase("true")) {
                requireAPREQ = true;
            }
        } else if (requireAPREQToken != null && requireAPREQToken.equalsIgnoreCase("true")) {
            requireAPREQ = true;
        }
        if (KRBGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(KRBGenerateLoginModule.tc, "requireAPREQ? " + requireAPREQ);
        }
        refreshAPREQOnly = false;
        krb5token = KRBGenerateLoginModule.getToken(tconfig, this._securityTokenManager);
        toInsertToken = false;
        ticketToken = null;
        serviceToken = null;
        apReqtokenbytes = null;
        createSTR = false;
        endPointAddress = null;
        endPoint = this.messageContext.getTo();
        if (endPoint != null) {
            endPointAddress = endPoint.getAddress();
        } else if (!this.isServer) {
            throw new LoginException("There is no End Point Address for the request.");
        }
        if (krb5token == null) {
            if (!this.isServer) {
                block95: {
                    idForServiceTicket = null;
                    idForTgt = null;
                    callTivoli = false;
                    krbTicket = null;
                    initMap = this.finalLoginData(krbtokenCallback);
                    idForServiceTicket = KRB5TokenCacheUtil.getClientIdentifierForServiceTicketByCallback(initMap);
                    password = (String)initMap.get("clientPassword");
                    if (password != null && !password.isEmpty()) {
                        idForTgt = KRB5TokenCacheUtil.getClientIdentifierForTGTByCallback(initMap);
                        ticketToken = (TGTAuthToken)CacheableTokenCacheFactory.getInstance().getToken(idForTgt);
                    } else {
                        runAsSubject = KRB5TokenCacheUtil.getRunAsSubject(this.messageContext);
                        if (runAsSubject != null) {
                            krbTicket = KRB5TokenCacheUtil.getTgtTicketFromRunAsSubject(runAsSubject);
                        }
                        if (krbTicket != null) {
                            subject = new Subject();
                            ticket = krbTicket;
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding Kerberos ticket to Subject: " + ticket.toString());
                                    }
                                    subject.getPrivateCredentials().add(ticket);
                                    initMap.put("subject", subject);
                                    return null;
                                }
                            });
                            clientName = KRB5Util.stripOutPrincipalName(krbTicket.getClient().getName());
                            initMap.put("clientName", clientName);
                            spnName = (String)initMap.get("serviceName");
                            idForServiceTicket = KRB5TokenCacheUtil.getClientCacheKeyFromKRBAuthnToken(runAsSubject, spnName);
                        }
                    }
                    if (idForServiceTicket != null && (serviceToken = (TGSAuthToken)CacheableTokenCacheFactory.getInstance().getToken(idForServiceTicket + endPointAddress)) != null && krbTicket != null) {
                        if (serviceToken.getTGT() == null) {
                            serviceToken = null;
                        } else if (krbTicket.hashCode() != serviceToken.getTGT().hashCode()) {
                            serviceToken = null;
                        } else if (KRBGenerateLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(KRBGenerateLoginModule.tc, "Found cached TGT token for the RunAsSubject:" + krbTicket.getClient().getName() + ":Expiration at " + krbTicket.getEndTime());
                        }
                    }
                    if (!(password != null && !password.isEmpty() || krbTicket != null && krbTicket.isCurrent() && krbTicket.isForwardable() || !WSSContextManagerFactory.getInstance().processIsServer() || !KRBGenerateLoginModule.tc.isDebugEnabled())) {
                        Tr.debug(KRBGenerateLoginModule.tc, "There is authentication data or delegation subject to request AP-REQ token");
                        if (password == null || password.isEmpty()) {
                            Tr.debug(KRBGenerateLoginModule.tc, "No password");
                        }
                        if (krbTicket == null) {
                            Tr.debug(KRBGenerateLoginModule.tc, "No Kerberos Ticket.");
                        }
                        if (krbTicket != null) {
                            Tr.debug(KRBGenerateLoginModule.tc, "Invalid Kerberos Ticket=" + krbTicket);
                        }
                        Tr.error(KRBGenerateLoginModule.tc, "security.wssecurity.KRBGenerateLoginModule.s01", new String[]{"There is authentication data or delegation subject to request AP-REQ token"});
                        throw new LoginException("\n" + ConfigUtil.getMessage("security.wssecurity.KRBGenerateLoginModule.s01", new String[]{"There is authentication data or delegation subject to request AP-REQ token."}));
                    }
                    if (ticketToken == null && serviceToken == null) {
                        callTivoli = true;
                    } else if (ticketToken == null && password != null && !password.isEmpty()) {
                        callTivoli = true;
                    } else if (serviceToken != null) {
                        if (KRB5TokenCacheUtil.TicketActionState.REISSUE.equals((Object)KRB5TokenCacheUtil.getTicketActionState(serviceToken.getTGT()))) {
                            callTivoli = true;
                        } else if (KRB5TokenCacheUtil.TicketActionState.REFLESH.equals((Object)KRB5TokenCacheUtil.getTicketActionState(serviceToken.getTGT()))) {
                            callTivoli = true;
                            subject = new Subject();
                            ticket = serviceToken.getTGT();
                            try {
                                ticket.refresh();
                                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                    @Override
                                    public Object run() {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding Kerberos ticket to Subject: " + ticket.toString());
                                        }
                                        subject.getPrivateCredentials().add(ticket);
                                        initMap.put("subject", subject);
                                        return null;
                                    }
                                });
                            }
                            catch (Exception e) {
                                if (KRBGenerateLoginModule.tc.isDebugEnabled()) {
                                    Tr.debug(KRBGenerateLoginModule.tc, "Re-issue due to failure in TGT refleshing: " + e.getMessage());
                                }
                            }
                        } else if (!KRB5TokenCacheUtil.TicketActionState.NONE.equals((Object)KRB5TokenCacheUtil.getTicketActionState(serviceToken.getTGS()))) {
                            callTivoli = true;
                            subject = new Subject();
                            ticket = serviceToken.getTGT();
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding Kerberos ticket to Subject: " + ticket.toString());
                                    }
                                    subject.getPrivateCredentials().add(ticket);
                                    initMap.put("subject", subject);
                                    return null;
                                }
                            });
                        } else if (requireAPREQ) {
                            callTivoli = true;
                            subject = new Subject();
                            ticket = serviceToken.getTGS();
                            tgtticket = serviceToken.getTGT();
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding Kerberos ticket to Subject: " + ticket.toString());
                                    }
                                    subject.getPrivateCredentials().add(tgtticket);
                                    subject.getPublicCredentials().add(ticket);
                                    initMap.put("subject", subject);
                                    return null;
                                }
                            });
                            refreshAPREQOnly = true;
                        }
                    } else if (ticketToken != null) {
                        if (KRB5TokenCacheUtil.TicketActionState.NONE.equals((Object)KRB5TokenCacheUtil.getTicketActionState(ticketToken.getTGT()))) {
                            callTivoli = true;
                            subject = new Subject();
                            ticket = ticketToken.getTGT();
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding Kerberos ticket to Subject: " + ticket.toString());
                                    }
                                    subject.getPrivateCredentials().add(ticket);
                                    initMap.put("subject", subject);
                                    return null;
                                }
                            });
                        } else if (KRB5TokenCacheUtil.TicketActionState.REISSUE.equals((Object)KRB5TokenCacheUtil.getTicketActionState(ticketToken.getTGT()))) {
                            callTivoli = true;
                        } else {
                            callTivoli = true;
                            subject = new Subject();
                            ticket = ticketToken.getTGT();
                            try {
                                ticket.refresh();
                                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                    @Override
                                    public Object run() {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding Kerberos ticket to Subject: " + ticket.toString());
                                        }
                                        subject.getPrivateCredentials().add(ticket);
                                        initMap.put("subject", subject);
                                        return null;
                                    }
                                });
                            }
                            catch (Exception e) {
                                if (!KRBGenerateLoginModule.tc.isDebugEnabled()) break block95;
                                Tr.debug(KRBGenerateLoginModule.tc, "Re-issue due to failure in TGT refleshing: " + e.getMessage());
                            }
                        }
                    }
                }
                spnName = (String)initMap.get("serviceName");
                if (callTivoli) {
                    toInsertToken = true;
                    try {
                        block96: {
                            contextMap = this.callKerberosTokenGenerator(initMap);
                            clientName = (String)initMap.get("clientName");
                            if (idForTgt != null && !refreshAPREQOnly) {
                                ticketToken = new TGTAuthToken(contextMap, clientName);
                                ticketToken.setIdentifier(idForTgt);
                                KRB5TokenCacheUtil.setKRB5TokenToCache((CacheableToken)ticketToken, idForTgt, ticketToken.getTGT().getEndTime());
                            }
                            apReqtokenbytes = KRBGenerateLoginModule.getAPREQ_TOKEN_Byte(initMap, contextMap);
                            apReqSha1 = KRB5TokenCacheUtil.getSha1FromBytes(apReqtokenbytes);
                            if (!refreshAPREQOnly) {
                                serviceToken = new TGSAuthToken(contextMap, clientName, spnName, tokenValueType, apReqSha1);
                            } else {
                                keyInAPREQToken = this.getSecretByteFromAPREQ(contextMap);
                                serviceToken = serviceToken.modifyTGSAuthToken(keyInAPREQToken, apReqSha1);
                            }
                            if (idForServiceTicket == null) {
                                idForServiceTicket = KRB5TokenCacheUtil.getClientCacheKeyFromSubject(ticketToken.getTGT(), spnName);
                            }
                            serviceToken.setIdentifier(idForServiceTicket + endPointAddress);
                            expirationDate = serviceToken.getServiceTicketExpirationTime();
                            KRB5TokenCacheUtil.setKRB5TokenToCache((CacheableToken)serviceToken, serviceToken.getIdentifier(), expirationDate);
                            serviceToken2 = (TGSAuthToken)serviceToken.clone();
                            serviceToken2.setIdentifier(serviceToken2.getSHA1ofAPREQ());
                            if (requireAPREQ) {
                                expirationDate = new Date();
                                TokenHolder.setInboundKerberosTokenToContext(serviceToken2, this.messageContext);
                            }
                            KRB5TokenCacheUtil.setKRB5TokenToCache((CacheableToken)serviceToken2, serviceToken2.getIdentifier(), expirationDate);
                            if (WSSContextManagerFactory.getInstance().processIsServer() || (obj = this.messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext")) == null || !(obj instanceof WSSContext)) ** GOTO lbl253
                            context = (WSSContext)obj;
                            subject = null;
                            stw = null;
                            try {
                                subject = context.getRunAsSubject(this.messageContext);
                                if (subject == null) {
                                    subject = new Subject();
                                    context.setRunAsSubject(subject, this.messageContext);
                                } else {
                                    set = subject.getPrivateCredentials(SecurityTokenWrapper.class);
                                    if (set != null && !set.isEmpty()) {
                                        for (SecurityTokenWrapper stw : set) {
                                            t = stw.getSecurityToken();
                                            if (t == null || !(t instanceof KRBAuthnToken)) continue;
                                            subject.getPrivateCredentials().remove(stw);
                                        }
                                    }
                                }
                            }
                            catch (Exception se) {
                                if (!KRBGenerateLoginModule.tc.isDebugEnabled()) break block96;
                                Tr.debug(KRBGenerateLoginModule.tc, "Exception caught " + se.getMessage());
                            }
                        }
                        if (subject == null || this.messageContext.getTo() == null) ** GOTO lbl253
                        stw = new SecurityTokenWrapper(KRBGenerateLoginModule.createKrbTokenImpl(serviceToken));
                        stw.setEndPoint(this.messageContext.getTo().getAddress());
                        subject.getPrivateCredentials().add(stw);
                    }
                    catch (Throwable t) {
                        Tr.processException(t, KRBGenerateLoginModule.clsName + ".login", "%C", this);
                        Tr.error(KRBGenerateLoginModule.tc, "security.wssecurity.KRBGenerateLoginModule.s01", t);
                        throw new LoginException("\n" + ConfigUtil.getMessage("security.wssecurity.KRBGenerateLoginModule.s01", new String[]{KRB5Util.stackToString(t)}));
                    }
                } else {
                    createSTR = true;
                }
            } else {
                serviceToken = TokenHolder.getKerberosTokenFromContext(this.messageContext);
                if (serviceToken == null) {
                    reqTokenId = TokenHolder.getTokenFromContext(TokenHolder.INBOUND_KRBTOKEN, this.messageContext);
                    serviceToken = (TGSAuthToken)CacheableTokenCacheFactory.getInstance().getToken(reqTokenId);
                }
            }
lbl253:
            // 7 sources

            if (serviceToken == null) {
                Tr.error(KRBGenerateLoginModule.tc, "security.wssecurity.KRBGenerateLoginModule.s01", "Token NotFound");
                throw new LoginException("\n" + ConfigUtil.getMessage("security.wssecurity.KRBGenerateLoginModule.s01", new String[]{"None Kerberos Token Found"}));
            }
            krb5token = KRBGenerateLoginModule.createKrbTokenImpl(serviceToken);
            id = IdUtils.getInstance().makeUniqueId(this._context, "krb5_");
            krb5token.setId(id);
            if (apReqtokenbytes != null) {
                krb5token.setBinary(apReqtokenbytes);
            }
            wssVersion = 0;
            obj = null;
            obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (obj != null && obj instanceof Integer) {
                wssVersion = (Integer)obj;
            }
            if ((keyfromToken = serviceToken.getSecretKeyByte()) == null) {
                throw new LoginException("\n" + ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{"Failed to get key from AP_REQ token."}));
            }
            identifier = krb5token.getSHA1ofAPREQ();
            krb5token.setIdentifier(identifier);
            parent = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            if (apReqtokenbytes != null) {
                tokenElem = KRBGenerateLoginModule.createTokenElement(parent.getOMFactory(), parent, tconfig, apReqtokenbytes, id, wssVersion);
                krb5token.setXML(new OMStructure(tokenElem));
                reference = "#" + id;
                krb5token.setReferenceURI(reference);
                if (KRBGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(KRBGenerateLoginModule.tc, "Setting the token's Reference URI = " + reference);
                }
            } else {
                this.setupKEYID(krb5token, identifier);
                if (!this.isServer && createSTR && this.isStandAlone) {
                    tokenElem = KRBGenerateLoginModule.createSecurityTokenReferenceElement(parent.getOMFactory(), parent, identifier, wssVersion);
                    krb5token.setXML(new OMStructure(tokenElem));
                    krb5token.setReferenceURI(identifier);
                    toInsertToken = true;
                }
            }
            if (!this.derivedkeyInfoConfigured) {
                this.createKey(krb5token);
            }
            this._processedTokens.add(krb5token);
            if (toInsertToken) {
                this._insertedTokens.add(krb5token);
            }
        } else {
            if (this.regenerateKey(krb5token)) {
                this.createKey(krb5token);
            }
            this._processedTokens.add(krb5token);
            xml = (OMStructure)krb5token.getXML();
            if (xml != null) {
                this._referencedTokenElement = xml.getNode();
            }
        }
        if (this.derivedkeyInfoConfigured) {
            this.populateSharedStateForDkey(krb5token);
        } else if (krb5token.getKeyIdentifier() != null && !this.isStandAlone) {
            this._context.put(Constants.WSSECURITY_KEYINFO_TYPE, "KEYID");
        }
        if (krb5token != null) {
            this.loginSucceeded = true;
        }
        if (KRBGenerateLoginModule.tc.isEntryEnabled()) {
            Tr.exit(KRBGenerateLoginModule.tc, "login()");
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private HashMap callKerberosTokenGenerator(HashMap initMap) throws LoginException {
        String spnName = (String)initMap.get("serviceName");
        if (!KRB5Util.hasValue(spnName) || KRB5Util.hasValue(spnName) && !KRB5Util.spnValid(spnName)) {
            throw new LoginException(newline + ConfigUtil.getMessage("security.wssecurity.KRBGenerateLoginModule.s03", new String[]{spnName == null ? "" : spnName}));
        }
        HashMap contextMap = new HashMap();
        KerberosTokenGenerator ktg = new KerberosTokenGenerator();
        try {
            if (tc.isDebugEnabled() && this.isServer) {
                Tr.debug(tc, "Calling KerberosTokenGenerator.init()");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "\nKerberosTokenGenerator init Map contains: \nclientName: " + initMap.get("clientName") + newline + "clientPassword" + ": " + (!KRB5Util.hasValue((String)initMap.get("clientPassword")) ? "" : "******") + newline + "clientLoginConfig" + ": " + initMap.get("clientLoginConfig") + newline + "clientRealmName" + ": " + initMap.get("clientRealmName") + newline + "serviceKeyTab" + ": " + initMap.get("serviceKeyTab") + newline + "serviceName" + ": " + initMap.get("serviceName") + newline + "serverPassword" + ": " + (!KRB5Util.hasValue((String)initMap.get("serverPassword")) ? "" : "******") + newline + "wrapped" + ": " + initMap.get("wrapped") + newline + "subject" + ": " + initMap.get("subject") + newline);
            }
            ktg.init(initMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling KerberosTokenGenerator.invoke():");
            }
            ktg.invoke(contextMap);
            byte[] krb5KeyBytes = (byte[])contextMap.get("contextSubKeyBytes");
            Integer encType = (Integer)contextMap.get("contextSubKeyEnc");
            if (!KRB5Util.hasValue(krb5KeyBytes)) {
                krb5KeyBytes = (byte[])contextMap.get("contextSessionKeyBytes");
                encType = (Integer)contextMap.get("contextSessionKeyEnc");
                if (KRB5Util.hasValue(krb5KeyBytes) && !KRB5Util.isSessKeyEncTypeSupported(encType)) {
                    throw new LoginException("\nUnsupported Kerberos session key encryption type...Please verify Kerberos configuration.");
                }
            } else if (!KRB5Util.isSubKeyEncTypeSupported(encType)) {
                throw new LoginException("\nUnsupported Kerberos sub-key encryption type...Please verify Kerberos configuration.");
            }
        }
        catch (Throwable e2) {
            FFDCFilter.processException(e2, KRBGenerateLoginModule.class.getName(), "1");
            Tr.processException(e2, clsName + ".login", "%C", this);
            Tr.error(tc, "security.wssecurity.KRBGenerateLoginModule.s01", KRB5Util.stackToString(e2));
            throw new LoginException(newline + ConfigUtil.getMessage("security.wssecurity.KRBGenerateLoginModule.s01", new String[]{KRB5Util.stackToString(e2)}));
        }
        return contextMap;
    }

    private boolean regenerateKey(KRB5TokenImpl krb5token) {
        boolean isSigning;
        boolean isEncrypting;
        if (this.derivedkeyInfoConfigured) {
            return false;
        }
        String keyType = (String)this._context.get(Constants.WSSECURITY_KEY_TYPE);
        if (keyType == null) {
            isEncrypting = false;
            isSigning = false;
        } else {
            isSigning = "SigningKey".equals(keyType);
            isEncrypting = "EncryptingKey".equals(keyType);
            if (tc.isDebugEnabled()) {
                if (isSigning) {
                    Tr.debug(tc, "Signing key type");
                } else if (isEncrypting) {
                    Tr.debug(tc, " Encrypting key type");
                }
            }
        }
        boolean gen = false;
        try {
            if (isEncrypting && krb5token.getKey(62) == null) {
                gen = true;
            }
            if (isSigning && krb5token.getKey(61) == null) {
                gen = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return gen;
    }

    public static byte[] getAPREQ_TOKEN_Byte(HashMap initMap, HashMap contextMap) {
        Integer isWrap = (Integer)initMap.get("wrapped");
        int isWrapped = isWrap;
        byte[] apReqtokenbytes = null;
        apReqtokenbytes = isWrapped == 1 ? (byte[])contextMap.get("contextGSSToken") : (byte[])contextMap.get("contextAPReq");
        return apReqtokenbytes;
    }

    private byte[] getSecretByteFromAPREQ(Map map) {
        byte[] keyfromToken = (byte[])map.get("contextSubKeyBytes");
        if (keyfromToken == null) {
            keyfromToken = (byte[])map.get("contextSessionKeyBytes");
            if (keyfromToken != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found session key of type: " + map.get("contextSessionKeyBytesType") + " from kerberos token.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found sub key of type: " + map.get("contextSubKeyBytesType") + " from kerberos token.");
        }
        return keyfromToken;
    }

    private void populateSharedStateForDkey(KRB5TokenImpl krb5token) throws LoginException {
        String dkeyTokenIdType = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken");
        String dkeyTokenIdEncType = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.baseToken.encodeType");
        QName dkeyTokenValueType = (QName)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenValueType");
        String KEYIDvalue = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenId");
        String intTokenRef = (String)this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.internalTokenReference");
        byte[] secretBytes = (byte[])this._sharedState.get("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Previous com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken: " + (KRB5Util.hasValue(dkeyTokenIdType) ? dkeyTokenIdType : ""));
            Tr.debug(tc, "Previous com.ibm.wsspi.wssecurity.dktlogin.baseToken.encodeType: " + (KRB5Util.hasValue(dkeyTokenIdEncType) ? dkeyTokenIdEncType : ""));
            Tr.debug(tc, "Previous com.ibm.wsspi.wssecurity.dktlogin.referencedTokenValueType: " + dkeyTokenValueType);
            Tr.debug(tc, "Previous com.ibm.wsspi.wssecurity.dktlogin.referencedTokenId: " + (KRB5Util.hasValue(KEYIDvalue) ? KEYIDvalue : ""));
            Tr.debug(tc, "Previous com.ibm.wsspi.wssecurity.dktlogin.internalTokenReference: " + (KRB5Util.hasValue(intTokenRef) ? intTokenRef : ""));
            Tr.debug(tc, "Previous com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes: " + (KRB5Util.hasValue(secretBytes) ? secretBytes : (byte[])""));
        }
        boolean iskeyId = true;
        String ref = krb5token.getReferenceURI();
        if (ref != null && ref.startsWith("#")) {
            iskeyId = false;
        }
        if (!iskeyId) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "1st request using Security Token Reference...");
            }
            dkeyTokenIdType = Constants.WSSECURITY_KEY_REFERENCE;
            dkeyTokenValueType = krb5token.getValueType();
            KEYIDvalue = krb5token.getId();
            intTokenRef = krb5token.getId();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Overwrites com.ibm.wsspi.wssecurity.dktlogin.internalTokenReference with " + intTokenRef);
            }
            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.internalTokenReference", intTokenRef);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subsequent messages using KeyIdentifier...");
            }
            dkeyTokenIdType = Constants.WSSECURITY_KEY_ID;
            dkeyTokenIdEncType = com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY.getLocalPart();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Overwrites com.ibm.wsspi.wssecurity.dktlogin.baseToken.encodeType with " + dkeyTokenIdEncType);
            }
            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.baseToken.encodeType", dkeyTokenIdEncType);
            dkeyTokenValueType = com.ibm.ws.wssecurity.common.Constants.KRB5_APREQ_SHA1;
            KEYIDvalue = krb5token.getIdentifier();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Overwrites com.ibm.wsspi.wssecurity.dktlogin.referencedTokenId with " + KEYIDvalue);
            }
            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenId", KEYIDvalue);
        }
        secretBytes = krb5token.getAPREQKeyByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Overwrites com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken with " + dkeyTokenIdType);
            Tr.debug(tc, "Overwrites com.ibm.wsspi.wssecurity.dktlogin.referencedTokenValueType with " + dkeyTokenValueType);
            Tr.debug(tc, "Overwrites com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes with " + secretBytes);
        }
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.howToReferenceBaseToken", dkeyTokenIdType);
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenValueType", dkeyTokenValueType);
        this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", secretBytes);
        this._processedTokens.add(krb5token);
        this._sharedState.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._sharedState.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KerberosTicket getkrbTktFromSubject(MessageContext messageContext, HashMap initMap) throws LoginException {
        KerberosTicket ktkt = null;
        WSSContext secContext = WSSContextFactory.getInstance();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found a WSSContext: " + secContext);
        }
        if (secContext != null) {
            try {
                final Subject runAsSubject = secContext.getRunAsSubject(messageContext);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RunAs Subject: " + runAsSubject + " is found.");
                }
                if (runAsSubject != null) {
                    ktkt = (KerberosTicket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Iterator<KerberosTicket> ticketIterator;
                            Set<KerberosTicket> kerberosTicketSet = runAsSubject.getPrivateCredentials(KerberosTicket.class);
                            if (kerberosTicketSet != null && kerberosTicketSet.size() > 0 && (ticketIterator = kerberosTicketSet.iterator()).hasNext()) {
                                return ticketIterator.next();
                            }
                            return null;
                        }
                    });
                    if (ktkt != null) {
                        boolean ticketForwardable;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found KerberosTicket for: " + ktkt.getClient().getName());
                            Tr.debug(tc, "Found forwardable KerberosTicket? " + ktkt.isForwardable());
                            Tr.debug(tc, "Found current KerberosTicket? " + ktkt.isCurrent());
                            Tr.debug(tc, "Found destroyed KerberosTicket? " + ktkt.isDestroyed());
                            Tr.debug(tc, "Found KerberosTicket: " + ktkt);
                        }
                        String realm = null;
                        String clientName = null;
                        boolean bl = ticketForwardable = ktkt.isCurrent() && ktkt.isForwardable() && !ktkt.isDestroyed();
                        if (!ticketForwardable) return ktkt;
                        clientName = ktkt.getClient().getName();
                        realm = ktkt.getClient().getRealm();
                        if (!KRB5Util.hasValue(clientName) || !KRB5Util.hasValue(realm)) return ktkt;
                        clientName = clientName.substring(0, clientName.lastIndexOf(realm) - 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Use a found Kerberos ticket for " + clientName + " in realm: " + realm);
                        }
                        initMap.put("clientName", clientName);
                        initMap.put("clientRealmName", realm);
                        initMap.put("subject", runAsSubject);
                        return ktkt;
                    }
                    if (!tc.isDebugEnabled()) return ktkt;
                    Tr.debug(tc, "KerberosTicket not found.");
                    return ktkt;
                }
                if (!tc.isDebugEnabled()) return ktkt;
                Tr.warning(tc, "No RunAs Subject is found.");
                return ktkt;
            }
            catch (Exception ex) {
                Tr.processException((Throwable)ex, clsName + ".login", "%C", this);
                Tr.error(tc, "security.wssecurity.KRBGenerateLoginModule.s01", ex);
                throw new LoginException(newline + ConfigUtil.getMessage("security.wssecurity.KRBGenerateLoginModule.s01", new String[]{KRB5Util.stackToString(ex)}));
            }
        } else {
            if (!tc.isDebugEnabled()) return ktkt;
            Tr.debug(tc, "No WSSContext is found. Return.");
        }
        return ktkt;
    }

    private void setupKEYID(KRB5TokenImpl krb5token, String id) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupKEYID()");
        }
        QName etype = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
        QName idtype = (QName)this._context.get(Constants.WSSECURITY_KEY_IDTYPE);
        if ((etype == null || NamespaceUtil.equals(etype, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) && (idtype == null || NamespaceUtil.equals(idtype, com.ibm.ws.wssecurity.common.Constants.KRB5_APREQ_SHA1))) {
            krb5token.setKeyIdentifier(id);
            krb5token.setKeyIdentifierEncodingType(com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY);
            krb5token.setKeyIdentifierValueType(com.ibm.ws.wssecurity.common.Constants.KRB5_APREQ_SHA1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupKEYID()");
        }
    }

    private SimpleTargetURL getSimpleTargetURL(final String url) throws PrivilegedActionException {
        SimpleTargetURLCache cache = SimpleTargetURL.getCache();
        SimpleTargetURL simple = null;
        if (!cache.contains(url)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url + " key is not in cache. Insert...");
            }
            if ((simple = (SimpleTargetURL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException, UnknownHostException {
                    return new SimpleTargetURL(url);
                }
            })) != null) {
                cache.insert(url, simple);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, url + " key is found in cache.");
            }
            simple = (SimpleTargetURL)cache.get(url);
        }
        return simple;
    }

    private HashMap finalLoginData(final KRBTokenGenerateCallback ktokenCB) {
        String serviceHost;
        Config krbCfg;
        char[] pwd;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finalLoginData()");
        }
        int isWrapped = 2;
        HashMap<String, Object> hm = new HashMap<String, Object>();
        String value = ktokenCB.getClientName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved client principal: " + value);
        }
        if (KRB5Util.hasValue(value)) {
            hm.put("clientName", value);
        }
        if (KRB5Util.hasValue(pwd = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ktokenCB.getClientPassword();
            }
        }))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resolved client password: ******");
            }
            hm.put("clientPassword", new String(pwd));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resolved client password: " + value);
            }
            hm.put("clientPassword", "");
        }
        value = ktokenCB.getClientKerberosRealm();
        String defaultRealm = null;
        try {
            if (!KRB5Util.hasValue(value)) {
                krbCfg = Config.getInstance();
                if (krbCfg != null) {
                    value = defaultRealm = krbCfg.getDefaultRealm();
                } else {
                    Tr.error(tc, "security.wssecurity.LoginProcessor.s11", "Unable to locate a Kerberos configuration. Please verify the Kerberos configuration and keytab file.");
                }
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.wssecurity.wssapi.token.impl.KRBGenerateLoginModule", "%C", this);
            Tr.processException(t, clsName + ".login", "%C", this);
            Tr.error(tc, "security.wssecurity.KRBGenerateLoginModule.s01", "\nUnable to locate a Kerberos configuration. Please verify the Kerberos configuration and keytab file.\n" + KRB5Util.stackToString(t));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved client Kerberos realm: " + value);
        }
        if (KRB5Util.hasValue(value)) {
            hm.put("clientRealmName", value);
        }
        if (!KRB5Util.hasValue(value = ktokenCB.getTargetServiceKerberosRealm())) {
            if (defaultRealm == null) {
                try {
                    krbCfg = Config.getInstance();
                    if (krbCfg != null) {
                        value = defaultRealm = krbCfg.getDefaultRealm();
                    } else {
                        Tr.error(tc, "security.wssecurity.LoginProcessor.s11", "Unable to locate a Kerberos configuration. Please verify the Kerberos configuration and keytab file.");
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.wssecurity.wssapi.token.impl.KRBGenerateLoginModule", "%C", this);
                    Tr.processException(t, clsName + ".login", "%C", this);
                    Tr.error(tc, "security.wssecurity.KRBGenerateLoginModule.s01", "\nUnable to locate a Kerberos configuration. Please verify the Kerberos configuration and keytab file.\n" + KRB5Util.stackToString(t));
                }
            }
            value = defaultRealm;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved service Kerberos realm name: " + value);
        }
        if (KRB5Util.hasValue(value)) {
            hm.put("serviceRealmName", value);
        }
        value = null;
        String serviceName = ktokenCB.getTargetServiceName();
        if (!KRB5Util.hasValue(serviceName) && (serviceName = this.messageContext.getAxisService().getName()) != null && serviceName.contains(".")) {
            serviceName = serviceName.substring(0, serviceName.indexOf("."));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved service name: " + serviceName);
        }
        if (!KRB5Util.hasValue(serviceHost = ktokenCB.getTargetServiceHostName())) {
            SimpleTargetURL simpleURL = null;
            String address = this.messageContext.getTo().getAddress();
            if (address == null) {
                address = (String)this.messageContext.getProperty(endptAddress_JAXWS);
            }
            if (address != null) {
                StringTokenizer tokenizer = new StringTokenizer(address, "/", true);
                StringBuffer sb = new StringBuffer();
                String token = null;
                int count = 0;
                while (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    if (token.equals("/")) {
                        ++count;
                    }
                    if (count == 3) break;
                    sb.append(token);
                }
                address = sb.toString();
                if (simpleURL == null) {
                    try {
                        simpleURL = this.getSimpleTargetURL(address);
                    }
                    catch (PrivilegedActionException pEx) {
                        FFDCFilter.processException((Throwable)pEx, "com.ibm.ws.wssecurity.wssapi.token.impl.KRBGenerateLoginModule", "%C", this);
                        Tr.processException((Throwable)pEx, clsName + ".login", "%C", this);
                        Tr.error(tc, "security.wssecurity.KRBGenerateLoginModule.s01", newline + KRB5Util.stackToString(pEx));
                        serviceHost = null;
                    }
                }
                if (simpleURL != null) {
                    serviceHost = simpleURL.getHostname();
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved service host name: " + serviceHost);
        }
        if (KRB5Util.hasValue(serviceName) && KRB5Util.hasValue(serviceHost)) {
            value = serviceName + "/" + serviceHost;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved service principal name(SPN): " + value);
        }
        hm.put("serviceName", value);
        QName qname = ktokenCB.getValueType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved Kerberos token type: " + qname);
        }
        if (qname.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ_TOKEN) || qname.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ1510_TOKEN) || qname.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ4120_TOKEN)) {
            isWrapped = 1;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved to GSS wrap? " + isWrapped);
        }
        hm.put("wrapped", new Integer(isWrapped));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resolved client JAAS Kerberos login: JAASClient");
        }
        hm.put("clientLoginConfig", "JAASClient");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finalLoginData()");
        }
        return hm;
    }

    private static final OMElement createTokenElement(OMFactory factory, OMElement parent, TokenGeneratorConfig config2, byte[] credToken, String id, int wssVersion) {
        QName tokenType;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenElement(");
            buf.append("OMFactory factory,");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("byte[] credToken[");
            buf.append(credToken == null ? "null" : "not null");
            buf.append("], ");
            buf.append("String id[").append(id).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("])");
            Tr.entry(tc, buf.toString());
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse";
        }
        OMElement tokenElem = factory.createOMElement("BinarySecurityToken", nsWsse, pWsse);
        if (isDecl) {
            tokenElem.declareNamespace(nsWsse, "wsse");
        }
        if (id != null) {
            isDecl = false;
            String pWsu = DOMUtils.getNamespacePrefix(parent, nsWsu);
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu";
            }
            if (isDecl) {
                tokenElem.declareNamespace(nsWsu, "wsu");
            }
            tokenElem.addAttribute("Id", id, factory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSU, pWsu));
        }
        if ((tokenType = config2.getType()) == null) {
            tokenType = com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ_TOKEN;
        }
        tokenElem.declareNamespace(tokenType.getNamespaceURI(), "wsst");
        DOMUtils.setQNameAttr(tokenElem, null, "ValueType", tokenType, wssVersion);
        String data = Base64.encode(credToken);
        tokenElem.addChild(factory.createOMText(data));
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenElement(");
            buf.append("OMFactory, OMElement, TokenGeneratorConfig, byte[], String, int)");
            buf.append(" returns OMElement[").append(tokenElem).append("]");
            Tr.exit(tc, buf.toString());
        }
        return tokenElem;
    }

    private static final OMElement createSecurityTokenReferenceElement(OMFactory factory, OMElement parent, String sha1APReq, int wssVersion) {
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
        boolean isDecl = false;
        String pWsse = null;
        if (parent != null) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
        }
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse";
        }
        OMElement elem1 = factory.createOMElement("SecurityTokenReference", nsWsse, pWsse);
        if (isDecl) {
            elem1.declareNamespace(nsWsse, "wsse");
        }
        OMElement elem12 = factory.createOMElement("KeyIdentifier", nsWsse, pWsse);
        OMNamespace wsseNS = factory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
        DOMUtils.setQNameAttr(elem12, null, "EncodingType", com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY, wssVersion);
        DOMUtils.setQNameAttr(elem12, null, "ValueType", com.ibm.ws.wssecurity.common.Constants.KRB5_APREQ_SHA1, wssVersion);
        elem12.setText(sha1APReq);
        elem1.addChild(elem12);
        return elem1;
    }

    private static final KRB5TokenImpl getToken(TokenGeneratorConfig config2, SecurityTokenManager securityTokenManager) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig config, ");
            buf.append("byte[] binary[");
            buf.append("], SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, buf.toString());
        }
        KRB5TokenImpl token = null;
        Collection<SecurityToken> tokens = securityTokenManager.getTokens(config2);
        if (tokens != null && tokens.size() > 0) {
            for (SecurityToken t : tokens) {
                if (!(t instanceof KRB5TokenImpl)) continue;
                token = (KRB5TokenImpl)t;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getToken(");
            buf.append("TokenGeneratorConfig, byte[], SecurityTokenManager)");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    private void createKey(KRB5TokenImpl krb5token) throws LoginException {
        boolean isSigning;
        boolean isEncrypting;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKey()");
        }
        Key[] returnKey = new Key[2];
        String keyType = (String)this._context.get(Constants.WSSECURITY_KEY_TYPE);
        if (keyType == null) {
            isEncrypting = false;
            isSigning = false;
        } else {
            isSigning = "SigningKey".equals(keyType);
            isEncrypting = "EncryptingKey".equals(keyType);
            if (tc.isDebugEnabled()) {
                if (isSigning) {
                    Tr.debug(tc, "Signing key type");
                } else if (isEncrypting) {
                    Tr.debug(tc, " Encrypting key type");
                }
            }
        }
        String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        boolean isStrref = false;
        isStrref = keyInfoType == null ? false : ConfigUtil.isKeyInfoStrref(keyInfoType);
        WSSGeneratorConfig gconfig = (WSSGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        String encAlg = null;
        String sigAlg = null;
        if (isSigning) {
            sigAlg = (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm");
        }
        if (isEncrypting) {
            encAlg = (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The supplied algorithms from WSSAPI, Encryption Algorithm: " + encAlg + " and Signature Algorithm: = " + sigAlg);
        }
        if (gconfig instanceof PolicyOutboundConfig) {
            encAlg = ((PolicyOutboundConfig)gconfig).getEncryptionAlgorithm();
            sigAlg = ((PolicyOutboundConfig)gconfig).getSymmetricSignatureAlgorithm();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The supplied algorithms from algorithm suite, Encryption Algorithm: " + encAlg + " and Signature Algorithm: = " + sigAlg);
            }
        }
        TokenGeneratorConfig config2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        if (KRB5Util.hasValue(encAlg)) {
            encAlg = DKTGenerateLoginModule.mapKeyAlgorithm2JCE(encAlg, false, false, false, true);
        }
        if (KRB5Util.hasValue(sigAlg)) {
            sigAlg = DKTGenerateLoginModule.mapKeyAlgorithm2JCE(sigAlg, false, false, true, false);
        }
        byte[] keyfromToken = krb5token.getAPREQKeyByte();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Kerberos key length is " + (keyfromToken != null && keyfromToken.length != 0 ? keyfromToken.length : 0));
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security token: " + krb5token);
            }
            if (sigAlg != null && sigAlg.compareTo("HmacSHA1") == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Generating key for..." + sigAlg);
                }
                SecretKeySpec secretKeySp = new SecretKeySpec(keyfromToken, "HmacSHA1");
                returnKey[0] = secretKeySp;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not generating key for..." + sigAlg);
            }
            if (encAlg != null && encAlg.compareTo("AES") == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Generating key for..." + encAlg);
                }
                AESKeySpec aesKeySpec = new AESKeySpec(keyfromToken);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                returnKey[1] = keyFactory.generateSecret((KeySpec)aesKeySpec);
            } else if (encAlg != null && encAlg.compareTo("DESede") == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Generating key for..." + encAlg);
                }
                DESedeKeySpec desKeySpec = new DESedeKeySpec(keyfromToken);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede", "IBMJCE");
                returnKey[1] = keyFactory.generateSecret(desKeySpec);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not generating key for..." + encAlg);
            }
            if (krb5token != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + returnKey[0] + " for SecurityToken.SIGNING_KEY " + " in " + krb5token);
                }
                krb5token.setKey(61, returnKey[0]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + returnKey[1] + " for SecurityToken.ENCRYPTING_KEY " + " in " + krb5token);
                }
                krb5token.setKey(62, returnKey[1]);
            }
        }
        catch (Throwable t) {
            Tr.processException(t, clsName + ".createKey", "%C", this);
            Tr.error(tc, "security.wssecurity.KRBGenerateLoginModule.s02", newline + KRB5Util.stackToString(t));
            throw new LoginException("Failed to generate key: " + KRB5Util.stackToString(t));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKey()");
        }
    }

    public static KRB5TokenImpl createKrbTokenImpl(TGSAuthToken tgsToken) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKrbTokenImpl()");
        }
        KRB5TokenImpl returnToken = null;
        HashMap table = tgsToken.getTGSAuthTokenAsMap();
        returnToken = (KRB5TokenImpl)_tokenFactory.createToken(table);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKrbTokenImpl()");
        }
        return returnToken;
    }
}

