/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import java.security.SecurityPermission;
import java.util.HashMap;
import javax.xml.namespace.QName;

public class KRBDerivedKeyTokenImpl
extends SecurityTokenImpl
implements DerivedKeyToken {
    private static final long serialVersionUID = 8708733700365578538L;
    private static final SecurityPermission GETBYTES_PERM = new SecurityPermission("wssapi.token.impl.KRBDerivedKeyTokenImpl.getBytes");
    private static final SecurityPermission SETSECRET_PERM = new SecurityPermission("wssapi.token.impl.KRBDerivedKeyTokenImpl.setSecret");
    private static final SecurityPermission SETSECRET_ARRAY_PERM = new SecurityPermission("wssapi.token.impl.KRBDerivedKeyTokenImpl.setSecret_array");
    private static final SecurityPermission SETSERVICELABEL_PERM = new SecurityPermission("wssapi.token.impl.KRBDerivedKeyTokenImpl.setServiceLabel");
    private static final SecurityPermission SETCLIENTLABEL_PERM = new SecurityPermission("wssapi.token.impl.KRBDerivedKeyTokenImpl.setClientLabel");
    private static TraceComponent tc = Tr.register(KRBDerivedKeyTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private QName retTokeType = null;
    private String refTokenId = "";
    private String tokenId = "";
    private String algorithm = Constants.SC_DK_ALGO_PSHA1;
    private String generation = "";
    private int length = 0;
    private String clientlabel = "";
    private String servicelabel = "";
    private byte[] nonce = null;
    private String keyType = "";
    private HashMap securityTokenReference = null;
    private String principal = "";
    private String uniqueID = "";
    private boolean valid = true;
    private boolean readOnly = false;
    private long expiration = -1L;

    public KRBDerivedKeyTokenImpl() {
        this.valueType = DerivedKeyToken.ValueType;
        this.tokenQName = DerivedKeyToken.TokenQname;
    }

    public KRBDerivedKeyTokenImpl(HashMap properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBDerivedKeyTokenImpl");
        }
        this.valueType = DerivedKeyToken.ValueType;
        this.tokenQName = DerivedKeyToken.TokenQname;
        if (properties != null) {
            this.tokenId = (String)properties.get("tokenID");
            this.algorithm = (String)properties.get("Algorithm");
            this.generation = (String)properties.get("Generation");
            this.length = Integer.parseInt((String)properties.get("Length"));
            this.nonce = (byte[])properties.get("Nonce");
            this.keyType = (String)properties.get("KeyType");
            this.securityTokenReference = (HashMap)properties.get("SecurityTokenReference");
            String string = (String)properties.get("ValueType");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Id:" + this.tokenId);
            Tr.debug(tc, "algorithm:" + this.algorithm);
            Tr.debug(tc, "generation:" + this.generation);
            Tr.debug(tc, "length:" + this.length);
            Tr.debug(tc, "nonce:" + this.nonce);
            Tr.debug(tc, "keyType:" + this.keyType);
            Tr.debug(tc, "securityTokenReference:" + this.securityTokenReference);
            Tr.debug(tc, "valueType:" + this.getType().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBDerivedKeyTokenImpl");
        }
    }

    public void setNonce(byte[] in_nonce) {
        if (!this.readOnly) {
            this.nonce = in_nonce;
        }
    }

    public void setrefTokenType(QName rtType) {
        if (!this.readOnly) {
            this.retTokeType = rtType;
        }
    }

    public void setrefTokenId(String rtId) {
        if (!this.readOnly) {
            this.refTokenId = rtId;
        }
    }

    public void setLength(int len) {
        if (!this.readOnly) {
            this.length = len;
        }
    }

    public String getLabel() {
        return this.clientlabel + ":" + this.servicelabel;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public QName getType() {
        return this.valueType;
    }

    public String getGeneration() {
        return this.generation;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getClientLabel() {
        return this.clientlabel;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public int getOffset() {
        return 0;
    }

    public byte[] getSecret() {
        return null;
    }

    public SecurityContextToken getSecurityContextToken() {
        return null;
    }

    public String getSecurityContextTokenTokenUUID() {
        return null;
    }

    public String getrefTokenId() {
        return this.refTokenId;
    }

    public String getServiceLabel() {
        return this.servicelabel;
    }

    public void setClientLabel(String label) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETCLIENTLABEL_PERM.toString());
            }
            sm.checkPermission(SETCLIENTLABEL_PERM);
        }
        if (!this.readOnly) {
            this.clientlabel = label;
        }
    }

    public void setSecurityContextTokenUUID(String uuid) {
    }

    public void setServiceLabel(String label) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETSERVICELABEL_PERM.toString());
            }
            sm.checkPermission(SETSERVICELABEL_PERM);
        }
        if (!this.readOnly) {
            this.servicelabel = label;
        }
    }

    public String getPrincipal() {
        return this.principal;
    }
}

