/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.crypto.provider.AESKeySpec;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.security.krb5.wss.KerberosTokenConsumer;
import com.ibm.websphere.wssecurity.callbackhandler.KRBTokenConsumeCallback;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KRBConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGenerator;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditEventGeneratorFactory;
import com.ibm.ws.wssecurity.platform.audit.WSSAuditService;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.token.CacheableTokenCacheFactory;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.KRB5TokenCacheUtil;
import com.ibm.ws.wssecurity.util.KRB5Util;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.KRB5TokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.KRBGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.TGSAuthToken;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityFaultCode;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.ietf.jgss.GSSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KRBConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(KRBConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KRBConsumeLoginModule.class.getName();
    private static final String newline = "\n";
    private static final String CONSUME_CALLBACK_BY_WSSAPI = "com.ibm.wsspi.wssecurity.krbtoken.consumeCallbackByWSSAPI:";
    private boolean loginSucceeded = false;
    private boolean isServer = false;
    private static final HexDumpEncoder hexDumper = new HexDumpEncoder();
    private KRBConfig config = null;
    private SecurityToken _token;
    private SecurityTokenManagerImpl _securityTokenManager;
    private Map<Object, Object> _context;
    private CallbackHandler _handler;
    private Map _sharedState;
    private Map _options;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private WSSAuditService _wssAuditService;
    private WSSAuditEventGenerator _wssAuditEventGenerator;
    private boolean _isAuthnEventsRequired;

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The token hash value = " + this._token.hashCode());
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = handler;
        this._sharedState = sharedState;
        this._options = options;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        this._wssAuditService = WSSContextManagerFactory.getInstance().getAuditService();
        this._wssAuditEventGenerator = WSSAuditEventGeneratorFactory.getInstance();
        boolean bl = this._isAuthnEventsRequired = this._wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS, this._context) || this._wssAuditService.isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED, this._context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        QName vtype;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        this.loginSucceeded = false;
        if (this._handler == null) {
            throw new LoginException("No callback handler is available.");
        }
        PropertyCallback propertyCallback = new PropertyCallback(null);
        KRBTokenConsumeCallback krbTokenConsumeCallback = new KRBTokenConsumeCallback();
        Callback[] callbacks = new Callback[]{propertyCallback, krbTokenConsumeCallback};
        try {
            this._handler.handle(callbacks);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wssecurity.wssapi.token.impl.KRBConsumeLoginModule", "%C", this);
            Tr.processException((Throwable)e, clsName + ".login", "%C", this);
            throw new LoginException(newline + ConfigUtil.getMessage("security.wssecurity.KRBConsumeLoginModule.s02", new String[]{KRB5Util.stackToString(e)}));
        }
        this._context = propertyCallback.getProperties();
        this._securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        TokenConsumerConfig tconfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        TokenGeneratorConfig gConfig = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        try {
            this.isServer = Axis2Util.isServiceProvider(messageContext);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        boolean isForwardable = true;
        String forwardable = (String)tconfig.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (forwardable != null && forwardable.equalsIgnoreCase("false")) {
            isForwardable = false;
        }
        if ((vtype = krbTokenConsumeCallback.getValueType()) == null) {
            vtype = tconfig.getType();
        }
        KRB5TokenImpl krb5token = null;
        if (!(vtype.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ_TOKEN) || vtype.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ1510_TOKEN) || vtype.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ4120_TOKEN) || vtype.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ_TOKEN) || vtype.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ1510_TOKEN) || vtype.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ4120_TOKEN))) {
            String errorMes = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{vtype.toString(), com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ1510_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_AP_REQ4120_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ1510_TOKEN.toString() + "\n or " + com.ibm.ws.wssecurity.common.Constants.KRB5_GSS_AP_REQ4120_TOKEN.toString() + newline});
            throw new LoginException(errorMes);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, krb5token);
        try {
            OMElement targetElem = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            if (targetElem != null && (targetElem.getNamespace().getNamespaceURI().equals(com.ibm.ws.wssecurity.common.Constants.NS_WSSE) || targetElem.getNamespace().getNamespaceURI().equals(com.ibm.ws.wssecurity.common.Constants.NS_WSSE11)) && targetElem.getLocalName().equals("BinarySecurityToken")) {
                String ValueType2 = DOMUtils.getAttribute(targetElem, com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q.getLocalPart());
                QName valueTypeQName = new QName("", ValueType2);
                if (!valueTypeQName.equals(vtype)) {
                    throw new LoginException("Encountered invalid BST with invalid ValueType: " + vtype.getLocalPart());
                }
                String requireAPREQToken = (String)tconfig.getProperties().get(Constants.ATTACH_KERBEROS_AP_REQUIRED);
                boolean requireAPREQ = false;
                String requireSHA1SupportToken = (String)tconfig.getProperties().get(Constants.ATTACH_HASHKEY_SUPPORT_KRB_TOKEN_REQUIRED);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, Constants.ATTACH_KERBEROS_AP_REQUIRED + ": " + requireAPREQToken);
                    Tr.debug(tc, Constants.ATTACH_HASHKEY_SUPPORT_KRB_TOKEN_REQUIRED + ": " + requireSHA1SupportToken);
                    Tr.debug(tc, "isUsedForDecryption? " + tconfig.isUsedForDecryption());
                    Tr.debug(tc, "isUsedForVerification? " + tconfig.isUsedForVerification());
                }
                if (!tconfig.isUsedForVerification() && !tconfig.isUsedForDecryption() && this.isServer) {
                    if (requireSHA1SupportToken == null || !requireSHA1SupportToken.equalsIgnoreCase("true")) {
                        requireAPREQ = true;
                    }
                } else if (requireAPREQToken != null && requireAPREQToken.equalsIgnoreCase("true")) {
                    requireAPREQ = true;
                }
                this.loginSucceeded = this.processBST(targetElem, krb5token, krbTokenConsumeCallback, valueTypeQName, requireAPREQ, messageContext);
            } else if (targetElem != null && targetElem.getLocalName().equals("DerivedKeyToken")) {
                this.loginSucceeded = this.verifyDKTokenElement(targetElem, tconfig, vtype, messageContext);
                if (this.loginSucceeded && this._token instanceof KRB5TokenImpl) {
                    byte[] secret = ((KRB5TokenImpl)this._token).getAPREQKeyByte();
                    this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", secret);
                    this._context.put("com.ibm.ws.wssecurity.sc.dkt.baseToken", this._token);
                }
            } else if (targetElem != null && (targetElem.getNamespace().getNamespaceURI().equals(com.ibm.ws.wssecurity.common.Constants.NS_WSSE) || targetElem.getNamespace().getNamespaceURI().equals(com.ibm.ws.wssecurity.common.Constants.NS_WSSE11)) && targetElem.getLocalName().equals("SecurityTokenReference")) {
                OMElement keyidElement = DOMUtils.getChildElement(targetElem, targetElem.getNamespace().getNamespaceURI(), "KeyIdentifier");
                if (keyidElement != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found KeyIdentifier element: " + keyidElement);
                    }
                    QName encodetypeQN = null;
                    QName valuetypeQN = null;
                    Iterator it = keyidElement.getAllAttributes();
                    String hashedKeyId = null;
                    if (it != null) {
                        while (it.hasNext()) {
                            OMAttribute attr = (OMAttribute)it.next();
                            if (attr.getQName().getLocalPart().equals(com.ibm.ws.wssecurity.common.Constants.ENCODINGTYPE_Q.getLocalPart())) {
                                encodetypeQN = new QName(attr.getAttributeValue());
                            }
                            if (attr.getQName().getLocalPart().equals(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q.getLocalPart())) {
                                valuetypeQN = new QName(attr.getAttributeValue());
                            }
                            if (encodetypeQN == null || valuetypeQN == null) continue;
                            hashedKeyId = keyidElement.getText();
                            break;
                        }
                        this.loginSucceeded = this.mapKeyIdToToken(hashedKeyId, encodetypeQN, valuetypeQN, messageContext);
                    }
                }
            } else {
                String tokenId;
                String keyInfoType = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
                boolean isStrref = false;
                boolean isKeyId = false;
                if (keyInfoType == null) {
                    isStrref = false;
                    isKeyId = false;
                } else {
                    isKeyId = ConfigUtil.isKeyInfoKeyid(keyInfoType);
                    isStrref = ConfigUtil.isKeyInfoStrref(keyInfoType);
                }
                if (isStrref) {
                    tokenId = (String)this._context.get(Constants.WSSECURITY_KEY_REFERENCE);
                    this.loginSucceeded = this.mapRefUriToToken(tokenId);
                } else if (isKeyId) {
                    tokenId = (String)this._context.get(Constants.WSSECURITY_KEY_ID);
                    QName enctype = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
                    QName valuetype = (QName)this._context.get(Constants.WSSECURITY_KEY_VALUETYPE);
                    this.loginSucceeded = this.mapKeyIdToToken(tokenId, enctype, valuetype, messageContext);
                }
                if (this.loginSucceeded) {
                    KeyInfoContentConsumerConfig keyInfoContent = (KeyInfoContentConsumerConfig)this._context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentConsumer.configKey");
                    DerivedKeyInfoConfig dkic = keyInfoContent.getDerivedKeyInfoConfig();
                    if (dkic != null && dkic.isRequireDerivedKeys()) {
                        if (tc.isDebugEnabled()) {
                            Tr.exit(tc, "DerivedKey is required.");
                        }
                        if (dkic.isRequireImpliedDerivedKeys()) {
                            if (tc.isDebugEnabled()) {
                                Tr.exit(tc, "ImpliedDerivedKeys is used.");
                            }
                            byte[] secret = ((KRB5TokenImpl)this._token).getAPREQKeyByte();
                            this._sharedState.put("com.ibm.wsspi.wssecurity.dktlogin.referencedTokenKeyBytes", secret);
                            this._context.put("com.ibm.ws.wssecurity.sc.dkt.baseToken", this._token);
                        }
                    } else {
                        this.loginSucceeded = this.retrieveKey();
                    }
                }
            }
            if (tc.isDebugEnabled() && this._token instanceof KRB5TokenImpl) {
                KRB5TokenImpl ktoken = (KRB5TokenImpl)this._token;
                Tr.debug(tc, "Principal from request Kerberos token: " + ktoken.getClientPrincipal());
                Tr.debug(tc, "Expired time for request TGT Kerberos token: " + ktoken.getTokenExpiration());
                KerberosTicket krbtkt = ktoken.getKerberosTicket();
                if (krbtkt != null) {
                    Tr.debug(tc, "Request Krb ticket in request Kerberos token: " + krbtkt.toString());
                } else {
                    Tr.debug(tc, "No Kerberos ticket is accessible at the moment.");
                }
            }
        }
        catch (Throwable t) {
            Tr.error(tc, "security.wssecurity.KRBConsumeLoginModule.s02", t);
            throw new LoginException(newline + ConfigUtil.getMessage("security.wssecurity.KRBConsumeLoginModule.s02", new String[]{KRB5Util.stackToString(t)}));
        }
        if (this.loginSucceeded && this._token instanceof KRB5TokenImpl) {
            TokenHolder.setInboundTokenToContext((KRB5TokenImpl)this._token, messageContext);
            if (this._isAuthnEventsRequired) {
                KRB5TokenImpl ktoken = (KRB5TokenImpl)this._token;
                Map<String, Object> auditContext = this._wssAuditEventGenerator.setExtendedAuditData(this._context, "TokenId", ktoken.getId());
                this._wssAuditEventGenerator.addExtendedAuditData(auditContext, "TokenPrincipal", ktoken.getPrincipal());
                this._wssAuditEventGenerator.addExtendedAuditData(auditContext, "Expiration", new Long(ktoken.getTokenExpiration()).toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private boolean verifyDKTokenElement(OMElement target, TokenConsumerConfig tconfig, QName valueTypeQName, MessageContext messageContext) throws LoginException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("consumeDKTokenElement(");
            buf.append("\nOMElement target [").append(DOMUtils.getDisplayName(target)).append("], ");
            Tr.entry(tc, buf.toString());
        }
        boolean returnVal = false;
        int wssVersion = 0;
        Object obj = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String tokenId = null;
        String refTokenUri = null;
        OMElement elem = DOMUtils.getChildElement(target, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "SecurityTokenReference");
        if (elem != null && (elem = DOMUtils.getChildElement(elem, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "Reference")) != null) {
            refTokenUri = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.URI_Q);
            if (KRB5Util.hasValue(refTokenUri)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reference Token URI in DerivedKeyToken element: " + refTokenUri);
                }
                tokenId = refTokenUri.startsWith("#") ? refTokenUri.substring(1) : refTokenUri;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No Reference token URI is found.");
            }
        }
        if (tokenId != null) {
            returnVal = this.mapRefUriToToken(tokenId);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No token id is located via Reference-URI. Try KeyIdentifier...");
            }
            if ((elem = DOMUtils.getChildElement(target, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "SecurityTokenReference")) != null && (elem = DOMUtils.getChildElement(elem, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "KeyIdentifier")) != null) {
                String enctype = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.ENCODINGTYPE_Q);
                String valtype = elem.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q);
                QName enctypeQN = DOMUtils.getQName(elem, enctype, wssVersion);
                QName valtypeQN = DOMUtils.getQName(elem, valtype, wssVersion);
                String kidValue = DOMUtils.getStringValue(elem);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "\nFound EncodingType: " + enctypeQN + newline + "Found ValueType: " + valtypeQN + newline + "Found KeyIdentifier value: " + kidValue);
                }
                if (KRB5Util.hasValue(kidValue)) {
                    returnVal = this.mapKeyIdToToken(kidValue, enctypeQN, valtypeQN, messageContext);
                }
            }
        }
        return returnVal;
    }

    private boolean retrieveKey() throws LoginException, InvalidKeyException, NoSuchProviderException, InvalidKeySpecException, NoSuchAlgorithmException {
        boolean isVerifying;
        boolean isDecrypting;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveKey()");
        }
        boolean result = false;
        byte[] keybytes = null;
        Object keytype = null;
        KRB5TokenImpl krb5token = null;
        if (this._token != null) {
            if (!(this._token instanceof KRB5TokenImpl)) {
                return true;
            }
            krb5token = (KRB5TokenImpl)this._token;
            if (krb5token == null) {
                throw new LoginException(newline + ConfigUtil.getMessage("Cannot find a kerberos token to generate required key."));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found kerberos token of token id: " + krb5token.getId());
            }
            keybytes = krb5token.getAPREQKeyByte();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Kerberos key length is " + (keybytes != null && keybytes.length != 0 ? keybytes.length : 0) + ", from token with id: " + krb5token.getId());
            }
        } else {
            throw new LoginException(newline + ConfigUtil.getMessage("Cannot find a kerberos token to generate required key."));
        }
        String keyType = (String)this._context.get(Constants.WSSECURITY_KEY_TYPE);
        if (keyType == null) {
            isDecrypting = false;
            isVerifying = false;
        } else {
            isVerifying = "VerifyingKey".equals(keyType);
            isDecrypting = "DecryptingKey".equals(keyType);
            if (tc.isDebugEnabled()) {
                if (isVerifying) {
                    Tr.debug(tc, "Verifying key type");
                } else if (isDecrypting) {
                    Tr.debug(tc, "Decrypting key type");
                }
            }
        }
        if (!isVerifying && !isDecrypting) {
            throw new LoginException(newline + ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.getKey02", new String[]{keyType}));
        }
        String keyalgo = null;
        String keyalgoURI = (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyalgoURI: " + keyalgoURI);
        }
        if (keyalgoURI != null) {
            keyalgo = DKTGenerateLoginModule.mapKeyAlgorithm2JCE((String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm"), isVerifying, isDecrypting, false, false);
            if (keyalgo == null) {
                throw new LoginException("Missing Algorithm info in the config");
            }
        }
        int minKeySize = 16;
        int maxKeySize = 32;
        WSSConsumerConfig cconfig = (WSSConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        TokenConsumerConfig tconfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        Object dkey = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isVerifying: " + isVerifying);
            Tr.debug(tc, "isDecrypting: " + isDecrypting);
            Tr.debug(tc, "keyalgo: " + keyalgo);
        }
        if (isVerifying) {
            if (keyalgo.compareTo("HmacSHA1") == 0) {
                if (krb5token != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "krb5token: " + krb5token);
                        Tr.debug(tc, "minKeySize: " + minKeySize);
                    }
                    SecretKeySpec secretKeySp = new SecretKeySpec(keybytes, "HmacSHA1");
                    krb5token.setKey(63, secretKeySp);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SecurityToken.VERIFYING_KEY: " + secretKeySp);
                    }
                }
                result = true;
            } else {
                result = false;
            }
        }
        if (isDecrypting) {
            if (keyalgo.compareTo("AES") == 0 || keyalgo.compareTo("DESede") == 0) {
                if (keyalgo.compareTo("AES") == 0) {
                    if (krb5token != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "krb5token: " + krb5token);
                            Tr.debug(tc, "minKeySize: " + minKeySize);
                        }
                        AESKeySpec aesKeySpec = new AESKeySpec(keybytes);
                        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES", "IBMJCE");
                        SecretKey key = keyFactory.generateSecret((KeySpec)aesKeySpec);
                        krb5token.setKey(64, key);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SecurityToken.DECRYPTING_KEY: " + key);
                        }
                    }
                    result = true;
                } else if (keyalgo.compareTo("DESede") == 0) {
                    if (krb5token != null) {
                        DESedeKeySpec desKeySpec = new DESedeKeySpec(keybytes);
                        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede", "IBMJCE");
                        SecretKey key = keyFactory.generateSecret(desKeySpec);
                        krb5token.setKey(64, key);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "SecurityToken.DECRYPTING_KEY: " + key);
                        }
                    }
                    result = true;
                }
            } else {
                result = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveKey()");
        }
        return result;
    }

    private boolean mapRefUriToToken(String tokenId) {
        TokenConsumerConfig tconfig;
        SecurityToken existToken;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapRefUriToToken()");
        }
        boolean result = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token identifier is [" + tokenId + "]");
        }
        if ((existToken = this._securityTokenManager.getToken(tconfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey"), tokenId)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WARNING: SecurityToken whose identifier is \"" + tokenId + "\" was not found in the Subject.");
            }
            result = false;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is the token [" + tokenId + "] stored in the Subject.");
                Tr.debug(tc, "Token instance: " + existToken + " and hashcode: " + existToken.hashCode());
            }
            this._token = existToken;
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapRefUriToToken()");
        }
        return result;
    }

    private boolean mapKeyIdToToken(String tokenId, QName enctype, QName valuetype, MessageContext messageContext) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapKeyIdToToken() for token id: " + tokenId + "...encoding type: " + enctype + "...value type:" + valuetype);
        }
        if (enctype == null || !enctype.equals(com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
            throw new LoginException(this.getClass().getName() + "Unexpected Encoding type : " + enctype + " for key id: " + tokenId);
        }
        if (valuetype == null || !valuetype.equals(com.ibm.ws.wssecurity.common.Constants.KRB5_APREQ_SHA1)) {
            throw new LoginException(this.getClass().getName() + "Unexpected Value type : " + valuetype + " for key id: " + tokenId);
        }
        TokenConsumerConfig tconfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        this._token = this._securityTokenManager.getToken(tconfig, tokenId);
        if (this._token != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Found token from SecurityTokenManager");
            }
            return true;
        }
        TGSAuthToken serviceToken = TokenHolder.getKerberosTokenFromContext(messageContext);
        if (serviceToken == null && (serviceToken = (TGSAuthToken)CacheableTokenCacheFactory.getInstance().getToken(tokenId)) == null) {
            boolean Found = false;
            for (int loop = 0; !Found && loop < 20; ++loop) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                serviceToken = (TGSAuthToken)CacheableTokenCacheFactory.getInstance().getToken(tokenId);
                if (serviceToken == null) continue;
                Found = true;
            }
        }
        if (serviceToken != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Service token expiration time: " + serviceToken.getServiceTicketExpirationTime());
            }
            if (!KRB5TokenCacheUtil.isTicketValid(null, serviceToken.getServiceTicketExpirationTime())) {
                QName soapFault = SoapSecurityFaultCode.InvalidSecurityToken;
                this._context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
                throw new LoginException(this.getClass().getName() + "Failed to locate token of: " + valuetype + " for key id: " + tokenId);
            }
        }
        if (serviceToken == null) {
            QName soapFault = SoapSecurityFaultCode.SecurityTokenUnavailable;
            this._context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
            throw new LoginException(this.getClass().getName() + "Failed to locate token of: " + valuetype + " for key id: " + tokenId);
        }
        KRB5TokenImpl krb5token = KRBGenerateLoginModule.createKrbTokenImpl(serviceToken);
        krb5token.setId(tokenId);
        krb5token.setIdentifier(krb5token.getSHA1ofAPREQ());
        this._token = krb5token;
        this.updateSharedState();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapKeyIdToToken()");
        }
        return true;
    }

    private boolean processBST(OMElement targetElem, KRB5TokenImpl krb5token, KRBTokenConsumeCallback callback, QName tokenValueType, boolean requireAPREQ, MessageContext messageContext) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processBST()");
        }
        boolean loginSucceeded = false;
        String tokenId = null;
        QName idattr = IdUtils.getInstance().getIdAttributeName(targetElem);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier attribute of the target element is [" + idattr + "].");
        }
        if (idattr != null) {
            tokenId = targetElem.getAttributeValue(idattr);
        }
        String encoded = DOMUtils.getStringValue(targetElem);
        byte[] in_token = Base64.decode(encoded);
        if (tc.isDebugEnabled()) {
            HexDumpEncoder hex = new HexDumpEncoder();
            Tr.debug(tc, "Processing inbound AP_REQ token:\n\n" + hex.encodeBuffer(in_token) + "\n\n");
            Tr.debug(tc, "in_token length= " + in_token.length);
        }
        if (in_token == null || in_token.length == 0) {
            throw new LoginException("Unexpected empty token bytes received");
        }
        TGSAuthToken serviceToken = this.validate(in_token, tokenValueType);
        if (serviceToken == null) {
            throw new LoginException("Failed to validate and consume the Kerberos token. No service security token is established for the service.");
        }
        serviceToken.setIdentifier(serviceToken.getSHA1ofAPREQ());
        long expirationTime = serviceToken.getServiceTicketExpirationTime().getTime();
        if (requireAPREQ) {
            TokenHolder.setInboundKerberosTokenToContext(serviceToken, messageContext);
        } else {
            CacheableTokenCacheFactory.getInstance().cacheToken(serviceToken.getIdentifier(), serviceToken, expirationTime);
        }
        krb5token = KRBGenerateLoginModule.createKrbTokenImpl(serviceToken);
        krb5token.setId(tokenId);
        krb5token.setXML(new OMStructure(targetElem));
        krb5token.setBinary(in_token);
        krb5token.setIdentifier(krb5token.getSHA1ofAPREQ());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Completing the establishment of token: " + krb5token + " for <" + krb5token.getPrincipal() + "> with hashcode: " + krb5token.hashCode());
        }
        this._token = krb5token;
        this.updateSharedState();
        loginSucceeded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processBST()");
        }
        return loginSucceeded;
    }

    private TGSAuthToken validate(byte[] inbound_token, QName tokenValueType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        TGSAuthToken serviceToken = null;
        boolean succeeded = false;
        String userPrincipal = "";
        String was_principal = "";
        String acceptorPrincipal = "";
        HashMap<String, Object> contextMap = null;
        try {
            TokenConsumerConfig tconfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
            CallbackHandlerConfig cconfig = tconfig.getCallbackHandler();
            Map<Object, Object> m = cconfig.getProperties();
            HashMap<String, byte[]> initMap = new HashMap<String, byte[]>();
            initMap.put("decodedToken", inbound_token);
            KerberosTokenConsumer ktc = new KerberosTokenConsumer();
            ktc.init(initMap);
            contextMap = new HashMap<String, Object>();
            ktc.invoke(contextMap);
            byte[] keyUsed = (byte[])contextMap.get("contextSubKeyBytes");
            Object keyType = contextMap.get("contextSubKeyBytesType");
            Object keyEncp = contextMap.get("contextSubKeyEnc");
            Object keyEncpClass = contextMap.get("contextSubKeyEncType");
            if (!KRB5Util.hasValue(keyUsed)) {
                keyUsed = (byte[])contextMap.get("contextSessionKeyBytes");
                keyType = contextMap.get("contextSessionKeyBytesType");
                keyEncp = contextMap.get("contextSessionKeyEnc");
                keyEncpClass = contextMap.get("contextSessionKeyEncType");
                if (KRB5Util.hasValue(keyUsed) && !KRB5Util.isSessKeyEncTypeSupported((Integer)keyEncp)) {
                    throw new LoginException("\nUnsupported Kerberos session key encryption type...Please verify Kerberos configuration.");
                }
            } else if (!KRB5Util.isSubKeyEncTypeSupported((Integer)keyEncp)) {
                throw new LoginException("\nUnsupported Kerberos sub key encryption type...Please verify Kerberos configuration.");
            }
            if (tc.isDebugEnabled()) {
                if (keyUsed != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key of type: " + keyType + " with encryption type: " + keyEncpClass + " from token as follows...\r\n" + KRB5Util.showHex(keyUsed));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server subkey or sessoin key is null ...\r\n");
                }
            }
            if (keyUsed != null && keyUsed.length != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Request token processed OK");
                }
                if ((userPrincipal = (String)contextMap.get("clientName")) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getAuthenticatedUsername: WebSphere Security principal = " + userPrincipal);
                    }
                    if ((was_principal = KRB5Util.stripOutPrincipalName(userPrincipal)) != null) {
                        succeeded = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Kerberos client principal: " + was_principal);
                        }
                    }
                    String apReqSha1 = KRB5TokenCacheUtil.getSha1FromBytes(inbound_token);
                    serviceToken = new TGSAuthToken(contextMap, null, null, tokenValueType, apReqSha1);
                } else {
                    succeeded = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "User principal is not available.");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Request token processed Not OK");
            }
        }
        catch (GSSException e) {
            QName soapFault = SoapSecurityFaultCode.InvalidSecurityToken;
            this._context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
            FFDCFilter.processException(e, KRBConsumeLoginModule.class.getName(), "1");
            Tr.processException((Throwable)e, clsName + ".login", "%C", this);
            Tr.error(tc, "security.wssecurity.KRBConsumeLoginModule.s02", KRB5Util.stackToString(e));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Please verify the Kerberos configuration.");
            }
            succeeded = false;
        }
        catch (Throwable e2) {
            QName soapFault = SoapSecurityFaultCode.InvalidSecurityToken;
            this._context.put("com.ibm.ws.wssecurity.sc.FaultCode", soapFault);
            FFDCFilter.processException(e2, KRBConsumeLoginModule.class.getName(), "1");
            Tr.processException(e2, clsName + ".login", "%C", this);
            Tr.error(tc, "security.wssecurity.KRBConsumeLoginModule.s02", KRB5Util.stackToString(e2));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Please verify the Kerberos configuration.");
            }
            succeeded = false;
        }
        if (!succeeded) {
            serviceToken = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return serviceToken;
    }

    private void updateSharedState() {
        if (this._token == null) {
            return;
        }
        String was_principal = this._token.getPrincipal();
        if (was_principal != null) {
            this._sharedState.put("com.ibm.wsspi.wssecurity.Constants.DN", was_principal);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Kerberos client principal: " + was_principal);
            }
        }
    }
}

