/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ws.wssecurity.platform.websphere.token.KRBTicket;
import com.ibm.ws.wssecurity.token.CacheableToken;
import com.ibm.ws.wssecurity.util.KRB5Util;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ObjectOutputInputUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.BinarySecurityTokenImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KRBAuthnTokenImpl
extends BinarySecurityTokenImpl
implements KRBAuthnToken,
KRBTicket,
CacheableToken,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    private static final String VERSION_NUMBER = "1.0";
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static final long DEFAULT_TOKEN_CUSHION = 600000L;
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static MessageDigest md = null;
    private static final TraceComponent tc = Tr.register(KRBAuthnTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static GSSManager gssMgr = null;
    private short version = 1;
    private byte[] tokenBytes = null;
    private String uniqueId = null;
    private String kpn = null;
    private String realm = null;
    protected KerberosTicket tgt = null;
    private GSSCredential gssCred = null;
    private long expiration = 0L;
    private String tokenName = WSSECURITY_KRBAUTHNTOKEN_NAME;
    private boolean isReadOnly = false;
    private Date renewTill = null;
    private Hashtable<String, String> kData = null;
    private String identifier = null;
    private boolean isAddressless = false;
    private boolean isForwardable = false;
    private boolean isRenewable = false;
    private int credType = 0;
    private byte[] apReqBytes = null;

    public KRBAuthnTokenImpl() {
    }

    public KRBAuthnTokenImpl(byte[] inputTokenBytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBAuthnTokenImpl(TokenBytes)");
        }
        this.tokenBytes = inputTokenBytes;
        if (this.tokenBytes != null) {
            try {
                ByteArrayInputStream bayin = new ByteArrayInputStream(this.tokenBytes);
                ObjectInputStream in = new ObjectInputStream(bayin);
                this.readExternal(in);
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{e});
                System.out.println("cyc> exception 2 e = " + e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBAuthnTokenImpl(TokenBytes)");
        }
    }

    public KRBAuthnTokenImpl(Map map) {
        int index;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBAuthnTokenImpl(map): ");
        }
        this.kpn = (String)map.get(KRBAuthnTokenFactory.PRINCIPAL_NAME);
        this.tgt = (KerberosTicket)map.get(KRBAuthnTokenFactory.KERBEROS_TICKET);
        this.gssCred = (GSSCredential)map.get(KRBAuthnTokenFactory.GSS_CREDENTIAL);
        this.realm = (String)map.get(KRBAuthnTokenFactory.REALM_NAME);
        Long exp = (Long)map.get(KRBAuthnTokenFactory.EXPIRATION_TIME);
        if (exp != null) {
            this.expiration = exp;
        }
        if (this.tgt != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TGT: " + KRB5Util.printTGT(this.tgt));
            }
            if (this.kpn == null) {
                this.kpn = this.tgt.getClient().toString();
            }
            if (!map.containsKey(KRBAuthnTokenFactory.EXPIRATION_TIME)) {
                this.expiration = this.tgt.getEndTime().getTime();
            }
            this.renewTill = this.tgt.getRenewTill();
            this.isAddressless = this.tgt.getClientAddresses() == null;
            this.isForwardable = this.tgt.isForwardable();
            this.isRenewable = this.tgt.isRenewable();
        } else if (this.gssCred != null) {
            try {
                if (this.kpn == null) {
                    this.kpn = ((Object)this.gssCred.getName()).toString();
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{e});
            }
        }
        if (this.gssCred != null) {
            long gssExp = 0L;
            try {
                gssExp = this.gssCred.getRemainingLifetime();
                gssExp = gssExp * 1000L + System.currentTimeMillis();
                if (gssExp < this.expiration || this.expiration == 0L) {
                    this.expiration = gssExp;
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{e});
            }
        }
        if (this.realm == null && this.kpn != null && (index = this.kpn.indexOf("@")) != -1) {
            this.realm = this.kpn.substring(index + 1, this.kpn.length());
        }
        this.principal = KRB5Util.stripOutPrincipalName(this.kpn);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBAuthnTokenImpl(map) = " + this.toString());
        }
    }

    public GSSCredential getGSSCredential() throws SoapSecurityException {
        if (this.gssCred == null && this.tgt != null) {
            try {
                this.gssCred = this.getGSSCredential(this.tgt);
            }
            catch (PrivilegedActionException pE) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{pE});
                throw new SoapSecurityException(pE);
            }
        }
        if (tc.isDebugEnabled()) {
            if (this.gssCred != null) {
                Tr.debug(tc, "this.gssCred = " + this.gssCred.toString());
            } else {
                Tr.debug(tc, "this.gssCred = null");
                if (this.tgt == null) {
                    Tr.debug(tc, "this.tgt = null");
                }
            }
        }
        return this.gssCred;
    }

    private GSSCredential getGSSCredential(final KerberosTicket ticket) throws PrivilegedActionException {
        GSSCredential gssCrd = null;
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(ticket);
        gssCrd = (GSSCredential)Subject.doAs(subject, new PrivilegedExceptionAction(){

            public Object run() throws SoapSecurityException {
                GSSCredential gc = KRBAuthnTokenImpl.this.createGSSCredential(ticket);
                return gc;
            }
        });
        return gssCrd;
    }

    private GSSCredential createGSSCredential(KerberosTicket ticket) throws SoapSecurityException {
        GSSCredential gssCrd = null;
        if (ticket != null) {
            try {
                String clientName = ticket.getClient().getName();
                Oid krbOid = new Oid(KRB5_OID);
                if (clientName != null && clientName.length() > 0) {
                    if (gssMgr == null) {
                        gssMgr = GSSManager.getInstance();
                    }
                    GSSName gssName = gssMgr.createName(clientName, GSSName.NT_USER_NAME, krbOid);
                    gssCrd = gssMgr.createCredential(gssName.canonicalize(krbOid), Integer.MAX_VALUE, krbOid, 1);
                }
            }
            catch (Throwable t) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{t});
                throw new SoapSecurityException(t);
            }
        }
        return gssCrd;
    }

    public boolean isAddressless() {
        return this.isAddressless;
    }

    public boolean isRenewable() {
        return this.isRenewable;
    }

    public Date getRenewTill() {
        return this.renewTill;
    }

    public String getTokenRealm() {
        return this.realm;
    }

    public KerberosTicket getKerberosTicket() {
        return this.tgt;
    }

    public String[] addTokenAttribute(String key, String value) {
        if (!this.isReadOnly) {
            String oldvalue;
            if (this.kData == null) {
                this.kData = new Hashtable();
            }
            if ((oldvalue = this.kData.put(key, value)) != null) {
                String[] returnedData = new String[]{oldvalue};
                return returnedData;
            }
        }
        return null;
    }

    public Enumeration getTokenAttributeNames() {
        if (this.kData == null) {
            this.kData = new Hashtable();
        }
        return this.kData.keys();
    }

    public String[] getTokenAttributes(String key) {
        String data;
        if (this.kData == null) {
            this.kData = new Hashtable();
        }
        if ((data = this.kData.get(key)) != null) {
            String[] returnedData = new String[]{data};
            return returnedData;
        }
        return null;
    }

    public byte[] getTokenBytes() {
        try {
            ByteArrayOutputStream bayout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bayout);
            this.writeExternal(out);
            out.flush();
            out.close();
            this.tokenBytes = bayout.toByteArray();
        }
        catch (Exception e) {
            Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{e});
            throw new RuntimeException(e.getMessage());
        }
        return this.tokenBytes;
    }

    public long getTokenExpiration() {
        return this.expiration;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public String getTokenPrincipal() {
        return KRB5Util.stripOutPrincipalName(this.kpn);
    }

    public String getTokenUniqueID() {
        if (this.uniqueId == null) {
            if (this.tgt != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KRBAuthnTokenImpl: using principal name and hash of TGT for unique ID");
                }
                this.uniqueId = ((Object)this.tgt).hashCode() > 0 ? this.kpn + ((Object)this.tgt).hashCode() : this.kpn + -1 * ((Object)this.tgt).hashCode() + "n";
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "KRBAuthnTokenImpl: using principal for unique ID");
                }
                this.uniqueId = this.kpn;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KRBAuthnTokenImpl: token unique ID = " + this.uniqueId);
        }
        return this.uniqueId;
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.tgt.getClient().getName();
        }
        return this.identifier;
    }

    public void setIdentifier(String idd) {
        this.identifier = idd;
    }

    public short getTokenVersion() {
        return this.version;
    }

    public boolean isTokenForwardable() {
        return this.isForwardable;
    }

    public boolean isTokenValid() {
        long current_time = System.currentTimeMillis();
        long timeRemaining = this.expiration - current_time;
        return timeRemaining >= 0L;
    }

    public void setTokenReadOnly() {
        this.isReadOnly = true;
    }

    public boolean isKRBAuthnToken(byte[] inBytes) {
        boolean isKRB;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isKRBAuthnToken(byte[] inBytes)");
            }
            isKRB = false;
            if (inBytes != null) {
                try {
                    String name;
                    ByteArrayInputStream bayin = new ByteArrayInputStream(inBytes);
                    ObjectInputStream in = new ObjectInputStream(bayin);
                    String version = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.version");
                    if (VERSION_NUMBER.equals(version) && KRBAuthnToken.WSSECURITY_KRBAUTHNTOKEN_NAME.equals(name = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.tokenName"))) {
                        isKRB = true;
                    }
                    in.close();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "isKRBAuthnToken. Can not determind if this is a KRBAuthnToken.", e.getCause());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKRBAuthnToken(byte[] inBytes)");
        }
        return isKRB;
    }

    public synchronized boolean refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reflesh()");
        }
        boolean ok = false;
        if (this.tgt != null) {
            try {
                KRBAuthnTokenImpl newToken = new KRBAuthnTokenImpl(this.getTokenBytes());
                newToken.tgt.refresh();
                this.tgt = newToken.tgt;
                this.expiration = this.tgt.getEndTime().getTime();
                this.gssCred = this.getGSSCredential(this.tgt);
                ok = true;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TGT reflesh Failed with Exception", e.getMessage());
                }
                Tr.warning(tc, "TGT reflesh failed. The downstream invocation with current TGT may fail.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reflesh()");
        }
        return ok;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readExternal(ObjectInput in)");
        }
        if (VERSION_NUMBER.equals(version = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.version"))) {
            this.tokenName = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.tokenName");
            this.credType = ObjectOutputInputUtil.readInt(in, "KRBAuthnToken.credType");
            this.kpn = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.kpn");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "this.kpn=" + this.kpn);
            }
            this.uniqueId = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.uniqueId");
            this.identifier = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.identifier");
            this.realm = ObjectOutputInputUtil.readUTF(in, "KRBAuthnToken.realm");
            this.expiration = ObjectOutputInputUtil.readLong(in, "KRBAuthnToken.expiration");
            this.readOnly = ObjectOutputInputUtil.readBoolean(in, "KRBAuthnToken.readOnly");
            Object tmp = ObjectOutputInputUtil.readObject(in, "KRBAuthnToken.kData");
            if (tmp != null) {
                this.kData = (Hashtable)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "KRBAuthnToken.tgt")) != null) {
                this.tgt = (KerberosTicket)tmp;
            }
            if ((tmp = ObjectOutputInputUtil.readObject(in, "KRBAuthnToken.APREQ")) != null) {
                this.apReqBytes = (byte[])tmp;
            }
            if (this.tgt != null) {
                try {
                    this.gssCred = this.getGSSCredential(this.tgt);
                }
                catch (PrivilegedActionException pE) {
                    Tr.error(tc, "security.wssecurity.WSSConsumer.s34", new Object[]{pE});
                    throw new IOException(pE);
                }
                this.renewTill = this.tgt.getRenewTill();
                this.isAddressless = this.tgt.getClientAddresses() == null;
                this.isForwardable = this.tgt.isForwardable();
                this.isRenewable = this.tgt.isRenewable();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readExternal(ObjectInput in)=" + in.available());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeExternal(ObjectOutput out)");
        }
        ObjectOutputInputUtil.writeUTF(out, VERSION_NUMBER, "KRBAuthnToken.version");
        ObjectOutputInputUtil.writeUTF(out, this.tokenName, "KRBAuthnToken.tokenName");
        ObjectOutputInputUtil.writeInt(out, this.credType, "KRBAuthnToken.credType");
        ObjectOutputInputUtil.writeUTF(out, this.kpn, "KRBAuthnToken.kpn");
        ObjectOutputInputUtil.writeUTF(out, this.uniqueId, "KRBAuthnToken.uniqueId");
        ObjectOutputInputUtil.writeUTF(out, this.identifier, "KRBAuthnToken.identifier");
        ObjectOutputInputUtil.writeUTF(out, this.realm, "KRBAuthnToken.realm");
        ObjectOutputInputUtil.writeLong(out, this.expiration, "KRBAuthnToken.expiration");
        ObjectOutputInputUtil.writeBoolean(out, this.readOnly, "KRBAuthnToken.readOnly");
        ObjectOutputInputUtil.writeObject(out, this.kData, "KRBAuthnToken.kData");
        ObjectOutputInputUtil.writeObject(out, this.tgt, "KRBAuthnToken.tgt");
        ObjectOutputInputUtil.writeObject(out, this.apReqBytes, "KRBAuthnToken.APREQ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeExternal(ObjectOutput out): this.tgt = " + KRB5Util.printTGT(this.tgt));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Date exp = new Date(this.expiration);
        new Date(this.expiration);
        sb.append("\ntoken name:         " + this.tokenName);
        sb.append("\nversion:            " + this.version);
        sb.append("\nhashCode:           " + this.hashCode());
        sb.append("\nuniqueId:           " + this.uniqueId);
        sb.append("\nkerberos principal: " + this.kpn);
        sb.append("\nrealm:              " + this.realm);
        sb.append("\nexpiration:         " + exp);
        sb.append("\nrenew until:        " + this.renewTill);
        sb.append("\nisReadOnly:         " + this.isReadOnly);
        sb.append("\nisAddressless:      " + this.isAddressless);
        sb.append("\nisForwardable:      " + this.isForwardable);
        sb.append("\nisRenewable:        " + this.isRenewable);
        sb.append("\nKerberosTicket:     " + KRB5Util.printTGT(this.tgt));
        sb.append("\nGSSCredential:      " + this.gssCred);
        return sb.toString();
    }
}

