/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.sig.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignPart;
import com.ibm.websphere.wssecurity.wssapi.spec.TransformParameterSpec;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSSignPartImpl
implements WSSSignPart {
    private static final TraceComponent tc = Tr.register(WSSSignPartImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSSignPartImpl.class.getName();
    private static final long serialVersionUID = -8045109640922047674L;
    private static final Map<Integer, String> partMap = new HashMap<Integer, String>();
    private SecurityToken token;
    private List<AlgorithmParameterData> transforms = new ArrayList<AlgorithmParameterData>();
    private String digestMethod = DefaultValueManager.getInstance().getDigestMethod();
    private String dialect = Constants.DIALECT_WAS;
    private String keyword;
    private String headerNamespace;
    private String headerName;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSSignPartImpl(SecurityTokenManagerImpl securityTokenManager) {
        this.securityTokenManager = securityTokenManager;
    }

    public WSSSignPartImpl(SecurityToken token, SecurityTokenManagerImpl securityTokenManager) {
        this.token = token;
        this.securityTokenManager = securityTokenManager;
        SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(this.token);
        tokenWrapper.setWssapiReferenceType(DefaultValueManager.getInstance().getTokenReferenceForSignature());
    }

    @Override
    public void addTransform(String algorithm, TransformParameterSpec paramSpec) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransform( algorithm[" + algorithm + "], TransformParameterSpec)");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getTransformAlgorithms().contains(algorithm)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s12";
            WSSException e = WSSException.format(msg, algorithm);
            Tr.processException((Throwable)e, clsName + ".addTransform", "135", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        AlgorithmParameterData paramData = new AlgorithmParameterData(algorithm, paramSpec);
        this.transforms.add(paramData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransform( algorithm, TransformParameterSpec)");
        }
    }

    @Override
    public void addTransform(String algorithm) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransform(" + algorithm + ")");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getTransformAlgorithms().contains(algorithm)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s12";
            WSSException e = WSSException.format(msg, algorithm);
            Tr.processException((Throwable)e, clsName + ".addTransform", "164", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        AlgorithmParameterData paramData = new AlgorithmParameterData(algorithm);
        this.transforms.add(paramData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransform(String algorithm)");
        }
    }

    @Override
    public void setDigestMethod(String algorithm) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDigestMethod(" + algorithm + ")");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getDigestAlgorithms().contains(algorithm)) {
            WSSException e = WSSException.format("security.wssecurity.PrivateConsumerConfig.s11", algorithm);
            Tr.processException((Throwable)e, clsName + ".setDigestMethod", "190", this);
            Tr.error(tc, clsName + "PrivateConsumerConfig.s11", new Object[]{e});
        }
        this.digestMethod = algorithm;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDigestMethod(String algorithm)");
        }
    }

    @Override
    public void setSignHeader(QName header) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignHeader(" + header + ")");
        }
        this.dialect = Constants.DIALECT_HEADER;
        this.headerNamespace = header.getNamespaceURI();
        this.headerName = header.getLocalPart();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], headerNamespace=[" + this.headerNamespace + "], headerName=[" + this.headerName + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignHeader(QName)");
        }
    }

    @Override
    public void setSignPart(SecurityToken securityToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignPart(" + securityToken.toString() + ")");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = IntegralDialectElementSelector.WASDIALECTS[2];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignHeader(SecurityToken)");
        }
    }

    @Override
    public void setSignPart(int part) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignPart(" + part + ")");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = this.getKeyword(part);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignPart(int)");
        }
    }

    @Override
    public void setSignPart(WSSTimestamp timestamp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignPart(" + timestamp + ")");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = IntegralDialectElementSelector.WASDIALECTS[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignPart(WSSTimestamp)");
        }
    }

    @Override
    public void setSignPartByXPath(String xpath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignPartByXPath(" + xpath + ")");
        }
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = xpath;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignPartByXPath(String)");
        }
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public List<AlgorithmParameterData> getTransforms() {
        return this.transforms;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getHeaderNamespace() {
        return this.headerNamespace;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getKeyword(int part) throws WSSException {
        String keyword;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyword( " + part + ")");
        }
        if ((keyword = partMap.get(part)) == null) {
            String msg = "security.wssecurity.WSEC7010E";
            WSSException e = WSSException.format(msg);
            Tr.processException((Throwable)e, clsName + ".getKeyword", "391", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyword( " + part + ")");
        }
        return keyword;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    static {
        partMap.put(21, IntegralDialectElementSelector.WASDIALECTS[0]);
        partMap.put(22, IntegralDialectElementSelector.WASDIALECTS[13]);
        partMap.put(23, IntegralDialectElementSelector.WASDIALECTS[1]);
    }
}

