/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.enc.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryptPart;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSEncryptionImpl
implements WSSEncryption,
Generatable {
    private static final TraceComponent tc = Tr.register(WSSEncryptionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSEncryptionImpl.class.getName();
    private static final long serialVersionUID = -5305579588438074252L;
    private static Map<Integer, String> referenceMap = new HashMap<Integer, String>();
    private SecurityToken token;
    private List<SecurityToken> tokensToBeEncrypted = new ArrayList<SecurityToken>();
    private List<WSSEncryptPart> encryptParts = new ArrayList<WSSEncryptPart>();
    private String encryptionMethod = DefaultValueManager.getInstance().getDataEncryptionMethod();
    private String keyEncryptionMethod = DefaultValueManager.getInstance().getKeyEncryptionMethod();
    private boolean encryptKey = DefaultValueManager.getInstance().isKeyEncrypted();
    private boolean optimized = DefaultValueManager.getInstance().isOptimized();
    private int tokenReference;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSEncryptionImpl(SecurityTokenManagerImpl securityTokenManager) {
        this.securityTokenManager = securityTokenManager;
        this.tokenReference = DefaultValueManager.getInstance().getTokenReferenceForEncryption();
    }

    public WSSEncryptionImpl(SecurityToken token, SecurityTokenManagerImpl securityTokenManager) {
        this.token = token;
        this.securityTokenManager = securityTokenManager;
        SecurityTokenWrapper tokenWrapper = securityTokenManager.getTokenWrapper(this.token);
        tokenWrapper.setWssapiReferenceType(DefaultValueManager.getInstance().getTokenReferenceForEncryption());
    }

    @Override
    public void addEncryptHeader(QName header) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPart(" + header + ")");
        }
        WSSEncryptPartImpl encrpytPart = new WSSEncryptPartImpl();
        encrpytPart.setEncryptHeader(header);
        this.encryptParts.add(encrpytPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPart(QName)");
        }
    }

    @Override
    public void addEncryptPart(int part) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPart( " + part + ")");
        }
        WSSEncryptPartImpl encrpytPart = new WSSEncryptPartImpl();
        encrpytPart.setEncryptPart(part);
        this.encryptParts.add(encrpytPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPart(int)");
        }
    }

    @Override
    public void addEncryptPart(WSSEncryptPart part) {
        this.encryptParts.add(part);
    }

    @Override
    public void addEncryptPart(WSSSignature signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPart(WSSSignature signature)");
        }
        WSSEncryptPartImpl encrpytPart = new WSSEncryptPartImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "signature[" + signature + "]");
        }
        encrpytPart.setEncryptPart(signature);
        this.encryptParts.add(encrpytPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPart(WSSSignature signature)");
        }
    }

    @Override
    public void addEncryptPartByXPath(String xpath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPartByXPath(" + xpath + ")");
        }
        WSSEncryptPartImpl encrpytPart = new WSSEncryptPartImpl();
        encrpytPart.setEncryptPartByXPath(xpath);
        this.encryptParts.add(encrpytPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPartByXPath(" + xpath + ")");
        }
    }

    @Override
    public void encryptKey(boolean isEncrypt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptKey(" + isEncrypt + ")");
            Tr.exit(tc, "encryptKey(boolean)");
        }
        this.encryptKey = isEncrypt;
    }

    @Override
    public void setOptimize(boolean isOptimized) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOptimize(" + isOptimized + ")");
            Tr.exit(tc, "setOptimize(boolean)");
        }
        this.optimized = isOptimized;
    }

    @Override
    public void setEncryptionMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getDataEncryptionAlgorithms().contains(method)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s14";
            WSSException e = WSSException.format(msg, method);
            Tr.processException((Throwable)e, clsName + ".setEncryptionMethod", "303", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(" + method + ")");
        }
        this.encryptionMethod = method;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(String)");
        }
    }

    @Override
    public void setKeyEncryptionMethod(String method) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getKeyEncryptionAlgorithms().contains(method)) {
            String msg = "security.wssecurity.PrivateConsumerConfig.s15";
            WSSException e = WSSException.format(msg, method);
            Tr.processException((Throwable)e, clsName + ".setKeyEncryptionMethod", "329", this);
            Tr.error(tc, msg, new Object[]{e});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyEncryptionMethod(" + method + ")");
        }
        this.keyEncryptionMethod = method;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyEncryptionMethod(String)");
        }
    }

    public List<WSSEncryptPart> getEncryptParts() {
        return this.encryptParts;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public String getKeyEncryptionMethod() {
        return this.keyEncryptionMethod;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public List<SecurityToken> getTokensToBeEncrypted() {
        return this.tokensToBeEncrypted;
    }

    public boolean isEncryptKey() {
        return this.encryptKey;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public void addEncryptPart(SecurityToken securityToken, boolean isElement) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPart(SecurityToken [" + securityToken.toString() + "], boolean[" + isElement + "])");
        }
        this.tokensToBeEncrypted.add(securityToken);
        WSSEncryptPartImpl encrpytPart = new WSSEncryptPartImpl();
        encrpytPart.setEncryptPart(securityToken, isElement);
        this.encryptParts.add(encrpytPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPart(SecurityToken securityToken, boolean isElement)");
        }
    }

    @Override
    public void setTokenReference(int tokenReference) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenReference(" + tokenReference + ")");
        }
        if (this.token == null) {
            this.tokenReference = tokenReference;
        } else {
            SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            tokenWrapper.setWssapiReferenceType(tokenReference);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenReference(int)");
        }
    }

    public String getTokenReferenceByStr() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenReferenceByStr()");
        }
        String tokenReference = null;
        if (this.token == null) {
            tokenReference = referenceMap.get(this.tokenReference);
        } else {
            SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            tokenReference = tokenWrapper.getWssapiReferenceTypeByStr();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenReferenceByStr()");
        }
        return tokenReference;
    }

    public int getTokenReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenReference()");
        }
        int tokenReference = 0;
        if (this.token == null) {
            tokenReference = this.tokenReference;
        } else {
            SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            tokenReference = tokenWrapper.getWssapiReferenceType();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenReference()");
        }
        return tokenReference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WSSEncryptionImpl:");
        buffer.append(" token: ");
        buffer.append(this.token);
        buffer.append(", encryptParts: ");
        buffer.append(this.encryptParts);
        buffer.append(", encryptionMethod: ");
        buffer.append(this.encryptionMethod);
        buffer.append(", keyEncryptionMethod: ");
        buffer.append(this.keyEncryptionMethod);
        buffer.append(", encryptKey: ");
        buffer.append(this.encryptKey);
        buffer.append(", tokenReference: ");
        buffer.append(this.tokenReference);
        buffer.append("]");
        return buffer.toString();
    }

    static {
        referenceMap.put(65, "STRREF");
        referenceMap.put(66, "KEYID");
        referenceMap.put(67, "EMB");
        referenceMap.put(68, "THUMBPRINT");
        referenceMap.put(71, "X509ISSUER");
    }
}

