/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.callbackhandler.DerivedKeyInfoCallback;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.spec.TransformParameterSpec;
import com.ibm.websphere.wssecurity.wssapi.spec.XPathFilter2ParameterSpec;
import com.ibm.websphere.wssecurity.wssapi.spec.XPathType;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import com.ibm.ws.wssecurity.wssapi.WSSTimestampImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptionImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignPartImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignatureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSOutboundConfig
extends PrivateGeneratorConfig {
    private static final TraceComponent tc = Tr.register(WSSOutboundConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSOutboundConfig.class.getName();
    private static final String COMMON_KEYINFO_CONTENT_GENERATOR = "com.ibm.ws.wssecurity.wssapi.CommonContentGenerator";
    private static final String COMMON_TOKEN_GENERATOR = "com.ibm.ws.wssecurity.wssapi.token.impl.CommonTokenGenerator";
    private Map<SecurityToken, PrivateGeneratorConfig.TokenGeneratorConfImpl> tokenGeneratorMap = new HashMap<SecurityToken, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSOutboundConfig(SecurityTokenManagerImpl securityTokenManager) {
        this._properties = new HashMap();
        this.securityTokenManager = securityTokenManager;
        try {
            try {
                this._nonceManager = AccessController.doPrivileged(new PrivilegedExceptionAction<NonceManager>(){

                    @Override
                    public NonceManager run() throws SoapSecurityException {
                        return NonceManagerFactory.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException pac) {
                Throwable th = pac.getCause();
                if (th instanceof SoapSecurityException) {
                    throw (SoapSecurityException)th;
                }
                throw new SoapSecurityException(th.getMessage());
            }
        }
        catch (SoapSecurityException e) {
            this._nonceManager = null;
        }
    }

    public void process(Generatable generatable) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process(Generatable generatable)");
        }
        if (generatable instanceof SecurityTokenWrapper) {
            this.setTokenWrapper((SecurityTokenWrapper)generatable);
        } else if (generatable instanceof WSSSignature) {
            this.setSignature((WSSSignature)((Object)generatable));
        } else if (generatable instanceof WSSEncryption) {
            this.setEncryption((WSSEncryption)((Object)generatable));
        } else if (generatable instanceof WSSTimestamp) {
            this.setTimeStamp((WSSTimestamp)((Object)generatable), false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process(Generatable)");
        }
    }

    public void setActor(String actor) {
        this._targetActor = actor;
    }

    public void setTimeStamp(WSSTimestamp wssTimestamp, boolean flag) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTimeStamp(WSSTimestamp wssTimestamp, " + flag + ")");
        }
        this._timestampGenerator = new PrivateGeneratorConfig.TimestampGeneratorConfImpl();
        this._timestampGenerator._duration = ((WSSTimestampImpl)wssTimestamp).getDuration();
        this._timestampEnabled = true;
        this._timestampGenerator.setToBeSigned(flag);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTimeStamp(WSSTimestamp, " + flag + ")");
        }
    }

    public void setTokenWrapper(SecurityTokenWrapper tokenWrapper) throws WSSException {
        Map<QName, TokenMapping> dvmap;
        TokenMapping tm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenWrapper(SecurityTokenWrapper tokenWrapper)");
        }
        QName valueTpe = tokenWrapper.getValueType();
        String loginConfigName = tokenWrapper.getWssapiLoginConfigName();
        if (loginConfigName == null && (loginConfigName = (tm = (dvmap = DefaultValueManager.getInstance().getTokenMapping()).get(valueTpe)).getJaasLoginConfigNameForGenerator()) == null) {
            throw WSSException.format("security.wssecurity.WSEC7077E");
        }
        PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfig = this.createTokenGeneratorConfig(valueTpe, loginConfigName, tokenWrapper.getWssapiCallbackHandler());
        SecurityToken token = tokenWrapper.getSecurityToken();
        if (!this.tokenGeneratorMap.containsKey(token)) {
            this.tokenGeneratorMap.put(token, tokenGeneratorConfig);
        }
        this._tokenGenerators.add(tokenGeneratorConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenWrapper(SecurityTokenWrapper)");
        }
    }

    public void setSignature(WSSSignature signature) throws WSSException {
        WSSSignatureImpl signatureImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignature(WSSSignature signature)");
        }
        if ((signatureImpl = (WSSSignatureImpl)signature).isSignatureConfirmation()) {
            this._signatureConfirmationRequired = true;
            this._request = signatureImpl.isRequiredSignatureConfirmation();
        }
        if (signatureImpl.getSignedParts().size() == 0) {
            List<Integer> signatures = DefaultValueManager.getInstance().getSignParts();
            for (int part : signatures) {
                if (part == 23) {
                    this.setTimeStamp(new WSSTimestampImpl(), true);
                }
                signature.addSignPart(part);
            }
        }
        ArrayList<PrivateCommonConfig.SigningReferenceConfImpl> references = new ArrayList<PrivateCommonConfig.SigningReferenceConfImpl>();
        PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfig = null;
        DerivedKeyInfoConfig dkInfo = null;
        for (WSSSignPartImpl wSSSignPartImpl : signatureImpl.getSignedParts()) {
            SecurityToken token;
            String keyword = wSSSignPartImpl.getKeyword();
            if (keyword != null && keyword.equals("timestamp")) {
                if (this._timestampGenerator == null) {
                    this.setTimeStamp(new WSSTimestampImpl(), true);
                }
                this._timestampGenerator.setToBeSigned(true);
            }
            if ((token = wSSSignPartImpl.getToken()) != null) {
                SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(token);
                if (token instanceof DKToken && ((DKToken)token).getDerivableSecurityToken() != null) {
                    token = ((DKToken)token).getDerivableSecurityToken();
                }
                if ((tokenGeneratorConfig = this.tokenGeneratorMap.get(token)) == null) {
                    Map<QName, TokenMapping> dvmap;
                    TokenMapping tm;
                    QName valueType = tokenWrapper.getValueType();
                    String loginConfigName = tokenWrapper.getWssapiLoginConfigName();
                    if (loginConfigName == null && (loginConfigName = (tm = (dvmap = DefaultValueManager.getInstance().getTokenMapping()).get(valueType)).getJaasLoginConfigNameForGenerator()) == null) {
                        throw WSSException.format("security.wssecurity.WSEC7077E");
                    }
                    tokenGeneratorConfig = this.createTokenGeneratorConfig(valueType, loginConfigName, tokenWrapper.getWssapiCallbackHandler());
                    this._tokenGenerators.add(tokenGeneratorConfig);
                    this.tokenGeneratorMap.put(token, tokenGeneratorConfig);
                    tokenGeneratorConfig._standAlone = false;
                    tokenGeneratorConfig._usedForSignature = true;
                }
            }
            PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfig = new PrivateCommonConfig.SigningReferenceConfImpl();
            signingReferenceConfig._digestMethod = this.createAlgorithmConfig(wSSSignPartImpl.getDigestMethod());
            signingReferenceConfig.getTransforms().addAll(this.createTransforms(wSSSignPartImpl.getTransforms()));
            PrivateCommonConfig.ReferencePartConfImpl referencePartConfig = new PrivateCommonConfig.ReferencePartConfImpl();
            PrivateCommonConfig.PartConfImpl partConfig = null;
            String dialect = wSSSignPartImpl.getDialect();
            partConfig = dialect.equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER) ? this.createPartConfig(wSSSignPartImpl.getDialect(), wSSSignPartImpl.getHeaderNamespace(), wSSSignPartImpl.getHeaderName()) : this.createPartConfig(wSSSignPartImpl.getDialect(), wSSSignPartImpl.getKeyword());
            referencePartConfig.getParts().add(partConfig);
            signingReferenceConfig._reference = referencePartConfig;
            references.add(signingReferenceConfig);
        }
        SecurityToken token = signatureImpl.getToken();
        if (token != null) {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(token);
            if (token instanceof DKToken && ((DKToken)token).getDerivableSecurityToken() != null) {
                token = ((DKToken)token).getDerivableSecurityToken();
            }
            dkInfo = this.createDerivedKeyInfo(securityTokenWrapper.getWssapiCallbackHandler());
            tokenGeneratorConfig = this.tokenGeneratorMap.get(token);
            if (tokenGeneratorConfig == null) {
                Map<QName, TokenMapping> dvmap;
                TokenMapping tm;
                QName valueType = securityTokenWrapper.getValueType();
                String loginConfigName = securityTokenWrapper.getWssapiLoginConfigName();
                if (loginConfigName == null && (loginConfigName = (tm = (dvmap = DefaultValueManager.getInstance().getTokenMapping()).get(valueType)).getJaasLoginConfigNameForGenerator()) == null) {
                    throw WSSException.format("security.wssecurity.WSEC7077E");
                }
                tokenGeneratorConfig = this.createTokenGeneratorConfig(valueType, loginConfigName, securityTokenWrapper.getWssapiCallbackHandler());
                this._tokenGenerators.add(tokenGeneratorConfig);
                this.tokenGeneratorMap.put(token, tokenGeneratorConfig);
                tokenGeneratorConfig._standAlone = false;
                tokenGeneratorConfig._usedForSignature = true;
            }
        }
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl = this.createkeyInfoContentGeneratorConfig(signatureImpl.getTokenReferenceByStr(), tokenGeneratorConfig);
        keyInfoContentGeneratorConfImpl._derivedKeyInfo = dkInfo;
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfig = this.createKeyInfoGeneratorConfig(keyInfoContentGeneratorConfImpl);
        PrivateGeneratorConfig.SignatureGeneratorConfImpl signatureGeneratorConfig = this.createSignatureGeneratorConfig(signatureImpl, keyInfoGeneratorConfig, references);
        this._signatureEnabled = true;
        this._operationGenerators.add(signatureGeneratorConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignature(WSSSignature)");
        }
    }

    private String getTokenReference(WSSEncryptionImpl encryptionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenReference(WSSEncryptionImpl encryptionImpl)");
        }
        String tokenReference = encryptionImpl.getTokenReferenceByStr();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenReference(WSSEncryptionImpl)");
        }
        return tokenReference;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncryption(WSSEncryption encryption) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryption(WSSEncryption encryption)");
        }
        WSSEncryptionImpl encryptionImpl = (WSSEncryptionImpl)encryption;
        PrivateCommonConfig.ReferencePartConfImpl referencePartConfig = new PrivateCommonConfig.ReferencePartConfImpl();
        if (encryptionImpl.getEncryptParts().size() == 0) {
            List<Integer> encrptParts = DefaultValueManager.getInstance().getEncryptionParts();
            for (int part : encrptParts) {
                encryption.addEncryptPart(part);
            }
        }
        PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfig = null;
        DerivedKeyInfoConfig dkInfo = null;
        for (SecurityToken securityToken : encryptionImpl.getTokensToBeEncrypted()) {
            Map<QName, TokenMapping> dvmap;
            TokenMapping tm;
            void var7_8;
            if (securityToken == null) continue;
            SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(securityToken);
            if (securityToken instanceof DKToken && ((DKToken)securityToken).getDerivableSecurityToken() != null) {
                SecurityToken securityToken2 = ((DKToken)securityToken).getDerivableSecurityToken();
            }
            if ((tokenGeneratorConfig = this.tokenGeneratorMap.get(var7_8)) != null) continue;
            QName valueType = tokenWrapper.getValueType();
            String loginConfigName = tokenWrapper.getWssapiLoginConfigName();
            if (loginConfigName == null && (loginConfigName = (tm = (dvmap = DefaultValueManager.getInstance().getTokenMapping()).get(valueType)).getJaasLoginConfigNameForGenerator()) == null) {
                throw WSSException.format("security.wssecurity.WSEC7077E");
            }
            tokenGeneratorConfig = this.createTokenGeneratorConfig(valueType, loginConfigName, tokenWrapper.getWssapiCallbackHandler());
            this.tokenGeneratorMap.put((SecurityToken)var7_8, tokenGeneratorConfig);
        }
        for (WSSEncryptPartImpl wSSEncryptPartImpl : encryptionImpl.getEncryptParts()) {
            PrivateCommonConfig.PartConfImpl partConfig = null;
            String dialect = wSSEncryptPartImpl.getDialect();
            partConfig = dialect.equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER) ? this.createPartConfig(wSSEncryptPartImpl.getDialect(), wSSEncryptPartImpl.getHeaderNamespace(), wSSEncryptPartImpl.getHeaderName()) : this.createPartConfig(wSSEncryptPartImpl.getDialect(), wSSEncryptPartImpl.getKeyword());
            referencePartConfig.getParts().add(partConfig);
        }
        SecurityToken token = encryptionImpl.getToken();
        if (token != null) {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(token);
            if (token instanceof DKToken && ((DKToken)token).getDerivableSecurityToken() != null) {
                token = ((DKToken)token).getDerivableSecurityToken();
            }
            dkInfo = this.createDerivedKeyInfo(securityTokenWrapper.getWssapiCallbackHandler());
            tokenGeneratorConfig = this.tokenGeneratorMap.get(token);
            if (tokenGeneratorConfig == null) {
                Map<QName, TokenMapping> dvmap;
                TokenMapping tm;
                QName valueType = securityTokenWrapper.getValueType();
                String loginConfigName = securityTokenWrapper.getWssapiLoginConfigName();
                if (loginConfigName == null && (loginConfigName = (tm = (dvmap = DefaultValueManager.getInstance().getTokenMapping()).get(valueType)).getJaasLoginConfigNameForGenerator()) == null) {
                    throw WSSException.format("security.wssecurity.WSEC7077E");
                }
                tokenGeneratorConfig = this.createTokenGeneratorConfig(valueType, loginConfigName, securityTokenWrapper.getWssapiCallbackHandler());
                this._tokenGenerators.add(tokenGeneratorConfig);
                this.tokenGeneratorMap.put(token, tokenGeneratorConfig);
                tokenGeneratorConfig._standAlone = false;
                tokenGeneratorConfig._usedForEncryption = true;
            } else {
                tokenGeneratorConfig._usedForEncryption = true;
            }
        }
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl = this.createkeyInfoContentGeneratorConfig(this.getTokenReference(encryptionImpl), tokenGeneratorConfig);
        keyInfoContentGeneratorConfImpl._derivedKeyInfo = dkInfo;
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfig = this.createKeyInfoGeneratorConfig(keyInfoContentGeneratorConfImpl);
        PrivateGeneratorConfig.EncryptionGeneratorConfImpl encryptionGeneratorConfig = this.createEncryptionGeneratorConfig(encryptionImpl, keyInfoGeneratorConfig, referencePartConfig);
        this._encryptionEnabled = true;
        this._operationGenerators.add(encryptionGeneratorConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryption(WSSEncryption encryption)");
        }
    }

    private List<PrivateCommonConfig.AlgorithmConfImpl> createTransforms(List<AlgorithmParameterData> transforms) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransforms(List<AlgorithmParameterData> transforms)");
        }
        ArrayList<PrivateCommonConfig.AlgorithmConfImpl> transformAlgorithms = new ArrayList<PrivateCommonConfig.AlgorithmConfImpl>();
        if (transforms.size() == 0) {
            List<String> transformMethods = DefaultValueManager.getInstance().getTransformMethodsForSignature();
            if (transformMethods != null) {
                Iterator<String> iter = transformMethods.iterator();
                while (iter.hasNext()) {
                    transformAlgorithms.add(this.createAlgorithmConfig(iter.next()));
                }
            }
        } else {
            for (AlgorithmParameterData transform : transforms) {
                transformAlgorithms.add(this.createAlgorithmConfig(transform));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTransforms(List<AlgorithmParameterData> transforms)");
        }
        return transformAlgorithms;
    }

    private PrivateCommonConfig.PartConfImpl createPartConfig(String dialect, String keyword) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPartConfig(" + dialect + ", " + keyword + ")");
        }
        PrivateCommonConfig.PartConfImpl partConfig = new PrivateCommonConfig.PartConfImpl();
        partConfig._dialect = dialect;
        partConfig._keyword = keyword;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPartConfig(String dialect, String keyword)");
        }
        return partConfig;
    }

    private PrivateCommonConfig.PartConfImpl createPartConfig(String dialect, String headerNamespace, String headerName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPartConfig(" + dialect + ", " + headerNamespace + ", " + headerName + ")");
        }
        PrivateCommonConfig.PartConfImpl partConfig = new PrivateCommonConfig.PartConfImpl();
        partConfig._dialect = dialect;
        partConfig._headerNamespace = headerNamespace;
        partConfig._headerName = headerName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPartConfig(String dialect, String headerNamespace, String headerName)");
        }
        return partConfig;
    }

    private PrivateCommonConfig.AlgorithmConfImpl createAlgorithmConfig(String methodName) {
        PrivateCommonConfig.AlgorithmConfImpl algorithmConf = new PrivateCommonConfig.AlgorithmConfImpl();
        algorithmConf._algorithm = methodName;
        return algorithmConf;
    }

    private PrivateCommonConfig.AlgorithmConfImpl createAlgorithmConfig(AlgorithmParameterData paramData) throws WSSException {
        PrivateCommonConfig.AlgorithmConfImpl algorithmConf = new PrivateCommonConfig.AlgorithmConfImpl();
        algorithmConf._algorithm = paramData.getAlgorithm();
        this.getAlgorithm(algorithmConf, paramData.getSpec());
        return algorithmConf;
    }

    private void getAlgorithm(PrivateCommonConfig.AlgorithmConfImpl algorithmConf, TransformParameterSpec spec) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithm(AlgorithmConfImpl algorithmConf, TransformParameterSpec spec)");
        }
        if (spec instanceof XPathFilter2ParameterSpec) {
            XPathFilter2ParameterSpec xpathSpec = (XPathFilter2ParameterSpec)spec;
            int index = 0;
            for (XPathType xpathType : xpathSpec.getXPathList()) {
                algorithmConf._properties.put(Constants.WSSECURITY_XPATH2_ORDER + "_" + index, Integer.toString(index));
                algorithmConf._properties.put(Constants.WSSECURITY_XPATH2_FILTER + "_" + index, xpathType.getFilter().toString());
                String expression = xpathType.getExpression();
                if (xpathType.getNamespaceMap() != null) {
                    String prefix = this.getPrefix(expression);
                    String mapNS = (String)xpathType.getNamespaceMap().get(prefix);
                    if (mapNS != null) {
                        algorithmConf._properties.put(Constants.WSSECURITY_XPATH2_EXPRESSION + "_" + index, this.convertExpression(expression, mapNS));
                    } else {
                        algorithmConf._properties.put(Constants.WSSECURITY_XPATH2_EXPRESSION + "_" + index, expression);
                    }
                } else {
                    algorithmConf._properties.put(Constants.WSSECURITY_XPATH2_EXPRESSION + "_" + index, expression);
                }
                ++index;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithm(AlgorithmConfImpl algorithmConf, TransformParameterSpec spec)");
        }
    }

    private String convertExpression(String expression, String mapNS) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertExpression(" + expression + "," + mapNS + ")");
        }
        if (expression == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertExpression(" + expression + "," + mapNS + ")");
            }
            return null;
        }
        StringBuffer converted = new StringBuffer("//*[namespace-uri()='");
        converted.append(mapNS + "' and local-name()='");
        StringBuffer buff = new StringBuffer(expression);
        int skip = buff.indexOf("//");
        if (skip == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertExpression(" + expression + "," + mapNS + ")");
            }
            return null;
        }
        int skip2 = buff.indexOf(":");
        if (skip2 == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertExpression(" + expression + "," + mapNS + ")");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertExpression(" + expression + "," + mapNS + ")");
        }
        return converted.append(buff.substring(skip2 + 1) + "']").toString();
    }

    private String getPrefix(String expression) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrefix(" + expression + ")");
        }
        if (expression == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrefix(" + expression + ")");
            }
            return null;
        }
        StringBuffer buff = new StringBuffer(expression);
        int skip = buff.indexOf("//");
        if (skip == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrefix(" + expression + ")");
            }
            return null;
        }
        int skip2 = buff.indexOf(":");
        if (skip2 == -1) {
            int skip3 = buff.length();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrefix(" + expression + ")");
            }
            return buff.substring(skip + 2, skip3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrefix(" + expression + ")");
        }
        return buff.substring(skip + 2, skip2);
    }

    private PrivateGeneratorConfig.TokenGeneratorConfImpl createTokenGeneratorConfig(QName valueType, String loginConfigName, CallbackHandler callbackHandler) throws WSSException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createTokenGeneratorConfig(");
            buf.append("QName valueType[").append(valueType).append("], ");
            buf.append("String loginConfigName[").append(loginConfigName).append("], ");
            buf.append("CallbackHandler callbackHandler)");
            Tr.entry(tc, buf.toString());
        }
        PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
        tokenGeneratorConfig._className = COMMON_TOKEN_GENERATOR;
        HashMap<Object, Object> type = new HashMap<Object, Object>();
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", tokenGeneratorConfig._className);
        try {
            WSSFactory factory = WSSFactory.getInstance("soap");
            tokenGeneratorConfig._instance = (TokenGeneratorComponent)factory.createGenerator(type, properties);
        }
        catch (SoapSecurityException e) {
            e.printStackTrace();
        }
        try {
            if (com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(valueType) || com.ibm.ws.wssecurity.common.Constants.LTPAv2_TOKEN.equals(valueType)) {
                PolicyConfigUtil.checkLTPATokenValid(valueType, tokenGeneratorConfig);
            }
        }
        catch (SoapSecurityException e) {
            Tr.processException((Throwable)e, clsName + ".createTokenGeneratorConfig", "756", this);
            WSSException we = WSSException.format("security.wssecurity.WSSOutboundConfig.s01", new String[]{e.toString()}, (Throwable)e);
            we.initCause(e);
            throw we;
        }
        tokenGeneratorConfig._type = valueType;
        tokenGeneratorConfig._standAlone = true;
        tokenGeneratorConfig._usedForSignature = false;
        tokenGeneratorConfig._usedForEncryption = false;
        tokenGeneratorConfig._jaasConfig = loginConfigName;
        PrivateCommonConfig.CallbackHandlerConfImpl callbackHandlerConfig = new PrivateCommonConfig.CallbackHandlerConfImpl();
        callbackHandlerConfig._className = callbackHandler.getClass().getName();
        callbackHandlerConfig._instance = callbackHandler;
        tokenGeneratorConfig._callbackHandler = callbackHandlerConfig;
        this._tokenEnabled = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTokenGeneratorConfig(QName, String, CallbackHandler)");
        }
        return tokenGeneratorConfig;
    }

    private PrivateGeneratorConfig.EncryptionGeneratorConfImpl createEncryptionGeneratorConfig(WSSEncryptionImpl encryptionImpl, PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfig, PrivateCommonConfig.ReferencePartConfImpl referencePartConfig) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createEncryptionGeneratorConfig(");
            buf.append("WSSEncryptionImpl encryptionImpl, ");
            buf.append("KeyInfoGeneratorConfImpl keyInfoGeneratorConfig, ");
            buf.append("ReferencePartConfImpl referencePartConfig)");
            Tr.entry(tc, buf.toString());
        }
        PrivateGeneratorConfig.EncryptionGeneratorConfImpl encryptionGeneratorConfig = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
        boolean isEncryptKey = encryptionImpl.isEncryptKey();
        encryptionGeneratorConfig._dataEncryptionMethod = this.createAlgorithmConfig(encryptionImpl.getEncryptionMethod());
        encryptionGeneratorConfig._keyEncryptionMethod = isEncryptKey ? this.createAlgorithmConfig(encryptionImpl.getKeyEncryptionMethod()) : null;
        encryptionGeneratorConfig._encryptionKeyInfo = keyInfoGeneratorConfig;
        encryptionGeneratorConfig._reference = referencePartConfig;
        boolean isOptimized = encryptionImpl.isOptimized();
        if (isOptimized) {
            encryptionGeneratorConfig._properties.put(Constants.WSSECURITY_MTOM_OPTIMIZE_ENCRYPTED_DATA, "true");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptionGeneratorConfig(WSSEncryptionImpl, KeyInfoGeneratorConfImpl, ReferencePartConfImpl)");
        }
        return encryptionGeneratorConfig;
    }

    private PrivateGeneratorConfig.SignatureGeneratorConfImpl createSignatureGeneratorConfig(WSSSignatureImpl signatureImpl, PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfig, List<PrivateCommonConfig.SigningReferenceConfImpl> references) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createSignatureGeneratorConfig(");
            buf.append("WSSSignatureImpl signatureImpl, ");
            buf.append("KeyInfoGeneratorConfImpl keyInfoGeneratorConfig, ");
            buf.append("List references)");
            Tr.entry(tc, buf.toString());
        }
        PrivateGeneratorConfig.SignatureGeneratorConfImpl signatureGeneratorConfig = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
        signatureGeneratorConfig._canonicalizationMethod = this.createAlgorithmConfig(signatureImpl.getCanonicalizationMethod());
        signatureGeneratorConfig._signatureMethod = this.createAlgorithmConfig(signatureImpl.getSignatureMethod());
        signatureGeneratorConfig._signingKeyInfo = keyInfoGeneratorConfig;
        signatureGeneratorConfig._references.addAll(references);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSignatureGeneratorConfig(WSSSignatureImpl, KeyInfoGeneratorConfImpl, List)");
        }
        return signatureGeneratorConfig;
    }

    private PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl createkeyInfoContentGeneratorConfig(String tokenReference, PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfig) {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("createkeyInfoContentGeneratorConfig(");
            buf.append("String tokenReference[").append(tokenReference).append("], ");
            buf.append("TokenGeneratorConfImpl tokenGeneratorConfig)");
            Tr.entry(tc, buf.toString());
        }
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfig = new PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl();
        keyInfoContentGeneratorConfig._className = COMMON_KEYINFO_CONTENT_GENERATOR;
        HashMap<Object, Object> type = new HashMap<Object, Object>();
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
        type.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", keyInfoContentGeneratorConfig._className);
        try {
            WSSFactory factory = WSSFactory.getInstance("soap");
            keyInfoContentGeneratorConfig._instance = (KeyInfoContentGeneratorComponent)factory.createGenerator(type, properties);
        }
        catch (SoapSecurityException e) {
            e.printStackTrace();
        }
        keyInfoContentGeneratorConfig._keyInfoType = tokenReference;
        keyInfoContentGeneratorConfig._tokenGenerator = tokenGeneratorConfig;
        keyInfoContentGeneratorConfig._keyName = SecurityUIDGenerator.createUID();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createkeyInfoContentGeneratorConfig(String, TokenGeneratorConfImpl) ");
        }
        return keyInfoContentGeneratorConfig;
    }

    private DerivedKeyInfoConfig createDerivedKeyInfo(CallbackHandler callbackHandler) throws WSSException {
        int nonceLeng;
        String clientLabel;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " createDerivedKeyInfo");
        }
        DerivedKeyInfoConfig derivedKeyInfo = new DerivedKeyInfoConfig();
        DerivedKeyInfoCallback dkcallback = new DerivedKeyInfoCallback();
        Callback[] callbacks = new Callback[]{dkcallback};
        try {
            callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            derivedKeyInfo.setRequireDerivedKeys(false);
            return derivedKeyInfo;
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".createDerivedKeyInfo()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", callbackHandler.getClass().getName(), (Throwable)e);
        }
        String serviceLabel = dkcallback.getServerLabel();
        if (serviceLabel != null && serviceLabel.length() > 0) {
            derivedKeyInfo.setServiceLabel(serviceLabel);
        }
        if ((clientLabel = dkcallback.getClientLabel()) != null && clientLabel.length() > 0) {
            derivedKeyInfo.setClientLabel(clientLabel);
        }
        boolean requirDKT = dkcallback.getRequiredDKT();
        derivedKeyInfo.setRequireDerivedKeys(requirDKT);
        int keyLeng = dkcallback.getKeyBytesLength();
        if (keyLeng != 0) {
            String keyL = new Integer(keyLeng).toString();
            derivedKeyInfo.setKeyLength(keyL);
        }
        if ((nonceLeng = dkcallback.getNonceBytesLength()) != 0) {
            String keyL = new Integer(nonceLeng).toString();
            derivedKeyInfo.setNonceLength(keyL);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " createDerivedKeyInfo");
        }
        return derivedKeyInfo;
    }

    private PrivateGeneratorConfig.KeyInfoGeneratorConfImpl createKeyInfoGeneratorConfig(PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyInfoGeneratorConfig(KeyInfoContentGeneratorConfig keyInfoContentGeneratorConfig)");
        }
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
        keyInfoGeneratorConfig._contentGenerator = keyInfoContentGeneratorConfig;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfoGeneratorConfig(KeyInfoContentGeneratorConfImpl)");
        }
        return keyInfoGeneratorConfig;
    }
}

