/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssobject.impl.WSSObjectDocumentImpl;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.KeyInfo;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.X509Data;
import com.ibm.ws.wssecurity.wssobject.impl.dsig.X509IssuerSerial;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Embedded;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.KeyIdentifier;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.Reference;
import com.ibm.ws.wssecurity.wssobject.impl.wsse10.SecurityTokenReference;
import com.ibm.ws.wssecurity.wssobject.interfaces.WSSObjectElement;
import com.ibm.ws.wssecurity.wssobject.util.QName;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartAttributeValue;
import com.ibm.ws.wssecurity.wssobject.util.VariablePartFactory;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsQNames;
import com.ibm.ws.wssecurity.wssobject.util.constants.Utf8ByteConstantsVariableParts;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSObjectCommonContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(WSSObjectCommonContentGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSObjectCommonContentGenerator.class.getName();
    private boolean _initialized = false;
    private Map<Object, Object> _selectors = null;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
            this._selectors = map;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(OMDocument doc, OMElement parent, Map<Object, Object> type, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKey(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("Map type, Map context)");
            Tr.entry(tc, buf.toString());
        }
        KeyInfo keyInfo = (KeyInfo)context.get("com.ibm.ws.wssecurity.WSSObjectKeyInfo");
        KeyInfoContentGeneratorConfig config2 = (KeyInfoContentGeneratorConfig)context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentGeneratorConfig [" + config2 + "].");
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String keyInfoType = config2.getKeyInfoType();
        context.put(Constants.WSSECURITY_KEYINFO_TYPE, keyInfoType);
        String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        context.put(Constants.WSSECURITY_KEY_TYPE, keyType);
        WSSObjectElement tokenParent = null;
        boolean isEmbedded = ConfigUtil.isKeyInfoEmb(keyInfoType);
        boolean isSTR = ConfigUtil.isKeyInfoStrref(keyInfoType);
        tokenParent = isSTR ? (WSSObjectElement)context.get("com.ibm.ws.wssecurity.WSSObjectSecurityHeader") : (isEmbedded ? WSSObjectCommonContentGenerator.insertEmbeddedElements(keyInfo, wssVersion, nsWsse) : keyInfo);
        TokenGeneratorConfig tconfig = config2.getTokenGenerator();
        if (tconfig == null) {
            throw SoapSecurityException.format("security.wssecurity.WSEC6818E", tconfig.toString());
        }
        String keyInfoName = config2.getKeyName();
        context.put(Constants.WSSECURITY_KEYINFO_UNIQUE_NAME, keyInfoName);
        final SecurityToken token = this.invokeTokenGenerator(doc, tokenParent, tconfig, context, keyInfoName);
        if (tconfig.getProperties().get("RequiredImpliedDerivedKeys") != null && ((Boolean)tconfig.getProperties().get("RequiredImpliedDerivedKeys")).booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Implied Derived Keys property is = TRUE");
            }
            type.put("RequiredImpliedDerivedKeys", (Boolean)tconfig.getProperties().get("RequiredImpliedDerivedKeys"));
        }
        Key key = null;
        if ("SigningKey".equals(keyType)) {
            try {
                key = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>(){

                    @Override
                    public Key run() throws WSSException {
                        Key k = token.getKey(61);
                        return k;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.processException((Throwable)e, clsName + ".login", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7073E", e.getCause());
            }
        }
        if ("EncryptingKey".equals(keyType)) {
            try {
                key = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>(){

                    @Override
                    public Key run() throws WSSException {
                        Key k = token.getKey(62);
                        return k;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.processException((Throwable)e, clsName + ".login", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7073E", e.getCause());
            }
        }
        if (key == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signing key or encrypting key is null.");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC7073E");
        }
        if (!isEmbedded) {
            WSSObjectCommonContentGenerator.insertKeyInfoChildElements(keyInfo, wssVersion, nsWsse, token, keyInfoType, type);
        } else {
            WSSObjectCommonContentGenerator.insertIdForEmbeddedElement(tokenParent, token, wssVersion);
        }
        context.remove("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey");
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKey(");
            buf.append("Document, Element, Map, Map)");
            buf.append(" returns Key[").append(key).append("]");
            Tr.exit(tc, buf.toString());
        }
        return key;
    }

    private static final WSSObjectElement insertEmbeddedElements(WSSObjectElement parent, int wssVersion, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertEmbeddedElements(");
            buf.append("WSSObjectElement parent[").append(parent).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("String nsWsse[").append(nsWsse).append("])");
            Tr.entry(tc, buf.toString());
        }
        WSSObjectDocumentImpl doc = parent.getWSSObjectDocument();
        SecurityTokenReference str = new SecurityTokenReference(doc);
        Embedded embedded = new Embedded(doc);
        str.addChild(embedded);
        if (parent.getChildrenSize() > 0) {
            parent.insertChildBefore(0, str);
        } else {
            parent.addChild(str);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertEmbeddedElements(");
            buf.append("WSSObjectElement, int, String)");
            buf.append(" returns OMElement[").append(embedded.getQName()).append("]");
            Tr.exit(tc, buf.toString());
        }
        return embedded;
    }

    private static final void insertIdForEmbeddedElement(WSSObjectElement embelem, SecurityToken token, int wssVersion) throws SoapSecurityException {
        String embId;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertIdForEmbeddedElement(");
            buf.append("WSSObjectElement embelem[").append(embelem).append("], ");
            buf.append("SecurityToken token[").append(token).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append(")");
            Tr.entry(tc, buf.toString());
        }
        if ((embId = token.getId()) != null && !embId.isEmpty()) {
            Embedded embedded = (Embedded)embelem;
            embedded.setWsuId(VariablePartFactory.getInstance().createAttrValueWithString(embId));
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Id not found from token for Embedded element");
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertIdForEmbeddedElement(");
            buf.append("WSSObjectElement embelem, SecurityToken token, int wssVersion)");
            Tr.exit(tc, buf.toString());
        }
    }

    private final SecurityToken invokeTokenGenerator(OMDocument doc, WSSObjectElement parent, TokenGeneratorConfig tconfig, Map<Object, Object> context, String keyInfoName) throws SoapSecurityException {
        PrivateGeneratorConfig.TokenGeneratorConfImpl confImpl;
        TokenGeneratorComponent tgen;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeTokenGenerator(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("WSSObjectElement parent[").append(parent).append("], ");
            buf.append("TokenGeneratorConfig tconfig, Map context, ");
            buf.append("String keyInfoName[").append(keyInfoName).append("])");
            Tr.entry(tc, buf.toString());
        }
        if ((tgen = (confImpl = (PrivateGeneratorConfig.TokenGeneratorConfImpl)tconfig).getInstance()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
        }
        TokenGeneratorComponent tmp = (TokenGeneratorComponent)this._selectors.get(tgen.getClass());
        if (tmp != null) {
            tgen = tmp;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Will invoke TokenGenerator of type " + tgen.getClass().getName());
        }
        SecurityToken token = null;
        token = keyInfoName != null ? (SecurityToken)context.get(keyInfoName) : (SecurityToken)context.get(tconfig);
        if (token == null) {
            context.put("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey", tconfig);
            context.put("com.ibm.ws.wssecurity.WSSObjectTokenParent", parent);
            tgen.invoke(doc, null, context);
            context.remove("com.ibm.ws.wssecurity.WSSObjectTokenParent");
            token = (SecurityToken)context.remove(Constants.WSSECURITY_TOKEN_LOGININFO);
            context.put(tconfig, token);
            if (keyInfoName != null) {
                context.put(keyInfoName, token);
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeTokenGenerator(");
            buf.append("Document doc, WSSObjectElement parent, TokenGeneratorConfig config, Map context)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    private static final void insertKeyInfoChildElements(KeyInfo parent, int wssVersion, String nsWsse, SecurityToken token, String keyInfoType, Map<Object, Object> type) throws SoapSecurityException {
        WSSObjectDocumentImpl doc;
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("insertKeyInfoChildElements(");
            buf.append("KeyInfo parent[").append(parent).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("String nsWsse[").append(nsWsse).append("], ");
            buf.append("SecurityToken token[").append(token).append("], ");
            buf.append("String keyInfoType[").append(keyInfoType).append("], ");
            buf.append("KeyInfoContentGeneratorConfig config, Map type)");
            Tr.entry(tc, buf.toString());
        }
        if (ConfigUtil.isKeyInfoStrref(keyInfoType)) {
            if (type.get("RequiredImpliedDerivedKeys") != null && ((Boolean)type.get("RequiredImpliedDerivedKeys")).booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Implied Derived Keys property is = TRUE");
                }
                doc = parent.getWSSObjectDocument();
                SecurityTokenReference str = new SecurityTokenReference(doc);
                byte[] nonce = ((DKToken)token).getNonce();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nonce from the DerivedKeyToken = " + Base64.encode(nonce));
                }
                QName nonceQName = null;
                QName lengthQName = null;
                VariablePartAttributeValue sctNS = null;
                if (token.getValueType().equals(com.ibm.ws.wssecurity.common.Constants.DKT_13)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "token ValueType is = " + token.getValueType() + ", using 1.3 namespace");
                    }
                    nonceQName = Utf8ByteConstantsQNames.WSC_13.QN_NONCE;
                    lengthQName = Utf8ByteConstantsQNames.WSC_13.QN_LENGTH;
                    sctNS = Utf8ByteConstantsVariableParts.VPA_NS_WSC_SCT_13;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "token ValueType is = " + token.getValueType() + ", using draft namespace");
                    }
                    nonceQName = Utf8ByteConstantsQNames.WSC.QN_NONCE;
                    lengthQName = Utf8ByteConstantsQNames.WSC.QN_LENGTH;
                    sctNS = Utf8ByteConstantsVariableParts.VPA_NS_WSC_SCT;
                }
                str.setAttributeToSortedSet(nonceQName, VariablePartFactory.getInstance().createAttrValueWithByteToBeBase64Encoded(nonce));
                String length = new Long(((DKToken)token).getLength()).toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Length from the DerivedKeyToken = " + length);
                }
                str.setAttributeToSortedSet(lengthQName, VariablePartFactory.getInstance().createAttrValueWithString(length));
                Reference reference = new Reference(doc);
                String refuri = "#" + ((DKToken)token).getrefTokenId();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reference URI from the DerivedKeyToken = " + refuri);
                }
                VariablePartAttributeValue vPart = IdUtils.getInstance().getVariablePart(refuri);
                reference.setUri(vPart);
                reference.setValueType(sctNS);
                str.addChild(reference);
                parent.addChild(str);
            } else {
                doc = parent.getWSSObjectDocument();
                SecurityTokenReference str = new SecurityTokenReference(doc);
                Reference reference = new Reference(doc);
                String refuri = token.getReferenceURI();
                VariablePartAttributeValue vPart = IdUtils.getInstance().getVariablePart(refuri);
                reference.setUri(vPart);
                if (token.getValueType().equals(com.ibm.ws.wssecurity.common.Constants.DKT_13)) {
                    reference.setValueType(Utf8ByteConstantsVariableParts.VPA_NS_WSC_DKT_13);
                } else if (token.getValueType().equals(com.ibm.ws.wssecurity.common.Constants.DKT)) {
                    reference.setValueType(Utf8ByteConstantsVariableParts.VPA_NS_WSC_DKT);
                } else {
                    String valueType = token.getValueType().toString();
                    reference.setValueType(VariablePartFactory.getInstance().createAttrValueWithString(valueType));
                }
                str.addChild(reference);
                parent.addChild(str);
            }
        } else if (ConfigUtil.isKeyInfoKeyid(keyInfoType)) {
            doc = parent.getWSSObjectDocument();
            SecurityTokenReference str = new SecurityTokenReference(doc);
            KeyIdentifier kielem = new KeyIdentifier(doc);
            javax.xml.namespace.QName encodingType = token.getKeyIdentifierEncodingType();
            javax.xml.namespace.QName valueType = token.getKeyIdentifierValueType();
            if (encodingType == null) {
                kielem.setEncodingType(VariablePartFactory.getInstance().createAttrValueWithString(com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY_STRING));
            } else {
                kielem.setEncodingType(VariablePartFactory.getInstance().createAttrValueWithString(encodingType.toString()));
            }
            kielem.setValueType(VariablePartFactory.getInstance().createAttrValueWithString(valueType.toString()));
            String keyId = token.getKeyIdentifier();
            kielem.setContent(VariablePartFactory.getInstance().createTextValueWithString(keyId));
            str.addChild(kielem);
            parent.addChild(str);
        } else if (ConfigUtil.isKeyInfoThumbprint(keyInfoType)) {
            doc = parent.getWSSObjectDocument();
            SecurityTokenReference str = new SecurityTokenReference(doc);
            KeyIdentifier kielem = new KeyIdentifier(doc);
            javax.xml.namespace.QName encodingType = token.getThumbprintEncodingType();
            javax.xml.namespace.QName valueType = token.getThumbprintValueType();
            if (encodingType == null) {
                kielem.setEncodingType(VariablePartFactory.getInstance().createAttrValueWithString(com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY_STRING));
            } else {
                kielem.setEncodingType(VariablePartFactory.getInstance().createAttrValueWithString(encodingType.toString()));
            }
            kielem.setValueType(VariablePartFactory.getInstance().createAttrValueWithString(valueType.toString()));
            String thumbprint = token.getThumbprint();
            kielem.setContent(VariablePartFactory.getInstance().createTextValueWithString(thumbprint));
            str.addChild(kielem);
            parent.addChild(str);
        } else if (ConfigUtil.isKeyInfoKeyname(keyInfoType)) {
            String keyName = token.getKeyName();
            String kn = KeyInfo.X509Data.decodeDName(keyName);
            if (kn != null) {
                keyName = kn;
            }
            parent.setKeyName(VariablePartFactory.getInstance().createTextValueWithString(keyName));
        } else if (!ConfigUtil.isKeyInfoEmb(keyInfoType)) {
            if (ConfigUtil.isKeyInfoX509issuer(keyInfoType)) {
                doc = parent.getWSSObjectDocument();
                SecurityTokenReference str = new SecurityTokenReference(doc);
                X509Data data = new X509Data(doc);
                str.addChild(data);
                X509IssuerSerial issuer = new X509IssuerSerial(doc);
                String issuerDN = ((X509Token)token).getIssuerName();
                issuer.setX509IssuerName(VariablePartFactory.getInstance().createTextValueWithString(issuerDN));
                String issuerSerial = ((X509Token)token).getIssuerSerial();
                issuer.setX509SerialNumber(VariablePartFactory.getInstance().createTextValueWithString(issuerSerial));
                data.addChild(issuer);
                parent.addChild(str);
            } else if (tc.isDebugEnabled()) {
                String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
                boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
                StringBuffer buf2 = new StringBuffer("WARNING: ").append(clsName);
                buf2.append(" found unknown key information type: ").append(keyInfoType).append(". ");
                buf2.append(" Please make sure the key information used for");
                if ("SigningKey".equals(keyType)) {
                    buf2.append(" siganture");
                } else {
                    buf2.append(" encryption");
                }
                buf2.append(" in the");
                if (isServer) {
                    buf2.append(" response generator configuration.");
                } else {
                    buf2.append(" request generator configuration.");
                }
                Tr.debug(tc, buf2.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("insertKeyInfoChildElements(");
            buf.append("KeyInfo parent, int wssVersion, String nsWsse, ");
            buf.append("SecurityToken token, String keyInfoType, Map type)");
            Tr.exit(tc, buf.toString());
        }
    }
}

