/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSContextPutterFactory;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextPutter;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import java.util.ArrayList;
import java.util.List;

public class WSSGenerationContextImpl
implements WSSGenerationContext {
    private static final TraceComponent tc = Tr.register(WSSGenerationContextImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final long serialVersionUID = 8735531148854013027L;
    private List<Generatable> targetList = new ArrayList<Generatable>();
    private String actor;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSGenerationContextImpl(SecurityTokenManagerImpl securityTokenManager) {
        this.securityTokenManager = securityTokenManager;
    }

    public WSSGenerationContextImpl(String actor, SecurityTokenManagerImpl securityTokenManager) {
        this.actor = actor;
        this.securityTokenManager = securityTokenManager;
    }

    public void add(WSSSignature sig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSSignature sig)");
        }
        this.targetList.add((Generatable)((Object)sig));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSSignature sig)");
        }
    }

    public void add(WSSEncryption enc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSEncryption enc)");
        }
        this.targetList.add((Generatable)((Object)enc));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSEncryption enc)");
        }
    }

    public void add(SecurityToken token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(SecurityToken token)");
        }
        SecurityTokenWrapper tokenWrapper = this.securityTokenManager.getTokenWrapper(token);
        this.targetList.add(tokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(SecurityToken token)");
        }
    }

    public void add(WSSTimestamp ts) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSTimestamp ts)");
        }
        this.targetList.add((Generatable)((Object)ts));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSTimestamp ts)");
        }
    }

    public void process(Object messageContext) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process(Object messageContext)");
        }
        if (messageContext == null) {
            WSSException.format("security.wssecurity.WSEC7008E");
        }
        WSSContextPutterFactory factory = WSSContextPutterFactory.getInstance();
        WSSGenerationContextPutter putter = factory.getWSSGeneratoinContextPutterFactory(messageContext);
        putter.put(messageContext, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process(Object messageContext)");
        }
    }

    public List getContexts() {
        return this.targetList;
    }

    public String getActor() {
        return this.actor;
    }

    public SecurityTokenManagerImpl getSecurityTokenManagerImpl() {
        return this.securityTokenManager;
    }
}

