/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSConsumingContextPutter;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextPutter;
import java.util.HashMap;
import java.util.Map;

public class WSSContextPutterFactory {
    private static final TraceComponent tc = Tr.register(WSSContextPutterFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSContextPutterFactory.class.getName();
    private static Map<String, String> generatorMap = new HashMap<String, String>();
    private static Map<String, String> consumerMap = new HashMap<String, String>();
    private static Map<String, WSSGenerationContextPutter> cacheGeneratorMap = new HashMap<String, WSSGenerationContextPutter>();
    private static Map<String, WSSConsumingContextPutter> cacheConsumerMap = new HashMap<String, WSSConsumingContextPutter>();
    private static WSSContextPutterFactory instance;

    private WSSContextPutterFactory() {
    }

    public static WSSContextPutterFactory getInstance() {
        return instance;
    }

    public WSSGenerationContextPutter getWSSGeneratoinContextPutterFactory(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSGeneratoinContextPutterFactory(Object object)");
        }
        if (object == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"getWSSGeneratoinContextPutterFactory"});
        }
        String className = null;
        className = object instanceof Map ? generatorMap.get("java.util.Map") : generatorMap.get("org.apache.axis2.client.ServiceClient");
        if (className == null) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "Cannot find class [" + object.getClass().getName() + "] in generatorMap");
            }
            throw WSSException.format("security.wssecurity.WSEC7007E");
        }
        WSSGenerationContextPutter putter = null;
        try {
            putter = cacheGeneratorMap.get(className);
            if (putter == null) {
                putter = (WSSGenerationContextPutter)Class.forName(className).newInstance();
                cacheGeneratorMap.put(className, putter);
            }
        }
        catch (IllegalAccessException e) {
            Tr.processException((Throwable)e, clsName + ".getWSSGeneratoinContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        catch (InstantiationException e) {
            Tr.processException((Throwable)e, clsName + ".getWSSGeneratoinContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Tr.processException((Throwable)e, clsName + ".getWSSGeneratoinContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSGeneratoinContextPutterFactory(Object object)");
        }
        return putter;
    }

    public WSSConsumingContextPutter getWSSConsumingContextPutterFactory(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSConsumingContextPutterFactory(Object object)");
        }
        if (object == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"getWSSConsumingContextPutterFactory"});
        }
        String className = null;
        className = object instanceof Map ? consumerMap.get("java.util.Map") : consumerMap.get("org.apache.axis2.client.ServiceClient");
        if (className == null) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "Cannot find class [" + object.getClass().getName() + "] in consumerMap");
            }
            throw WSSException.format("security.wssecurity.WSEC7007E");
        }
        WSSConsumingContextPutter putter = null;
        try {
            putter = cacheConsumerMap.get(className);
            if (putter == null) {
                putter = (WSSConsumingContextPutter)Class.forName(className).newInstance();
                cacheConsumerMap.put(className, putter);
            }
        }
        catch (IllegalAccessException e) {
            Tr.processException((Throwable)e, clsName + ".getWSSConsumingContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        catch (InstantiationException e) {
            Tr.processException((Throwable)e, clsName + ".getWSSConsumingContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Tr.processException((Throwable)e, clsName + ".getWSSConsumingContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", className, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSConsumingContextPutterFactory(Object object)");
        }
        return putter;
    }

    static {
        generatorMap.put("java.util.Map", "com.ibm.ws.wssecurity.wssapi.JAXWSGenerationContextPutter");
        generatorMap.put("org.apache.axis2.client.ServiceClient", "com.ibm.ws.wssecurity.wssapi.Axis2GenerationContextPutter");
        consumerMap.put("java.util.Map", "com.ibm.ws.wssecurity.wssapi.JAXWSConsumingContextPutter");
        consumerMap.put("org.apache.axis2.client.ServiceClient", "com.ibm.ws.wssecurity.wssapi.Axis2ConsumingContextPutter");
        instance = new WSSContextPutterFactory();
    }
}

