/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueManager {
    private static final TraceComponent tc = Tr.register(DefaultValueManager.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static Map<String, String> classMap = new HashMap<String, String>();
    private static final String SIGNATURE_CLASS = "com.ibm.websphere.wssecurity.wssapi.signature";
    private static final String DECRYPTION_CLASS = "com.ibm.websphere.wssecurity.wssapi.decryption";
    private static final String ENCRYPTION_CLASS = "com.ibm.websphere.wssecurity.wssapi.encryption";
    private static final String VERIFICATOIN_CLASS = "com.ibm.websphere.wssecurity.wssapi.verification";
    private static final String TOKEN_CLASS = "com.ibm.websphere.wssecurity.wssapi.token";
    private static final String WSS_CLASS = "com.ibm.websphere.wssecurity.wssapi";
    private static String DEFAULT_VALUE_FILE_NAME;
    private static String SIGNATURE;
    private static String CANONICALIZATIONMETHOD;
    private static String SIGNATUREMETHOD;
    private static String DIGESTMETHOD;
    private static String TRANSFORMMETHODS;
    private static String TRANSFORMMETHOD;
    private static String SIGNPARTS;
    private static String SIGNPART;
    private static String ENCRYPTION;
    private static String KEYENCRYPTED;
    private static String OPTIMIZED;
    private static String KEYENCRYPTIONMETHOD;
    private static String DATAENCRYPTIONMETHOD;
    private static String ENCRYPTIONPARTS;
    private static String ENCRYPTIONPART;
    private static String VERIFICATON;
    private static String ALLOWEDCANONICALIZATIONMETHODS;
    private static String ALLOWEDSIGNATUREMETHODS;
    private static String VERIFYPARTS;
    private static String VERIFYPART;
    private static String DECRYPTION;
    private static String ALLOWEDKEYENCRYPTIONMETHODS;
    private static String ALLOWEDDATAENCRYPTIONMETHODS;
    private static String DECRYPTIONPARTS;
    private static String DECRYPTIONPART;
    private static String TOKENREFERENCE;
    private static String TOKENMAPPINGS;
    private static String TOKENMAPPING;
    private static String VALUETYPE;
    private static String JAASLOGINCONFIGNAME;
    private String canonicalizationMethod;
    private String signatureMethod;
    private String digestMethod;
    private List<String> transformMethodsForSignature = new ArrayList<String>();
    private List<Integer> signParts = new ArrayList<Integer>();
    private int tokenReferenceForSignature;
    private Map<QName, TokenMapping> tokenMappingForSignature = new HashMap<QName, TokenMapping>();
    private boolean optimized = false;
    private boolean keyEncrypted;
    private String keyEncryptionMethod;
    private String dataEncryptionMethod;
    private List<Integer> encryptionParts = new ArrayList<Integer>();
    private int tokenReferenceForEncryption;
    private Map<QName, TokenMapping> tokenMappingForEncryption = new HashMap<QName, TokenMapping>();
    private List<String> allowedCanonicalizationMethods = new ArrayList<String>();
    private List<String> allowedSignatureMethods = new ArrayList<String>();
    private List<String> transformMethodsForVerification = new ArrayList<String>();
    private List<Integer> verifyParts = new ArrayList<Integer>();
    private Map<QName, TokenMapping> tokenMappingForVerification = new HashMap<QName, TokenMapping>();
    private boolean keyEncryptedForDecrption;
    private List<String> allowedKeyEncryptionMethods = new ArrayList<String>();
    private List<String> allowedDataEncryptionMethods = new ArrayList<String>();
    private List<Integer> decryptionParts = new ArrayList<Integer>();
    private Map<QName, TokenMapping> tokenMappingForDecryption = new HashMap<QName, TokenMapping>();
    private Map<QName, TokenMapping> tokenMapping = new HashMap<QName, TokenMapping>();
    private static final String GENERATE = "generate";
    private static final String CONSUME = "consume";
    private static final String TIMESTAMP = "timestamp";
    private static final String DURATION = "duration";
    private String duration;
    private static final String ALGORITHMS = "algorithms";
    private static final String SIGNATUREALGORITHM = "signatureAlgorithm";
    private static final String ENCRYPTIONALGORITHM = "encryptionAlgorithm";
    private static final String DEFAULTSIGNATUREALGORITHM = "defaultSignatureAlgorithm";
    private static final String DEFAULTENCRYPTIONALGORITHM = "defaultEncryptionAlgorithm";
    private static final String ALGORITHMNAME = "algorithmName";
    private static final String KEYFACTORYALGORITHM = "keyFactoryAlgorithm";
    private static final String KEYLENGTH = "keyLength";
    public static final String KEY_ALGORITHM = "algorithm";
    public static final String KEY_KEYLENGTH = "keyLength";
    private Map<String, Map> signatureAlgorithmMap = new HashMap<String, Map>();
    private Map<String, Map> encryptionAlgorithmMap = new HashMap<String, Map>();
    private String defaultSignatureAlgorithm;
    private String defaultEncryptionAlgorithm;
    private static DefaultValueManager instance;

    private DefaultValueManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DefaultValueManager()");
        }
        StAXOMBuilder builder = null;
        ClassLoader loader = DefaultValueManager.class.getClassLoader();
        InputStream is = loader.getResourceAsStream(DEFAULT_VALUE_FILE_NAME);
        try {
            builder = new StAXOMBuilder(is);
        }
        catch (XMLStreamException e) {
            Tr.warning(tc, "WSEC7001W");
            return;
        }
        OMElement doc = builder.getDocumentElement();
        this.getTimestampDefaultValue(doc);
        this.getSignatureDefaultValue(doc);
        this.getEncryptionDefaultValue(doc);
        this.getVerificationDefaultValue(doc);
        this.getDecryptionDefaultValue(doc);
        this.getAlgorithmDefaultValue(doc);
        this.getDefaultValue(doc);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DefaultValueManager()");
        }
    }

    public static DefaultValueManager getInstance() {
        return instance;
    }

    private void getAlgorithmDefaultValue(OMElement doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithmDefaultValue(OMElement doc)");
        }
        OMElement elm1 = doc.getFirstChildWithName(new QName(ALGORITHMS));
        OMElement elm11 = elm1.getFirstChildWithName(new QName(DEFAULTSIGNATUREALGORITHM));
        OMElement elm12 = elm11.getFirstChildWithName(new QName(ALGORITHMNAME));
        this.defaultSignatureAlgorithm = this.getDataAsString(elm12.getText());
        OMElement elm13 = elm1.getFirstChildWithName(new QName(DEFAULTENCRYPTIONALGORITHM));
        OMElement elm14 = elm13.getFirstChildWithName(new QName(ALGORITHMNAME));
        this.defaultEncryptionAlgorithm = this.getDataAsString(elm14.getText());
        Iterator iter1 = elm1.getChildrenWithName(new QName(SIGNATUREALGORITHM));
        while (iter1.hasNext()) {
            HashMap<String, Object> algoMap = new HashMap<String, Object>();
            OMElement elm2 = (OMElement)iter1.next();
            OMElement elm3 = elm2.getFirstChildWithName(new QName(ALGORITHMNAME));
            OMElement elm4 = elm2.getFirstChildWithName(new QName(KEYFACTORYALGORITHM));
            OMElement elm5 = elm2.getFirstChildWithName(new QName("keyLength"));
            algoMap.put(KEY_ALGORITHM, elm4.getText());
            algoMap.put("keyLength", new Integer(elm5.getText()));
            this.signatureAlgorithmMap.put(this.getDataAsString(elm3.getText()), algoMap);
        }
        Iterator iter2 = elm1.getChildrenWithName(new QName(ENCRYPTIONALGORITHM));
        while (iter2.hasNext()) {
            HashMap<String, Object> algoMap = new HashMap<String, Object>();
            OMElement elm2 = (OMElement)iter2.next();
            OMElement elm3 = elm2.getFirstChildWithName(new QName(ALGORITHMNAME));
            OMElement elm4 = elm2.getFirstChildWithName(new QName(KEYFACTORYALGORITHM));
            OMElement elm5 = elm2.getFirstChildWithName(new QName("keyLength"));
            algoMap.put(KEY_ALGORITHM, elm4.getText());
            algoMap.put("keyLength", new Integer(elm5.getText()));
            this.encryptionAlgorithmMap.put(this.getDataAsString(elm3.getText()), algoMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithmDefaultValue(OMElement doc)");
        }
    }

    private void getTimestampDefaultValue(OMElement doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTImestampDefaultValue(OMElement doc)");
        }
        OMElement elm = doc.getFirstChildWithName(new QName(TIMESTAMP));
        OMElement elm2 = elm.getFirstChildWithName(new QName(DURATION));
        this.duration = elm2.getText();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimestampDefaultValue(OMElement doc): [duration:[" + this.duration + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestampDefaultValue(OMElement doc)");
        }
    }

    private void getDefaultValue(OMElement doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultValue(OMElement doc)");
        }
        OMElement elm7 = doc.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iter4 = elm7.getChildrenWithName(new QName(TOKENMAPPING));
        while (iter4.hasNext()) {
            TokenMapping mapping = new TokenMapping();
            OMElement elm4 = (OMElement)iter4.next();
            OMElement elm8 = elm4.getFirstChildWithName(new QName(VALUETYPE));
            mapping.setValueType(this.getDataAsQName(elm8.getText()));
            Iterator iter9 = elm4.getChildrenWithName(new QName(JAASLOGINCONFIGNAME));
            while (iter9.hasNext()) {
                OMElement element = (OMElement)iter9.next();
                this.addTokenMapping(mapping, element);
            }
            this.tokenMapping.put(mapping.getValueType(), mapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getDefaultValue(OMElement doc): [TokenMapping: mapping:[" + mapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultValue(OMElement doc)");
        }
    }

    private void addTokenMapping(TokenMapping mapping, OMElement element) {
        String type = element.getAttributeValue(new QName("type"));
        if (type.equals(GENERATE)) {
            mapping.setJaasLoginConfigNameForGenerator(element.getText());
        }
        if (type.equals(CONSUME)) {
            mapping.setJaasLoginConfigNameForConsumer(element.getText());
        }
    }

    private void getDecryptionDefaultValue(OMElement doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDecryptionDefaultValue(OMElement doc)");
        }
        OMElement elm = doc.getFirstChildWithName(new QName(DECRYPTION));
        OMElement elm2 = elm.getFirstChildWithName(new QName(KEYENCRYPTED));
        this.keyEncryptedForDecrption = this.getDataAsBoolean(elm2.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [keyEncryptedForDecrption:[" + this.keyEncryptedForDecrption + "]");
        }
        OMElement elm3 = elm.getFirstChildWithName(new QName(ALLOWEDKEYENCRYPTIONMETHODS));
        Iterator iter = elm3.getChildrenWithName(new QName(KEYENCRYPTIONMETHOD));
        while (iter.hasNext()) {
            OMElement elm4 = (OMElement)iter.next();
            this.allowedKeyEncryptionMethods.add(this.getDataAsString(elm4.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [allowedKeyEncryptionMethods:[" + this.allowedKeyEncryptionMethods + "]");
        }
        OMElement elm5 = elm.getFirstChildWithName(new QName(ALLOWEDDATAENCRYPTIONMETHODS));
        Iterator iter2 = elm5.getChildrenWithName(new QName(DATAENCRYPTIONMETHOD));
        while (iter2.hasNext()) {
            OMElement elm4 = (OMElement)iter2.next();
            this.allowedDataEncryptionMethods.add(this.getDataAsString(elm4.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [allowedDataEncryptionMethods:[" + this.allowedDataEncryptionMethods + "]");
        }
        OMElement elm6 = elm.getFirstChildWithName(new QName(DECRYPTIONPARTS));
        Iterator iter3 = elm6.getChildrenWithName(new QName(DECRYPTIONPART));
        while (iter3.hasNext()) {
            OMElement elm4 = (OMElement)iter3.next();
            this.decryptionParts.add(this.getDataAsInt(elm4.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [decryptionParts:[" + this.decryptionParts + "]");
        }
        OMElement elm7 = elm.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iter4 = elm7.getChildrenWithName(new QName(TOKENMAPPING));
        while (iter4.hasNext()) {
            TokenMapping mapping = new TokenMapping();
            OMElement elm4 = (OMElement)iter4.next();
            OMElement elm8 = elm4.getFirstChildWithName(new QName(VALUETYPE));
            mapping.setValueType(this.getDataAsQName(elm8.getText()));
            OMElement elm9 = elm4.getFirstChildWithName(new QName(JAASLOGINCONFIGNAME));
            mapping.setJaasLoginConfigNameForConsumer(elm9.getText());
            this.tokenMappingForDecryption.put(mapping.getValueType(), mapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getDecryptionDefaultValue(OMElement doc): [tokenMappingForDecryption:[" + mapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDecryptionDefaultValue(OMElement doc)");
        }
    }

    private void getVerificationDefaultValue(OMElement doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVerificationDefalutValue(OMElement doc)");
        }
        OMElement elm = doc.getFirstChildWithName(new QName(VERIFICATON));
        OMElement elm2 = elm.getFirstChildWithName(new QName(ALLOWEDCANONICALIZATIONMETHODS));
        Iterator iter = elm2.getChildrenWithName(new QName(CANONICALIZATIONMETHOD));
        while (iter.hasNext()) {
            OMElement elm3 = (OMElement)iter.next();
            this.allowedCanonicalizationMethods.add(this.getDataAsString(elm3.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [allowedCanonicalizationMethods:[" + this.allowedCanonicalizationMethods + "]");
        }
        OMElement elm4 = elm.getFirstChildWithName(new QName(ALLOWEDSIGNATUREMETHODS));
        Iterator iter2 = elm4.getChildrenWithName(new QName(SIGNATUREMETHOD));
        while (iter2.hasNext()) {
            OMElement elm3 = (OMElement)iter2.next();
            this.allowedSignatureMethods.add(this.getDataAsString(elm3.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [allowedSignatureMethods:[" + this.allowedSignatureMethods + "]");
        }
        OMElement elm5 = elm.getFirstChildWithName(new QName(TRANSFORMMETHODS));
        Iterator iter3 = elm5.getChildrenWithName(new QName(TRANSFORMMETHOD));
        while (iter3.hasNext()) {
            OMElement elm3 = (OMElement)iter3.next();
            this.transformMethodsForVerification.add(this.getDataAsString(elm3.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [transformMethodsForVerification:[" + this.transformMethodsForVerification + "]");
        }
        OMElement elm6 = elm.getFirstChildWithName(new QName(VERIFYPARTS));
        Iterator iter4 = elm6.getChildrenWithName(new QName(VERIFYPART));
        while (iter4.hasNext()) {
            OMElement elm3 = (OMElement)iter4.next();
            this.verifyParts.add(this.getDataAsInt(elm3.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [verifyParts:[" + this.verifyParts + "]");
        }
        OMElement elm7 = elm.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iter8 = elm7.getChildrenWithName(new QName(TOKENMAPPING));
        while (iter8.hasNext()) {
            TokenMapping mapping = new TokenMapping();
            OMElement elm9 = (OMElement)iter8.next();
            OMElement elm10 = elm9.getFirstChildWithName(new QName(VALUETYPE));
            mapping.setValueType(this.getDataAsQName(elm10.getText()));
            OMElement elm11 = elm9.getFirstChildWithName(new QName(JAASLOGINCONFIGNAME));
            mapping.setJaasLoginConfigNameForConsumer(elm11.getText());
            this.tokenMappingForVerification.put(mapping.getValueType(), mapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getVerificationDefaultValue(OMElement doc): [tokenMappingForVerification:[" + mapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVerificationDefalutValue(OMElement doc)");
        }
    }

    private void getEncryptionDefaultValue(OMElement doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEncryptionDefalutValue(OMElement doc)");
        }
        OMElement elm = doc.getFirstChildWithName(new QName(ENCRYPTION));
        OMElement elm2 = elm.getFirstChildWithName(new QName(KEYENCRYPTED));
        this.keyEncrypted = this.getDataAsBoolean(elm2.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [keyEncrypted:[" + this.keyEncrypted + "]");
        }
        OMElement elm3 = elm.getFirstChildWithName(new QName(KEYENCRYPTIONMETHOD));
        this.keyEncryptionMethod = this.getDataAsString(elm3.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [keyEncryptionMethod:[" + this.keyEncryptionMethod + "]");
        }
        OMElement elm4 = elm.getFirstChildWithName(new QName(DATAENCRYPTIONMETHOD));
        this.dataEncryptionMethod = this.getDataAsString(elm4.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [dataEncryptionMethod:[" + this.dataEncryptionMethod + "]");
        }
        OMElement elm5 = elm.getFirstChildWithName(new QName(ENCRYPTIONPARTS));
        Iterator iter = elm5.getChildrenWithName(new QName(ENCRYPTIONPART));
        while (iter.hasNext()) {
            OMElement elm6 = (OMElement)iter.next();
            this.encryptionParts.add(this.getDataAsInt(elm6.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [encryptionParts:[" + this.encryptionParts + "]");
        }
        OMElement elm7 = elm.getFirstChildWithName(new QName(TOKENREFERENCE));
        this.tokenReferenceForEncryption = this.getDataAsInt(elm7.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [tokenReferenceForEncryption:[" + this.tokenReferenceForEncryption + "]");
        }
        OMElement elm8 = elm.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iter9 = elm8.getChildrenWithName(new QName(TOKENMAPPING));
        while (iter9.hasNext()) {
            TokenMapping mapping = new TokenMapping();
            OMElement elm9 = (OMElement)iter9.next();
            OMElement elm10 = elm9.getFirstChildWithName(new QName(VALUETYPE));
            mapping.setValueType(this.getDataAsQName(elm10.getText()));
            OMElement elm11 = elm9.getFirstChildWithName(new QName(JAASLOGINCONFIGNAME));
            mapping.setJaasLoginConfigNameForGenerator(elm11.getText());
            this.tokenMappingForEncryption.put(mapping.getValueType(), mapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getEncryptionDefaultValue(OMElement doc): [tokenMappingForEncryption:[" + mapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncryptionDefalutValue(OMElement doc)");
        }
    }

    private boolean getDataAsBoolean(String elementData) {
        Boolean flag = new Boolean(elementData);
        return flag;
    }

    private void getSignatureDefaultValue(OMElement doc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSignatureDefalutValue(OMElement doc)");
        }
        OMElement elm = doc.getFirstChildWithName(new QName(SIGNATURE));
        OMElement elm2 = elm.getFirstChildWithName(new QName(CANONICALIZATIONMETHOD));
        this.canonicalizationMethod = this.getDataAsString(elm2.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [canonicalizationMethod:[" + this.canonicalizationMethod + "]");
        }
        OMElement elm3 = elm.getFirstChildWithName(new QName(SIGNATUREMETHOD));
        this.signatureMethod = this.getDataAsString(elm3.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [signatureMethod:[" + this.signatureMethod + "]");
        }
        OMElement elm4 = elm.getFirstChildWithName(new QName(DIGESTMETHOD));
        this.digestMethod = this.getDataAsString(elm4.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [digestMethod:[" + this.digestMethod + "]");
        }
        OMElement elm5 = elm.getFirstChildWithName(new QName(TRANSFORMMETHODS));
        Iterator iter = elm5.getChildrenWithName(new QName(TRANSFORMMETHOD));
        while (iter.hasNext()) {
            OMElement elm6 = (OMElement)iter.next();
            this.transformMethodsForSignature.add(this.getDataAsString(elm6.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [transformMethodsForSignature:[" + this.transformMethodsForSignature + "]");
        }
        OMElement elm7 = elm.getFirstChildWithName(new QName(SIGNPARTS));
        Iterator iter2 = elm7.getChildrenWithName(new QName(SIGNPART));
        while (iter2.hasNext()) {
            OMElement elm6 = (OMElement)iter2.next();
            this.signParts.add(this.getDataAsInt(elm6.getText()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [signParts:[" + this.signParts + "]");
        }
        OMElement elm8 = elm.getFirstChildWithName(new QName(TOKENREFERENCE));
        this.tokenReferenceForSignature = this.getDataAsInt(elm8.getText());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [tokenReferenceForSignature:[" + this.tokenReferenceForSignature + "]");
        }
        OMElement elm9 = elm.getFirstChildWithName(new QName(TOKENMAPPINGS));
        Iterator iter9 = elm9.getChildrenWithName(new QName(TOKENMAPPING));
        while (iter9.hasNext()) {
            TokenMapping mapping = new TokenMapping();
            OMElement elm10 = (OMElement)iter9.next();
            OMElement elm11 = elm10.getFirstChildWithName(new QName(VALUETYPE));
            mapping.setValueType(this.getDataAsQName(elm11.getText()));
            OMElement elm12 = elm10.getFirstChildWithName(new QName(JAASLOGINCONFIGNAME));
            mapping.setJaasLoginConfigNameForGenerator(elm12.getText());
            this.tokenMappingForSignature.put(mapping.getValueType(), mapping);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "getSignatureDefaultValue(OMElement doc): [tokenMappingForSignature:[" + mapping + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSignatureDefalutValue(OMElement doc)");
        }
    }

    private String getDataAsString(String elementData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataAsString(String elementData): [elementData:[" + elementData + "]");
        }
        int index = elementData.indexOf(".");
        String className = elementData.substring(0, index);
        String modifier = classMap.get(className);
        String fieldName = elementData.substring(index + 1).trim();
        try {
            Class<?> cls = Class.forName(modifier + "." + className);
            Field field = cls.getField(fieldName);
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataAsString(String elementData): [elementData:[" + (String)field.get(cls) + "]");
                }
                return (String)field.get(cls);
            }
            catch (IllegalArgumentException e) {
                Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e.getMessage()}));
            }
            catch (IllegalAccessException e) {
                Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e.getMessage()}));
            }
        }
        catch (SecurityException e1) {
            Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        catch (NoSuchFieldException e1) {
            Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        catch (ClassNotFoundException e1) {
            Tr.warning(tc, "getDataAsString(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataAsString(String elementData)");
        }
        return null;
    }

    private QName getDataAsQName(String elementData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataAsQName(String elementData): [elementData:[" + elementData + "]");
        }
        int index = elementData.indexOf(".");
        String className = elementData.substring(0, index);
        String modifier = classMap.get(className);
        String fieldName = elementData.substring(index + 1).trim();
        try {
            Class<?> cls = Class.forName(modifier + "." + className);
            Field field = cls.getField(fieldName);
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataAsQName(String elementData): [elementData:[" + (QName)field.get(cls) + "]");
                }
                return (QName)field.get(cls);
            }
            catch (IllegalArgumentException e) {
                Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e.getMessage()}));
            }
            catch (IllegalAccessException e) {
                Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e.getMessage()}));
            }
        }
        catch (SecurityException e1) {
            Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        catch (NoSuchFieldException e1) {
            Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        catch (ClassNotFoundException e1) {
            Tr.warning(tc, "getDataAsQName(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataAsString(String elementData) returns null");
        }
        return null;
    }

    private int getDataAsInt(String elementData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataAsInt(String elementData): [elementData:[" + elementData + "]");
        }
        int index = elementData.indexOf(".");
        String className = elementData.substring(0, index);
        String modifier = classMap.get(className);
        String fieldName = elementData.substring(index + 1);
        try {
            Class<?> cls = Class.forName(modifier + "." + className);
            Field field = cls.getField(fieldName);
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataAsInt(String elementData): return [" + field.getInt(cls) + "]");
                }
                return field.getInt(cls);
            }
            catch (IllegalArgumentException e) {
                Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e.getMessage()}));
            }
            catch (IllegalAccessException e) {
                Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e.getMessage()}));
            }
        }
        catch (SecurityException e1) {
            Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        catch (NoSuchFieldException e1) {
            Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        catch (ClassNotFoundException e1) {
            Tr.warning(tc, "getDataAsInt(String elementData): " + ConfigUtil.getMessage("security.wssecurity.WSEC7002W", new String[]{e1.getMessage()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataAsInt(String elementData): return [-1]");
        }
        return -1;
    }

    public List<String> getAllowedCanonicalizationMethods() {
        return this.allowedCanonicalizationMethods;
    }

    public List<String> getAllowedDataEncryptionMethods() {
        return this.allowedDataEncryptionMethods;
    }

    public List<String> getAllowedKeyEncryptionMethods() {
        return this.allowedKeyEncryptionMethods;
    }

    public List<String> getAllowedSignatureMethods() {
        return this.allowedSignatureMethods;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public String getDataEncryptionMethod() {
        return this.dataEncryptionMethod;
    }

    public List<Integer> getDecryptionParts() {
        return this.decryptionParts;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public List<Integer> getEncryptionParts() {
        return this.encryptionParts;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public boolean isKeyEncrypted() {
        return this.keyEncrypted;
    }

    public boolean isKeyEncryptedForDecrption() {
        return this.keyEncryptedForDecrption;
    }

    public String getKeyEncryptionMethod() {
        return this.keyEncryptionMethod;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public List<Integer> getSignParts() {
        return this.signParts;
    }

    public List<String> getTransformMethodsForSignature() {
        return this.transformMethodsForSignature;
    }

    public List<String> getTransformMethodsForVerification() {
        return this.transformMethodsForVerification;
    }

    public List<Integer> getVerifyParts() {
        return this.verifyParts;
    }

    public int getTokenReferenceForSignature() {
        return this.tokenReferenceForSignature;
    }

    public int getTokenReferenceForEncryption() {
        return this.tokenReferenceForEncryption;
    }

    public Map<QName, TokenMapping> getTokenMappingForDecryption() {
        return this.tokenMappingForDecryption;
    }

    public Map<QName, TokenMapping> getTokenMappingForEncryption() {
        return this.tokenMappingForEncryption;
    }

    public Map<QName, TokenMapping> getTokenMappingForSignature() {
        return this.tokenMappingForSignature;
    }

    public Map<QName, TokenMapping> getTokenMappingForVerification() {
        return this.tokenMappingForVerification;
    }

    public Map<QName, TokenMapping> getTokenMapping() {
        return this.tokenMapping;
    }

    public String getDuration() {
        return this.duration;
    }

    public Map<String, Map> getSignatureAlgorithmMap() {
        return this.signatureAlgorithmMap;
    }

    public Map<String, Map> getEncryptionAlgorithmMap() {
        return this.encryptionAlgorithmMap;
    }

    public String getDefaultSignatureAlgorithm() {
        return this.defaultSignatureAlgorithm;
    }

    public String getDefaultEncryptionAlgorithm() {
        return this.defaultEncryptionAlgorithm;
    }

    static {
        classMap.put("WSSSignature", SIGNATURE_CLASS);
        classMap.put("WSSSignPart", SIGNATURE_CLASS);
        classMap.put("WSSDecryption", DECRYPTION_CLASS);
        classMap.put("WSSEncryption", ENCRYPTION_CLASS);
        classMap.put("WSSVerification", VERIFICATOIN_CLASS);
        classMap.put("WSSVerifyPart", VERIFICATOIN_CLASS);
        classMap.put("WSSConsumingContext", WSS_CLASS);
        classMap.put("X509Token", TOKEN_CLASS);
        classMap.put("X509PKCS7Token", TOKEN_CLASS);
        classMap.put("X509PKIPathToken", TOKEN_CLASS);
        classMap.put("LTPAToken", TOKEN_CLASS);
        classMap.put("LTPAPropagationToken", TOKEN_CLASS);
        classMap.put("UsernameToken", TOKEN_CLASS);
        classMap.put("KRB5_APREQToken", TOKEN_CLASS);
        classMap.put("KRB5_APREQ1510Token", TOKEN_CLASS);
        classMap.put("KRB5_APREQ4120Token", TOKEN_CLASS);
        classMap.put("KRB5_GSSAPREQToken", TOKEN_CLASS);
        classMap.put("KRB5_GSSAPREQ1510Token", TOKEN_CLASS);
        classMap.put("KRB5_GSSAPREQ4120Token", TOKEN_CLASS);
        classMap.put("SecurityContextToken", TOKEN_CLASS);
        classMap.put("SecurityContextToken13", TOKEN_CLASS);
        classMap.put("SecurityToken", TOKEN_CLASS);
        classMap.put("LTPAv2Token", TOKEN_CLASS);
        DEFAULT_VALUE_FILE_NAME = "META-INF/wssapiDefaultValues.xml";
        SIGNATURE = "signature";
        CANONICALIZATIONMETHOD = "canonicalizationMethod";
        SIGNATUREMETHOD = "signatureMethod";
        DIGESTMETHOD = "digestMethod";
        TRANSFORMMETHODS = "transformMethods";
        TRANSFORMMETHOD = "transformMethod";
        SIGNPARTS = "signParts";
        SIGNPART = "signPart";
        ENCRYPTION = "encryption";
        KEYENCRYPTED = "keyEncrypted";
        OPTIMIZED = "optimized";
        KEYENCRYPTIONMETHOD = "keyEncryptionMethod";
        DATAENCRYPTIONMETHOD = "dataEncryptionMethod";
        ENCRYPTIONPARTS = "encryptionParts";
        ENCRYPTIONPART = "encryptionPart";
        VERIFICATON = "verification";
        ALLOWEDCANONICALIZATIONMETHODS = "allowedCanonicalizationMethods";
        ALLOWEDSIGNATUREMETHODS = "allowedSignatureMethods";
        VERIFYPARTS = "verifyParts";
        VERIFYPART = "verifyPart";
        DECRYPTION = "decryption";
        ALLOWEDKEYENCRYPTIONMETHODS = "allowedKeyEncryptionMethods";
        ALLOWEDDATAENCRYPTIONMETHODS = "allowedDataEncryptionMethods";
        DECRYPTIONPARTS = "decryptionParts";
        DECRYPTIONPART = "decryptionPart";
        TOKENREFERENCE = "tokenReference";
        TOKENMAPPINGS = "tokenMappings";
        TOKENMAPPING = "tokenMapping";
        VALUETYPE = "valueType";
        JAASLOGINCONFIGNAME = "jaasLoginConfigName";
        instance = new DefaultValueManager();
    }
}

