/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.config.DerivedKeyInfoConfig;
import com.ibm.ws.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(CommonContentGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CommonContentGenerator.class.getName();
    private boolean _initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    @Override
    public Key getKey(OMDocument doc, OMElement parent, Map<Object, Object> type, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKey(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("Map type, Map context)");
            Tr.entry(tc, buf.toString());
        }
        KeyInfoContentGeneratorConfig config2 = (KeyInfoContentGeneratorConfig)context.get("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyInfoContentGeneratorConfig [" + config2 + "].");
        }
        int soapVersion = 0;
        Object obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        int wssVersion = 0;
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][wssVersion];
        String keyInfoType = config2.getKeyInfoType();
        context.put(Constants.WSSECURITY_KEYINFO_TYPE, keyInfoType);
        String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        context.put(Constants.WSSECURITY_KEY_TYPE, keyType);
        OMFactory factory = doc.getOMDocumentElement().getOMFactory();
        OMElement tokenParent = null;
        boolean isEmbedded = ConfigUtil.isKeyInfoEmb(keyInfoType);
        boolean isSTR = ConfigUtil.isKeyInfoStrref(keyInfoType);
        if (isSTR) {
            WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            String actor = gconfig.getTargetActor();
            boolean mustUnderstand = Axis2Util.getMustUnderstand(context);
            OMElement header = WSSGenerator.getHeader(doc, false);
            tokenParent = WSSGenerator.getSecurityHeader(header, soapVersion, wssVersion, actor, mustUnderstand);
        } else {
            tokenParent = isEmbedded ? CommonContentGenerator.insertEmbeddedElements(factory, parent, wssVersion, nsWsse) : parent;
        }
        TokenGeneratorConfig tconfig = config2.getTokenGenerator();
        if (tconfig == null) {
            throw SoapSecurityException.format("security.wssecurity.WSEC6818E", tconfig.toString());
        }
        String keyInfoName = config2.getKeyName();
        context.put(Constants.WSSECURITY_KEYINFO_UNIQUE_NAME, keyInfoName);
        final SecurityToken token = CommonContentGenerator.invokeTokenGenerator(doc, tokenParent, tconfig, context, keyInfoName);
        DerivedKeyInfoConfig dkic = config2.getDerivedKeyInfoConfig();
        if (dkic != null && dkic.isRequireImpliedDerivedKeys()) {
            type.put("RequiredImpliedDerivedKeys", true);
            if (tconfig.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.externalURIReference") != null && ((Boolean)tconfig.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.externalURIReference")).booleanValue()) {
                type.put("com.ibm.ws.wssecurity.sc.dkt.externalURIReference", true);
            }
        }
        Key key = null;
        if ("SigningKey".equals(keyType)) {
            try {
                key = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>(){

                    @Override
                    public Key run() throws WSSException {
                        Key k = token.getKey(61);
                        return k;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.processException((Throwable)e, clsName + ".login", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7073E", e.getCause());
            }
        }
        if ("EncryptingKey".equals(keyType)) {
            try {
                key = AccessController.doPrivileged(new PrivilegedExceptionAction<Key>(){

                    @Override
                    public Key run() throws WSSException {
                        Key k = token.getKey(62);
                        return k;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.processException((Throwable)e, clsName + ".login", "%C", this);
                throw SoapSecurityException.format("security.wssecurity.WSEC7073E", e.getCause());
            }
        }
        if (key == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signing key or encrypting key is null.");
            }
            throw SoapSecurityException.format("security.wssecurity.WSEC7073E");
        }
        keyInfoType = (String)context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (!isEmbedded) {
            CommonContentGenerator.insertKeyInfoChildElements(factory, parent, wssVersion, nsWsse, token, keyInfoType, type);
        } else {
            CommonContentGenerator.insertIdForEmbeddedElement(tokenParent, token, wssVersion);
        }
        context.remove("com.ibm.ws.wssecurity.impl.config.keyinfoContentGenerator.configKey");
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("getKey(");
            buf.append("Document, Element, Map, Map)");
            buf.append(" returns Key[").append(key).append("]");
            Tr.exit(tc, buf.toString());
        }
        return key;
    }

    private static final OMElement insertEmbeddedElements(OMFactory factory, OMElement parent, int wssVersion, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertEmbeddedElements(");
            buf.append("OMFactory factory, ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("String nsWsse[").append(nsWsse).append("])");
            Tr.entry(tc, buf.toString());
        }
        String prefix = DOMUtils.getNamespacePrefix(parent, nsWsse);
        boolean nsDecl = false;
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsse";
        }
        OMElement strelem = factory.createOMElement("SecurityTokenReference", nsWsse, prefix);
        if (nsDecl) {
            strelem.declareNamespace(nsWsse, "wsse");
        }
        OMElement embelem = factory.createOMElement("Embedded", nsWsse, prefix);
        strelem.addChild(embelem);
        OMNode firstChild = parent.getFirstOMChild();
        if (firstChild == null) {
            parent.addChild(strelem);
        } else {
            firstChild.insertSiblingBefore(strelem);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertEmbeddedElements(");
            buf.append("OMFactory, OMElement, int, String)");
            buf.append(" returns OMElement[").append(DOMUtils.getDisplayName(embelem)).append("]");
            Tr.exit(tc, buf.toString());
        }
        return embelem;
    }

    private static final void insertIdForEmbeddedElement(OMElement embelem, SecurityToken token, int wssVersion) throws SoapSecurityException {
        String embId;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertIdForEmbeddedElement(");
            buf.append("OMElement embelem[").append(DOMUtils.getDisplayName(embelem)).append("], ");
            buf.append("SecurityToken token[").append(token).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append(")");
            Tr.entry(tc, buf.toString());
        }
        if ((embId = token.getId()) != null) {
            boolean isDecl = false;
            String nsWsu = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][wssVersion];
            String pWsu = null;
            OMContainer parent = embelem.getParent();
            if (parent instanceof OMElement) {
                pWsu = DOMUtils.getNamespacePrefix((OMElement)parent, nsWsu);
            }
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu";
            }
            if (isDecl) {
                embelem.declareNamespace(nsWsu, pWsu);
            }
            embelem.addAttribute("Id", embId, embelem.getOMFactory().createOMNamespace(nsWsu, pWsu));
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Id not found from token for Embedded element");
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("insertIdForEmbeddedElement(");
            buf.append("OMElement embelem, SecurityToken token, int wssVersion)");
            Tr.exit(tc, buf.toString());
        }
    }

    private static final SecurityToken invokeTokenGenerator(OMDocument doc, OMElement parent, TokenGeneratorConfig tconfig, Map<Object, Object> context, String keyInfoName) throws SoapSecurityException {
        PrivateGeneratorConfig.TokenGeneratorConfImpl confImpl;
        TokenGeneratorComponent tgen;
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeTokenGenerator(");
            buf.append("OMDocument doc[").append(DOMUtils.getDisplayName(doc)).append("], ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("TokenGeneratorConfig tconfig, Map context)");
            Tr.entry(tc, buf.toString());
        }
        if ((tgen = (confImpl = (PrivateGeneratorConfig.TokenGeneratorConfImpl)tconfig).getInstance()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
        }
        SecurityToken token = null;
        token = keyInfoName != null ? (SecurityToken)context.get(keyInfoName) : (SecurityToken)context.get(tconfig);
        if (token == null) {
            context.put("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey", tconfig);
            tgen.invoke(doc, parent, context);
            token = (SecurityToken)context.remove(Constants.WSSECURITY_TOKEN_LOGININFO);
            context.put(tconfig, token);
            if (keyInfoName != null) {
                context.put(keyInfoName, token);
            }
        } else if (token.getKeyIdentifier() != null && !tconfig.isStandAlone()) {
            context.put(Constants.WSSECURITY_KEYINFO_TYPE, "KEYID");
        }
        if (tc.isEntryEnabled()) {
            StringBuffer buf = new StringBuffer("invokeTokenGenerator(");
            buf.append("Document doc, Element parent, TokenGeneratorConfig config, Map context)");
            buf.append(" returns SecurityToken[").append(token).append("]");
            Tr.exit(tc, buf.toString());
        }
        return token;
    }

    private static final void insertKeyInfoChildElements(OMFactory factory, OMElement parent, int wssVersion, String nsWsse, SecurityToken token, String keyInfoType, Map<Object, Object> type) throws SoapSecurityException {
        String pWsse;
        StringBuffer buf;
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("insertKeyInfoChildElements(");
            buf.append("OMFactory factory, ");
            buf.append("OMElement parent[").append(DOMUtils.getDisplayName(parent)).append("], ");
            buf.append("int wssVersion[").append(wssVersion).append("], ");
            buf.append("String nsWsse[").append(nsWsse).append("], ");
            buf.append("SecurityToken token[").append(token).append("], ");
            buf.append("KeyInfoContentGeneratorConfig config, Map type)");
            Tr.entry(tc, buf.toString());
        }
        if (ConfigUtil.isKeyInfoStrref(keyInfoType)) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
            boolean nsDecl = false;
            if (pWsse == null) {
                nsDecl = true;
                pWsse = "wsse";
            }
            OMElement strelem = factory.createOMElement("SecurityTokenReference", nsWsse, pWsse);
            if (nsDecl) {
                strelem.declareNamespace(nsWsse, pWsse);
            }
            if (type.get("RequiredImpliedDerivedKeys") != null && ((Boolean)type.get("RequiredImpliedDerivedKeys")).booleanValue()) {
                String refuri;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Implied Derived Keys property is = TRUE");
                }
                boolean externalUriReference = false;
                if (type.get("com.ibm.ws.wssecurity.sc.dkt.externalURIReference") != null && ((Boolean)type.get("com.ibm.ws.wssecurity.sc.dkt.externalURIReference")).booleanValue()) {
                    externalUriReference = true;
                }
                String nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC_13;
                String tokenType = com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT_13;
                Object refTokenType = null;
                if (((DKToken)token).getType() != null && com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT.equals(((DKToken)token).getType())) {
                    nsWsc = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Implied derived key generation, WSC name space = " + nsWsc);
                }
                nsDecl = false;
                String pWsc = null;
                if (parent != null) {
                    pWsc = DOMUtils.getNamespacePrefix(parent, nsWsc);
                }
                if (pWsc == null) {
                    nsDecl = true;
                    pWsc = "wsc";
                }
                if (nsDecl) {
                    strelem.declareNamespace(nsWsc, pWsc);
                }
                String nonceStr = null;
                nonceStr = Base64.encode(((DKToken)token).getNonce());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nonce from the DerivedKeyToken= " + nonceStr);
                }
                strelem.addAttribute("Nonce", nonceStr, strelem.getOMFactory().createOMNamespace(nsWsc, pWsc));
                String s = new Long(((DKToken)token).getLength()).toString();
                strelem.addAttribute("Length", s, strelem.getOMFactory().createOMNamespace(nsWsc, pWsc));
                if (!externalUriReference) {
                    refuri = "#" + ((DKToken)token).getrefTokenId();
                } else {
                    refuri = ((DKToken)token).getSecurityContextTokenTokenUUID();
                    if (refuri == null) {
                        refuri = ((DKToken)token).getrefTokenId();
                    }
                }
                OMElement refelem = null;
                if (token instanceof DKToken && !((DKToken)token).isReferMasterTokenBySTR()) {
                    refelem = factory.createOMElement("KeyIdentifier", nsWsse, pWsse);
                    QName valueType = ((DKToken)token).getrefTokenType();
                    String keyId = ((DKToken)token).getrefTokenId();
                    String encoding = ((DKToken)token).getReferMaterTokenEncoding();
                    if (encoding != null && encoding.length() > 0) {
                        refelem.addAttribute("EncodingType", encoding, null);
                    }
                    refelem.addAttribute("ValueType", valueType.getLocalPart(), null);
                    refelem.setText(keyId);
                } else {
                    refelem = factory.createOMElement("Reference", nsWsse, pWsse);
                    refelem.addAttribute("URI", refuri, null);
                    QName valueType = new QName("", ((DKToken)token).getrefTokenType().getLocalPart());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Implied derived key generation, Referenced token value type = " + valueType);
                    }
                    DOMUtils.setQNameAttr(refelem, null, "ValueType", valueType, wssVersion);
                    if (externalUriReference && (refuri = ((DKToken)token).getRefTokenInstance()) != null) {
                        refelem.addAttribute("Instance", refuri, refelem.getOMFactory().createOMNamespace(nsWsc, "wsc"));
                    }
                }
                strelem.addChild(refelem);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "STR element = " + strelem);
                }
            } else {
                String reference = token.getReferenceURI();
                OMElement refelem = factory.createOMElement("Reference", nsWsse, pWsse);
                refelem.addAttribute("URI", reference, null);
                QName valueType = token.getValueType();
                DOMUtils.setQNameAttr(refelem, null, "ValueType", valueType, wssVersion);
                strelem.addChild(refelem);
            }
            parent.addChild(strelem);
        } else if (ConfigUtil.isKeyInfoKeyid(keyInfoType)) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
            boolean nsDecl = false;
            if (pWsse == null) {
                nsDecl = true;
                pWsse = "wsse";
            }
            OMElement strelem = factory.createOMElement("SecurityTokenReference", nsWsse, pWsse);
            if (nsDecl) {
                strelem.declareNamespace(nsWsse, pWsse);
            }
            OMElement kielem = factory.createOMElement("KeyIdentifier", nsWsse, pWsse);
            QName encodingType = null;
            QName valueType = null;
            encodingType = token.getKeyIdentifierEncodingType();
            valueType = token.getKeyIdentifierValueType();
            if (encodingType != null) {
                DOMUtils.setQNameAttr(kielem, null, "EncodingType", encodingType, wssVersion);
            }
            if (valueType != null) {
                DOMUtils.setQNameAttr(kielem, null, "ValueType", valueType, wssVersion);
            }
            strelem.addChild(kielem);
            String keyId = token.getKeyIdentifier();
            OMText text = factory.createOMText(keyId);
            kielem.addChild(text);
            parent.addChild(strelem);
        } else if (ConfigUtil.isKeyInfoThumbprint(keyInfoType)) {
            pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
            boolean nsDecl = false;
            if (pWsse == null) {
                nsDecl = true;
                pWsse = "wsse";
            }
            OMElement strelem = factory.createOMElement("SecurityTokenReference", nsWsse, pWsse);
            if (nsDecl) {
                strelem.declareNamespace(nsWsse, pWsse);
            }
            OMElement kielem = factory.createOMElement("KeyIdentifier", nsWsse, pWsse);
            QName encodingType = token.getThumbprintEncodingType();
            DOMUtils.setQNameAttr(kielem, null, "EncodingType", encodingType, wssVersion);
            QName valueType = token.getThumbprintValueType();
            DOMUtils.setQNameAttr(kielem, null, "ValueType", valueType, wssVersion);
            strelem.addChild(kielem);
            String thumbprint = token.getThumbprint();
            OMText text = factory.createOMText(thumbprint);
            kielem.addChild(text);
            parent.addChild(strelem);
        } else if (ConfigUtil.isKeyInfoKeyname(keyInfoType)) {
            String prefix = DOMUtils.getNamespacePrefix(parent, com.ibm.ws.wssecurity.common.Constants.NS_DSIG);
            if (prefix == null) {
                prefix = "ds";
            }
            OMElement knelem = factory.createOMElement("KeyName", com.ibm.ws.wssecurity.common.Constants.NS_DSIG, prefix);
            String keyName = token.getKeyName();
            String kn = KeyInfo.X509Data.decodeDName(keyName);
            if (kn != null) {
                keyName = kn;
            }
            OMText text = factory.createOMText(keyName);
            knelem.addChild(text);
            parent.addChild(knelem);
        } else if (!ConfigUtil.isKeyInfoEmb(keyInfoType)) {
            if (ConfigUtil.isKeyInfoX509issuer(keyInfoType)) {
                pWsse = DOMUtils.getNamespacePrefix(parent, nsWsse);
                boolean nsDecl = false;
                if (pWsse == null) {
                    nsDecl = true;
                    pWsse = "wsse";
                }
                OMElement strelem = factory.createOMElement("SecurityTokenReference", nsWsse, pWsse);
                if (nsDecl) {
                    strelem.declareNamespace(nsWsse, pWsse);
                }
                String nsDs = com.ibm.ws.wssecurity.common.Constants.NS_DSIG;
                String pDs = DOMUtils.getNamespacePrefix(parent, nsDs);
                nsDecl = false;
                if (pDs == null) {
                    nsDecl = true;
                    pDs = "ds";
                }
                if (nsDecl) {
                    strelem.declareNamespace(nsDs, pDs);
                }
                OMElement data = factory.createOMElement("X509Data", nsDs, pDs);
                strelem.addChild(data);
                OMElement issuer = factory.createOMElement("X509IssuerSerial", nsDs, pDs);
                data.addChild(issuer);
                OMElement name = factory.createOMElement("X509IssuerName", nsDs, pDs);
                issuer.addChild(name);
                String issuerDN = ((X509Token)token).getIssuerName();
                OMText tname = factory.createOMText(issuerDN);
                name.addChild(tname);
                OMElement number = factory.createOMElement("X509SerialNumber", nsDs, pDs);
                issuer.addChild(number);
                String issuerSerial = ((X509Token)token).getIssuerSerial();
                OMText tsnum = factory.createOMText(issuerSerial);
                number.addChild(tsnum);
                parent.addChild(strelem);
            } else {
                String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
                boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
                StringBuffer buf2 = new StringBuffer("WARNING: ").append(clsName);
                buf2.append(" found unknown key information type: ").append(keyInfoType).append(". ");
                buf2.append(" Please make sure the key information used for");
                if ("SigningKey".equals(keyType)) {
                    buf2.append(" siganture");
                } else {
                    buf2.append(" encryption");
                }
                buf2.append(" in the");
                if (isServer) {
                    buf2.append(" response generator configuration.");
                } else {
                    buf2.append(" request generator configuration.");
                }
                Tr.debug(tc, buf2.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            buf = new StringBuffer("insertKeyInfoChildElements(");
            buf.append("OMFactory factory, OMElement parent, int wssVersion, String nsWsse, ");
            buf.append("SecurityToken token, KeyInfoContentGeneratorConfig config, Map type)");
            Tr.exit(tc, buf.toString());
        }
    }
}

