/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.timer;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.Alarm;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManager;

class _Alarm
implements Alarm,
Comparable,
Runnable {
    private static final TraceComponent tc = Tr.register(_Alarm.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    long expirationTime;
    Object context;
    AlarmListener listener;
    boolean deferrable;
    boolean fired = false;

    _Alarm() {
        this.expirationTime = -1L;
        this.context = null;
        this.listener = null;
        this.deferrable = true;
    }

    _Alarm(long t, AlarmListener l, Object o, boolean d) {
        this.expirationTime = t;
        this.listener = l;
        this.context = o;
        this.deferrable = d;
    }

    public void run() {
        try {
            this.listener.alarm(this.context);
        }
        catch (Throwable t) {
            Tr.error(tc, "firing alarm failed", new Object[]{this, t});
        }
    }

    public void cancel() {
        AlarmManager.cancel(this);
    }

    public final int compareTo(Object c) {
        if (this == c) {
            return 0;
        }
        long otherExpirationTime = ((_Alarm)c).expirationTime;
        if (this.expirationTime < otherExpirationTime) {
            return -1;
        }
        if (this.expirationTime > otherExpirationTime) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "_Alarm(" + this.expirationTime + "," + this.listener + "," + this.context + ")";
    }
}

