/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.timer;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.timer.Alarm;
import com.ibm.ws.wssecurity.util.timer.AlarmListener;
import com.ibm.ws.wssecurity.util.timer.AlarmManagerThread;
import com.ibm.ws.wssecurity.util.timer.BinaryHeap;
import com.ibm.ws.wssecurity.util.timer._Alarm;
import java.util.Vector;

public class AlarmManager {
    private static final TraceComponent tc = Tr.register(AlarmManager.class, null, null);
    public static final String ALARM_WORKBASED = "com.ibm.ejs.am.mode.workbased";
    static final BinaryHeap deferredAlarmQ = new BinaryHeap(new _Alarm());
    static final BinaryHeap nonDeferredAlarmQ = new BinaryHeap(new _Alarm());
    private static boolean initialized = false;
    private static boolean deferred = false;
    private static Vector deferredAlarmList = new Vector();
    private static int activeWork = 0;

    private AlarmManager() {
    }

    private static final synchronized void init() {
        if (initialized) {
            return;
        }
        Thread dThread = new Thread((Runnable)new AlarmManagerThread(deferredAlarmQ, deferred, "Deferrable Alarm"), "Deferred Alarm Manager");
        dThread.setDaemon(true);
        dThread.start();
        Thread ndThread = new Thread((Runnable)new AlarmManagerThread(nonDeferredAlarmQ, false, "Non-deferrable Alarm"), "Non-Deferred Alarm Manager");
        ndThread.setDaemon(true);
        ndThread.start();
        initialized = true;
    }

    public static final Alarm create(long n, AlarmListener listener, Object alarmContext) {
        return AlarmManager.createDeferrable(n, listener, alarmContext);
    }

    public static final Alarm create(long n, AlarmListener listener) {
        return AlarmManager.createDeferrable(n, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Alarm createNonDeferrable(long n, AlarmListener l, Object alarmContext) {
        AlarmManager.init();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonDeferrable", new Object[]{new Long(n), l, alarmContext});
        }
        if (l == null) {
            throw new NullPointerException();
        }
        if (n < 0L) {
            n = 0L;
        }
        if ((n += System.currentTimeMillis()) < 0L) {
            n = Long.MAX_VALUE;
        }
        _Alarm result = new _Alarm(n, l, alarmContext, false);
        BinaryHeap binaryHeap = nonDeferredAlarmQ;
        synchronized (binaryHeap) {
            nonDeferredAlarmQ.insert(result);
            if (result == nonDeferredAlarmQ.minimum()) {
                nonDeferredAlarmQ.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonDeferrable", result);
        }
        return result;
    }

    public static final Alarm createNonDeferrable(long n, AlarmListener l) {
        return AlarmManager.createNonDeferrable(n, l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Alarm createDeferrable(long n, AlarmListener l, Object alarmContext) {
        AlarmManager.init();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDeferrable", new Object[]{new Long(n), l, alarmContext});
        }
        if (l == null) {
            throw new NullPointerException();
        }
        if (n < 0L) {
            n = 0L;
        }
        _Alarm result = new _Alarm(n, l, alarmContext, true);
        if (!deferred || activeWork > 0) {
            BinaryHeap binaryHeap = deferredAlarmQ;
            synchronized (binaryHeap) {
                result.expirationTime += System.currentTimeMillis();
                if (result.expirationTime < 0L) {
                    result.expirationTime = Long.MAX_VALUE;
                }
                deferredAlarmQ.insert(result);
                if (result == deferredAlarmQ.minimum()) {
                    deferredAlarmQ.notify();
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Alarm has been deferred", result);
        }
        Vector vector = deferredAlarmList;
        synchronized (vector) {
            deferredAlarmList.add(result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDeferrable", result);
        }
        return result;
    }

    public static final Alarm createDeferrable(long n, AlarmListener l) {
        return AlarmManager.createDeferrable(n, l, null);
    }

    static final void cancel(Alarm a) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
        AlarmManager.disableAlarm(a);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean disableAlarm(Alarm a) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableAlarm", a);
        }
        boolean disabled = false;
        if (((_Alarm)a).deferrable) {
            BinaryHeap binaryHeap = deferredAlarmQ;
            synchronized (binaryHeap) {
                Vector vector = deferredAlarmList;
                synchronized (vector) {
                    if (!((_Alarm)a).fired) {
                        deferredAlarmQ.delete((_Alarm)a);
                        deferredAlarmList.remove((_Alarm)a);
                        disabled = true;
                    }
                }
            }
        }
        BinaryHeap binaryHeap = nonDeferredAlarmQ;
        synchronized (binaryHeap) {
            if (!((_Alarm)a).fired) {
                nonDeferredAlarmQ.delete((_Alarm)a);
                disabled = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableAlarm", disabled);
        }
        return disabled;
    }

    private static final void armDeferredAlarms() {
        AlarmManager.createNonDeferrable(1000L, new AlarmListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alarm(Object alarmContext) {
                _Alarm result = null;
                BinaryHeap binaryHeap = deferredAlarmQ;
                synchronized (binaryHeap) {
                    Vector vector = deferredAlarmList;
                    synchronized (vector) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Starting arm of " + deferredAlarmList.size() + " deferred alarms");
                        }
                        for (int ix = 0; ix < deferredAlarmList.size(); ++ix) {
                            result = (_Alarm)deferredAlarmList.elementAt(ix);
                            result.expirationTime += System.currentTimeMillis();
                            if (result.expirationTime < 0L) {
                                result.expirationTime = Long.MAX_VALUE;
                            }
                            deferredAlarmQ.insert(result);
                        }
                        deferredAlarmList.clear();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Completed arm of deferred alarms");
                        }
                        deferredAlarmQ.notify();
                    }
                }
            }
        });
    }

    public static synchronized void incActiveWork() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "activeWork = " + activeWork);
        }
        if (activeWork == 0) {
            AlarmManager.armDeferredAlarms();
        }
        ++activeWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decActiveWork() {
        BinaryHeap binaryHeap = deferredAlarmQ;
        synchronized (binaryHeap) {
            Class<AlarmManager> clazz = AlarmManager.class;
            synchronized (AlarmManager.class) {
                --activeWork;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "activeWork = " + activeWork);
                }
                if (activeWork == 0) {
                    deferredAlarmQ.notify();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    public static synchronized int getActiveWork() {
        return activeWork;
    }
}

