/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.io;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ObjectFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.ProxyOutputStream;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class WriterChainHolder {
    private static final TraceComponent tc = Tr.register(WriterChainHolder.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected final BufferedWriter bufferedWriter;
    protected final OutputStreamWriter outputStreamWriter;
    protected final ProxyOutputStream proxyOutputStream;

    protected WriterChainHolder(String encoding) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WriterChainHolder", new Object[]{encoding, this});
        }
        try {
            this.proxyOutputStream = new ProxyOutputStream(null);
            this.outputStreamWriter = new OutputStreamWriter((OutputStream)this.proxyOutputStream, encoding);
            this.bufferedWriter = new BufferedWriter(this.outputStreamWriter);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WriterChainHolder");
        }
    }

    public final BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    public final ProxyOutputStream getProxyOutputStream() {
        return this.proxyOutputStream;
    }

    protected void reset() {
        this.proxyOutputStream.setOutputStream(null);
    }

    public static Utf8WriterChainHolderFactory getUtf8WriterChainHolderFactory() {
        return Utf8WriterChainHolderFactory.getInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Utf8WriterChainHolderFactory
    extends ObjectFactory<WriterChainHolder> {
        private static final Utf8WriterChainHolderFactory INSTANCE = new Utf8WriterChainHolderFactory();

        private Utf8WriterChainHolderFactory() {
        }

        public static final Utf8WriterChainHolderFactory getInstance() {
            return INSTANCE;
        }

        @Override
        protected WriterChainHolder createNewInstance() {
            return new WriterChainHolder(Constants.ENCODING_UTF8);
        }

        @Override
        protected void reset(WriterChainHolder object) {
            object.reset();
        }
    }
}

