/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.io;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.io.InputStream;

public abstract class DataTransformInputStream
extends InputStream {
    private static final TraceComponent tc = Tr.register(DataTransformInputStream.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static final int DEFAULT_BUFFER_SIZE = 256;
    protected static final int STATE_MIDDLE_PART = 1;
    protected static final int STATE_LAST_PART = 2;
    protected static final int STATE_FINISHED = 3;
    protected int state;
    protected byte[] bytebuf;
    protected int bufpos;
    protected int bufcount;

    public DataTransformInputStream() {
        this(256);
    }

    public DataTransformInputStream(int bufferSize) {
        if (bufferSize < 256) {
            bufferSize = 256;
        }
        this.bytebuf = new byte[bufferSize];
        this.state = 1;
    }

    private void resetBufPos() {
        this.bufpos = 0;
        this.bufcount = 0;
    }

    public void resetInstance() {
        this.resetBufPos();
        this.state = 1;
    }

    public void clear() {
        this.bytebuf = null;
    }

    public void close() throws IOException {
        super.close();
        this.state = 3;
        this.clear();
    }

    public int read() throws IOException {
        if (this.state == 3) {
            return -1;
        }
        if (this.state == 2 && this.bufpos >= this.bufcount) {
            this.state = 3;
            return -1;
        }
        if (this.bufpos >= this.bufcount) {
            this.bufcount = this.internalRead(this.bytebuf, 0, this.bytebuf.length);
            if (this.bufcount == 0 && this.state == 2) {
                this.state = 3;
                return -1;
            }
            this.bufpos = 0;
        }
        return this.bytebuf[this.bufpos++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.state == 3) {
            return -1;
        }
        if (this.state == 2 && this.bufpos >= this.bufcount) {
            this.state = 3;
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        int count = 0;
        int remainBufCount = this.bufcount - this.bufpos;
        if (remainBufCount > 0) {
            if (len <= remainBufCount) {
                System.arraycopy(this.bytebuf, this.bufpos, b, off, len);
                this.bufpos += len;
                return len;
            }
            System.arraycopy(this.bytebuf, this.bufpos, b, off, remainBufCount);
            this.bufpos = 0;
            this.bufcount = 0;
            off += remainBufCount;
            len -= remainBufCount;
            count += remainBufCount;
        }
        return count += this.internalRead(b, off, len);
    }

    protected abstract int internalRead(byte[] var1, int var2, int var3);

    public boolean markSupported() {
        return false;
    }
}

