/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.io;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.Base64Table;
import java.io.IOException;
import java.io.InputStream;

public class Base64DecodeInputStream
extends InputStream {
    private static final TraceComponent tc = Tr.register(Base64DecodeInputStream.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    public static int DEFAULT_BUFFER_SIZE = 512;
    protected InputStream in;
    protected byte[] buffEncoded;
    protected byte[] buffDecoded;
    protected int countDecoded;
    protected int posDecoded;
    protected boolean finished;

    public Base64DecodeInputStream(InputStream in) {
        this(in, DEFAULT_BUFFER_SIZE);
    }

    public Base64DecodeInputStream(InputStream in, int encodedBufferSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, Base64DecodeInputStream.class.getSimpleName() + "(InputStream in=" + in + ", int encodedBufferSize=" + encodedBufferSize + ")");
        }
        if (encodedBufferSize < 4) {
            encodedBufferSize = DEFAULT_BUFFER_SIZE;
        }
        int blockSize = encodedBufferSize / 4;
        int decodedBufferSize = blockSize * 3;
        encodedBufferSize = blockSize * 4;
        this.buffEncoded = new byte[encodedBufferSize];
        this.buffDecoded = new byte[decodedBufferSize];
        this.in = in;
        this.posDecoded = 0;
        this.countDecoded = 0;
        this.finished = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, Base64DecodeInputStream.class.getSimpleName() + "(InputStream in=" + in + ", int encodedBufferSize=" + encodedBufferSize + ")");
        }
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, Base64DecodeInputStream.class.getSimpleName() + ".close(), this.in=" + this.in + ", posDecoded=" + this.posDecoded + ", countDecoded=" + this.countDecoded + ", finished=" + this.finished + ".");
        }
        this.in.close();
        this.finished = true;
        this.buffDecoded = null;
        this.buffEncoded = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, Base64DecodeInputStream.class.getSimpleName() + ".close(), this.in=" + this.in + ", posDecoded=" + this.posDecoded + ", countDecoded=" + this.countDecoded + ", finished=" + this.finished + ".");
        }
    }

    public synchronized int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (this.posDecoded >= this.countDecoded) {
            this.decode();
            if (this.finished) {
                return -1;
            }
        }
        return this.buffDecoded[this.posDecoded++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException(Base64DecodeInputStream.class.getSimpleName() + ".read(byte[] b, int off, int len), b.length=" + b.length + ", off=" + off + ", len=" + len + ".");
        }
        if (len == 0 && !this.finished) {
            return 0;
        }
        if (this.finished) {
            return -1;
        }
        if (this.posDecoded >= this.countDecoded) {
            this.decode();
        }
        int decodedSize = 0;
        while (len - decodedSize >= this.countDecoded - this.posDecoded) {
            if (this.finished) {
                return decodedSize;
            }
            System.arraycopy(this.buffDecoded, this.posDecoded, b, off + decodedSize, this.countDecoded - this.posDecoded);
            decodedSize += this.countDecoded - this.posDecoded;
            this.decode();
        }
        if (len - decodedSize > 0) {
            if (this.finished) {
                return decodedSize;
            }
            int remainSize = len - decodedSize;
            System.arraycopy(this.buffDecoded, this.posDecoded, b, off + decodedSize, remainSize);
            decodedSize += remainSize;
            this.posDecoded += remainSize;
        }
        return decodedSize;
    }

    private void decode() throws IOException {
        int readsize = this.in.read(this.buffEncoded, 0, this.buffEncoded.length);
        if (readsize <= 0) {
            this.finished = true;
            return;
        }
        this.countDecoded = Base64Table.decode(this.buffEncoded, 0, readsize, this.buffDecoded, 0);
        this.posDecoded = 0;
    }
}

