/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util.io;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.io.DataTransformInputStream;
import java.io.IOException;

public class AsciiStringInputStream
extends DataTransformInputStream {
    private static final TraceComponent tc = Tr.register(AsciiStringInputStream.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected String sourceString;
    protected int sourcePos;
    protected char[] charbuf;

    public AsciiStringInputStream(String asciiString) {
        this(asciiString, 256);
    }

    public AsciiStringInputStream(String asciiString, int bufferSize) {
        super(bufferSize);
        bufferSize = this.bytebuf.length;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, AsciiStringInputStream.class.getSimpleName() + "(String asciiString, int bufferSize=" + bufferSize + ")");
        }
        this.charbuf = new char[bufferSize];
        this.sourceString = asciiString;
        this.sourcePos = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, AsciiStringInputStream.class.getSimpleName() + "(String asciiString, int bufferSize=" + bufferSize + ")");
        }
    }

    public void setString(String asciiString) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, AsciiStringInputStream.class.getSimpleName() + ".setString(String asciiString=" + asciiString + ")");
        }
        this.sourceString = asciiString;
        this.resetInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, AsciiStringInputStream.class.getSimpleName() + ".setString(String asciiString=" + asciiString + ")");
        }
    }

    public void resetInstance() {
        super.resetInstance();
        this.sourcePos = 0;
    }

    public void clear() {
        super.clear();
        this.sourceString = null;
        this.charbuf = null;
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, AsciiStringInputStream.class.getSimpleName() + "close()");
        }
        super.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, AsciiStringInputStream.class.getSimpleName() + "close()");
        }
    }

    protected int internalRead(byte[] bytebuf, int bufoff, int buflength) {
        int remainSourceLen = this.sourceString.length() - this.sourcePos;
        int internalReadLength = remainSourceLen;
        if (internalReadLength > buflength) {
            internalReadLength = buflength;
        }
        if (internalReadLength == remainSourceLen) {
            this.state = 2;
        }
        int targetSourcePos = this.sourcePos + internalReadLength;
        while (this.sourcePos < targetSourcePos) {
            int length = targetSourcePos - this.sourcePos;
            if (length > this.charbuf.length) {
                length = this.charbuf.length;
            }
            this.sourceString.getChars(this.sourcePos, this.sourcePos + length, this.charbuf, 0);
            for (int i = 0; i < length; ++i) {
                char c = this.charbuf[i];
                if (c < '\u0000' || c > '\u007f') {
                    throw new IllegalArgumentException("Non ASCII character '" + this.charbuf[i] + "' comes.");
                }
                bytebuf[bufoff++] = (byte)c;
            }
            this.sourcePos += length;
        }
        return internalReadLength;
    }
}

