/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class WsObjectInputStream
extends ObjectInputStream {
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    private static final TraceComponent tc = Tr.register(WsObjectInputStream.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected static ClassResolver resolver;
    protected ClassLoader classloader;
    protected String name;
    PrivilegedExceptionAction loadAction = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            try {
                Class clazz = null;
                if (resolver != null) {
                    clazz = resolver.resolveClass(WsObjectInputStream.this.name);
                }
                if (clazz == null) {
                    clazz = WsObjectInputStream.this.loadClass(WsObjectInputStream.this.name, WsObjectInputStream.this.classloader);
                }
                return clazz;
            }
            catch (ClassNotFoundException cnf) {
                Class c = (Class)primClasses.get(WsObjectInputStream.this.name);
                if (c != null) {
                    return c;
                }
                throw cnf;
            }
        }
    };

    public WsObjectInputStream(InputStream is) throws IOException {
        super(is);
        this.classloader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public WsObjectInputStream(InputStream is, ClassLoader cl) throws IOException {
        super(is);
        this.classloader = cl;
    }

    protected Class resolveClass(ObjectStreamClass objStrmClass) throws IOException, ClassNotFoundException {
        try {
            this.name = objStrmClass.getName();
            return (Class)AccessController.doPrivileged(this.loadAction);
        }
        catch (PrivilegedActionException pae) {
            Exception wrapped = pae.getException();
            if (wrapped instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)wrapped;
            }
            throw new ClassNotFoundException(this.name);
        }
    }

    private Class loadClass(String name, ClassLoader loader) throws ClassNotFoundException {
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException cnf) {
            return Class.forName(name);
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
        boolean inOSGi = true;
        try {
            Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
        }
        catch (ClassNotFoundException cnfe) {
            inOSGi = false;
        }
        if (inOSGi) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.util.ClassResolverImpl");
                resolver = (ClassResolver)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                Tr.error(tc, "com.ibm.ws.util.WsObjectInputStream", new Object[]{cnfe});
            }
            catch (Exception e) {
                Tr.error(tc, "com.ibm.ws.util.WsObjectInputStream", new Object[]{e});
            }
        }
    }

    public static interface ClassResolver {
        public Class resolveClass(String var1);
    }
}

