/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;
import java.security.Security;

public class WSSNonceGenerator {
    private static final TraceComponent tc = Tr.register(WSSNonceGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final int DEFAULT_KEY_LENGTH = 16;
    private static SecureRandom _random = null;

    public static byte[] generateBytes(int keyLength) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateBytes()");
        }
        byte[] nonce = null;
        if (_random == null) {
            WSSNonceGenerator.initSecureRandom();
        }
        if (keyLength == 0) {
            keyLength = 16;
        }
        nonce = new byte[keyLength];
        _random.nextBytes(nonce);
        if (tc.isEntryEnabled()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(nonce, 0, nonce.length);
            Tr.exit(tc, "generateBytes", out.toString());
        }
        return nonce;
    }

    private static synchronized void initSecureRandom() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecureRandom()");
        }
        if (_random != null) {
            return;
        }
        try {
            if (Security.getProvider("IBMJCE") != null) {
                _random = SecureRandom.getInstance("IBMSecureRandom");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JCE Default Provider is IBMJCE");
                }
            } else {
                _random = SecureRandom.getInstance("SHA1PRNG");
            }
        }
        catch (Exception e) {
            _random = new SecureRandom();
        }
        _random.setSeed(SecurityUIDGenerator.createUID().getBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initSecureRandom()");
        }
    }
}

