/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPFunctionElementSelector
extends XPathElementSelector {
    private static final TraceComponent tc = Tr.register(WSPFunctionElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String WSP_BODY = "wsp:Body";
    private static final String WSP_HEADER = "wsp:Header";
    private static final String[] BODY_TEMPLATE = new String[]{"/*[namespace-uri()='", "' and local-name()='Envelope']/*[namespace-uri()='", "' and local-name()='Body']"};
    private static final String[] HEADER_TEMPLATE = new String[]{"/*[namespace-uri()='", "' and local-name()='Envelope']/*[namespace-uri()='", "' and local-name()='Header']/*[name()='", "']"};

    @Override
    public void init(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        super.init(properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(node) + "], Map context)");
        }
        String keyword = (String)context.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expression [" + keyword + "]");
        }
        int version = 0;
        Object obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][version];
        if (keyword != null) {
            keyword = WSPFunctionElementSelector.convert2XPath(nsSoap, keyword);
            context.put("com.ibm.ws.wssecurity.util.selector.keyword", keyword);
        }
        ArrayList<OMNode> list = super.getElements(node, context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode node, Map)");
        }
        return list;
    }

    protected static String convert2XPath(String nsSoap, String exp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convert2XPath(String nsSoap[" + nsSoap + "]," + "String exp[" + exp + "])");
        }
        exp = exp.trim();
        StringBuffer buf = new StringBuffer();
        if (exp.startsWith(WSP_BODY)) {
            buf.append(BODY_TEMPLATE[0]).append(nsSoap);
            buf.append(BODY_TEMPLATE[1]).append(nsSoap);
            buf.append(BODY_TEMPLATE[2]);
            int start = exp.indexOf(41) + 1;
            if (start != exp.length()) {
                buf.append(exp.substring(start));
            }
        } else if (exp.startsWith(WSP_HEADER)) {
            buf.append(HEADER_TEMPLATE[0]).append(nsSoap);
            buf.append(HEADER_TEMPLATE[1]).append(nsSoap);
            buf.append(HEADER_TEMPLATE[2]);
            int start = exp.indexOf(40) + 1;
            int end = exp.indexOf(41);
            buf.append(exp.substring(start, end));
            buf.append(HEADER_TEMPLATE[3]);
            if (end != exp.length() - 1) {
                buf.append(exp.substring(end + 1));
            }
        }
        String ret = buf.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convert2XPath(String, String) returns String[" + ret + "]");
        }
        return ret;
    }

    @Override
    public ArrayList<XMLElement> getXMLElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        ArrayList<OMNode> orig_list = this.getElements(node, context);
        ArrayList<XMLElement> new_list = new ArrayList<XMLElement>();
        if (orig_list != null && orig_list.size() > 0) {
            for (int i = 0; i < orig_list.size(); ++i) {
                OMNode obj = orig_list.get(i);
                XMLElement el = new XMLElement(obj);
                new_list.add(el);
            }
        }
        return new_list;
    }
}

