/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.core.ElementSelector;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.core.XMLElement;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampDialectElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(TimestampDialectElementSelector.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    public static final String MOVE_MODE = "move";
    public static final String CHECK_MODE = "check";
    public static final int SECURITYFIRST = 0;
    public static final int SECURITYLAST = 1;
    public static final int SOAPHEADERFIRST = 2;
    public static final int SOAPHEADERLAST = 3;
    public static final int SECURITY_GENERATOR_DEFAULT = 0;
    public static final int SOAPHEADER_GENERATOR_DEFAULT = 3;
    public static final int SECURITY_CONSUMER_DEFAULT = 4;
    public static final int SOAPHEADER_CONSUMER_DEFAULT = 5;
    public static final String[] WASDIALECTS = new String[]{"SecurityFirst".intern(), "SecurityLast".intern(), "SOAPHeaderFirst".intern(), "SOAPHeaderLast".intern(), "SecurityConsumerDefault".intern(), "SOAPHeaderConsumerDefault".intern()};

    public void init(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map properties)");
        }
    }

    @Override
    public ArrayList<OMNode> getElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMNode node[" + DOMUtils.getDisplayName(node) + "], Map context)");
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String keyword = (String)context.get("com.ibm.ws.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expression [" + keyword + "]");
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.wssecurity.util.selector.operation");
        boolean move = MOVE_MODE.equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Mode [" + obj + "]");
        }
        obj = context.get("com.ibm.ws.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        obj = context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        String actor = null;
        if (context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey") == null) {
            WSSConsumerConfig cconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
            if (cconfig != null) {
                actor = cconfig.getMyActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got consumer actor " + actor);
            }
        } else {
            WSSGeneratorConfig gconfig = (WSSGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
            if (gconfig != null) {
                actor = gconfig.getTargetActor();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got generator actor " + actor);
            }
        }
        OMDocument doc = DOMUtil.getOwnerDocument(node);
        OMElement header = WSSGenerator.getHeader(doc, false);
        OMElement security = WSSGenerator.getSecurityHeader(header, soapVersion, wssVersion, actor, false);
        ArrayList<OMNode> list = null;
        list = move ? TimestampDialectElementSelector.moveTimestamp(header, security, keyword, nsWsu, context) : TimestampDialectElementSelector.getElements(header, security, keyword, nsWsu);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMNode, Map)");
        }
        return list;
    }

    private static ArrayList<OMNode> moveTimestamp(OMElement header, OMElement security, String keyword, String nsWsu, Map<Object, Object> context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "moveTimestamp(OMElement header[" + DOMUtils.getDisplayName(header) + "]," + "OMElement security[" + DOMUtils.getDisplayName(security) + "]," + "String keyword[" + keyword + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)");
        }
        OMNode timestamp = null;
        Object[] objs = (Object[])context.get("com.ibm.ws.wssecurity.util.selector.element");
        if (objs != null && objs.length > 0) {
            timestamp = (OMNode)objs[0];
        }
        if (timestamp == null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampDialectElementSelector.s01");
        }
        timestamp.detach();
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        if (WASDIALECTS[0].equals(keyword)) {
            OMNode firstChild;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Moving to the first of the Security element.");
            }
            if ((firstChild = security.getFirstOMChild()) == null) {
                security.addChild(timestamp);
            } else {
                firstChild.insertSiblingBefore(timestamp);
            }
        } else if (WASDIALECTS[1].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Moving to the last of the Security element.");
            }
            security.addChild(timestamp);
        } else if (WASDIALECTS[2].equals(keyword)) {
            OMNode firstChild;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Moving to the first of the SOAP header element.");
            }
            if ((firstChild = header.getFirstOMChild()) == null) {
                header.addChild(timestamp);
            } else {
                firstChild.insertSiblingBefore(timestamp);
            }
        } else if (WASDIALECTS[3].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Moving to the last of the Security element.");
            }
            header.addChild(timestamp);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown keyword[" + keyword + "], so applying the default.");
                Tr.debug(tc, "Moving to the last of the Security element.");
            }
            security.addChild(timestamp);
        }
        objs[0] = timestamp;
        context.put("com.ibm.ws.wssecurity.util.selector.element", objs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "moveTimestamp(OMElement, OMElement, String, String, Map) returns ArrayListList[" + list + "]");
        }
        return list;
    }

    private static ArrayList<OMNode> getElements(OMElement header, OMElement security, String keyword, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getElements(OMElement header[" + DOMUtils.getDisplayName(header) + "]," + "OMElement security[" + DOMUtils.getDisplayName(security) + "]," + "String keyword[" + keyword + "]," + "String nsWsu[" + nsWsu + "])");
        }
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        OMElement element = null;
        if (WASDIALECTS[0].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the first child element in the Security element.");
            }
            element = DOMUtils.getFirstElement(security);
        } else if (WASDIALECTS[1].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the last child element in the Security element.");
            }
            element = DOMUtils.getLastElement(security);
        } else if (WASDIALECTS[2].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the first child element in the SOAP header element.");
            }
            element = DOMUtils.getFirstElement(header);
        } else if (WASDIALECTS[3].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the last child element in the SOAP header element.");
            }
            element = DOMUtils.getLastElement(header);
        } else if (WASDIALECTS[4].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the immediate child element in the Security element.");
            }
            element = DOMUtils.getFirstElement(security, nsWsu, "Timestamp");
        } else if (WASDIALECTS[5].equals(keyword)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the immediate child element in the SOAP header element.");
            }
            element = DOMUtils.getFirstElement(header, nsWsu, "Timestamp");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown keyword[" + keyword + "], so applying the default.");
                Tr.debug(tc, "Getting the last child element in the Security element.");
            }
            element = DOMUtils.getLastElement(security);
        }
        list.add(element);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getElements(OMElement, OMElement, String, String) returns ArrayList[" + list + "]");
        }
        return list;
    }

    @Override
    public ArrayList<XMLElement> getXMLElements(OMNode node, Map<Object, Object> context) throws SoapSecurityException {
        ArrayList<OMNode> orig_list = this.getElements(node, context);
        ArrayList<XMLElement> new_list = new ArrayList<XMLElement>();
        if (orig_list != null && orig_list.size() > 0) {
            for (int i = 0; i < orig_list.size(); ++i) {
                OMNode obj = orig_list.get(i);
                XMLElement el = new XMLElement(obj);
                new_list.add(el);
            }
        }
        return new_list;
    }
}

