/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;

public final class SecurityUIDGenerator {
    private static Random randomGen = new Random();
    private static short processId = 0;
    private static short sequence = 1;
    private static long previousTime = 0L;
    private static final int sessionIDMax = 45;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUID() {
        boolean vmidFound = true;
        String sessionID = new String();
        try {
            Object vmid = Class.forName("java.rmi.dgc.VMID").newInstance();
            sessionID = vmid.toString();
        }
        catch (ClassNotFoundException e) {
            vmidFound = false;
        }
        catch (InstantiationException e) {
            vmidFound = false;
        }
        catch (IllegalAccessException e) {
            vmidFound = false;
        }
        catch (Throwable e) {
            vmidFound = false;
        }
        finally {
            if (!vmidFound) {
                sessionID = SecurityUIDGenerator.generate();
            }
        }
        return sessionID;
    }

    private static short currentProcessId() {
        while (processId == 0) {
            processId = (short)(SecurityUIDGenerator.randomInt(900) + 100);
        }
        return processId;
    }

    public static synchronized String generate() {
        long time = System.currentTimeMillis();
        short seq = SecurityUIDGenerator.getSequence(time);
        short milli = (short)(time % 1000L);
        short pid = SecurityUIDGenerator.currentProcessId();
        String hostAddress = SecurityUIDGenerator.getLocalAddress();
        int rand = SecurityUIDGenerator.randomInt(0x3FFFFF);
        int index = hostAddress.indexOf("/");
        String ipMinusName = hostAddress.substring(index + 1);
        String uid = new String(ipMinusName + ":" + Integer.toHexString(pid) + Integer.toHexString(seq) + Long.toHexString(time /= 1000L) + Integer.toHexString(rand) + Integer.toHexString(milli));
        if (uid.length() > 45) {
            return uid.substring(0, 44);
        }
        return uid;
    }

    private static String getLocalAddress() {
        String defaultHost = "localhost";
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    InetAddress host = InetAddress.getLocalHost();
                    return host.toString();
                }
            });
        }
        catch (PrivilegedActionException e) {
            return defaultHost;
        }
    }

    private static synchronized short getSequence(long time) {
        if (time <= previousTime) {
            sequence = (short)(sequence + 1);
        }
        previousTime = time;
        return sequence;
    }

    private static int randomInt(int max) {
        int result = randomGen.nextInt();
        if (result < 0) {
            result = -result;
        }
        if (max > 0) {
            return result % max;
        }
        return result;
    }
}

