/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.util;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Duration;
import com.ibm.ws.wssecurity.util.Hex;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

public class NonceUtil {
    private static final TraceComponent tc = Tr.register(NonceUtil.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = NonceUtil.class.getName();
    private static final long minForwardClockSkew = 90000L;
    private static final QName ENCODINGTYPE_Q = new QName("", "EncodingType");
    private static final QName VALUETYPE_Q = new QName("", "ValueType");
    private static final String HTTP_STR = "http://".intern();

    public static OMElement getTimestamp(OMElement parent, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestamp(OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "String nsWsu[" + nsWsu + "])");
        }
        OMElement timestamp = null;
        timestamp = DOMUtils.equals(parent, nsWsu, "Timestamp") ? parent : DOMUtils.getLastElement(parent, nsWsu, "Timestamp");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestamp(OMElement, nsWsu) returns OMElement[" + DOMUtils.getDisplayName(timestamp) + "]");
        }
        return timestamp;
    }

    public static OMElement getNonce(OMElement parent, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonce(OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "String nsWsse[" + nsWsse + "])");
        }
        OMElement nonce = null;
        nonce = DOMUtils.equals(parent, nsWsse, "Nonce") ? parent : DOMUtils.getLastElement(parent, nsWsse, "Nonce");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonce(OMElement, String) returns OMElement[" + DOMUtils.getDisplayName(nonce) + "]");
        }
        return nonce;
    }

    public static OMElement getChildTimestamp(OMElement parent, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestamp(OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "String nsWsu[" + nsWsu + "])");
        }
        OMElement timestamp = DOMUtils.getOneChildElement(parent, nsWsu, "Timestamp");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestamp(OMElement, String) returns OMElement[" + DOMUtils.getDisplayName(timestamp) + "]");
        }
        return timestamp;
    }

    public static OMElement getChildNonce(OMElement parent, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonce(OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "String nsWsse[" + nsWsse + "])");
        }
        OMElement nonce = DOMUtils.getOneChildElement(parent, nsWsse, "Nonce");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonce(OMElement parent, String nsWsse) returns OMElement[" + DOMUtils.getDisplayName(nonce) + "]");
        }
        return nonce;
    }

    public static OMElement createTimestamp(OMFactory factory, OMElement parent, String nsWsu, String extType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTimestamp(OMFactory factory[" + factory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "String nsWsu[" + nsWsu + "]," + "String extType[" + extType + "])");
        }
        String prefix = DOMUtils.getNamespacePrefix(parent, nsWsu);
        OMElement timestamp = null;
        if (prefix == null) {
            timestamp = factory.createOMElement("Timestamp", nsWsu, "wsu");
            timestamp.declareNamespace(nsWsu, "wsu");
        } else {
            timestamp = factory.createOMElement("Timestamp", nsWsu, prefix);
        }
        if ("wedsig".equals(extType) || "weenc".equals(extType)) {
            timestamp.addAttribute("wasextention", extType, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTimestamp(OMFactory, OMElement, String, boolean) returns OMElement[" + DOMUtils.getDisplayName(timestamp) + "]");
        }
        return timestamp;
    }

    public static OMElement addCreated(OMFactory factory, OMElement parent, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCreated(OMFactory factory[" + factory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "String nsWsu[" + nsWsu + "])");
        }
        boolean nsDecl = false;
        String prefix = DOMUtils.getNamespacePrefix(parent, nsWsu);
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsu";
        }
        Date now = new Date();
        String dt = UTC.format(now);
        OMElement created = factory.createOMElement("Created", nsWsu, prefix);
        created.addChild(factory.createOMText(dt));
        parent.addChild(created);
        if (nsDecl) {
            created.declareNamespace(nsWsu, "wsu");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCreated(OMFactory, OMElement, String) returns OMElement[" + DOMUtils.getDisplayName(created) + "]");
        }
        return created;
    }

    public static OMElement addExpires(OMFactory factory, OMElement parent, Duration duration, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addExpires(OMFactory factory[" + factory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "Duration duration[" + duration + "]," + "String nsWsu[" + nsWsu + "])");
        }
        boolean nsDecl = false;
        String prefix = DOMUtils.getNamespacePrefix(parent, nsWsu);
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsu";
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        duration.addTo(cal);
        String dt = UTC.format(cal.getTime());
        OMElement expires = factory.createOMElement("Expires", nsWsu, prefix);
        expires.addChild(factory.createOMText(dt));
        parent.addChild(expires);
        if (nsDecl) {
            expires.declareNamespace(nsWsu, "wsu");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addExpires(OMFactory, OMElement, Duration, String) returns OMElement[" + DOMUtils.getDisplayName(expires) + "]");
        }
        return expires;
    }

    public static OMElement addNonce(OMFactory factory, OMElement parent, String nsWsse, NonceManager nmanager, String extType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNonce(OMFactory factory[" + factory + "]," + "OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "String nsWsse[" + nsWsse + "]," + "NonceManager nmanager[" + nmanager + "]," + "String extType[" + extType + "])");
        }
        boolean nsDecl = false;
        String prefix = DOMUtils.getNamespacePrefix(parent, nsWsse);
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsse";
        }
        OMElement nonce = factory.createOMElement("Nonce", nsWsse, prefix);
        if (nsDecl) {
            nonce.declareNamespace(nsWsse, "wsse");
        }
        if ("wedsig".equals(extType) || "weenc".equals(extType)) {
            nonce.addAttribute("wasextention", extType, null);
        }
        nonce.addChild(factory.createOMText(NonceUtil.generateNonce(nmanager)));
        parent.addChild(nonce);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNonce(OMFactory, OMElement, String, NonceManager, String) returns OMElement[" + DOMUtils.getDisplayName(nonce) + "]");
        }
        return nonce;
    }

    public static String generateNonce(NonceManager nmanager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateNonce(NonceManager nmanager[" + nmanager + "])");
        }
        byte[] nonce = nmanager.generate();
        String nvalue = Base64.encode(nonce);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateNonce(NonceManager) returns String[" + nvalue + "]");
        }
        return nvalue;
    }

    public static byte[] generateUnencodedNonce(NonceManager nmanager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateUnencodedNonce(NonceManager nmanager[" + nmanager + "])");
        }
        byte[] nonce = nmanager.generate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateUnencodedNonce(NonceManager) returns byte[][" + Base64.encode(nonce) + "]");
        }
        return nonce;
    }

    public static void checkNonce(OMElement element, String nsWsse, NonceManager nmanager) throws SoapSecurityException {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNonce(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "String nsWsse[" + nsWsse + "]," + "NonceManager nmanager[" + nmanager + "])");
        }
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s06");
        }
        String ln = element.getLocalName();
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getNamespaceURI();
        if (!nsWsse.equals(ns) || !"Nonce".equals(ln)) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(element));
        }
        QName etype = Constants.BASE64_BINARY;
        String value = element.getAttributeValue(ENCODINGTYPE_Q);
        if (value != null) {
            etype = DOMUtils.getQName(element, value);
        }
        value = DOMUtils.getStringValue(element);
        byte[] nonce = null;
        if (Constants.BASE64_BINARY.equals(etype)) {
            nonce = Base64.decode(value);
        } else if (Constants.HEX_BINARY.equals(etype)) {
            try {
                nonce = Hex.decode(value);
            }
            catch (ParseException e) {
                Tr.processException(e, clsName + ".checkNonce", "371");
                throw SoapSecurityException.format("security.wssecurity.NonceUtil.s01", e);
            }
        }
        if (!nmanager.validate(nonce)) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s02");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNonce(OMElement, String, NonceManager)");
        }
    }

    public static void checkTimestamp(OMNode node, String nsWsu, int maxAge, int clockSkew, boolean logError) throws SoapSecurityException {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTimestamp(OMNode node[" + DOMUtils.getDisplayName(node) + "]," + "String nsWsu[" + nsWsu + "]," + "int maxAge[" + maxAge + "]," + "int clockSkew[" + clockSkew + "]," + "boolean logError[" + logError + "])");
        }
        if (node == null || node.getType() != 1) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s07");
        }
        OMElement element = (OMElement)node;
        String ln = element.getLocalName();
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getNamespaceURI();
        if (!nsWsu.equals(ns) || !"Timestamp".equals(ln)) {
            if (logError) {
                Tr.error(tc, "security.wssecurity.WSSConsumer.s03", new Object[]{DOMUtils.getQualifiedName(node)});
            }
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(node));
        }
        Date created = null;
        Date expires = null;
        try {
            OMElement eel;
            OMElement cel = DOMUtils.getFirstElement(element, nsWsu, "Created");
            if (cel != null) {
                NonceUtil.checkType(cel);
                created = UTC.parse(DOMUtils.getStringValue(cel));
            }
            if ((eel = DOMUtils.getFirstElement(element, nsWsu, "Expires")) != null) {
                NonceUtil.checkType(eel);
                expires = UTC.parse(DOMUtils.getStringValue(eel));
            }
        }
        catch (ParseException e) {
            Tr.processException(e, clsName + ".checkTimestamp", "437");
            if (logError) {
                Tr.error(tc, "security.wssecurity.NonceUtil.s03", new Object[]{e});
            }
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s03", e);
        }
        long current = System.currentTimeMillis();
        Date now = new Date(current);
        if (expires != null && now.after(expires)) {
            String cstr = created != null ? created.toString() : "";
            String estr = expires != null ? expires.toString() : "";
            String nstr = now.toString();
            if (logError) {
                Tr.error(tc, "security.wssecurity.NonceUtil.s04", new Object[]{cstr, estr, nstr});
            }
            throw SoapSecurityException.format(Constants.MESSAGE_EXPIRED, "security.wssecurity.NonceUtil.s04", new String[]{cstr, estr, nstr});
        }
        if (created != null) {
            Long machine_time = new Long(current);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current time = " + current + " ms");
            }
            if (maxAge < 0) {
                maxAge = 300;
            }
            long maxAgeMillis = maxAge * 1000;
            long skewedback = current - maxAgeMillis;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Max age = " + maxAgeMillis + " ms, (current - max age) = " + skewedback + " ms");
            }
            if (clockSkew < 0) {
                clockSkew = 0;
            }
            long clockSkewMillis = clockSkew * 1000;
            skewedback -= clockSkewMillis;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clock skew = " + clockSkewMillis + " ms, (current - clock skew) = " + skewedback + " ms");
            }
            long createdTime = created.getTime();
            Long created_time = new Long(createdTime);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created time (timestamp) = " + createdTime + " ms");
            }
            if (createdTime < skewedback) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Timestamp is not fresh, creation timestamp " + UTC.format(created) + " too old");
                }
                String msgKey_generator = "security.wssecurity.WSEC5205E";
                String msgKey_consumer = "security.wssecurity.WSEC5206E";
                Tr.error(tc, msgKey_consumer, new Object[]{machine_time.toString(), created_time.toString()});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, msgKey_generator);
            }
            if (clockSkewMillis < 90000L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clock skew increased to 90000ms for forward timestamp check.");
                }
                clockSkewMillis = 90000L;
            }
            long skewedforward = current + clockSkewMillis;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clock skew = " + clockSkewMillis + " ms, (current + clock skew) = " + skewedforward + " ms");
            }
            if (createdTime > skewedforward) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Timestamp is not valid, creation timestamp " + UTC.format(created) + " too far in future");
                }
                String msgKey_generator = "security.wssecurity.WSEC5208E";
                String msgKey_consumer = "security.wssecurity.WSEC5206E";
                Tr.error(tc, msgKey_consumer, new Object[]{machine_time.toString(), created_time.toString()});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, msgKey_generator);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Timestamp is fresh");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTimestamp(OMNode, String, int, int, boolean)");
        }
    }

    private static void checkType(OMElement timestamp) throws SoapSecurityException {
        String value;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkType(OMElement timestamp[" + DOMUtils.getDisplayName(timestamp) + "])");
        }
        if ((value = timestamp.getAttributeValue(VALUETYPE_Q)) != null && value.length() > 0) {
            if (value.startsWith(HTTP_STR)) {
                if (!value.equals(Constants.XSD_DATETIME)) {
                    throw SoapSecurityException.format("security.wssecurity.NonceUtil.s05", value, Constants.XSD_DATETIME);
                }
            } else {
                QName valueType = DOMUtils.getQName(timestamp, value);
                if (!valueType.equals(Constants.DATETIME)) {
                    throw SoapSecurityException.format("security.wssecurity.NonceUtil.s05", valueType.toString(), Constants.DATETIME.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkType(OMElement)");
        }
    }

    public static boolean isNonceFirst(OMElement parent, OMElement nonce, OMElement timestamp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNonceFirst(OMElement parent[" + DOMUtils.getDisplayName(parent) + "]," + "OMElement nonce[" + DOMUtils.getDisplayName(nonce) + "]," + "OMElement timestamp[" + DOMUtils.getDisplayName(timestamp) + "])");
        }
        boolean ret = false;
        if (nonce != null) {
            if (timestamp == null) {
                ret = true;
            } else {
                OMElement node = DOMUtils.getFirstElement(parent);
                while (node != null) {
                    if (node.equals(nonce)) {
                        ret = true;
                        break;
                    }
                    if (node.equals(timestamp)) break;
                    node = DOMUtils.getNextElement(node);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNonceFirst(OMElement, OMElement, OMElement) return boolean[" + ret + "]");
        }
        return ret;
    }

    public static Date checkNonceTimestamp(OMElement element, String nsWsu, int maxAge, int clockSkew) throws SoapSecurityException {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNonceTimestamp(OMElement element[" + DOMUtils.getDisplayName(element) + "]," + "String nsWsu[" + nsWsu + "]," + "int maxAge[" + maxAge + "]," + "int clockSkew[" + clockSkew + "])");
        }
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s08");
        }
        String ln = element.getLocalName();
        String string = ns = element.getNamespace() == null ? null : element.getNamespace().getNamespaceURI();
        if (!nsWsu.equals(ns) || !"Created".equals(ln)) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtils.getQualifiedName(element));
        }
        Date created = null;
        try {
            NonceUtil.checkType(element);
            created = UTC.parse(DOMUtils.getStringValue(element));
        }
        catch (ParseException e) {
            Tr.processException(e, clsName + ".checkNonceTimestamp", "626");
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s03", e);
        }
        long current = System.currentTimeMillis();
        Date now = new Date(current);
        Long server_time = new Long(current);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current time = " + current + " ms");
        }
        if (maxAge < 0) {
            maxAge = 300;
        }
        long maxAgeMillis = maxAge * 1000;
        long skewedback = current - maxAgeMillis;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce max age = " + maxAgeMillis + " ms, (current - Nonce max age) = " + skewedback + " ms");
        }
        if (clockSkew < 0) {
            clockSkew = 0;
        }
        long clockSkewMillis = clockSkew * 1000;
        skewedback -= clockSkewMillis;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce clock skew = " + clockSkewMillis + " ms, (current - Nonce clock skew) = " + skewedback + " ms");
        }
        long createdTime = created.getTime();
        Long created_time = new Long(createdTime);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce created time (timestamp) = " + createdTime + " ms");
        }
        if (createdTime < skewedback) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce timestamp is not fresh, creation timestamp " + UTC.format(created) + " too old");
            }
            String msgKey_client = "security.wssecurity.WSEC5193E";
            String msgKey_server = "security.wssecurity.WSEC5200E";
            Tr.error(tc, msgKey_server, new Object[]{server_time.toString(), created_time.toString()});
            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, msgKey_client);
        }
        if (clockSkewMillis < 90000L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Clock skew increased to 90000ms for forward timestamp check.");
            }
            clockSkewMillis = 90000L;
        }
        long skewedforward = current + clockSkewMillis;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Clock skew = " + clockSkewMillis + " ms, (current + clock skew) = " + skewedforward + " ms");
        }
        if (createdTime > skewedforward) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce timestamp is not valid, creation timestamp " + UTC.format(created) + " too far in advance");
            }
            String msgKey_generator = "security.wssecurity.WSEC5209E";
            String msgKey_consumer = "security.wssecurity.WSEC5200E";
            Tr.error(tc, msgKey_consumer, new Object[]{server_time.toString(), created_time.toString()});
            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, msgKey_generator);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce Timestamp is fresh");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNonceTimestamp(OMElement, String, int, int) returns Date[" + created + "]");
        }
        return created;
    }
}

